#include <stdio.h>
#include <alloc.h>
#include <mem.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include <math.h>
#include <values.h>
#include "xlib_all.h"

#define BUFF_LEN 100

   char drive[MAXDRIVE];
   char dir[MAXDIR];
   char name[MAXFILE],newname[MAXFILE];
   char ext[MAXEXT];
   char filenamewild[100];
   char filenamein[100];
   char filenameout[100];
   char filenamedif[100];
   unsigned int currvalue,maxpal=0,minpal=MAXINT;
   int maxpalid=0,minpalid=0;
   char reverse_text[256];
   int index[256];
   int brightness[256];
   long color_order[256];

typedef struct _palstruc {
  unsigned char r;
  unsigned char g;
  unsigned char b;
} far * PAL_STRUC;

char *intro[9]= {"This program is a simple palette manipulation and display program.\n",
		 "As well a displaying the pallete it has several sort and move     \n",
		 "Options for palette entries. Palette entries can be moved using   \n",
		 "the mouse.. Just click and drag. A new palette may be written to  \n",
		 "disk along with a \".DIF\" file which contains the differences in \n",
		 "palette entries between the original and new file which could be  \n",
		 "used to modify existing bitmaps.\n",
		 NULL};


PAL_STRUC p;

void load_user_fonts();

int brightcompare(const void *a,const void *b){
  return brightness[*((int*)b)]-brightness[*((int*)a)];
}
int ordercompare(const void *a,const void *b){
  return color_order[*((int*)b)]-color_order[*((int*)a)];
}

void syntax(){
  int i;
  printf("SHOWPAL - Palette display and manipulation utility          T. Gouthas 20/11/92\n");
  printf("\n SHOWPAL <pal filespec> \n\n");
  for(i=0;i<9 && intro[i];i++)
    printf(intro[i]);
  exit(0);
};

size_t farfread(void far *destptr,size_t size, size_t n, FILE *fp){
   unsigned len;
   unsigned char buff[BUFF_LEN];
   len=size*n;
   while(len >=BUFF_LEN){
     fread(buff,BUFF_LEN,1,fp);
     movedata((unsigned)_DS,(unsigned)buff,FP_SEG(destptr),FP_OFF(destptr),BUFF_LEN);
     len-=BUFF_LEN;
     (char far *)destptr+=BUFF_LEN;
   }
   if (len>0){
     fread(buff,len,1,fp);
     movedata((unsigned)_DS,(unsigned)buff,FP_SEG(destptr),FP_OFF(destptr),len);
   }
};

size_t farfwrite(void far *srcptr,size_t size, size_t n, FILE *fp){
   WORD len;
   BYTE buff[BUFF_LEN];
   len=size*n;
   while(len >=BUFF_LEN){
     movedata(FP_SEG(srcptr),FP_OFF(srcptr),(unsigned)_DS,(unsigned)buff,BUFF_LEN);
     fwrite(buff,BUFF_LEN,1,fp);
     len-=BUFF_LEN;
     (char far *)srcptr+=BUFF_LEN;
   }
   if (len>0){
     movedata(FP_SEG(srcptr),FP_OFF(srcptr),(unsigned)_DS,(unsigned)buff,len);
     fwrite(buff,len,1,fp);
   }
};




int which_cell(int x, int y){
  int xpos,ypos;
  if (x < 0) return -1;
  if (x > 255*23+22) return -1;
  if (y < 18) return -1;
  if (y > 255*29+28+18) return -1;
  xpos =  x / 23;
  ypos =  (y-18) / 29;
  return ypos*16+xpos;

}

void write_outfiles(){
  FILE *f;
  int i;
  f=fopen(filenameout,"wb");
  if (!f) return;
  for(i=0;i<256;i++)
    farfwrite(&p[index[i]].r,3,1,f);
  fclose(f);
  f=fopen(filenamedif,"wt");
  if (!f) return;
  for(i=0;i<256;i++)
    if (index[i]!=i)
      fprintf(f,"%d %d\n",i,index[i]);
  fclose(f);
}

void main(int argc, char *argv[] ){
  FILE *f;
  struct ffblk ffb;
  ldiv_t d;
  unsigned char c[3];
  
  int i,j,k,l,infilesize;
  char far *buff;
  char ch;
  int x0,y0,x1,y1,idx0,idx1;

  if (argc<2) syntax();
  if (!strcmp(argv[1],"-g")){
    if (argc<3) syntax();
    strcpy(filenamewild,argv[2]);
  } else strcpy(filenamewild,argv[1]);
  fnsplit(filenamewild,drive,dir,NULL,ext);
  if (*ext=='\0') strcat(filenamewild,".PAL");
  if(findfirst(filenamewild,&ffb,0)){
    return;
  }
  fnsplit(ffb.ff_name,NULL,NULL,name,ext);
  fnmerge(filenamein,drive,dir,name,ext);
  strcpy(newname,"NEWPAL");
  fnmerge(filenameout,drive,dir,newname,ext);
  fnmerge(filenamedif,drive,dir,newname,".dif");
  f=fopen(filenamein,"rb");
  if (!f) return;
  fseek(f,0,SEEK_END);
  infilesize = (unsigned) ftell(f);
  fseek(f,0,SEEK_SET);
  if (infilesize < 768) return;
  buff=farmalloc(infilesize);
  if (buff==NULL) return;
  farfread(buff,infilesize,1,f);
  fclose(f);
  for (i=0;i<256;i++) index[i]=i;
  x_set_mode(X_MODE_376x564,376/4);
  x_text_init();
  load_user_fonts();
  x_mouse_init();
  x_set_font(FONT_USER);
  x_put_pal_raw(buff,256,0);
  p=(PAL_STRUC) buff;
  for (i=0;i<256;i++){
     currvalue=(int)(p[i].r)+
	       (int)(p[i].g)+
	       (int)(p[i].b);
     brightness[i]=(int)(p[i].r)*(int)(p[i].r)+
		   (int)(p[i].g)*(int)(p[i].g)+
		   (int)(p[i].b)*(int)(p[i].b);
     color_order[i]= (((int)(p[i].r))<<16)+
		     (((int)(p[i].g))<<8)+
		     (int)(p[i].b);
     if (currvalue<minpal){
       minpal=currvalue;
       minpalid=i;
     } else if (currvalue>maxpal){
       maxpal=currvalue;
       maxpalid=i;
     }
  }
  for (i=0;i<256;i++){
     currvalue=(int)(p[i].r)+
	       (int)(p[i].g)+
	       (int)(p[i].b);
     if (currvalue<maxpal/2)
       reverse_text[i]=0;
     else
       reverse_text[i]=1;
  }

  x_rect_fill(0,0,375,563,0,minpalid);
  x_set_font(FONT_8x15);
  x_printf(0,0,0,maxpalid,"%s%s",name,ext);
  x_set_font(FONT_USER);
  k=0;
  for(j=0;j<16;j++)
    for(i=0;i<16;k++,i++){
      x_rect_fill(i*23,j*29+18,i*23+22,j*29+18+28,0,index[k]);
      x_printf(i*23,j*29+18,0,reverse_text[index[k]]?minpalid:maxpalid,"%d",
	index[k]);
    }
  x_set_font(FONT_8x15);
  x_printf(0,507,0,maxpalid,"Sort by B)rightness C)olor or O)riginal order");
  x_printf(0,519,0,maxpalid,"W)rite new pal and difference file Q)uit");
  x_show_mouse();
  MouseColor=maxpalid;
  do {
   do {} while (!kbhit() && !(MouseButtonStatus&LEFT_PRESSED));
   if (kbhit()){
     ch=getch();
     if (ch=='@') ch=' ';
   } else {
      x0=MouseX; y0=MouseY;
      ch='@';
      do {} while (MouseButtonStatus&LEFT_PRESSED);
      x1=MouseX; y1=MouseY;
      idx0=which_cell(x0,y0);
      if (idx0>-1){
	idx1=which_cell(x1,y1);
	if (idx1>-1){
	  i=index[idx0];
	  index[idx0]=index[idx1];
	  index[idx1]=i;
	}
      }
   }
   x_hide_mouse();
   if (toupper(ch)=='B'){
      qsort(index,256,2,brightcompare);
   } else if (toupper(ch)=='C'){
      qsort(index,256,2,ordercompare);
   } else if (toupper(ch)=='O'){
      for(i=0;i<256;i++) index[i]=i;
   } else if (toupper(ch)=='W'){
      write_outfiles();
   }
   if (toupper(ch)!='Q'&&toupper(ch)!='W'){
     x_rect_fill(0,16,375,500,0,minpalid);
     x_set_font(FONT_USER);
     k=0;
     for(j=0;j<16;j++)
       for(i=0;i<16;k++,i++){
	 x_rect_fill(i*23,j*29+18,i*23+22,j*29+18+28,0,index[k]);
	 x_printf(i*23,j*29+18,0,reverse_text[index[k]]?minpalid:maxpalid,"%d",
	   index[k]);
       }
      x_show_mouse();
  }
  } while(toupper(ch)!='Q');
  x_mouse_remove();
  x_text_mode();
  farfree(buff);
}
unsigned char fontdat[]={
  30,0,8,0,0,0,12,30,63,63,0,0,7,0,0,63,63,30,12,0,0,7,0,0,0,0,0,0,0,0,4,
  4,4,4,4,4,0,4,0,4,10,10,0,0,0,0,0,0,5,0,10,31,10,31,10,0,0,6,4,30,5,14,
  20,15,4,0,6,0,35,19,8,4,50,49,0,7,6,9,5,2,21,9,22,0,6,6,4,2,0,0,0,0,0,
  4,8,4,2,2,2,4,8,0,5,2,4,8,8,8,4,2,0,5,0,10,4,31,4,10,0,0,6,0,4,4,
  31,4,4,0,0,6,0,0,0,0,0,6,4,2,4,0,0,0,31,0,0,0,0,6,0,0,0,0,0,0,2,
  0,3,32,16,8,4,2,1,0,0,7,14,17,25,21,19,17,14,0,6,4,6,4,4,4,4,14,0,5,14,17,
  16,14,1,17,31,0,6,14,17,16,12,16,17,14,0,6,1,9,9,9,31,8,8,8,6,31,1,15,16,16,17,
  14,0,6,14,17,1,15,17,17,14,0,6,31,16,16,8,4,4,4,0,6,14,17,17,14,17,17,14,0,6,14,
  17,17,30,16,17,14,0,6,0,4,4,0,0,4,4,0,4,0,4,4,0,0,4,4,2,4,8,4,2,1,2,
  4,8,0,5,0,0,31,0,0,31,0,0,6,2,4,8,16,8,4,2,0,6,14,17,8,4,4,0,4,0,6,
  14,17,21,29,13,1,30,0,6,4,10,17,17,31,17,17,0,6,15,17,17,15,17,17,15,0,6,14,17,1,1,
  1,17,14,0,6,7,9,17,17,17,9,7,0,6,31,1,1,7,1,1,31,0,6,31,1,1,7,1,1,1,0,
  6,14,17,1,25,17,17,14,0,6,17,17,17,31,17,17,17,0,6,14,4,4,4,4,4,14,0,5,16,16,16,
  16,17,17,14,0,6,17,9,5,3,5,9,17,0,6,1,1,1,1,1,1,31,0,6,17,27,21,21,17,17,17,
  0,6,17,19,21,25,17,17,17,0,6,14,17,17,17,17,17,14,0,6,15,17,17,15,1,1,1,0,6,14,17,
  17,17,21,9,22,0,6,15,17,17,15,5,9,17,0,6,14,17,1,14,16,17,14,0,6,31,4,4,4,4,4,
  4,0,6,17,17,17,17,17,17,14,0,6,17,17,17,17,10,10,4,0,6,17,17,17,21,21,27,17,0,6,17,
  17,10,4,10,17,17,0,6,17,17,10,4,4,4,4,0,6,31,16,8,4,2,1,31,0,6,14,2,2,2,2,
  2,14,0,5,0,1,2,4,8,16,0,0,6,14,8,8,8,8,8,14,0,5,4,10,17,0,0,0,0,0,6,
  0,0,0,0,0,0,31,0,6,6,2,4,0,0,0,0,0,4,0,0,14,16,30,17,14,0,6,1,1,15,17,
  17,17,15,0,6,0,0,14,17,1,17,14,0,6,16,16,30,17,17,17,30,0,6,0,0,14,17,15,1,14,0,
  6,12,18,2,7,2,2,2,0,6,0,0,14,17,17,30,16,14,6,1,1,15,17,17,17,17,0,6,1,0,1,
  1,1,9,6,0,5,16,0,16,16,16,16,18,12,6,1,1,17,9,7,9,17,0,6,1,1,1,1,1,1,6,
  0,4,0,0,11,21,21,17,17,0,6,0,0,13,19,17,17,17,0,6,0,0,14,17,17,17,14,0,6,0,0,
  15,17,17,15,1,1,6,0,0,14,17,17,30,16,16,6,0,0,13,19,1,1,1,0,6,0,0,30,1,14,16,
  15,0,6,2,2,7,2,2,2,12,0,5,0,0,17,17,17,17,14,0,6,0,0,17,17,10,10,4,0,6,0,
  0,17,17,21,27,17,0,6,0,0,17,10,4,10,17,0,6,0,0,17,17,18,28,17,14,6,0,0,31,8,4,
  2,31,0,6,24,4,4,2,4,4,24,0,6,4,4,4,0,4,4,4,0,4,6,8,8,16,8,8,6,0,6,
  0,0,10,5,0,0,0,0,5
} ;

void load_user_fonts(){
  static char far* newfnt;
  int i; char c;
  newfnt = MK_FP(_DS,fontdat);
  x_text_init();
  x_register_userfont(newfnt);
  x_set_font(2);
}


