/* tailor.h -- target dependent definitions
 * Copyright (C) 1992-1993 Jean-loup Gailly.
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License, see the file COPYING.
 */

/* The target dependent definitions should be defined here only.
 * The target dependent functions should be defined in tailor.c.
 */

/* $Id: tailor.h,v 0.10 1993/02/11 09:47:02 jloup Exp $ */

#if defined(__MSDOS__) && !defined(MSDOS)
#  define MSDOS
#endif

#ifdef MSDOS
#  define MAXSEG_64K
#  define PATH_SEP '\\'
#  define OTHER_PATH_SEP ':'
#  define MAX_PATH_LEN  128
#  define NO_MULTIPLE_DOTS
#  define NO_CHOWN
#  define PROTO
#  define STDC_HEADERS
#  define NO_SIZE_CHECK
#  define casemap(c) tolow(c) /* Force file names to lower case */
#  include <io.h>
#  define OS_CODE  0x000
#else
#  define near
#endif

#ifdef OS2
#  define PATH_SEP '\\'
#  define OTHER_PATH_SEP ':'
#  define NO_CHOWN
#  define PROTO
#  define STDC_HEADERS
#  define HAVE_SYS_UTIME_H
#  define DIRENT
#  define casemap(c) tolow(c)
#  include <io.h>
#  define OS_CODE  0x600
#endif

#ifndef MAXSEG_64K
#  define fcalloc(items,size) malloc((unsigned)(items)*(unsigned)(size))
#  define fcfree(ptr) free(ptr)
#else
#  ifdef __TURBOC__
#    include <alloc.h>
#    define NO_UTIME
#    define DYN_ALLOC
     /* Turbo C 2.0 does not accept static allocations of large arrays */
     void * fcalloc (unsigned items, unsigned size);
     void fcfree (void *ptr);
#  else /* MSC */
#    define HAVE_SYS_UTIME_H
#    include <malloc.h>
#    define fcalloc(nitems,itemsize) halloc((long)(nitems),(itemsize))
#    define fcfree(ptr) hfree(ptr)
#  endif
#endif

#ifdef VMS
#  define PATH_SEP ']'
#  define OTHER_PATH_SEP ':'
#  define NO_MULTIPLE_DOTS
#  define NO_FCNTL_H
#  define RECORD_IO 1
#  define casemap(c) tolow(c)
#  define unlink delete
#  include <file.h>
#  include <unixio.h>
#  define OS_CODE  0x200
#endif

#ifdef AMIGA
#  define NO_STDIN_FSTAT
#  define OTHER_PATH_SEP ':'
#  define SYSDIR
#  define STDC_HEADERS
#  define HAVE_STRING_H
#  define NO_SYMLINK
#  define NO_UTIME
#  define NO_CHOWN
#  define direct dirent
   extern void _expand_args(int *argc, char ***argv);
#  define EXPAND(argc,argv) _expand_args(&argc,&argv);
#  define OS_CODE  0x100
#endif

#ifdef ATARI_ST
#  define OS_CODE  0x500
#endif

#ifdef MACOS
#  define OS_CODE  0x700
#endif

#ifdef WIN32
#  define OS_CODE  0xb00
#endif

#ifdef TOPS20
#  define OS_CODE  0xa00
#endif

#ifndef OS_CODE
#  define OS_CODE  0x300  /* assume Unix */
#endif

#ifndef PATH_SEP
#  define PATH_SEP '/'
#endif

#ifndef casemap
#  define casemap(c) (c)
#endif

/* Wild card expansion */
#ifdef __EMX__
#  define EXPAND(argc,argv) {_response(&argc, &argv); _wildcard(&argc, &argv);}
#endif

#ifndef EXPAND
#  define EXPAND(argc,argv)
#endif

/* Force binary mode on open file */
#if defined(MSDOS) || defined(OS2)
#  define SET_BINARY_MODE(fd) setmode(fd, O_BINARY)
#else
#  define SET_BINARY_MODE(fd)
#endif

#ifndef RECORD_IO
#  define RECORD_IO 0
#endif

/* Use ASM code by default on MSDOS */
#if defined(MSDOS) && !defined(NO_ASM) && !defined(ASMV)
#  define ASMV
#endif
#if defined(ASMV) && !defined(MSDOS) && defined(DYN_ALLOC)
  error: DYN_ALLOC not yet supported in match.s
#endif
