/*
 * CELT.C - Copyright 1989 by Michael Bartman
 *
 *   This program may be copied and used by anyone, provided that it
 *   remains intact. Any alteration of the program must be accompanied by a
 *   change in the program name. This is intended to prevent confusion
 *   over multiple variations. Thank you, and have fun!
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define VERSION         "CELT - v1.0, June 1989"
#define DEBUG            0

/******************
 *  Generate a random number between 0 and the given upper limit
 */
int random_num (int upper_lim)
{
   if (upper_lim == 0)
     return (0) ;
   else
     return (abs(rand() % upper_lim)) ;

}  /* end random_num */


/******************
  SUBROUTINE "V"

         A, 40.0%        I, 15.0%       AI,  5.0%        E, 17.5%
        EI,  5.0%        O,  2.5%        U,  2.5%        Y,  7.5%
        EY,  2.5%       AU,  2.5%
*/
void rtn_V (char *buf)
{
        int     tot, i ;
        int     weights[] =
                 {400, 150, 50, 175, 50, 25, 25, 75, 25, 25} ;

        char    *letters[] =
                 {"A", "I", "AI", "E", "EI", "O", "U", "Y", "EY", "AU"} ;

        tot = random_num(1000) ;
        i = 0 ;
        while (tot > 0) tot -= weights[i] ;
        strcat (buf, letters[i]) ;
}  /* end rtn_V */


/******************
  SUBROUTINE VC

 the vowel part:
        AI, 10%         A, 57%          EE,  4%          E,  9%
         I,  7%         O, 13%

 the consonant part:

        S,  6%          R, 25%          N, 30%          M,  5%
        L, 13%          DD, 3%          G,  3%          D,  6%
        T,  3%          NC, 2%          NN, 2%          RD, 2%
*/
void rtn_VC (char *buf)
{
        int     tot, i ;

        int     weights_V[] =
                 {10, 57, 4,  9,  7, 13} ;

        int     weights_C[] =
                 {6, 25, 30, 5, 13, 3, 3, 6, 3, 2, 2, 2} ;

        char    *letters_V[] =
                 {"AI", "A", "EE", "E", "I", "O"} ;

        char    *letters_C[] =
                 {"S", "R", "N", "M", "L", "DD", "G", "D", "T", "NC",
                  "NN", "RD" } ;

        tot = random_num(100) ;
        i = 0 ;
        while (tot >= 0) tot -= weights_V[i++] ;
        i-- ;
        strcat (buf, letters_V[i]) ;

        tot = random_num(100) ;
        i = 0 ;
        while (tot >= 0) tot -= weights_C[i++] ;
        i-- ;
        strcat (buf, letters_C[i]) ;

}  /* end rtn_VC */


/******************
  SUBROUTINE CV

 the consonant:
        G,   4%         T,   2%         C,  13%         R,   8%
        D,   9%         L,  11%         F,   2%         N,  12%
        GW,  4%         TH,  1%         K,   2%         Y,   2%
        M,   1%         V,   3%         S,   3%         W,   1%
        B,   2%         LL,  2%         BR,  3%         FL,  1%
        RH,  1%         TT,  1%         CL,  1%         CR,  1%
        DD,  1%         HW,  1%         GL,  1%         BL,  2%
        BH,  1%         DR,  2%         GHL, 1%         W,   1%

  the vowel:
        A,  31%         EU,  3%         EA,  2%         U,   5%
        Y,  22%         OW,  1%         O,   9%         OI,  2%
        AY,  3%         E,  15%         EY,  6%         EE,  1%
*/
void rtn_CV (char *buf)
{
        int     tot, i ;

        int     weights_V[] =
                 {31, 3, 2, 5, 22, 1, 9, 2,
                  3, 15, 6, 1} ;

        int     weights_C[] =
                 {4, 2, 13, 8, 9, 11, 2, 12,
                  4, 1, 2, 2, 1, 3, 3, 1,
                  2, 2, 3, 1, 1, 1, 1, 1,
                  1, 1, 1, 2, 1, 2, 1, 1 } ;

        char    *letters_V[] =
                 {"A", "EU", "EA", "U", "Y", "OW", "O", "OI",
                  "AY", "E", "EY", "EE"} ;

        char    *letters_C[] =
                 {"G",  "T",  "C",  "R",  "D",  "L",  "F",   "N",
                  "GW", "TH", "K",  "Y",  "M",  "V",  "S",   "W",
                  "B",  "LL", "BR", "FL", "RH", "TT", "CL",  "CR",
                  "DD", "HW", "GL", "BL", "BH", "DR", "GHL", "W"} ;

        tot = random_num(100) ;
        i = 0 ;
        while (tot >= 0) tot -= weights_C[i++] ;
        i-- ;
        strcat (buf, letters_C[i]) ;

        tot = random_num(100) ;
        i = 0 ;
        while (tot >= 0) tot -= weights_V[i++] ;
        i-- ;
        strcat (buf, letters_V[i]) ;

}  /* end rtn_CV */


/******************
  SUBROUTINE CVC

 the first consonant:
        L,  11.6%       RH,  1.4%       BR,  3.0%       W,   5.5%
        C,  15.8%       D,   6.9%       N,   6.1%       R,   2.5%
        GU,  0.6%       T,   1.5%       K,   1.5%       LL,  1.8%
        V,   1.8%       M,  10.5%       GR,  0.6%       S,   2.5%
        G,   3.5%       PR,  0.6%       BL,  1.0%       B,   2.6%
        F,   2.2%       FR,  0.6%       CH,  1.0%       H,   2.6%
        CL,  1.0%       DD,  1.0%       CR,  1.0%       DW,  0.6%
        FL,  0.6%       CHR, 0.6%       TH,  2.0%       SHR, 0.6%
        GL,  0.6%       GW,  1.4%       Y,   1.0%       TR,  0.6%
        ST,  1.0%       P,   0.6%       SH,  0.6%

 the vowel:
        I,  11.9%       EE,  1.1%       UI,  0.5%       O,  15.9%
        OU,  0.5%       A,  23.9%       W,   1.1%       E,  19.9%
        Y,   9.1%       IA,  0.5%       AI,  3.9%       EA,  2.3%
        U,   2.7%       OY,  1.7%       AE,  1.1%       EI,  1.1%
        EU,  0.5%       AW,  1.1%       AU,  0.6%       AY,  0.6%

 the second consonant:
        NN,  2.4%       N,  33.0%       ND,  0.8%       D,   7.6%
        M,   1.2%       R,  22.6%       DD,  1.6%       V,   0.8%
        T,   1.6%       S,   3.2%       F,   0.4%       TH,  2.0%
        L,   7.6%       B,   0.8%       LT,  0.8%       LL,  1.6%
        W,   0.8%       C,   1.2%       CK,  1.6%       RN,  1.2%
        CH,  1.6%       RD,  0.4%       RS,  0.4%       RR,  0.8%
        G,   2.4%       RCH, 0.8%       LD,  0.4%       TT,  0.4%
*/
void rtn_CVC (char *buf)
{
        int     tot, i ;

        int     weights_V[] =
                 {119, 11,  5, 159,  5, 239, 11, 199,
                  91,  5, 39, 23, 27, 17, 11, 11,
                   5, 11,  6,  6} ;

        int     weights_C1[] =
                 {116, 14, 30, 55, 158, 69, 61, 25,
                   6, 15, 15, 18, 18, 105,  6, 25,
                  35,  6, 10, 26, 22,  6, 10, 26,
                  10, 10, 10,  6,  6,  6, 20,  6,
                   6, 14, 10,  6, 10,  6,  6} ;

        int     weights_C2[] =
                 {24, 330, 8, 76, 12, 226, 16, 8,
                  16, 32,  4, 20, 76,  8,  8, 16,
                   8, 12, 16, 12, 16,  4,  4,  8,
                  24,  8,  4,  4} ;

        char    *letters_V[] =
                 {"I", "EE", "UI", "O", "OU", "A", "W", "E",
                  "Y", "IA", "AI", "EA", "U", "OY", "AE", "EI",
                  "EU", "AW", "AU", "AY"} ;

        char    *letters_C1[] =
                 {"L", "RH", "BR", "W", "C", "D", "N", "R",
                  "GU", "T", "K", "LL", "V", "M", "GR", "S",
                  "G", "PR", "BL", "B", "F", "FR", "CH", "H",
                  "CL", "DD", "CR", "DW", "FL", "CHR", "TH", "SHR",
                  "GL", "GW", "Y", "TR", "ST", "P", "SH"} ;

        char    *letters_C2[] =
                 {"NN", "N", "ND", "D", "M", "R", "DD", "V",
                  "T", "S", "F", "TH", "L", "B", "LT", "LL",
                  "W", "C", "CK", "RN", "CH", "RD", "RS", "RR",
                  "G", "RCH", "LD", "TT"} ;

        tot = random_num(1000) ;
        i = 0 ;
        while (tot >= 0) tot -= weights_C1[i++] ;
        i-- ;
        strcat (buf, letters_C1[i]) ;

        tot = random_num(1000) ;
        i = 0 ;
        while (tot >= 0) tot -= weights_V[i++] ;
        i-- ;
        strcat (buf, letters_V[i]) ;

        tot = random_num(1000) ;
        i = 0 ;
        while (tot >= 0) tot -= weights_C2[i++] ;
        i-- ;
        strcat (buf, letters_C2[i]) ;

}  /* end rtn_CVC */


/******************
 *  GENERATE
 */
void generate (char *buff)
{
        int     num_syl, syl_type ;
        int     i ;

        int     sylable_counts[] = {10, 65, 20, 5} ;
        int     sylable_types[] = {8, 10, 39, 43} ;
/*
 *  find number of sylables
 *
 *      1 sylable= 10%, 2 sylable= 65%, 3 sylable= 20%, 4 sylable= 5%
 */
        num_syl = 0 ;
        i = random_num(100) ;
        while (i > 0) i -= sylable_counts[num_syl++] ;
/*
 *  find the type of each sylable
 *      V= 8%,  VC= 10%,  CV= 39%,  CVC= 43%
*/
        for (; num_syl > 0; num_syl--)
         {
                syl_type = 0 ;
                i = random_num(100) ;
                while (i >= 0) i -= sylable_types[syl_type++] ;

                switch (syl_type)
                 {
                  case 1: rtn_V (buff) ;
                          break ;
                  case 2: rtn_VC (buff) ;
                          break ;
                  case 3: rtn_CV (buff) ;
                          break ;
                  case 4: rtn_CVC (buff) ;
                 }  /* end switch */
         }
}  /* end generate */


main (int argc, char *argv[])
{
        char    outfilename[256] ;
        char    buff[30] ;
        int     num_names ;
        FILE    *ofile ;                /* where to write the names */

  printf ("\n%s\n", VERSION) ;
/*
 *  Init a couple of variables and the random number generator
 */
  if (argc < 2)
    num_names = 20 ;
  else
    num_names = atoi(argv[1]) ;

  if (argc < 3)
    strcpy (outfilename, "CELT.OUT") ;
  else
    strcpy (outfilename, argv[2]) ;

  randomize() ;
/*
 *  call the generate routine as many times as needed. Generates one
 *   name per call.
 */
        if ((ofile = fopen(outfilename, "w")) == NULL)
           {
                printf("Error -- unable to open the output file \"%s\".\n",
                        outfilename) ;
                exit (0) ;
           }

        printf ("\n -- Generating %d names. Output to %s --\n",
                num_names, outfilename) ;
        fprintf (ofile, "\n -- Generating %d names. Output to %s --\n",
                num_names, outfilename) ;

        for (; num_names > 0; num_names--)
          {
                strcpy (buff, "") ;
                generate (buff) ;
                fprintf (ofile, "%s\n", buff) ;
          }
        printf ("\n\7Done.") ;

}  /* end main */
