' *************************************
' *    F15 Strike Eagle ]I[ Editor    *
' *           version 1.1             *
' *                                   *
' * F-15 Strike Eagle III is [tm] of  *
' * MicroProse Software, Inc.         *
' *                                   *
' * F15 Strike Eagle ]I[ Editor is (c)*
' * by Christopher Thompson, 1993     *
' *************************************

SCREEN 0
WIDTH 80
KEY OFF
RESTORE Medals
CLS

' Variables defined below
    Record$ = ""       ' Storage for record being modified
    Number% = 0        ' Pilot number, 0 - 7
    Pilot$ = ""         ' Pilot name
    Rank% = 0          ' Rank, 0 - 6
    Status% = 0        ' Status, 0 - 4
    Score& = 0         ' Score
    Died% = 0          ' Player died?
    Eject% = 0         ' Number of times a player ejected
    DIM STATIC Medals%(0:8)   
                       ' How many of which type of medal
    DIM STATIC Campaign%(1:3) 
                       ' Campaign medal received?
    Score1% = 0        ' Temporary score
    Score2% = 0        '        "
    Score3% = 0        '        "
    loopx% = 0         ' Loop variable
    loopy% = 0         '        "
    loopz& = 0         '        "
    x$ = ""            ' Temporary string
    i$ = ""            ' Results of keyboard input
    x% = 0             ' Temporary variable

Medals:
    DATA "Purple Heart","Air Force Commendation","Air Medal"
    DATA "Meritorious Service Award","Distinguished Flying Cross","Legion of Merit"
    DATA "Silver Star","Air Force Cross"
    DATA "Congressional Medal of Honor"
Campaigns:
    DATA "Korea","Gulf War","Panama"
Rank:
    DATA "2nd Lieutenant","1st Lieutenant","Captain","Major"
    DATA "Lieutenant Colonel","Colonel","Brigadier General"

' Main loop
    ON ERROR GOTO ErrorHandler
    COLOR 12,0
    LOCATE 1,20
    PRINT "F15 Strike Eagle ]I[ Editor ";
    COLOR 15,0
    PRINT "version 1.1"
    LOCATE 2,25
    PRINT "(c) Christopher Thompson, 1993"
    LOCATE 3,11
    PRINT "F-15 Strike Eagle III is [tm] of MicroProse Software, Inc."
    COLOR 14,0
    LOCATE 6,1
    PRINT "1.  Record "
    PRINT "2.  Name "
    PRINT "3.  Status "
    PRINT "4.  Rank "
    PRINT "5.  Score "
    PRINT "6.  Died?            Ejected: "
    PRINT "7.  Medals:"
    RESTORE Medals
    FOR loopx% = 0 TO 8
        READ x$
        PRINT "   ";x$;
        IF (loopx%/2)=FIX(loopx%/2) THEN PRINT STRING$((37-LEN(x$))," "); _
            ELSE PRINT
    NEXT loopx%
    PRINT
    PRINT "8. Campaign Medals:"
    RESTORE Campaigns
    FOR loopx% = 1 TO 3
        READ x$
        PRINT "  ";x$;
        PRINT STRING$((23-LEN(x$))," ");
    NEXT loopx%
    PRINT

LoadRec:
    OPEN "ROSTER." FOR BINARY AS #1
    SEEK #1, (Number%*94)
    GET$ #1, 94, Record$
    CLOSE #1
    Pilot$ = MID$(Record$,2,35)
    Rank%=ASC(MID$(Record$,38,1))
    Status%=ASC(MID$(Record$,39,1))
    Score1%=ASC(MID$(Record$,71,1))
    Score2%=ASC(MID$(Record$,72,1))
    Score3%=ASC(MID$(Record$,73,1))
    Score&=(CLNG(Score3%)*65536) + (CLNG(Score2%)*256) + (CLNG(Score1%))
    IF MID$(Record$,89,1) = CHR$(255) THEN Died% = 1 ELSE Died% = 0
    Eject%=ASC(MID$(Record$,79,1))
    loopy% = 43
    FOR loopx% = 0 TO 8
        Medals%(loopx%) = ASC(MID$(Record$,(loopy%+loopx%),1))
    NEXT loopx%
    loopy% = 60
    FOR loopx% = 1 TO 3
        Campaign%(loopx%) = ASC(MID$(Record$,(loopy%+loopx%),1))
    NEXT loopx%

DispRec:
    COLOR 13,0
    LOCATE 6,12
    PRINT Number%
    LOCATE 7,12
    PRINT Pilot$;
    PRINT STRING$((40-LEN(Pilot$))," ")
    LOCATE 8,13
    SELECT CASE Status%
        CASE 0
             PRINT "*inactive*       "
        CASE 1
             PRINT "*active*         "
        CASE 2
             PRINT "Retired          "
        CASE 3
             PRINT "Missing in Action"
        CASE 4
             PRINT "Killed in Action "
        CASE ELSE
             PRINT "***unknown***    "
    END SELECT
    LOCATE 9,13
    RESTORE Rank
    FOR loopx% = 0 TO Rank%
        READ x$
    NEXT loopx%
    PRINT x$;
    PRINT STRING$((40-LEN(x$))," ");
    LOCATE 10,13
    PRINT USING "# ### ###"; Score&;
    LOCATE 11,13
    IF Died% = 1 THEN PRINT "Yes" ELSE PRINT "No "
    LOCATE 11,31
    PRINT Eject%
    loopy% = 13
    FOR loopx% = 0 TO 8
        IF (loopx%/2)=FIX(loopx%/2) THEN LOCATE loopy%,1 ELSE _
            LOCATE loopy%,40
        PRINT USING "##";Medals%(loopx%);
        IF (loopx%/2)<>FIX(loopx%/2) THEN loopy% = loopy% + 1
    NEXT loopx%
    FOR loopx% = 1 TO 3
        LOCATE 19, ((loopx%-1)*25 + 1)
        PRINT USING "#";Campaign%(loopx%);
    NEXT loopx%
    LOCATE 21, 25
    COLOR 11,0
    PRINT "[S]ave   [A]bort to DOS   [1-8] Edit"
    COLOR 15,0

Edit:
    GOSUB GetInput
    IF i$ = "s" OR i$ = "S" THEN GOTO SaveRec
    IF i$ = "a" OR i$ = "A" THEN GOTO Abort
    IF i$ = "1" THEN GOTO EdRecord
    IF i$ = "2" THEN GOTO EdName
    IF i$ = "3" THEN GOTO EdStatus
    IF i$ = "4" THEN GOTO EdRank
    IF i$ = "5" THEN GOTO EdScore
    IF i$ = "6" THEN GOTO EdDied
    IF i$ = "7" THEN GOTO EdMedals
    IF i$ = "8" THEN GOTO EdCampaign
    BEEP
    GOTO Edit

EdRecord:
    LOCATE 22,1
    INPUT "Edit which record? [0-7, 8 to return to this record] ",loopy%
    IF loopy% < 0 OR loopy% > 8 OR loopy%<>FIX(loopy%) THEN BEEP:_
        GOTO EdRecord
    IF loopy% = 8 THEN GOSUB ClearInput : GOTO DispRec
    Number% = loopy%
    GOSUB ClearInput
    GOTO LoadRec

EdName:
    LOCATE 22,1
    INPUT "Please name this pilot: [35 char max] ",x$
    IF LEN(x$)=0 OR LEN(x$) > 35 THEN BEEP:GOTO EdName
    Pilot$ = x$
    GOSUB ClearInput
    GOTO DispRec

EdStatus:
    LOCATE 22,1
    PRINT "0 Inactive   1 active   2 retired  3 MIA  4 KIA"
    INPUT "Please select status: [0 - 4] ",loopy%
    IF loopy% < 0 OR loopy% > 4 or loopy%<>FIX(loopy%) THEN BEEP:_
        GOTO EdStatus
    Status% = loopy%
    GOSUB ClearInput
    GOTO DispRec

EdRank:
    LOCATE 22,1
    RESTORE Rank
    FOR loopx% = 0 TO Rank%
        READ x$
    NEXT loopx%
    PRINT "Current rank: ";x$;"                "
    PRINT "Use + or - to adjust, ENTER to accept"
    GOSUB GetInput
    IF i$ = "+" OR i$ = "=" THEN
        Rank% = Rank% + 1
        IF Rank% > 6 THEN Rank% = 0
    ELSEIF i$ = "-" THEN
        Rank% = Rank% - 1
        IF Rank% < 0 THEN Rank% = 6
    END IF
    IF i$ = "+" OR i$ = "=" THEN GOTO EdRank
    IF i$ = "-" THEN GOTO EdRank
    IF i$ = CHR$(13) THEN GOSUB ClearInput : GOTO DispRec
    BEEP
    GOTO EdRank

EdScore:
    LOCATE 22,1
    INPUT "Enter score: ",loopz&
    IF loopz& < 0 OR loopz& > 9999999 OR loopz&<>FIX(loopz&) THEN BEEP:_
        GOTO EdScore
    Score& = loopz&
    GOSUB ClearInput
    GOTO DispRec

EdDied:
    LOCATE 22,1
    PRINT "Has pilot ever died before? [Y/N] "
    GOSUB GetInput
    IF i$ = "Y" OR i$ = "y" THEN Died% = 1 : GOTO EdEject
    IF i$ = "N" OR i$ = "n" THEN Died% = 0 : GOTO EdEject
    BEEP
    GOTO EdDied
EdEject:
    LOCATE 22,1
    PRINT "How many times has pilot ejected? [0-99] "
    loopy% = 0
GetEject:
    LOCATE 22,45
    GOSUB GetInput
    IF VAL(i$) <> 0 THEN
        loopy% = loopy%*10+VAL(i$)
        IF loopy% > 99 THEN loopy% = 99
        PRINT loopy%;" ";
        GOTO GetEject
    ELSEIF i$=CHR$(13) THEN
        Eject% = loopy%
        GOSUB ClearInput
        GOTO DispRec
    ELSEIF i$=CHR$(8) THEN
        loopy% = FIX(loopy%/10)
        PRINT loopy%;" ";
        GOTO GetEject
    ELSEIF i$="0" THEN
        loopy% = loopy%*10
        IF loopy% > 99 THEN loopy% = 99
        PRINT loopy%;" ";
        GOTO GetEject
    ELSE
        BEEP
        GOTO GetEject
    END IF

EdMedals:
    RESTORE Medals
    FOR loopx% = 0 TO 8
        READ x$
        LOCATE 22,1
        PRINT "How many ";x$;"'s?                    ";
        loopy% = 0
    GetMed:
        LOCATE 22,42
        GOSUB GetInput
        IF VAL(i$) <> 0 THEN
            loopy% = loopy%*10+VAL(i$)
            IF loopy% > 99 THEN loopy% = 99
            PRINT loopy%;" ";
            GOTO GetMed
        ELSEIF i$=CHR$(13) THEN
            Medals%(loopx%) = loopy%
            GOTO EndLoopMed
        ELSEIF i$=CHR$(8) THEN
            loopy% = FIX(loopy%/10)
            PRINT loopy%;" ";
            GOTO GetMed
        ELSEIF i$="0" THEN
            loopy% = loopy%*10
            IF loopy% > 99 THEN loopy% = 99
            PRINT loopy%;" ";
            GOTO GetMed
        ELSE
            BEEP
            GOTO GetMed
        END IF
    EndLoopMed:
    Next loopx%
    GOSUB ClearInput
    GOTO DispRec

EdCampaign:
    RESTORE Campaigns
    FOR loopx% = 1 TO 3
        READ x$
        LOCATE 22,1
        PRINT "How many ";x$;" campaigns? [0-9]          ";
    GetCamp:
        GOSUB GetInput
        IF VAL(i$) <> 0 THEN
            Campaign%(loopx%) = VAL(i$)
            GOTO EndLoopCamp
        ELSEIF i$="0" THEN
            Campaign%(loopx%) = 0
            GOTO EndLoopCamp
        ELSE
            BEEP
            GOTO GetCamp
        END IF
    EndLoopCamp:
    NEXT loopx%
    GOSUB ClearInput
    GOTO DispRec


GetInput:
    Edit1:
        i$ = INKEY$
        IF i$ <> "" THEN GOTO Edit1
    Edit2:
        i$ = INKEY$
        IF i$ = "" THEN GOTO Edit2
    RETURN

ClearInput:
    LOCATE 22,1
    PRINT STRING$(79," ")
    PRINT STRING$(79," ");
    RETURN

SaveRec:
    OPEN "ROSTER." FOR BINARY AS #1
    SEEK #1, (Number%*94)
    IF Score& > 65535 THEN
        Score3%=FIX(Score&/65536)
        Score& = Score& - (Score3% * 65536)
    ELSE
        Score3% = 0
    END IF
    IF Score& > 255 THEN
        Score2% = FIX(Score&/256)
        Score& = Score& - (CLNG(Score2%) * 256)
    ELSE
        Score2% = 0
    END IF
    Score1% = Score&
    MID$(Record$,2) = Pilot$
    FOR loopx% = (LEN(Pilot$)+1) TO 35
        MID$(Record$,(loopx%+1)) = CHR$(0)
    NEXT loopx%
    MID$(Record$,38) = CHR$(Rank%)
    MID$(Record$,39) = CHR$(Status%)
    MID$(Record$,71) = CHR$(Score1%)
    MID$(Record$,72) = CHR$(Score2%)
    MID$(Record$,73) = CHR$(Score3%)
    SELECT CASE Died%
        CASE 0
            MID$(Record$,89) = CHR$(0)
            MID$(Record$,90) = CHR$(0)
            MID$(Record$,91) = CHR$(0)
        CASE ELSE
            MID$(Record$,89) = CHR$(255)
            MID$(Record$,90) = CHR$(255)
            MID$(Record$,91) = CHR$(1)
    END SELECT
    MID$(Record$,79) = CHR$(Eject%)
    loopy% = 43
    FOR loopx% = 0 TO 8
        MID$(Record$,(loopy%+loopx%)) = CHR$(Medals%(loopx%))
    NEXT loopx%
    loopy% = 60
    FOR loopx% = 1 TO 3
        MID$(Record$,(loopy%+loopx%)) = CHR$(Campaign%(loopx%))
    NEXT loopx%
    PUT$ #1, Record$
    CLOSE #1
    LOCATE 22,24
    PRINT "Roster record saved successfully"
    DELAY 2
    GOSUB ClearInput
    GOTO LoadRec

Abort:
    LOCATE 22,1
    PRINT "Have you saved?  Are you sure you wish to exit to DOS? "
    GOSUB GetInput
    IF i$ = "n" OR i$ = "N" THEN GOSUB ClearInput : GOTO Edit
    IF i$ <> "Y" AND i$ <> "y" THEN BEEP : GOTO Abort
    CLOSE
    END

' Error handling (Probably ROSTER. opening/writing/closing problem)

ErrorHandler:
    IF ERR<>53 GOTO MiscError
    CLS
    PRINT "File Not Found error, please check that the file  ROSTER.  exists"
    PRINT "in the current directory."
    END
    MiscError:
    CLS
    PRINT "Error number ";ERR;" occurred in F15 Strike Eagle ]I[ Editor."
    PRINT "Please correct and rerun."
    END
