program setfiletime;
{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  : 1993/07/14.  First public release.  DDA
v1.10  : 1993/09/07.  Added support for single field specification,
                            suggestion and assistance from Don Dougherty.  DDA
                      Added support for century.
                            (Set century=2000 for 20th century dates.)  DDA
v1.10a : 1993/09/09.  Now specifying seconds is optional, default is :00  DDA
v1.11  : 1993/09/13.  Added "/p": prompt for date, time doesn't change.  DDA

------------------------------------------------------------------------------}

uses dos;
var
   dirinfo : searchrec ;
   ps2     : string ;
   century : word ;

procedure showhelp ( errornum : byte );
const
    progdata = 'REDATE!- Free DOS utility: file redater.';
    progdat2 = 'V1.11: September 13, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';

    usage = 'Usage: REDATE! file(s) [mm/dd/yy (or) mm-dd-yy] [hh:mm[:ss]]';
    usag2 = '  or : REDATE! file(s) /p  (prompt for date, time doesn''t change)';
var
    message : string [80];
begin
    writeln ( progdata );
    writeln ( progdat2 );
    writeln ;
    writeln ( usage );
    writeln ( usag2 );
    writeln ;

    case errornum of
      1 : message := 'you must specify -exactly- one filespec (wildcards are OK).';
      2 : message := 'too many parameters.';
      3 : message := 'non-numeric found in a date or time string!';
    end;
    writeln ( 'ERROR: (#',errornum,') - ', message );
    halt ( errornum );
end;

function leadingzero ( w : word ) : string ;
var
  s : string ;
begin
  str (w:0,s);
  if length (s) = 1 then
    s := '0' + s;
  leadingzero := s;
end;

procedure parsedate ( dates : string ; var cdt : longint );
var
     date_time : datetime;
     valerr : integer ;
begin
     with date_time do
     begin
          val ( copy ( dates ,1,2 ), month, valerr );
              if valerr <> 0 then showhelp (3);
          val ( copy ( dates ,4,2 ), day,   valerr );
              if valerr <> 0 then showhelp (3);
          val ( copy ( dates ,7,2 ), year,  valerr );
              if valerr <> 0 then showhelp (3);
          year := century + year;
     end;
     packtime ( date_time, cdt );
end;

procedure parsetime ( times : string ; var cdt : longint );
var
     date_time : datetime;
     valerr : integer ;
begin
     if length ( times ) = 5 then
        times := times + ':00' ;
     with date_time do
     begin
          val ( copy ( times ,1,2 ), hour, valerr );
              if valerr <> 0 then showhelp (3);
          val ( copy ( times ,4,2 ), min,  valerr );
              if valerr <> 0 then showhelp (3);
          val ( copy ( times ,7,2 ), sec,  valerr );
              if valerr <> 0 then showhelp (3);
     end;
     packtime ( date_time, cdt );
end;

procedure get_dt ( var cur_dt : longint );
var
    y,mo,d,w,
    h,mi,s,u  : word;
    date_time : datetime;
begin
     getdate (y,mo,d,w);
     gettime (h,mi,s,u);
     with date_time do
     begin
          YEAR := y;  MONTH := mo;  DAY := d;
          HOUR := h;  MIN   := mi;  SEC := s;
     end;
     packtime ( date_time, cur_dt );
end;

function extract_file_date ( fname : string ) : string ;
var
    afile : file ;
    fdate : longint ;
    dtt   : datetime ;
    dstr  : string ;
begin
     assign (afile, fname);
     reset (afile);
     getftime (afile, fdate);
     close (afile);
     unpacktime ( fdate, dtt );
     dstr := '' ;
     with dtt do begin
          dstr := dstr + leadingzero ( month ) + '/' ;
          dstr := dstr + leadingzero ( day ) + '/' ;
          dstr := dstr + ( copy ( ( leadingzero ( year )), 3, 2 ));
     end;
     extract_file_date := dstr ;
end;

function extract_file_time ( fname : string ) : string ;
var
    afile : file ;
    ftime : longint ;
    dtt   : datetime ;
    tstr  : string ;
begin
     assign (afile, fname);
     reset (afile);
     getftime (afile, ftime);
     close (afile);
     unpacktime ( ftime, dtt );
     tstr := '' ;
     with dtt do begin
          tstr := tstr + leadingzero ( hour ) + ':' ;
          tstr := tstr + leadingzero ( min ) + ':' ;
          tstr := tstr + leadingzero ( sec );
     end;
     extract_file_time := tstr ;
end;

procedure stampfile ( fname : string ; ftime : longint );
var
   afile : file ;
begin
     assign (afile, fname);
     reset (afile);
     setftime (afile, ftime);
     close (afile);
     write ('.');
end;

procedure todaysdate;
var
   dt : longint ;
begin
     get_dt ( dt );
     while doserror = 0 do begin
           stampfile ( dirinfo.name, dt );
           findnext ( dirinfo );
     end;
end;

procedure justdate ( datestr : string );
var
   timestr : string ;
   dt_int  : longint ;
begin
     parsedate ( datestr , dt_int );
     while doserror = 0 do begin
           timestr := extract_file_time ( dirinfo.name );
           parsetime ( timestr , dt_int );
           stampfile ( dirinfo.name , dt_int );
           findnext ( dirinfo );
     end;
end;

procedure justtime ( timestr : string );
var
   datestr : string ;
   dt_int  : longint ;
begin
     parsetime ( timestr , dt_int );
     while doserror = 0 do begin
           datestr := extract_file_date ( dirinfo.name );
           parsedate ( datestr , dt_int );
           stampfile ( dirinfo.name , dt_int );
           findnext ( dirinfo );
     end;
end;

procedure newdate ( datestr, timestr : string );
var
   dt_int : longint ;
begin
     parsedate ( datestr , dt_int );
     parsetime ( timestr , dt_int );
     while doserror = 0 do begin
           stampfile ( dirinfo.name , dt_int );
           findnext ( dirinfo );
     end;
end;

var cent : string ;
    vale : integer ;

begin
     findfirst ( paramstr (1), archive, dirinfo );
     if ( doserror <> 0) then
          showhelp(1);
     write ( 'Working ' );

     cent := getenv ( 'century' );
     if cent = '' then cent := '1900' ;
     val ( cent, century, vale );
     if vale <> 0 then century := 1900 ;

     case paramcount of
          1 : todaysdate;
          2 : begin
                 ps2 := paramstr ( 2 );
                 if ((ps2 = '/p') or (ps2 = '/P')) then
                    begin
                       while ( length (ps2) < 8) do begin
                          writeln ;
                          writeln ('Enter a date in the format mm/dd/yy:');
                          readln  (ps2);
                       end;
                       justdate (ps2);
                    end
                 else
                 if (( ps2[3] = '-' ) or
                     ( ps2[3] = '/' )) then justdate ( ps2 )
                 else justtime ( ps2 );

              end;
          3 : newdate ( paramstr (2), paramstr (3) );
     else
          showhelp(2);
     end;   { case }

     writeln ( ' done!' );
end.
