@echo off
cls
echo This batch file illustrates different output formats FFG provides.  A search
echo for .COM, .BAT, and .EXE files is used as an example.
echo.
echo Because the list of files may be long for each search, you may want to
echo press the ESCAPE key to interrupt the search and move on to the next
echo example.
echo.
pause
REM --------------------------------------------------------------------------
cls
echo This is the default output format:
pause
echo on
ffg /p *.com+*.exe+*.bat
@echo off
echo.
pause
REM --------------------------------------------------------------------------
cls
echo Next is a search where only the summary is shown:
pause
echo on
ffg *.com+*.exe+*.bat /fs.
@echo off
echo.
pause
REM --------------------------------------------------------------------------
cls
echo Next only the full file path will be shown.  This output can be
echo redirected to a file, which is useful for creating an @FILE file for ZIPing
echo groups of files.  Other programs besides ZIP also support @ files for input.
echo Since this output would likely be redirected, output of the summary information
echo is turned off.
pause
echo on
ffg /p *.com+*.exe+*.bat /fp /fs!
@echo off
echo.
pause
REM --------------------------------------------------------------------------
cls
echo Next the output will be in a comma-delimited ASCII database format.  This
echo is good for import into most databases.
pause
echo on
ffg /p *.com+*.exe+*.bat /f, /fs!
@echo off
echo.
pause
REM --------------------------------------------------------------------------
cls
echo Next is the database format again, but now only selected information will
echo be shown.  In this example we chose to capture the disk drive letter,
echo directory path, and file name.  Attributes, date and time are not
echo captured.
pause
echo on
ffg /p *.com+*.exe+*.bat /f,:rf.e /fs!
@echo off
echo.
pause
REM --------------------------------------------------------------------------
cls
echo Next is "batch file" output format which is intended to be redirected to
echo a batch file for subsequent processing of the files as a group.  In this
echo case we want a batch file that has two replaceable parmeters before the
echo found file and one more after it.  Later this batch file could be
echo executed with the desired command and options.  For example, if the
echo output were redirected to a file called DO-IT.BAT, the following command
echo.
echo        DO-IT XCOPY /V A:
echo.
echo would result in XCOPYing (with VERIFY) each file to the A: drive.
echo.
echo This is one of FFG's most powerful features.  It provies file grouping
echo capabilities that you can not achieve with DOS alone.
echo.
pause
echo on
ffg /p *.com+*.exe+*.bat /fb1_2_pf.e_3 /fs!
@echo off
echo.
pause
cls
