@echo off
rem This batch file requires Fdate v7.0 or greater

if (%1)==(SUBROUTINE) goto %2
cls
if (%1)==() goto help
if (%1)==(?) goto help

if (%2)==() goto OKparm2
if (%2)==(REM) goto OKparm2
if (%2)==(rem) goto OKparm2
if (%2)==(Rem) goto OKparm2
echo Invalid second parm [%2].
goto endit
:OKparm2

set year=%1

rem verify %1 (year parm) is a valid year
Fdate /Ff /A01-01-%year% /occyy /p"@set year=">junktemp.bat
if errorlevel 1 echo Year parm [%1] is not valid.
call junktemp.bat
del  junktemp.bat
if errorlevel 1 goto help


cls
echo 
echo                   FEDERAL HOLIDAYS IN %year%
echo 
echo.



REM =========== NEW YEARS DAY: JANUARY 1 ======================
set holiday=01-01-%year%
Fdate /Ff /A%holiday% /odow# /p"@set dow#=">junktemp.bat
call junktemp.bat

REM Popular leave day: the Monday before a Tuesday holiday
%2 if %dow#%==3 Fdate /Fadd /N-1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

CALL %0  SUBROUTINE CheckWeekend %holiday%
Fdate /Ff /A%holiday% /p"New Year's Day %year%%cf%..."

REM Popular leave day: the Friday after a Thursday holiday
%2 if %dow#%==5 Fdate /Fadd /N+1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

REM =========== MARTIN LUTHER KING BIRTHDAY: 3rd Monday in January
Fdate /Fw /D2 /N3 /A01-01-%year% /P"Martin Luther King, Jr. Birthday........"
Fdate /Fw /D2 /N3 /A01-01-%year% /Omm-dd-ccyy /P"@set MLKDAY="> JUNKTEMP.BAT
call junktemp.bat


REM =========== INAUGURATION DAY: JAN 20, every 4th year after 1965
set holiday=01-20-%year%
Fdate /Ff /A%holiday% /odow# /p"@set dow#=">junktemp.bat
call junktemp.bat

rem Inauguration day became a federal holiday starting in 1966
Fdate /F#comp /A%year% /B1966 /p"@set mod=">junktemp.bat
call junktemp.bat
if (%mod%)==(LT) goto EndInaugural

Fdate /F#mod /A%year% /B4 /p"@set mod=">junktemp.bat
call junktemp.bat
if (%mod%)==(1) goto Inaugural
                goto EndInaugural

:Inaugural

:Popular leave day: the Tuesday between MLK birthday and Inauguration Day
%2 if %dow#%==4 Fdate /Fadd /N-1 /A%holiday% /P"-- POPULAR LEAVE DAY (Washington, DC)..."


REM Jan 20 is inauguration day, unless it falls on a SUNDAY

set pf= .................
if %dow#%==7 echo       (Inauguration Day, January 20, falls on Saturday)
if %dow#%==7 goto EndInaugural
if %dow#%==1 goto Imoved
             goto Iweekday

:Imoved
REM Inauguration day (Jan 20) falls on a Sunday.  Move it to Monday.
Fdate /Fadd /A%holiday% /N+1 /omm-dd-ccyy /p"@set holiday=">junktemp.bat
call junktemp.bat
set pf= (celebrated).....
set dow#=2
:Iweekday

if %holiday%==%mlkday% echo       (Inauguration Day falls on same day as M. L. King's birthday)
if %holiday%==%mlkday% goto endInaugural

Fdate /Ff /A%holiday% /p"Inauguration Day%pf%......"
echo       (Applies only to Federal employees working in the Washington, DC area)

REM Popular leave day: the Friday after a Thursday holiday
%2 if %dow#%==5 Fdate /Fadd /N+1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

echo.
:EndInaugural
set pf=
REM ===============================================================


REM ======== GEORGE WASHINGTON's BIRTHDAY: 3rd Monday in February
Fdate /Fw /D2 /N3 /A02-01-%year% /P"Washington's Birthday..................."


REM =============== MEMORIAL DAY: last monday in May ==============
Fdate /FW /D2 /N-1 /A05-31-%year% /P"Memorial Day............................"


REM =============== INDEPENDENCE DAY: July 4 ====================
set holiday=07-04-%year%
Fdate /Ff /A%holiday% /Odow# /p"@set dow#=">junktemp.bat
call junktemp.bat

REM Popular leave day: the Monday before a Tuesday holiday
%2 if %dow#%==3 Fdate /Fadd /N-1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

CALL %0  SUBROUTINE CheckWeekend %holiday%
Fdate /Ff /A%holiday% /p"Independence Day%cf%......"

REM Popular leave day: the Friday after a Thursday holiday
%2 if %dow#%==5 Fdate /Fadd /N+1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."


REM =============== LABOR DAY: first Monday in September ==========
Fdate /Fw /D2 /N1  /A09-01-%year% /P"Labor Day..............................."


REM =============== COLUMBUS DAY: second Monday in October ========
Fdate /Fw /D2 /N2  /A10-01-%year% /P"Columbus Day............................"


REM =============== VETERAN'S DAY: November 11 =================
set holiday=11-11-%year%
Fdate /Ff /A%holiday% /odow# /p"@set dow#=">junktemp.bat
call junktemp.bat

REM Popular leave day: the Monday before a Tuesday holiday
%2 if %dow#%==3 Fdate /Fadd /N-1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

CALL %0  SUBROUTINE CheckWeekend %holiday%
Fdate /Ff /A%holiday% /p"Veteran's Day%cf%........."

REM Popular leave day: the Friday after a Thursday holiday
%2 if %dow#%==5 Fdate /Fadd /N+1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."


REM =============== THANKSGIVING: 4th Thursday in November ========
REM Get date of Thanksgiving in mm-dd-ccyy format
Fdate /Fw /D5 /N4  /A11-01-%year% /Omm-dd-ccyy /P"@set holiday=">junktemp.bat
call junktemp.bat

Fdate /Ff /A%holiday%  /P"Thanksgiving Day........................"

REM Popular leave day: the Friday after a Thursday holiday
%2 Fdate /Fadd /N+1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."


REM =============== CHRISTMAS DAY: December 25 =================
set holiday=12-25-%year%
Fdate /Ff /A%holiday% /odow# /p"@set dow#=">junktemp.bat
call junktemp.bat

REM Popular leave day: the Monday before a Tuesday holiday
%2 if %dow#%==3 Fdate /Fadd /N-1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

REM The President often gives Federal employees leave on the afternoon
REM of Christmas Eve, when Christmas Day falls on Friday
%2 if %dow#%==6 Fdate /Fadd /A%holiday% /N-1 /P"-- President MAY grant leave for afternoon of "

CALL %0  SUBROUTINE CheckWeekend %holiday%
Fdate /Ff /A%holiday% /p"Christmas Day%cf%........."

REM Popular leave day: the Friday after a Thursday holiday
%2 if %dow#%==5 Fdate /Fadd /N+1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."


REM =============== NEW YEARS DAY: January 1 ===================
rem advance year to next year
fdate /f#add /a%year% /b1 /p"@set year=">junktemp.bat
call junktemp.bat

set holiday=01-01-%year%
Fdate /Ff /A%holiday% /odow# /p"@set dow#=">junktemp.bat
call junktemp.bat

REM Popular leave day: the Monday before a Tuesday holiday
%2 if %dow#%==3 Fdate /Fadd /N-1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

CALL %0  SUBROUTINE CheckWeekend %holiday%
Fdate /Ff /A%holiday% /p"New Year's Day %year%%cf%..."

REM Popular leave day: the Friday after a Thursday holiday
%2 if %dow#%==5 Fdate /Fadd /N+1 /A%holiday% /P"-- POPULAR LEAVE DAY...................."

set year=
set cf=..................
set holiday=
echo.
goto cleanup

REM ================================================================
REM               SUBROUTINES
REM ================================================================
:help
cls
echo 
echo                   HOW TO USE HOLIFEDS.BAT
echo 
ECHO HOLIFEDS with a YEAR parameter displays federal holidays in YEAR, along with
ECHO          days that are likely to be popular as annual-leave days.
ECHO.
ECHO HOLIFEDS with a YEAR parameter followed by the word "REM" displays federal
ECHO          holidays in YEAR, and supresses display of popular leave days.
ECHO.
ECHO EXAMPLES:
ECHO   HOLIFEDS 1996        displays federal holidays & popular leave days in 1996
ECHO   HOLIFEDS 1996 REM    displays federal holidays in 1996
ECHO.
ECHO 
echo The notation "(celebrated)" means that the holiday actually falls on
ECHO a Saturday or Sunday, so Federal workers are given the previous Friday
ECHO or the following Monday as a holiday.
ECHO 
ECHO.
ECHO When the calendar is displayed, you can print it by pressing SHIFT+PRINTSCREEN
ECHO.
goto endit


:CheckWeekend
shift
shift
goto Dow-%dow#%

:dow-1
Fdate /Fadd /A%1 /N+1 /omm-dd-ccyy /p"@set holiday=">junktemp.bat
set dow#=2
call junktemp.bat
set cf= (celebrated).....
goto endit

:dow-7
Fdate /Fadd /A%1 /N-1 /omm-dd-ccyy /p"@set holiday=">junktemp.bat
call junktemp.bat
set dow#=6
set cf= (celebrated).....
goto endit

:dow-2
:dow-3
:dow-4
:dow-5
:dow-6
set holiday=%1
set cf=..................
goto endit


:CLEANUP
set fdate=
set dow#=
set mod=
set mlkday=
set cf=
set pf=
if exist  junktemp.bat del  junktemp.bat

:endit
