@echo off
CLS
goto EndDoc
----------------------------------------------------------------------
HOLIDAYS.BAT for FDATE version 4.3a
===================================
If you have any corrections to the algorithms
in this batch file, please send them to Steve Ferg.

If environment variable RAMDISK is set before running this batch
file, then it will use the RAM disk and run a bit faster.
----------------------------------------------------------------------
Revision history:
===================================
4.2b Jan 6, 1992
     Corrected algorithm for Advent (thanks to L. Schliesser)
4.2c Jan 10, 1992
     Added entry for LABOR DAY (1st Monday in Sept) (thanks to L. S.)
4.3a Jan 12, 1992
     Removed all /Imm-dd-ccyy and /Od1, since those are now the default.
4.4a Jan 20, 1992
     Added beginning of Black History month to demonstrate new /S
     Added x'FF' in Black History month entry to demonstrate formatting
6.1a Feb 14, 1992
     Now use new /V parm to set environment variables.
6.2a Feb 19, 1992
     Return to using batch file to set environment variables,
           for users of 4DOS and NDOS, for whom /V will not work
7.0a Nov 23, 1992
     added Canadian Thanksgiving Day
----------------------------------------------------------------------
:EndDoc

if not (%1)==() goto nohelp
echo 
echo                   HOW TO USE HOLIDAYS.BAT
echo 
ECHO HOLIDAYS without any parameters displays events in current year.
ECHO.
ECHO HOLIDAYS [year]                 displays events in [year].
ECHO EXAMPLE: HOLIDAYS 1999          displays events in year 1999.
ECHO.
ECHO.
ECHO.
ECHO To print the calendar, press SHIFT+PRINTSCREEN to print each screen.
ECHO.
pause
cls
:nohelp


rem --------------------------------------------------------
rem get current year
rem --------------------------------------------------------
Fdate /Ff /At /Occyy /P"@set year=" >%RAMDISK%JUNKTEMP.BAT
call %RAMDISK%JUNKTEMP.BAT


REM if user specifies a year as parm1, use it
if not (%1)==() set year=%1


rem --------------------------------------------------------
rem Determine if year is a leapyear
rem AND check for validity of year parm (%1)
rem --------------------------------------------------------
Fdate /Ff /A01-01-%year% /Oly /P"@set LY=" >%RAMDISK%JUNKTEMP.BAT
call %RAMDISK%JUNKTEMP.BAT
if (%LY%)==(ERROR) echo Parm #1 was not a valid year: %1
if (%LY%)==(ERROR) goto endit



echo 
if (%LY%)==(0) ECHO                   EVENTS IN %YEAR%
if (%LY%)==(1) ECHO                   EVENTS IN %YEAR%         Note: %year% is a leap year
echo 
Fdate /Ff         /A01-01-%year% /P"New Year's Day........................"
Fdate /Ff         /A01-06-%year% /P"Epiphany.............................."

Fdate /Fw /D2 /N3 /A01-01-%year% /P"Martin Luther King, Jr. Day..........."
Fdate /Ff /A02-01-%year% /P" Note that " /S" begins Black History Month"
rem   note use of x'ff'     ^^^^ for formatting
Fdate /Ff         /A02-14-%year% /P"Valentine's day......................."
Fdate /Fw /D2 /N3 /A02-01-%year% /P"Presidents' Day......................."
Fdate /Ff         /A03-17-%year% /P"St. Patricks's Day...................."

if (%LY%)==(1) Fdate /Ff /A02-29-%year% /P"Sadie Hawkins Day....................."

REM ========== begin: DATES TIED TO EASTER==============================
set easter=
if (%year%)==(1991) set easter=03-31-%year%
if (%year%)==(1992) set easter=04-19-%year%
if (%year%)==(1993) set easter=04-11-%year%
if (%year%)==(1994) set easter=04-03-%year%
if (%year%)==(1995) set easter=04-16-%year%
if (%year%)==(1996) set easter=04-07-%year%
if (%year%)==(1997) set easter=03-30-%year%
if (%year%)==(1998) set easter=04-12-%year%
if (%year%)==(1999) set easter=04-04-%year%
if (%year%)==(2000) set easter=04-23-%year%
if (%year%)==(2001) set easter=04-15-%year%
if (%easter%)==() goto unknown
echo.
Fdate /Fsub /N40 /A%easter% /P"Mardi Gras (Shrove Tuesday)..........."
Fdate /Fsub /N46 /A%easter% /P"Ash Wednesday (Lent begins)..........."
Fdate /Fsub /N7  /A%easter% /P"Palm Sunday..........................."
Fdate /Fsub /N2  /A%easter% /P"Good Friday..........................."
Fdate /Ff        /A%easter% /P"Easter................................"
:unknown
REM ==========   end: DATES TIED TO EASTER==============================

echo 
PAUSE
CLS

Fdate /Fw /D4 /N4  /A04-01-%year% /P"Secretary's Day......................."
Fdate /Ff          /A05-05-%year% /P"Cinco de Mayo (Mexico)................"

Fdate /Fw /D1 /N2  /A05-01-%year% /P"Mother's Day.........................."
Fdate /Fw /D2 /N-1 /A05-24-%year% /P"Victoria Day (Canada)................."
Fdate /FW /D2 /N-1 /A05-31-%year% /P"Memorial Day (observed)..............."

if not (%easter%)==() Fdate /Fadd /N39 /A%easter% /P"Ascension Day........................."
if not (%easter%)==() Fdate /Fadd /N49 /A%easter% /P"Pentecost............................."
if not (%easter%)==() echo.
Fdate /Ff         /A06-14-%year% /P"Flag Day.............................."
rem ----- anniversary of Bloom's Day, June 16, 1904 ------------------
rem Here's a way to show an anniversary or event that you want to note.
rem Thanks to L. Schliesser for the algorithm.
rem ------------------------------------------------------------------
Fdate /F#dif /A%year% /B1904 /P"@set ann=" >%RAMDISK%JUNKTEMP.BAT
call %RAMDISK%JUNKTEMP.BAT
Fdate /Ff         /A06-16-%year% /P"Bloom's Day (%ann%th anniversary)........"
SET ann=
rem ---------------end bloom's day --------------------------------------

Fdate /Fw /D1 /N3 /A06-01-%year% /P"Father's Day.........................."
Fdate /Ff         /A07-01-%year% /P"Canada Day (Canada)..................."
Fdate /Ff         /A07-04-%year% /P"Independence Day (USA)................"
Fdate /Ff         /A07-14-%year% /P"Bastille Day (France)................."

rem echo 
rem PAUSE
rem CLS

Fdate /Fw /D2 /N1 /A09-01-%year% /P"Labor Day............................."


rem ---- begin ------- note a particular day in a particular year
rem This technique is useful for noting special events:
rem 21st birthdays, 50th wedding anniversaries, etc.
if (%year%)==(1992) Fdate /Ff /A10-12-%year% /P"500th ann. of Columbus's discovery...."
rem ----  end -------- note a particular day in a particular year

Fdate /Fw /D2 /N2  /A10-01-%year% /P"Columbus Day (observed)..............."
Fdate /Fw /D2 /N2  /A10-01-%year% /P"Thanksgiving Day (Canada)............."
Fdate /Ff          /A11-11-%year% /P"Veteran's Day........................."

rem third thursday in November
Fdate /Fw /D5 /N4  /A11-01-%year% /P"Thanksgiving Day (USA)................"


Fdate /Fw /D1 /N-4 /A12-24-%year% /P"First Sunday in Advent................"
Fdate /Ff          /A12-25-%year% /P"Christmas............................."
Fdate /fadd /N1    /A12-31-%year% /P"New Year's Day........................"
echo 
:endit
DEL %RAMDISK%JUNKTEMP.BAT>nul
set year=
set easter=
set LY=
