;-----------------------------------------------------------------------
; DL!LOGON.RS - Robocomm 4.x script for DataLink - TBBS/QSO
;               Logon to board, reset profile if necessary
;.......................................................................
; Author:   Rick Matthews
; Date:     06/27/93
; Version:  2.1
;
; Notes:    In order for this script to function properly, your login
;           name must be set up within RoboComm as "First;Last".
;           The ";" is very important.  Instead of "JOHN DOE", it should
;           be "JOHN;DOE".  The script will not function properly
;           otherwise.
;
;           This script will also reset your help level to expert (2),
;           and reset your page length so that Datalink will not stop on
;           each page with the -More- message.  QSO will be checked to
;           ensure that Zmodem is set as the download method for the
;           mail packets.
;
;           Your last message read, and other information is captured
;           and stored in the RoboComm Statistics area for the BBS.
;
;-----------------------------------------------------------------------
TITLE "Logon to DataLink"

:LOGON
WHEN "FIRST NAME?"              SEND "%BBS13%;;%BBS7%|y"
WHEN "correct?"                 SEND "Y"
WHEN "Password:"                SEND "%BBS7%|"
WHEN "TO CONTINUE"              SEND "|"
WHEN "Read Now(Y/N)?"           SEND "N"
WHEN "-Press Any Key-"          SEND "|"
WHEN "-More-"                   SEND "|"
WHEN "breaking in to chat"      SEND "Script file, cannot respond.|"
WHEN "TBBS Welcomes"            CAPTURE "%ID%.STS" OVERWRITE
WAITFOR "COMMAND:"              FAILURE GOTO LOGONFAIL

; Capture board statistics, current phone line, and remaining
; download time and load into RoboComm Statistics for DataLink

MESSAGE "Capturing Datalink Statistics for RoboComm'
SEND "W"
WAITFOR "COMMAND:"
SEND "T"
WAITFOR "COMMAND:"
CLOSE
MESSAGE "Storing Data in RoboComm BBS Statistics"
STATISTICS "%ID%.STS"
SEND "="
WHEN "DataLink Main Menu"       GOTO Reset_Profile
:CONTINUE
WAITFOR "COMMAND:"
EXIT 0

:LogonFail
MESSAGE "Unable to Login, hanging up"
HANGUP
EXIT 1

:Reset_Profile
;
MESSAGE "Setting User Profile for Optimum Script Performance"
CLEAR WATCHES
WHEN "each display page(Y/N)"   SEND "N"
WHEN "on each transfer (Y/N)?"  SEND "N"
WHEN "Protocol:"                SEND "Z"
WHEN "protocols:"               SEND "Z"
;
; Set help level to Expert level 2
;
MESSAGE "Setting Help level to 2"
SEND "U"
WAITFOR "Command:"
SEND "X"
WAITFOR "New level?"
SEND "2"
WAITFOR "Command:"
;
; Set page pause off
:
MESSAGE "Setting Page Pause to Off"
SEND "P"
WAITFOR "Set Page Pause"
SEND "P"
WAITFOR "to exit:"
;
; Set Download Protocol to Zmodem
;
MESSAGE "Setting File Download Protocol to Zmodem"
SEND "D"
WAITFOR "to exit:"
;
; Set upload protocol to zmodem
;
MESSAGE "Setting File Upload Protocol to Zmodem"
SEND "U"
WAITFOR "exit:"
SEND "|="
;
; Let's Check the protocol settings for QSO
;
MESSAGE "Setting QSO Protocol to Zmodem"
SEND "Q"
WAITFOR "Main Menu Command"
SEND "C"
WAITFOR "Menu Command?"
SEND "P"
WAITFOR "Menu Command?"
SEND "Q"
WAITFOR "Main Menu Command"
SEND "Q|="
GOTO Continue
;
; End of Script
;
