/************************************************************************
  Author:  SemWare (Richard Blackburn)
  Date:    April 8, 1993

  Description:

  A couple of macros to go to the next and previous paragraphs.
  Assumes paragraphs are separated by blank lines.

  Usage notes:

  To use, add these macros to your TSE.S file, and key assignments to
  your TSE.KEY file, and re-bind the editor using the -b switch of sc.

  Example key assignments might be:

  <f7>          NextPara()
  <f8>          PrevPara()

  Alternatively, add the key assignments to this file, and load the
  macro (as an external macro) as needed via the LoadMacro command
  (<ctrl f10><L> or 'menu->macro->load')
 ************************************************************************/

// Go to the start of the next Paragraph.
proc NextPara()
    // if in a paragraph, scan till the end of it
    while PosFirstNonWhite()
        if not Down()
            goto common_exit
        endif
    endwhile

    // skip any blank lines
    while PosFirstNonWhite() == 0
        if not Down()
            goto common_exit
        endif
    endwhile

    common_exit:
    GotoPos(PosFirstNonWhite())
end

// If in a para (and not on the first line) go to the beginning of the para.
// Otherwise, go to the beginning of the previous para.
proc PrevPara()
    if not Up()
        goto common_exit
    endif

    while PosFirstNonWhite() == 0
        if not Up()
            goto common_exit
        endif
    endwhile

    while PosFirstNonWhite()
        if not Up()
            goto common_exit
        endif
    endwhile

    Down()

    common_exit:
    GotoPos(PosFirstNonWhite())
end

