program graphix;

uses
    crt;

var
    color:byte;

{*******************************************************************}

procedure video_mode(mode:byte);
begin
      asm
        mov  AH,00
        mov  AL,mode
        int  10h
      end;
end;

{*******************************************************************}

procedure set_color(color,red,green,blue:byte);
begin
    port[$3c8]:=color;
    port[$3c9]:=red;
    port[$3c9]:=green;
    port[$3c9]:=blue;
end;

{*******************************************************************}

procedure get_color(color,red,green,blue:byte);
begin
    port[$3c8]:=color;
    red:=port[$3c9];
    green:=port[$3c9];
    blue:=port[$3c9];
end;

{*******************************************************************}

procedure put_pixel(x,y:integer; color:byte);
begin
     mem[$A000:(320*y)+x]:=color;
end;

{*******************************************************************}

procedure get_pixel(x,y:integer; color:byte);
begin
     color:=mem[$A000:(320*y)+x];
end;

{*******************************************************************}

begin
    video_mode($13);            {sets mode to 320x200x256}
    set_color(50,63,63,63);     {sets color 50 to white}
    put_pixel(100,100,50);      {puts a pixel at 100,100, color 50}
    get_pixel(100,100,color);   {gets the value of color at 100,100}
    repeat until keypressed;
    video_mode(3);              {sets mode to standard 80x25 text}
    writeln('The color # at 100,100 was: ',color);

end.