@ECHO off
CLS
REM Safecopy.bat
REM This program will copy a file to a new location, then
REM   delete the file from it's original location and
REM   show where the file is newly located
IF NOT %1==? GOTO START
:INSTRUCTIONS
ECHO.
ECHO   ͻ
ECHO             The syntax for SAFECOPY is as follows:                   
ECHO                                                                      
ECHO                 SAFECOPY Filename NewFilePath                        
ECHO                                                                      
ECHO    After typing SAFECOPY, leave a space, type the filename you want, 
ECHO    leave another space, and copy the destination path that you want  
ECHO    the file to be copied to. EXAMPLE: SAFECOPY Hounds C:\Dogs\Hounds 
ECHO                                                                      
ECHO                 Okay, partner. Start over again.                     
ECHO   ͼ
PAUSE
GOTO END
:START                                    
REM Begin the program here
CLS
ECHO.
ECHO     ͻ
ECHO                      SAFECOPY IS IN ACTION                    
ECHO                                                               
ECHO     ͼ
ECHO.
ECHO.
REM First check for errors
ECHO "%1" has been chosen as the SOURCE file   
ECHO "%2" has been chosen as the TARGET path
ECHO.
REM Another error check opportunity
ECHO "%1" will be copied to "%2"         
ECHO.
PAUSE
ECHO ___________________________________________________________________________
ECHO.
ECHO Copying SOURCE "%1" to TARGET "%2"
REM Checking for target files pre-existence
IF EXIST %2 GOTO AlreadyExists            
IF NOT EXIST %2 GOTO HereNext
:AlreadyExists
ECHO.
ECHO ͻ
ECHO   That file path already exists. DO YOU WANT TO OVERWRITE IT?  
ECHO                     If NOT press CTRL-C                        
ECHO    If you DO want to overwrite the file path, then continue    
ECHO ͼ
ECHO.
PAUSE
:HereNext
REM Checking for source file existence
IF EXIST %1 GOTO GO_ON
IF NOT EXIST %1 GOTO NOTEXIST         
:NOTEXIST
ECHO.
ECHO ͻ
ECHO   Sorry, partner. The source file doesn't seem to exist 
ECHO                   Check your spelling                   
ECHO                           or                            
ECHO                Try a different filename                 
ECHO ͼ
ECHO.
REM Exiting if no source file
GOTO END                                  
:GO_ON
REM Copy Source to Target
ECHO.
Copy %1 %2                                
ECHO.
REM Checking Target to see if copy worked
ECHO Checking the target path - to see if "%1" has landed safely
ECHO.                                     
PAUSE
CLS
ECHO.
IF NOT EXIST %2 GOTO NOFILE               
IF EXIST %2 GOTO NEXT
:NOFILE
ECHO ͻ
ECHO  Sorry, partner. The source file didn't copy to that path 
ECHO                      Try a new path                       
ECHO ͼ
ECHO.
REM Exit if copy didn't occur for any reason
GOTO END                                  
:NEXT                                     
REM Showing Source's new location
ECHO THIS IS THE NEW LOCATION FOR "%1": 
REM Creating horizontal alphabetized directory
dir/o/w/p %2                              
ECHO.
ECHO ͻ
ECHO         The source file has been copied correctly to the target      
ECHO                              *****                                   
ECHO         If you DON'T want the source file deleted, press CTRL-C      
ECHO             The source file will Remain UNTOUCHED if you do          
ECHO                              *****                                   
ECHO            IF YOU CONTINUE - THE SOURCE FILE WILL BE DELETED         
ECHO         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!       
ECHO ͼ
PAUSE
REM Deleting Source file
del %1                                    
CLS
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO        "%1" has been DELETED from its original directory position
ECHO        "%1" is now located at "%2"
ECHO.
ECHO.
ECHO.
ECHO             ͻ 
ECHO               !!!!!   Thank you for using SAFECOPY  !!!!!  
ECHO                                  @;-)                      
ECHO               Another Wink^Ware creation from OPPENHEIMER  
ECHO             ͼ
ECHO.
ECHO.
PAUSE
CLS
:END

REM  Created by Michael J. Penner
REM             717 W. Elm St.
REM             Olathe, KS 66061
REM
REM             Voice phone - 913-829-3747
REM             Home fax    - 913-829-6625
REM             Home BB     - 913-829-3723 (KC-RSNET) RSNET=PASSWORD
