%
%
% This is an example with ALL control statements that can be used in the
% MTA.CTL (alike) file. This is a normal ASCII file. Rules for coding
% are:
%
% - Case is not important
% - A line without '%' or ';' in the first position is considered a
%   control statement;
%
% - Lines with a '%' or ';' character in position 1 are comment
%   statements.
%
% - The starting position of the options is not important but the ORDER
%   of the parameters is. You can start an option ANYWHERE on the line
%   but lines can not exceed 255 bytes in length !
%
%
%
%
%                   B A S I C   S T A T E M E N T S
%
ARCPath                      C:\SYS\ARC\ARC.EXE       N 192
UNARCPath                    C:\SYS\ARC\XARC.EXE      N 192
PAKPath                      C:\SYS\ARC\PAK.EXE       Y 256
DWCPath                      C:\SYS\ARC\DWC.EXE       N 256
LZHPath                      C:\SYS\ARC\LHARC.EXE     Y 256
LZSPath                      C:\SYS\ARC\LARC.EXE      N 192
ZOOPath                      C:\SYS\ARC\ZOO.EXE       N 256
PKZIPPath                    C:\SYS\ARC\PKZIP.EXE     Y 256 C:\SYS\ARC\P2ZIP.EXE
PKUNZIPPath                  C:\SYS\ARC\PKUNZIP.EXE   N 192 C:\SYS\ARC\P2UNZIP.EXE
ZIP2EXEPath                  C:\SYS\ARC\ZIP2EXE.EXE   N 192
PKUNPAKPath                  C:\SYS\ARC\PKUNPAK.EXE   N 192
MDPath                       C:\SYS\ARC\MDCD.EXE      N 192
ARJPath                      C:\SYS\ARC\ARJ.EXE       Y 512 C:\SYS\ARC\ARJNEW.EXE
SQZPath                      C:\SYS\ARC\SQZ.EXE       Y 512
HYPERPath                    C:\SYS\ARC\HYPER.EXE     N 320
PKLITEPath                   C:\SYS\ARC\PKLITE.EXE    N 256
JPG2GIFPath                  C:\SYS\ARC\JPG2GIF.EXE   N 512
GIF2JPGPath                  C:\SYS\ARC\GIF2JPG.EXE   N 512
GIFLITEPath                  C:\SYS\ARC\GIFLITE.EXE   N 320
GIFTESTPath                  C:\SYS\ARC\GIFTEST.EXE   N 320
%
CompressionType              ZIP
%
LZHVersion                   212
PAKVersion                   210
ZIPVersion                   110 200
%
ZIPCompression               -ex
% ZSFCompression             -ex
ZOOCompression               h
DWCCompression                z
LZHCompression               /O-
% LSFCompression             /O-
ARJCompression               -jm
% ASFCompression             -jm
% SQZCompression             /m1
% SSFCompression             /m1
PKLITECompression            -b
% GIFLITECompression         Use what you like
% G2JCompression             Use what you like
% J2GCompression             Use what you like
%
OriginalARJName
%
%
%
%                    M T A   E N V I R O N M E N T
%
% TempPath                   E:\ 300000
MTATempPath                  E:\ZIP\MTA 200000
ALTMTATempPath               D:\ZIP\MTA 200000
MTAErrorPath                 E:\ZIP\ERR
FDUTempPath                  E:\ZIP\DIS
FDUTrashPath                 E:\ZIP\TRA
% ITSPath                    E:\
% SwapPath                   E:\
% NoEMS
% NoXMS
% MoveToDir                  E:\ZIP\TRA
FreeMemory                   150000
RunTime                      600
% Not4DosAware
% VideoMode                  3
SubstDrive                   FGH
% SubstOn  C:\DOS\SUBST.EXE %DF %PP
% SubstOff C:\DOS\SUBST.EXE %DF /D
% NoSubstTest
ExtendedTesting
% ShareWait                  1200
AltDisplay
WarningTime                  10
% NoBeep
%
%
%
%                         M T A   L O G G I N G
%
LogPath                      D:\LOG\MTA__RUN.LOG
AVLogPath                    D:\LOG\MTA__AVS.LOG
NormalPasswordListPath       D:\LOG\MTA__PWD.LOG
RandomPasswordListPath       D:\LOG\MTA__PWD.LOG
LogThreshold                 128000
%
% FRONTDOOR  <tm>  style
%
% LogStartStyleFormat        ^M----------__%D__,_MTA
% LogStyleFormat             >__%T__
% LogTimeFormat              hh:mm:ss
% LogDateFormat              dd_nnn_yy
%
% D'BRIDGE    <tm>  style
%
LogStyleFormat               %D_%T__MTA:_
LogDateFormat                mm/dd/yy
LogTimeFormat                hh:mm
%
% QUICKBBS    <tm> style
%
% LogStyleFormat             %D_%T__
% LogDateFormat              dd-nnn-yy
% LogTimeFormat              hh:mm
%
% OPUS  1.XX   <tm> style
%
% LogStyleFormat             +_%D_%T_MTAZ_
% LogDateFormat              dd_nnn
% LogTimeFormat              hh:mm:ss
%
% B I N K L E Y      <tm> style
%
% LogStyleFormat             +_%D_%T_MTAZ_
% LogDateFormat              dd_nnn
% LogTimeFormat              hh:mm:ss
%
% FANTASY           style
%
% LogStyleFormat             MTALOG__%D__%T__Executed:_
% LogDateFormat              dd_nnn_yyyy
% LogTimeFormat              hh:mm:ss
%
%
%
%                  F I L E   S E L E C T I O N
%
% DefaultPath                C:\ZIP     E:\ZIP
% DefaultPath                C:\ZIP\TRA
% DefaultPath                C:\ZIP\MOV
%
% DoNot                      *.A0?
% DoNot                      *.A1?
% DoNot                      *.A2?
% DoNot                      *.A3?
% DoNot                      *.A4?
% DoNot                      *.A5?
% DoNot                      *.A6?
% DoNot                      *.A7?
% DoNot                      *.A8?
% DoNot                      *.A9?
% DoNot                      ALLFILES.*
% DoNot                      F:\DONOT\*.ZIP
%
SFXFiles
MaxGifDim                    640 480 256
% NoMarked
% MarkHeader                 MYCONV
% MarkString                 Insert_Your_ID
% Unmark
% ExcludeFriendlyMark        ??????Insert_Your_ID
% OnlyNewFiles
% DelOldFiles                01-1990 Ask
% DelOldFiles                -365
% DelOldPath                 E:\OLDFILES
% SkipNewFiles               10
%
%
%
%                  R E S U L T I N G   F I L E S
%
ExcludeFile                  !               SUB
ExcludeFile                  CHKLIST.CPS     SUB
ExcludeFile                  U_READ.ME
ExcludeFile                  LOGO.ASC        SUB
ExcludeFile                  WHO_FROM.TXT    SUB
ExcludeFile                  CRCKLIST.CRC
ExcludeFile                  SAFE_OWL.COM    SUB
ExcludeFile                  RUN_THIS.COM    SUB
ExcludeFile                  #CRC_DIR.SEC    SUB
%
% IncludeFile                C:\ZIP\BBE.SND !
% IncludeFile                C:\DOC\BPPC.CAT
% IncludeFile                C:\ZIP\MTABAT.BAT AutoLarc.BAT
%
TouchHig
% TouchLow
% TouchCur +10
%
ChildTouch FILE
%
MakeArc                      *.*
MakeArcExclude               *.GIF
%
FixedConversion              NODELIST.A?? ARC
FixedConversion              NODEDIFF.A?? ARC
%
% IgnoreTimeComponent
% AcceptHighDate
% NoArcInArc
% OptimizeOnSize
% OnlyUpgrade
% AllDisketteFiles
% KeepAbnormalExtensions
ReportSpecialAttributes
% ReportSpecialAttributes SKIP
ReportInvalidFiles
%
KeepAV
IncludeAVFile *.EXE       @@@###
IncludeAVFile *.COM       @@@###
IncludeAVFile SCAN*.*     NWN405
IncludeAVFile CLEAN*.*    NWN405
IncludeAVFile VSHLD*.*    NWN405
IncludeAVFile VCOPY*.*    NWN405
IncludeAVFile 4DOS*.*
IncludeAVFile ARJ*.EXE    0000
IncludeAVFile UNARJ*.EXE  0000
ExcludeAVFile *.*         FOO001 DELETE
ExcludeAVFile *.*         RVH001 KEEP
ExcludeAVFile *.*         1234   MOVE
%
KeepVolLabel
% SkipBackups
% OverwriteDuplicates
% Description
% AutoDescription             C:\SYS\ARC\MYHEADER.ANS
%
%
%
%                    O W N   C O M P R E S S O R
%
% OwnCompressPath            C:\SYS\ARC\PKZIP.EXE Y SWAP
% OwnCompressCall            -a %1 *.*
% OwnCompressLowErrorRC      1
% OwnDeCompressPath          C:\SYS\ARC\PKUNZIP.EXE N SWAP
% OwnDecompressCall          -x %1
% OwnDeCompressLowErrorRC    1
% OwnExtension               RVH
% OwnRecursive
%
%
%
%                 V I R U S  S C A N N E R S
%
% Working example for : SCAN (V9x>)   
%
VirusScanner   McAfee_SCAN      B 300 1       C:\SYS\VIR\SCAN.EXE   %P /NOMEM /NOPAUSE /E
%
% Working example for : TBSCAN (V4x>) 
%
% VirusScanner Thunderbyte_SCAN D 240 1       C:\SYS\VIR\TBSCAN.EXE %F -analyze -compat -valid -sub -batch -logd:\log\tbscan.log -logall
%
% Working example for : HTSCAN (V16>) 
%
% VirusScanner Thijssen_SCAN    D 300 175 255 C:\SYS\VIR\HTSCAN.EXE %P /A /B- /P- /V=C:\SYS\VIR\TBSCAN.DAT /O=D:\LOG\HTSCAN.LOG
%
% Working example for : VIRX (2.3>)   
%
% VirusScanner VIRX_SCAN        D 330 1   255 C:\SYS\VIR\VIRX.EXE   %P -L -A -M -E -BI -BM -RD:\LOG\VIRX.LOG
%
% Working example for : CPAV (1.4>)   
%
VirusScanner   Central_Point    B 640 86      C:\SYS\VIR\CPAV.EXE   %S /S /P /NF
%
% Working example for : SOLOMON'S     
%
% VirusScanner Dr.Solomon_SCAN  D 640 2       C:\SYS\VIR\FINDVIRU.EXE %S /REPORT=D:\LOG\SOLOMON.LOG /NOBOOT /NOPART /DOALLFILES /MUTANT
%
% Working example for : GOBBLER       
%
% VirusScanner Gobbler          B 128 1       C:\SYS\VIR\GII.EXE -b %P
% Working example for : F-PROT        
%
% VirusScanner Skulason_FPROT   B 300 3     4 C:\SYS\VIR\F-PROT.EXE %F /COMMAND /RENAM /NOMEN /ALL /TROJAN /NOBREAK
%
% VirusMasks *.EXE *.COM *.SYS *.OVR *.BIN *.DLL *.OVR *.OVL
%
%                 E X I T S   A N D   O T H E R   H O O K S
%
% ExitBeforeStart            256  FLASH /D
% ExitBetweenConversion      512  C:\SYS\DIV\MTABETWE.BAT %1 %2 %3
% ExitAfterCompression       300  MAKESFX.BAT
% ExitBeforeFill             256  FORMAT A: /V
ExitAfterFill                C:\CAT\CATDISK.EXE /F?
% ExitBeforeEnd              FLASH /A
%
%
%
%                        B B S   O P T I O N S
%
% QBBSPaths                  D:\BBS\RAX\FILEDAT.CFG NEW
% RaPaths                    D:\BBS\RAX\FILES.RA  D:\BBS\FIL
% MaxPaths                   D:\BBS\MAX\AREAS.DAT
% ExcludeDirectory           D:\BBS\FIL\AMIGA
%
%
%
WeekExtension ARJ J
WeekExtension ARC A
WeekExtension ZIP Z
WeekExtension LZH L
WeekExtension LZS L
%
% CarryComment               1  ##_The_MTA_Board_##
FilesBBS                     Files.BBS
AddFilesBBS
FILEIDDiz                    FILE_ID.DIZ  DESC.SDI
LeadingSpace                 TRIM
% LeadingSpace               CHAR 032
% ReplaceComment
% FilesBBSFormat             1 1 14
FilesCounter                 START [ ]
% FilesCounter               END   ( )
% FilesCounter               NONE
DefFilesBBSDesc              NODELIST.* The new nodelist file
DefFilesBBSDesc              NODEDIFF.* The new nodediff file
DefFilesBBSDesc              NODE*.*    Something to do with nodelists
DefFilesBBSDesc              *.*        Sorry, no description present
%
%
TickFiles                    E:\INBOUND\*.TIC
TickFiles                    E:\INBOUND\*.BAD
FESFiles                     E:\INBOUND\*.FES
FESFiles                     E:\INBOUND\*.BAD
% UpdateUntypedFiles         D:\BBS\MAI\MSG\*.MSG
% UpdateUntypedFull
% UpdateMSGFiles             E:\BBS\MAI\MSG\
% UpdateMSGFull
% UpdateTICKFiles            D:\BBS\MAI\HLD\*.TIC
% UpdateFESFiles             D:\BBS\MAI\HLD\*.FES
%
%
% COMPort                    2
% FossilPort                 1
% Baudrate                   2400
% StoreSize                  XS1
% StoreName                  FILEDOOR.XS2
% StoreComment               FILEDOOR.XS3
% Remote
% RemoteColor 1 2 3 4 5 6    (A very rare combination !)
%
%
%
%                  S P E C I A L   S T A T E M E N T S
%
% IncludeCTL                 C:\SYS\OWN\MTACOMM.CTL
%
%
%
%              R E G I S T R A T I O N  (Only when registered)
%
% RegistrationName           [Unregistered Evaluation Copy]
