.I 0 6
/*
** KILLFF.C - A program was written to strip out all the Form Feeds
** in text files.
**
** Public domain by Erik VanRiper, 12/22/91
** Modified by Bob Stout, 17 Feb 93
.D 1 11
.I 13 11
** characters! The default action is to create a duplicate without
** Form Feeds, then remove the original and rename the dupliicate,
** although an explicit output file name may be specified.
**
** Form Feed characters are replaced with newline characters ('\n').
** Since ANSI mandates that fwrite() will translate newlines when
** a stream is opened in text (non-binary) mode, these will appear
** in the ouput file in a format appropriate to the implementation,
** e.g. CRLF pairs on PC's.
**
** Usage: KILLFF filename [newname]
.D 14 4
.I 23 1
#define BSIZ 32768U             /* max size of read/write buffer */
.D 24 1
.I 29 9
        temp[80],               /* output file name              */
        *buf;                   /* buffer we will use to write   */
/*        *s;                     /* searching pointer             */
   size_t bad,                  /* check to see if write ok      */
          num;                  /* number of bytes read          */
   int retval  = EXIT_SUCCESS,  /* return value                  */
       tmpflag = 0;             /* non-zero if tmpnam() used     */

   printf("\nKILL FORM FEEDS by Erik VanRiper & Bob Stout\n\n");
.D 30 8
.I 40 4
      puts("Usage: KILLFF input_file [output_file]");
      puts("\nIf no output file is given, the input file will "
           "be replaced.");
      return retval;                         /* return to OS     */
.D 41 2
.I 46 6
   else
   {
      tmpnam(temp);
      tmpflag = -1;
   }

.D 47 6
.I 54 2
      printf("\nCan't Open Input File %s",name);
      return (retval = EXIT_FAILURE);        /* return to OS     */
.D 55 3
.I 60 1
      printf("\nCan't Open Output File %s",temp);
.D 61 1
.I 62 11
      return (retval = EXIT_FAILURE);        /* return to OS     */
   }

   if((buf = malloc(BSIZ)) == NULL)     /* malloc a large buffer */
   {
      printf("\nOut of memory\n");
      return (retval = EXIT_FAILURE);        /* return to OS     */
   }

   printf("Input file: %s Output file: %s\n",
      name,tmpflag ? name : temp);
.D 63 5
.I 70 9
   while (0 < (num = fread(buf,sizeof(char),BSIZ,in)))
   {
      size_t i;

      for (i = 0; i < num; ++i)              /* look for FF      */
         if ('\f' == buf[i])
            buf[i] = '\n';                  /* change to newline */

      bad=fwrite(buf,sizeof(char),num,out);  /* write out buf    */
.D 71 8
.I 81 2
         retval = EXIT_FAILURE;              /* return to OS     */
         break;
.D 82 4
.D 87 1
.I 91 10
   if (tmpflag)
   {
      if (remove(name))
      {
         printf("Can't rename %s\n", name);
         printf("Converted file is named %s\n", temp);
      }
      else
         rename(temp, name);
   }
.I 92 13
   return retval;                            /* return to OS     */
}
/*

List this source file to test this program!

New page

New page

All done

*/
.D 93 2
