
#ifdef _MSC_VER
#include <malloc.h>
#endif

#ifdef __BORLANDC__
#include <alloc.h>
#endif

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "hhstring.h"

/*									*/
/*	global variables						*/
/*									*/
char part1[80];
char part2[80];
int printflag;			/* command line flag controls full	*/
				/*	 v.s. partial printing		*/
int ne; 			/* number of errors 			*/
/*									*/
/*	function prototypes						*/
/*									*/
void printline(char *linehead, char *answer, char *OKanswer);

/************************************************************************/
/*									*/
/*	main --- hhstring library test					*/
/*									*/
void main(int argc, char *argv[])
{
/*               01234567890123456789	to show character positions	*/
char *string1 = "time date size other";
char *string2 = "   123456789        ";
char *string3 = "Sample string w/CASE";
char *string4 = "   12345.678        ";
char *string5 = "1eAf57b        B13f9";
char *string6 = "sub1   SUB1     sub1";
char *string7 = "text1!text2,text3.so";

char *ans01 = "date size other";
char *ans02 = "time date";
char *ans03 = "size other";
char *ans04 = "           time date";
char *ans05 = "size other          ";
char *ans06 = "           123456789";
char *ans07 = "123456789           ";
char *ans08 = "size othertime date ";
char *ans09 = "123456789        ";
char *ans10 = "   123456789";
char *ans11 = "123456789";
char *ans12 = "---123456789";
char *ans13 = "123456789---";
char *ans14 = "      123456789     ";
char *ans15 = "      12345678      ";
char *ans16 = "     123456789     ";
char *ans17 = "      12345678     ";
char *ans18 = "--------------------";
char *ans19 = "---- date size other";
char *ans20 = "time date size -----";
char *ans21 = "TIME DATE SIZE OTHER";
char *ans22 = "time size other";
char *ans23 = "timedatesizeother";
char *ans24 = "timdatsizothr";
char *ans25 = "rehto ezis etad emit";
char *ans26 = "time------size other";
char *ans27 = "time----------------";
char *ans28 = "timtsizothr";
char *ans29 = "---123456789--------";
char *ans30 = "other";
char *ans31 = "time new size other";
char *ans32 = "time---size other";
char *ans33 = "  123456789 ";
char *ans34 = "  123456789  ";
char *ans35 = "  12345678  ";
char *ans36 = "   12345678  ";
char *ans37 = "123,456,789";
char *ans38 = "12,345,678";
char *ans39 = "1,234,567";
char *ans40 = "          size other";
char *ans41 = "time date           ";
char *ans42 = "   123,456,789";
char *ans43 = "ample tring w/CAE";
char *ans44 = "-ample -tring w/CA-E";
char *ans45 = " B13f9";

char work1[80];
char work2[80];
char work3[80];
char work4[80];

char *tempp;
char tempc;
int tempi;				/* scratch integer		*/
unsigned int ii;
int bad_command;
/*									*/
/* print the header							*/
/*									*/
printf(	"\n"
	"\n	Hobbit House utility to test hhstring.lib"
	"\n	-----------------------------------------\n");
/*									*/
/* set defaults for command line parameters				*/
/*									*/
printflag = 1;
bad_command = 0;			/* init bad command flag = off	*/
/*									*/
/* parse the command line						*/
/*									*/
for(ii = 1; ii < (unsigned)argc; ii++)	/* for each of the actual	*/
					/*   command line arguments:	*/
{ tempc = toupper((argv[ii][0]));	/* get the command character	*/
  switch(tempc)				/* switch on the command char	*/
  { case 'F':				/* case for print flag		*/
      printflag = 0;			/* reset the print flag		*/
      break;				/* break case F			*/
    default:				/* none of the above		*/
      bad_command = 1;			/* save the bad command		*/
      break;				/* break the default case	*/
  }					/* end the argument switch	*/
  /*									*/
  /* if a command line parameter is bad, tell the user and go bye bye	*/
  /*									*/
  if (bad_command)			/* if there's a bad cmd		*/
  { printf("\nthe command \"%s\" does "	/*   then tell the user what	*/
	"not compute!\n", argv[ii]);	/*     it was and exit back	*/
    exit(0);				/*	 to DOS			*/
  }					/* end if bad command		*/
}					/* end for all args		*/

if (printflag)
  printf("\n\n\n");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	atoh								*/
/*									*/
ltoa(atoh("  dead  "), work1, 16);
printline("atoh #1", work1, "dead");

ltoa(atoh("beef"), work1, 16);
printline("atoh #2", work1, "beef");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	atoh2								*/
/*									*/
ltoa(atoh2(&tempi, "  dead  "), work1, 16);
strrtpad(work1, 4, ' ');
itoa(tempi, work1 + 5, 10);
printline("atoh2 #1", work1, "dead 4");

ltoa(atoh2(&tempi, "1a"), work1, 16);
strrtpad(work1, 4, ' ');
itoa(tempi, work1 + 3, 10);
printline("atoh2 #2", work1, "1a 2");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	atolh								*/
/*									*/
ltoa(atolh("  deadbeef  "), work1, 16);
printline("atolh #1", work1, "deadbeef");

ltoa(atolh("123456789"), work1, 16);
printline("atolh #2", work1, "23456789");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	atolh2								*/
/*									*/
ltoa(atolh2(&tempi, "  deadbeef  "), work1, 16);
strrtpad(work1, 4, ' ');
ltoa(tempi, work1 + 9, 10);
printline("atolh2 #1", work1, "deadbeef 8");

ltoa(atolh2(&tempi, "  dead"), work1, 16);
strrtpad(work1, 4, ' ');
ltoa(tempi, work1 + 5, 10);
printline("atolh2 #2", work1, "dead 4");

ltoa(atolh2(&tempi, "  123456789"), work1, 16);
strrtpad(work1, 4, ' ');
ltoa(tempi, work1 + 9, 10);
printline("atolh2 #3", work1, "23456789 9");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	atoo								*/
/*									*/
ltoa(atoo("  123456"), work1, 8);
printline("atoo #1", work1, "123456");

ltoa(atoo("18"), work1, 8);
printline("atoo #2", work1, "1");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	atoo2								*/
/*									*/
ltoa(atoo2(&tempi, "  123456 "), work1, 8);
strrtpad(work1, 4, ' ');
ltoa(tempi, work1 + 7, 10);
printline("atoo2 #1", work1, "123456 6");

ltoa(atoo2(&tempi, "  18"), work1, 8);
strrtpad(work1, 4, ' ');
ltoa(tempi, work1 + 2, 10);
printline("atoo2 #1", work1, "1 1");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	btoc								*/
/*									*/
work1[0] = btoc(0);
work1[1] = btoc(1);
work1[2] = EOS;
printline("btoc", work1, "01");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ctob								*/
/*									*/
itoa(ctob('0'), work1, 10);
itoa(ctob('1'), work1 + 1, 10);
printline("ctob", work1, "01");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ctod								*/
/*									*/
itoa(ctod('0'), work1, 10);
itoa(ctod('9'), work1 + 1, 10);
printline("ctod", work1, "09");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ctoh								*/
/*									*/
itoa(ctoh('0'), work1, 16);
itoa(ctoh('f'), work1 + 1, 16);
printline("ctoh", work1, "0f");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	dtoc								*/
/*									*/
work1[0] = dtoc(0);
work1[1] = dtoc(9);
work1[2] = dtoc(10);		/* use error return to insert EOS	*/
printline("dtoc", work1, "09");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	fnconv_1to2							*/
/*									*/
strcpy(work1, "sub1.h");
fnconv_1to2(work1);
printline("fnconv_1to2 #1", work1, "sub1     h  ");

strcpy(work1, "thisfile.ext");
fnconv_1to2(work1);
printline("fnconv_1to2 #2", work1, "thisfile ext");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	fnconv_2to1							*/
/*									*/
strcpy(work1, "sub1     h  ");
fnconv_2to1(work1);
printline("fnconv_2to1 #1", work1, "sub1.h");

strcpy(work1, "thisfile ext");
fnconv_2to1(work1);
printline("fnconv_2to1 #2", work1, "thisfile.ext");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	htoc								*/
/*									*/
work1[0] = htoc(0);
work1[1] = htoc(15);
work1[2] = htoc(16);		/* use error return to put in EOS	*/
printline("htoc", work1, "0F");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	isfilename							*/
/*									*/
strcpy(work1, "12345678.9ab");
itoa(isfilename(work1), work2, 10);
strrtsize(work2, 4);
printline("isfilename #1", strcat(work2, work1), "0   12345678.9ab");

strcpy(work1, "*.bak");
itoa(isfilename(work1), work2, 10);
strrtsize(work2, 4);
printline("isfilename #2", strcat(work2, work1), "-1  *.bak");

strcpy(work1, "123<5>78.9ab");
itoa(isfilename(work1), work2, 10);
strrtsize(work2, 4);
printline("isfilename #3", strcat(work2, work1), "-2  123<5>78.9ab");

strcpy(work1, "123456789.ab");
itoa(isfilename(work1), work2, 10);
strrtsize(work2, 4);
printline("isfilename #4", strcat(work2, work1), "-3  123456789.ab");

strcpy(work1, "1234567.89ab");
itoa(isfilename(work1), work2, 10);
strrtsize(work2, 4);
printline("isfilename #5", strcat(work2, work1), "-4  1234567.89ab");

strcpy(work1, "*234*.abc");
itoa(isfilename(work1), work2, 10);
strrtsize(work2, 4);
printline("isfilename #6", strcat(work2, work1), "-5  *234*.abc");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstblank							*/
/*									*/
printline("ptrfirstblank #1", 1 + ptrfirstblank(string1), ans01);

printline("ptrfirstblank #2", ptrfirstblank("abcd123"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstchr							*/
/*									*/
printline("ptrfirstchr #1", ptrfirstchr(string1, 'd'), string1 + 5);

printline("ptrfirstchr #2", ptrfirstchr(string1, 't'), string1);

printline("ptrfirstchr #3", ptrfirstchr(string1, 'T'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstchri							*/
/*									*/
printline("ptrfirstchri #1", ptrfirstchri(string1, 'D'), string1 + 5);

printline("ptrfirstchri #2", ptrfirstchri(string1, 'T'), string1);

printline("ptrfirstchri #3", ptrfirstchri(string1, 'b'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstdig							*/
/*									*/
printline("ptrfirstdig #1", ptrfirstdig(string2), ans09);

printline("ptrfirstdig #2", ptrfirstdig(string1), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirsthex							*/
/*									*/
printline("ptrfirsthex #1", ptrfirsthex(string2), ans09);

printline("ptrfirsthex #2", ptrfirsthex(string5 + 9), ans45 + 1);

printline("ptrfirsthex #3", ptrfirsthex("ghijklmn"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstnotblank						*/
/*									*/
printline("ptrfirstnotblank #1", ptrfirstnotblank(string2), ans09);

printline("ptrfirstnotblank #2", ptrfirstnotblank("   "), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstnotchr							*/
/*									*/
printline("ptrfirstnotchr #1", ptrfirstnotchr(string2, ' '), ans09);

printline("ptrfirstnotchr #2", ptrfirstnotchr(ans18, '-'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstnotchri							*/
/*									*/
printline("ptrfirstnotchri #1", ptrfirstnotchri(string3, 's'), string3 + 1);

printline("ptrfirstnotchri #2", ptrfirstnotchri("aAaAa", 'a'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstnotdig							*/
/*									*/
printline("ptrfirstnotdig #1", ptrfirstnotdig(ans37), ans37 + 3);

printline("ptrfirstnotdig #2", ptrfirstnotdig("123"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstnothex							*/
/*									*/
printline("ptrfirstnothex #1", ptrfirstnothex(string5), string5 + 7);

printline("ptrfirstnothex #2", ptrfirstnothex(ans11), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstnotrange						*/
/*									*/
printline("ptrfirstnotrange #1",
		ptrfirstnotrange(ans37, '0', '9'), ans37 + 3);

printline("ptrfirstnotrange #2",
		ptrfirstnotrange(string2, ' ', '9'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstnotgr							*/
/*									*/
printline("ptrfirstnotgr #1",
		ptrfirstnotgr(ans37, "0123456789"), ans37 + 3);

printline("ptrfirstnotgr #2",
		ptrfirstnotgr("abcabc", "abc"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstnottextterm						*/
/*									*/
printline("ptrfirstnottextterm #1", ptrfirstnottextterm(ans06), ans11);

printline("ptrfirstnottextterm #2", ptrfirstnottextterm("     "), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstnotwhite						*/
/*									*/
printline("ptrfirstnotwhite #1", ptrfirstnotwhite(string2), ans09);

printline("ptrfirstnotwhite #2", ptrfirstnotwhite("      "), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstrange							*/
/*									*/
printline("ptrfirstrange #1", ptrfirstrange(string1, 'a', 'd'), ans01);

printline("ptrfirstrange #2", ptrfirstrange(string1, 'A', 'Z'), NULL);

printline("ptrfirstrange #3", ptrfirstrange(string2, '9', '0'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstgr							*/
/*									*/
printline("ptrfirstgr #1", ptrfirstgr(string2, "0123456789"), ans09);

printline("ptrfirstgr #2", ptrfirstgr(string1, "0123456789"), NULL);

printline("ptrfirstgr #3", ptrfirstgr(string1, ""), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstsub							*/
/*									*/
printline("ptrfirstsub #1", ptrfirstsub(string1, ans30), ans30);

printline("ptrfirstsub #2", ptrfirstsub(string1, "time"), string1);

printline("ptrfirstsub #3", ptrfirstsub(string1, "not here"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstsubi							*/
/*									*/
printline("ptrfirstsubi #1", ptrfirstsubi(ans21, "other"), "OTHER");

printline("ptrfirstsubi #2", ptrfirstsubi(string1, "OTHER"), ans30);

printline("ptrfirstsubi #3", ptrfirstsubi(string1, "not here"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirsttext							*/
/*									*/
printline("ptrfirsttext #1", ptrfirsttext(ans04), ans02);

printline("ptrfirsttext #2", ptrfirsttext("!.,;:this"), "this");

printline("ptrfirsttext #3", ptrfirsttext("!.,;:"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirsttextterm						*/
/*									*/
printline("ptrfirsttextterm #1", ptrfirsttextterm(string7), string7 + 5);

printline("ptrfirsttextterm #2", ptrfirsttextterm("this:is"), ":is");

printline("ptrfirsttextterm #3", ptrfirsttextterm("nonehere"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstwhite							*/
/*									*/
printline("ptrfirstwhite #1", ptrfirstwhite(string1), string1 + 4);

printline("ptrfirstwhite #2", ptrfirstwhite("abc\tother"), "\tother");

printline("ptrfirstwhite #3", ptrfirstwhite(ans18), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrfirstword							*/
/*									*/
printline("ptrfirstword #1", ptrfirstword(string2), ans09);

printline("ptrfirstword #2", ptrfirstword(string1 + 15), string1 + 15);

printline("ptrfirstword #3", ptrfirstword("    "), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastblank							*/
/*									*/
printline("ptrlastblank #1", ptrlastblank(string1), string1 + 14);

printline("ptrlastblank #2", ptrlastblank(ans18), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastchr							*/
/*									*/
printline("ptrlastchr #1", ptrlastchr(string1, 'e'), "er");

printline("ptrlastchr #2", ptrlastchr(string2, 'e'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastchri							*/
/*									*/
printline("ptrlastchri #1", ptrlastchri(string1, 'E'), "er");

printline("ptrlastchri #2", ptrlastchri(ans21, 'e'), "ER");

printline("ptrlastchri #3", ptrlastchri(string2, 'E'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastdig							*/
/*									*/
printline("ptrlastdig #1", ptrlastdig(string2), string2 + 11);

printline("ptrlastdig #2", ptrlastdig(ans06), "9");

printline("ptrlastdig #3", ptrlastdig(string1), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlasthex							*/
/*									*/
printline("ptrlasthex #1", ptrlasthex(string2), string2 + 11);

printline("ptrlasthex #2", ptrlasthex(string1), string1 + 18);

printline("ptrlasthex #3", ptrlasthex(ans18), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastnotblank							*/
/*									*/
printline("ptrlastnotblank #1", ptrlastnotblank(string2), string2 + 11);

printline("ptrlastnotblank #2", ptrlastnotblank(string1), "r");

printline("ptrlastnotblank #3", ptrlastnotblank("   "), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastnotchr							*/
/*									*/
printline("ptrlastnotchr #1", ptrlastnotchr(string2, ' '), string2 + 11);

printline("ptrlastnotchr #2", ptrlastnotchr(string1, 'r'), "er");

printline("ptrlastnotchr #3", ptrlastnotchr(ans18, '-'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastnotchri							*/
/*									*/
printline("ptrlastnotchri #1", ptrlastnotchri(string1, 'R'), "er");

printline("ptrlastnotchri #2", ptrlastnotchri(ans21, 'r'), "ER");

printline("ptrlastnotchri #3", ptrlastnotchri(ans18, '-'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastnotdig							*/
/*									*/
printline("ptrlastnotdig #1", ptrlastnotdig(ans12), ans12 + 2);

printline("ptrlastnotdig #2", ptrlastnotdig(string1), "r");

printline("ptrlastnotdig #3", ptrlastnotdig(ans11), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastnothex							*/
/*									*/
printline("ptrlastnothex #1", ptrlastnothex(ans12), ans12 + 2);

printline("ptrlastnothex #2", ptrlastnothex(string5), ans45);

printline("ptrlastnothex #3", ptrlastnothex(ans11), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastnotrange							*/
/*									*/
printline("ptrlastnotrange #1", ptrlastnotrange(ans27, ' ', '?'), ans27 + 3);

printline("ptrlastnotrange #2", ptrlastnotrange(string1, ' ', 'z'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastnotgr							*/
/*									*/
printline("ptrlastnotgr #1",
		ptrlastnotgr(ans37, "0123456789"), ans37 + 7);

printline("ptrlastnotgr #2",
		ptrlastnotgr("abcabc", "abc"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastnottextterm						*/
/*									*/
printline("ptrlastnottextterm #1", ptrlastnottextterm("abc.\t,"), "c.\t,");

printline("ptrlastnottextterm #2", ptrlastnottextterm(". , ! ; :"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastnotwhite							*/
/*									*/
printline("ptrlastnotwhite #1", ptrlastnotwhite("abc \t "), "c \t ");

printline("ptrlastnotwhite #2", ptrlastnotwhite("   \t  "), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastnotwordterm						*/
/*									*/
printline("ptrlastnotwordterm #1", ptrlastnotwordterm("abc \t "), "c \t ");

printline("ptrlastnotwordterm #2", ptrlastnotwordterm(" \t "), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastrange							*/
/*									*/
printline("ptrlastrange #1", ptrlastrange(string2, '0', '9'), string2 + 11);

printline("ptrlastrange #2", ptrlastrange(ans18, '0', '9'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastgr							*/
/*									*/
printline("ptrlastgr #1", ptrlastgr(string2, "0123456789"), string2 + 11);

printline("ptrlastgr #2", ptrlastgr(ans18, "0123456789"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastsub							*/
/*									*/
printline("ptrlastsub #1", ptrlastsub(string6, "sub1"), string6 + 16);

printline("ptrlastsub #2", ptrlastsub(string1, "size"), ans03);

printline("ptrlastsub #3", ptrlastsub(string6, "not here"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastsubi							*/
/*									*/
printline("ptrlastsubi #1", ptrlastsubi(string6, "SUB1"), string6 + 16);

printline("ptrlastsubi #2", ptrlastsubi(ans21, "size"), ans21 + 10);

printline("ptrlastsubi #3", ptrlastsubi(string6, "not here"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlasttext							*/
/*									*/
/*									*/
printline("ptrlasttext #1", ptrlasttext(string7), "so");

printline("ptrlasttext #2", ptrlasttext(", ! ; :"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlasttextterm							*/
/*									*/
printline("ptrlasttextterm #1", ptrlasttextterm(string7), ".so");

printline("ptrlasttextterm #2", ptrlasttextterm("nonehere"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastwhite							*/
/*									*/
printline("ptrlastwhite #1", ptrlastwhite(string1), string1 + 14);

printline("ptrlastwhite #2", 1 + ptrlastwhite("abc\tother"), ans30);

printline("ptrlastwhite #3", ptrlastwhite(ans18), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrlastword							*/
/*									*/
printline("ptrlastword #1", ptrlastword(string1), ans30);

printline("ptrlastword #2", ptrlastword(ans18), ans18);

printline("ptrlastword #3", ptrlastword("   "), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextblank							*/
/*									*/
printline("ptrnextblank #1", ptrnextblank(string1), string1 + 4);

printline("ptrnextblank #2", ptrnextblank(ans18), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextchr							*/
/*									*/
printline("ptrnextchr #1", ptrnextchr(string1, 'd'), string1 + 5);

printline("ptrnextchr #2", ptrnextchr(string1, 't'), string1 + 7);

printline("ptrnextchr #3", ptrnextchr(string1 + 5, 'd'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextchri							*/
/*									*/
printline("ptrnextchri #1", ptrnextchri(string1, 'D'), string1 + 5);

printline("ptrnextchri #2", ptrnextchri(string1, 'T'), string1 + 7);

printline("ptrnextchri #3", ptrnextchri(string1, 'b'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextdig							*/
/*									*/
printline("ptrnextdig #1", ptrnextdig(string2), ans09);

printline("ptrnextdig #2", ptrnextdig(string2 + 5), string2 + 6);

printline("ptrnextdig #3", ptrnextdig(string1), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnexthex							*/
/*									*/
printline("ptrnexthex #1", ptrnexthex(string2), ans09);

printline("ptrnexthex #2", ptrnexthex(string5), string5 + 1);

printline("ptrnexthex #3", ptrnexthex("ghijklmn"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextnotblank							*/
/*									*/
printline("ptrnextnotblank #1", ptrnextnotblank(string2), ans09);

printline("ptrnextnotblank #2", ptrnextnotblank(string1 + 4), ans01);

printline("ptrnextnotblank #3", ptrnextnotblank("   "), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextnotchr							*/
/*									*/
printline("ptrnextnotchr #1", ptrnextnotchr(string1 + 4, ' '), ans01);

printline("ptrnextnotchr #2", ptrnextnotchr(ans18, '-'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextnotchri							*/
/*									*/
printline("ptrnextnotchri #1", ptrnextnotchri("bAaAab", 'a'), "b");

printline("ptrnextnotchri #2", ptrnextnotchri("aAaAa", 'a'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextnotdig							*/
/*									*/
printline("ptrnextnotdig #1", ptrnextnotdig(ans37), ans37 + 3);

printline("ptrnextnotdig #2", ptrnextnotdig(ans37 + 3), ans37 + 7);

printline("ptrnextnotdig #3", ptrnextnotdig("123"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextnothex							*/
/*									*/
printline("ptrnextnothex #1", ptrnextnothex(string5), string5 + 7);

printline("ptrnextnothex #2", ptrnextnothex(ans11), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextnotrange							*/
/*									*/
printline("ptrnextnotrange #1",
		ptrnextnotrange(ans37 + 3, '0', '9'), ans37 + 7);

printline("ptrnextnotrange #2",
		ptrnextnotrange(string2, ' ', '9'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextnotgr							*/
/*									*/
printline("ptrnextnotgr #1",
		ptrnextnotgr(ans37 + 3, "0123456789"), ans37 + 7);

printline("ptrnextnotgr #2",
		ptrnextnotgr("dabcabc", "abc"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextnottextterm						*/
/*									*/
printline("ptrnextnottextterm #1", ptrnextnottextterm("., !:is"), "is");

printline("ptrnextnottextterm #2", ptrnextnottextterm("., !:"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextnotwhite							*/
/*									*/
printline("ptrnextnotwhite #1", ptrnextnotwhite(string2), ans09);

printline("ptrnextnotwhite #2", ptrnextnotwhite("a     "), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextrange							*/
/*									*/
printline("ptrnextrange #1", ptrnextrange(string1, 'a', 'd'), ans01);

printline("ptrnextrange #2", ptrnextrange(string5, ' ', 'z'), string5 + 1);

printline("ptrnextrange #3", ptrnextrange(string1, 'A', 'Z'), NULL);

printline("ptrnextrange #4", ptrnextrange(string2, '9', '0'), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextgr							*/
/*									*/
printline("ptrnextgr #1", ptrnextgr(string2, "0123456789"), ans09);

printline("ptrnextgr #2", ptrnextgr(string5, "1ea"), string5 + 1);

printline("ptrnextgr #3", ptrnextgr(string1, "0123456789"), NULL);

printline("ptrnextgr #4", ptrnextgr(string1, ""), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextsub							*/
/*									*/
printline("ptrnextsub #1", ptrnextsub(string1, ans30), ans30);

printline("ptrnextsub #2", ptrnextsub(string1, ans01), ans01);

printline("ptrnextsub #3", ptrnextsub(string1, "time"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextsubi							*/
/*									*/
printline("ptrnextsubi #1", ptrnextsubi(ans21, "other"), "OTHER");

printline("ptrnextsubi #2", ptrnextsubi(string1, "OTHER"), ans30);

printline("ptrnextsubi #3", ptrnextsubi(string1, ans01), ans01);

printline("ptrnextsubi #4", ptrnextsubi(string1, "time"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnexttext							*/
/*									*/
printline("ptrnexttext #1", ptrnexttext(string7), string7 + 6);

printline("ptrnexttext #2", ptrnexttext(" ! , : "), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnexttextterm							*/
/*									*/
printline("ptrnexttextterm #1", ptrnexttextterm(string7), string7 + 5);

printline("ptrnexttextterm #2", ptrnexttextterm("nonehere"), NULL);


/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextwhite							*/
/*									*/
printline("ptrnextwhite #1", ptrnextwhite(string1), string1 + 4);

printline("ptrnextwhite #2", ptrnextwhite("abc\tother"), "\tother");

printline("ptrnextwhite #3", ptrnextwhite("\tother"), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrnextword							*/
/*									*/
printline("ptrnextword #1", ptrnextword(string2), ans09);

printline("ptrnextword #2", ptrnextword(string1), ans01);

printline("ptrnextword #3", ptrnextword("    "), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevblank							*/
/*									*/
printline("ptrprevblank #1", ptrprevblank(strend(string1)), string1 + 14);

printline("ptrprevblank #2", ptrprevblank(string1 + 9), string1 + 4);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevchr							*/
/*									*/
printline("ptrprevchr #1", ptrprevchr(strend(string1), 'e'), "er");

printline("ptrprevchr #2", ptrprevchr(string1 + 9, ' '), string1 + 4);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevchri							*/
/*									*/
printline("ptrprevchri #1", ptrprevchri(strend(string1), 'E'), "er");

printline("ptrprevchri #2", ptrprevchri(strend(ans21), 'e'), "ER");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevdig							*/
/*									*/
printline("ptrprevdig #1", ptrprevdig(strend(string2)), string2 + 11);

printline("ptrprevdig #2", ptrprevdig(string5 + 4), string5);

printline("ptrprevdig #3", ptrprevdig(strend(ans06)), "9");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevhex							*/
/*									*/
printline("ptrprevhex #1", ptrprevhex(strend(string2)), string2 + 11);

printline("ptrprevhex #2", ptrprevhex(strend(string1)), string1 + 18);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevnotblank							*/
/*									*/
printline("ptrprevnotblank #1", ptrprevnotblank(strend(string2)), string2 + 11);

printline("ptrprevnotblank #2", ptrprevnotblank(string1 + 5), string1 + 3);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevnotchr							*/
/*									*/
printline("ptrprevnotchr #1", ptrprevnotchr(strend(string2), ' '), string2 + 11);

printline("ptrprevnotchr #2", ptrprevnotchr(string1 + 6, 'a'), ans01);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevnotchri							*/
/*									*/
printline("ptrprevnotchri #1", ptrprevnotchri(strend(string1), 'R'), "er");

printline("ptrprevnotchri #2", ptrprevnotchri(strend(ans21), 'r'), "ER");

/*printline("ptrprevnotchri #3", ptrprevnotchri(string1 + 6, 'A'), ans01);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevnotdig							*/
/*									*/
printline("ptrprevnotdig #1", ptrprevnotdig(strend(ans12)), ans12 + 2);

printline("ptrprevnotdig #2", ptrprevnotdig(strend(string1)), "r");

printline("ptrprevnotdig #3", 1 + ptrprevnotdig(string2 + 9), ans09);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevnotrange							*/
/*									*/
printline("ptrprevnotrange #1",
		ptrprevnotrange(strend(ans27), ' ', '?'), ans27 + 3);

printline("ptrprevnotrange #2",
		ptrprevnotrange(string1 + 9, 'a', 'z'), string1 + 4);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevnotgr							*/
/*									*/
printline("ptrprevnotgr",
		ptrprevnotgr(ans37 + 7, "0123456789"), ans37 + 3);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevnottextterm						*/
/*									*/
printline("ptrprevnottextterm",
		ptrprevnottextterm(11 + "this:,. \t!,"), "s:,. \t!,");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevnotwhite							*/
/*									*/
printline("ptrfirstnotwhite", ptrfirstnotwhite(string2), ans09);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevrange							*/
/*									*/
printline("ptrprevrange #1", ptrprevrange(strend(string2), '0', '9'), string2 + 11);

printline("ptrprevrange #2", ptrprevrange(string4 + 9, '0', '9'), string4 + 7);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevgr							*/
/*									*/
printline("ptrprevgr #1", ptrprevgr(strend(string2), "0123456789"), string2 + 11);

printline("ptrprevgr #2", ptrprevgr(string1, ""), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevsub							*/
/*									*/
printline("ptrprevsub #1", ptrprevsub(strend(string6), "sub1"), string6 + 16);

printline("ptrprevsub #2", ptrprevsub(strend(string1), "size"), ans03);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevsubi							*/
/*									*/
printline("ptrprevsubi #1", ptrprevsubi(strend(string6), "SUB1"), string6 + 16);

printline("ptrprevsubi #2", ptrprevsubi(strend(ans21), "size"), ans21 + 10);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevtext							*/
/*									*/
printline("ptrprevtext", ptrprevtext(string2 + 16), string2 + 3);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevtextterm							*/
/*									*/
printline("ptrprevtextterm", ptrprevtextterm(string7 + 11), string7 + 5);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevwhite							*/
/*									*/
printline("ptrprevwhite #1", ptrprevwhite(strend(string1)), string1 + 9);

strcpy(work1, "abc\tother");

printline("ptrprevwhite #2", 1 + ptrprevwhite(strend(work1)), ans30);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrprevword							*/
/*									*/
printline("ptrprevword #1", ptrprevword(strend(string1)), ans30);

printline("ptrprevword #2", ptrprevword(strend(string1) - 1), string1 + 10);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrthistext							*/
/*									*/
printline("ptrthistext #1", ptrthistext(string7 + 10), string7 + 6);

printline("ptrthistext #2", ptrthistext(" "), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	ptrthisword							*/
/*									*/
printline("ptrthisword #1", ptrthisword(string1 + 12), ans03);

printline("ptrthisword #2", ptrthisword(string1 + 10), ans03);

printline("ptrthisword #3", ptrthisword(string1 + 9), NULL);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strblank							*/
/*									*/
strcpy(work1, ans30);
strblank(work1);
printline("strblank #1", work1, "     ");

strcpy(work1, ans30);
printline("strblank #2", strblank(work1), "     ");


/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strblanktotab							*/
/*									*/
strcpy(work1, "This is         the     sample line");
strblanktotab(work1, 8);
printline("strblanktotab #1", work1, "This is\t\tthe\tsample line");

strcpy(work1, "This is     the     sample line");
strblanktotab(work1, 4);
printline("strblanktotab #2", work1, "This is\t\tthe\t\tsample line");

strcpy(work1, "This is         the     sample line");
printline("strblanktotab #1", strblanktotab(work1, 8),
			"This is\t\tthe\tsample line");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcenter							*/
/*									*/
strcpy(work1, string2);
*(work1+11) = ' ';
strcenter(work1);
printline("strcenter #2", work1, ans15);

strcpy(work1, string2);
*(strend(work1)-1) = '\0';
strcenter(work1);
printline("strcenter #3", work1, ans16);

strcpy(work1, string2);
*(work1+11) = ' ';
*(strend(work1)-1) = '\0';
strcenter(work1);
printline("strcenter #4", work1, ans17);

strcpy(work1, string2);
printline("strcenter #5", strcenter(work1), ans14);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcentern							*/
/*									*/
strcpy(work1, string2);
strcentern(work1, 12);
printline("strcentern #1", work1, ans33);

strcpy(work1, string2);
strcentern(work1, 13);
printline("strcentern #2", work1, ans34);

strcpy(work1, string2);
*(work1+11) = ' ';
strcentern(work1, 12);
printline("strcentern #3", work1, ans35);

strcpy(work1, string2);
*(work1+11) = ' ';
strcentern(work1, 13);
printline("strcentern #4", work1, ans36);

strcpy(work1, string2);
printline("strcentern #5", strcentern(work1, 12), ans33);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcenternew							*/
/*									*/
strcpy(work1, string2);
strcenternew(work2, work1);
printline("strcenternew #1", work2, ans14);

strcpy(work1, string2);
*(work1+11) = ' ';
strcenternew(work2, work1);
printline("strcenternew #2", work2, ans15);

strcpy(work1, string2);
*(work1+strlen(work1)-1) = '\0';
strcenternew(work2, work1);
printline("strcenternew #3", work2, ans16);

strcpy(work1, string2);
*(work1+11) = ' ';
*(work1+strlen(work1)-1) = '\0';
strcenternew(work2, work1);
printline("strcenternew #4", work2, ans17);

strcpy(work1, string2);
printline("strcenternew #5", strcenternew(work2, work1), ans14);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcenternnew							*/
/*									*/
strcenternnew(work1, string2, 12);
printline("strcenternnew #1", work1, ans33);

strcenternnew(work1, string2, 13);
printline("strcenternnew #2", work1, ans34);

strcpy(work1, string2);
*(work1+11) = ' ';
strcenternnew(work2, work1, 12);
printline("strcenternnew #3", work2, ans35);

strcpy(work1, string2);
*(work1+11) = ' ';
strcenternnew(work2, work1, 13);
printline("strcenternnew #4", work2, ans36);

printline("strcenternnew #5", strcenternnew(work1, string2, 12), ans33);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchecksuma							*/
/*									*/
/*	unsigned long  strchecksuma(char *instring);			*/
/*									*/
/*	<== not done yet <==	*/

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchecksumia							*/
/*									*/
/*	unsigned long  strchecksumia(char *instring);			*/
/*									*/
/*	<== not done yet <==	*/

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchecksumil							*/
/*									*/
/*	unsigned char  strchecksumil(char *instring);			*/
/*									*/
/*	<== not done yet <==	*/

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchecksuml							*/
/*									*/
/*	unsigned char  strchecksuml(char *instring);			*/
/*									*/
/*	<== not done yet <==	*/

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrcount							*/
/*									*/
itoa(strchrcount(string3, 's'), work1, 10);
printline("strchrcount #1", work1, "1");

itoa(strchrcount(string1, '-'), work1, 10);
printline("strchrcount #2", work1, "0");

itoa(strchrcount(ans18, '-'), work1, 10);
printline("strchrcount #3", work1, "20");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrcounti							*/
/*									*/
itoa(strchrcounti(string3, 's'), work1, 10);
printline("strchrcounti #1", work1, "3");

itoa(strchrcounti(string1, '-'), work1, 10);
printline("strchrcounti #2", work1, "0");

itoa(strchrcounti(ans18, '-'), work1, 10);
printline("strchrcounti #3", work1, "20");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrdel							*/
/*									*/
strcpy(work1, string1);
strchrdel(work1, ' ');
printline("strchrdel #1", work1, ans23);

strcpy(work1, string1);
printline("strchrdel #2", strchrdel(work1, ' '), ans23);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrdeli							*/
/*									*/

strcpy(work1, string3);
strchrdeli(work1, 's');
printline("strchrdeli #1", work1, ans43);

strcpy(work1, string3);
printline("strchrdeli #2", strchrdeli(work1, 's'), ans43);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrdelinew							*/
/*									*/

strcpy(work1, string3);
strchrdelinew(work2, work1, 's');
printline("strchrdelinew #1", work2, ans43);

strcpy(work1, string3);
printline("strchrdelinew #2", strchrdelinew(work2, work1, 's'), ans43);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrdelnew							*/
/*									*/
strchrdelnew(work1, string1, ' ');
printline("strchrdelnew #1", work1, ans23);

printline("strchrdelnew #2", strchrdelnew(work1, string1, ' '), ans23);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrdelrange							*/
/*									*/
strcpy(work1, string1);
strchrdelrange(work1,' ', 'e');
printline("strchrdelrange #1", work1, ans28);

strcpy(work1, string1);
printline("strchrdelrange #2", strchrdelrange(work1,' ', 'e'), ans28);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrdelrangenew						*/
/*									*/
strchrdelrangenew(work1, string1, ' ', 'e');
printline("strchrdelrangenew #1", work1, ans28);

printline("strchrdelrangenew #2",
		strchrdelrangenew(work1, string1, ' ', 'e'), ans28);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrdelgr							*/
/*									*/
strcpy(work1, string1);
strchrdelgr(work1, "e ");
printline("strchrdelgr #1", work1, ans24);

strcpy(work1, string1);
printline("strchrdelgr #2", strchrdelgr(work1, "e "), ans24);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrdelgrnew							*/
/*									*/
strchrdelgrnew(work1, string1, "e ");
printline("strchrdelgrnew #1", work1, ans24);

printline("strchrdelgrnew #2",
			strchrdelgrnew(work1, string1, "e "), ans24);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrfromc							*/
/*									*/
strcpy(work1, "\\\\");
tempc = strchrfromc(&tempi, work1);
itoa(tempi, work2, 10);
tempp = strend(work2);
tempp[0] = tempc;
tempp[1] = EOS;
printline("strchrfromc #1", work2, "2\\");

strcpy(work1, "\\t");
tempc = strchrfromc(&tempi, work1);
itoa(tempi, work2, 10);
tempp = strend(work2);
tempp[0] = tempc;
tempp[1] = EOS;
printline("strchrfromc #2", work2, "2\t");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrrpl							*/
/*									*/
strcpy(work1, string2);
strchrrpl(work1, ' ', '-');
printline("strchrrpl #1", work1, ans29);

strcpy(work1, string2);
printline("strchrrpl #2", strchrrpl(work1, ' ', '-'), ans29);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrrpli							*/
/*									*/
strcpy(work1, string3);
strchrrpli(work1, 'S', '-');
printline("strchrrpli #1", work1, ans44);

strcpy(work1, string3);
printline("strchrrpli #2", strchrrpli(work1, 'S', '-'), ans44);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrrplinew							*/
/*									*/
strcpy(work1, string3);
strchrrplinew(work2, work1, 'S', '-');
printline("strchrrplinew #1", work2, ans44);

strcpy(work1, string3);
printline("strchrrplinew #2",
		strchrrplinew(work2, work1, 'S', '-'), ans44);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrrplnew							*/
/*									*/
strchrrplnew(work1, string2, ' ', '-');
printline("strchrrplnew #1", work1, ans29);

printline("strchrrplnew #2", strchrrplnew(work1, string2, ' ', '-'), ans29);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strchrtoc							*/
/*									*/
strcpy(work1, "\5\t\142");
strtoc(work1, "\5");
strtoc(work2, "\t");
strtoc(work3, "\142");
work4[0] = EOS;
strxcat(work4, work1, work2, work3, NULL);
printline("strchrtoc", work4, "\\x05\\tb");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcode1							*/
/*									*/
/*	char *strcode1 (char *instring,	char *codestring);		*/
/*									*/
strcpy(work1,"EXAMPLE CODING STRING");
strcpy(work2, "sample string to en/decode");
strcode1(work2, work1);
printline("strcode1 #1", work2, "69,=<)eS7=-')gT<t7'a# ;.)5");
strcode1(work2, work1);
printline("strcode1 #2", work2, "sample string to en/decode");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcode2							*/
/*									*/
/*	char *strcode2(char *instring);					*/
/*									*/
strcpy(work2, "sample string to en/decode");
strcode2(work2);
work1[0] = work2[1];			/* just check a couple		*/
work1[1] = work2[3];			/*   of converted characters	*/
work1[2] = EOS;
printline("strcode2 #1", work1, "7P");
strcode2(work2);		/* this re-convert is the real test	*/
printline("strcode2 #2", work2, "sample string to en/decode");


/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcomma							*/
/*									*/
strcpy(work3, string2);

strcpy(work1, work3);
strcomma(work1);
printline("strcomma #1", work1, ans37);

strcpy(work1, work3);
*(work1+11) = ' ';
strcomma(work1);
printline("strcomma #2", work1, ans38);

strcpy(work1, work3);
*(work1+11) = ' ';
*(work1+10) = ' ';
strcomma(work1);
printline("strcomma #3", work1, ans39);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcommaf							*/
/*									*/
strcpy(work1, string4);
strcommaf(work1);
printline("strcommaf #1", work1, "12,345.678");

strcpy(work1, string4);
printline("strcommaf #2", strcommaf(work1), "12,345.678");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcommafnew							*/
/*									*/
strcpy(work1, string4);
strcommafnew(work2, work1);
printline("strcommafnew #1", work2, "12,345.678");

strcpy(work1, string4);
printline("strcommafnew #2", strcommafnew(work2, work1), "12,345.678");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcommafri							*/
/*									*/
strcommafri(work1, 1234);
printline("strcommafri #1", work1, "1,234");

strcommafri(work1, -1234);
printline("strcommafri #2", work1, "-1,234");


printline("strcommafri #3", strcommafri(work1, 1234), "1,234");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcommafrl							*/
/*									*/
strcommafrl(work1, 123456789L);
printline("strcommafrl #1", work1, ans37);

strcommafrl(work1, -123456789L);
printline("strcommafrl #2", work1, "-123,456,789");

printline("strcommafrl #3", strcommafrl(work1, 123456789L), ans37);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcommafrui							*/
/*									*/
strcommafrui(work1, (unsigned)60000L);
printline("strcommafrui #1", work1, "60,000");

printline("strcommafrui #2", strcommafrui(work1, (unsigned)60000L), "60,000");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcommafrul							*/
/*									*/
strcommafrul(work1, 4000000000L);
printline("strcommafrul #1", work1, "4,000,000,000");

printline("strcommafrul #2",
		strcommafrul(work1, 4000000000L), "4,000,000,000");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcomman							*/
/*									*/
strcpy(work1, string2);
strcomman(work1, 14);
printline("strcomman #1", work1, ans42);

strcpy(work1, string2);
printline("strcomman #2", strcomman(work1, 14), ans42);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcommanew							*/
/*									*/
strcpy(work1, string2);
strcommanew(work2, work1);
printline("strcommanew #1", work2, ans37);

strcpy(work1, string2);
*(work1+11) = ' ';
strcommanew(work2, work1);
printline("strcommanew #2", work2, ans38);

strcpy(work1, string2);
*(work1+11) = ' ';
*(work1+10) = ' ';
strcommanew(work2, work1);
printline("strcommanew #3", work2, ans39);

strcpy(work1, string2);
printline("strcommanew #4", strcommanew(work2, work1), ans37);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcommannew							*/
/*									*/
strcpy(work1, string2);
strcommannew(work2, work1, 14);
printline("strcommannew #1", work2, ans42);

strcpy(work1, string2);
printline("strcommannew #2", strcommannew(work2, work1, 14), ans42);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcommatoi							*/
/*									*/
strcpy(work1, ans39 + 4);
itoa(strcommatoi(work1), work2, 10);
printline("strcommatoi #1", work2, "4567");

strcpy(work1, "-1,234");
itoa(strcommatoi(work1), work2, 10);
printline("strcommatoi #2", work2, "-1234");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcommatol							*/
/*									*/
strcpy(work1, "2,000,000,000");
ltoa(strcommatol(work1), work2, 10);
printline("strcommatol #1", work2, "2000000000");

strcpy(work1, "-2,000,000,000");
ltoa(strcommatol(work1), work2, 10);
printline("strcommatol #2", work2, "-2000000000");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcommatoui							*/
/*									*/
strcpy(work1, "60,000");
ltoa(strcommatoui(work1), work2, 10);
printline("strcommatoui", work2, "60000");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strcommatoul							*/
/*									*/
strcpy(work1, "4,000,000,000");
ultoa(strcommatoul(work1), work2, 10);
printline("strcommatoul", work2, "4000000000");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strdelwhite							*/
/*									*/
strcpy(work1, string1);
printline("strdelwhite", strdelwhite(work1), ans23);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strend								*/
/*									*/
printline("strend", strend(string1)-5, ans30);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	streos								*/
/*									*/
strcpy(work1, string1);
printline("streos #1", streos(work1), work1);
for (ii = 0; ii < strlen(string1); ii++)
  if (work1[ii] != EOS)
    break;
if (ii == strlen(string1))
  strcpy(work1, "good");
else
  strcpy(work1, "bad");
printline("streos #2", work1, "good");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strfromc							*/
/*									*/
strcpy(work1, "a\\t\\142");
strfromc(work1);
printline("strfromc", work1, "a\tb");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strindex							*/
/*									*/
itoa(strindex(string1+15, string1), work1, 10);
printline("strindex", work1, "15");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strinsert							*/
/*									*/
strcpy(work1, string1 + 9);
printline("strinsert #1", strinsert(work1, 0, "time date"), string1);

strcpy(work1, string1);
strset(work1 + 10, '-');
work1[10] = EOS;
strinsert(work1, strlen(work1), "size other");
printline("strinsert #2", work1, string1);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strinsertnew							*/
/*									*/
strcpy(work1, string1 + 9);
printline("strinsertnew #1", strinsertnew(work2, work1, 0, "time date"), string1);

strcpy(work1, string1);
strset(work1 + 10, '-');
work1[10] = EOS;
strinsertnew(work2, work1, strlen(work2), "size other");
printline("strinsertnew #2", work2, string1);


/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strisempty							*/
/*									*/
work1[0] = EOS;
tempi = strisempty(work1);
printline("strisempty #1", itoa(tempi, work2, 10), "1");

work1[0] = '\n';
work1[1] = EOS;
tempi = strisempty(work1);
printline("strisempty #2", itoa(tempi, work2, 10), "1");

strcpy(work1, "    ");
tempi = strisempty(work1);
printline("strisempty #3", itoa(tempi, work2, 10), "1");

tempi = strisempty(string1);
printline("strisempty #4", itoa(tempi, work2, 10), "0");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	striswhite							*/
/*									*/
tempi = striswhite("    \t   ");
printline("striswhite #1", itoa(tempi, work2, 10), "1");

tempi = striswhite("\n");
printline("striswhite #2", itoa(tempi, work2, 10), "0");


/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strleft								*/
/*									*/
strcpy(work1, string1);
strleft(work1, 9);
printline("strleft #1", work1, ans02);

strcpy(work1, string1);
strleft(work1, 99);
printline("strleft #2", work1, string1);


/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strleftnew							*/
/*									*/
strcpy(work2, "");
strleftnew(work2, string1, 9);
printline("strleftnew #1", work2, ans02);

strcpy(work2, "");
strleftnew(work2, string1, 99);
printline("strleftnew #2", work2, string1);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlenmax							*/
/*									*/
tempi = strlenmax(string1, 50);
printline("strlenmax #1", itoa(tempi, work1, 10), "50");

tempi = strlenmax(string1, 10);
printline("strlenmax #2", itoa(tempi, work1, 10), "20");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlenmin							*/
/*									*/
tempi = strlenmin(string1, 50);
printline("strlenmin #1", itoa(tempi, work1, 10), "20");

tempi = strlenmin(string1, 10);
printline("strlenmin #2", itoa(tempi, work1, 10), "10");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlfdel							*/
/*									*/
strcpy(work1, string1);
strlfdel(work1, 10);
printline("strlfdel #1", work1, ans03);

strcpy(work1, string1);
strlfdel(work1, 99);
printline("strlfdel #2", work1, "");

strcpy(work1, string1);
printline("strlfdel #3", strlfdel(work1, 10), ans03);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlfdelnew							*/
/*									*/
strcpy(work1, string1);
strlfdelnew(work2, work1, 10);
printline("strlfdelnew #1", work2, ans03);

strcpy(work1, string1);
strlfdelnew(work2, work1, 99);
printline("strlfdelnew #2", work2, "");

strcpy(work1, string1);
printline("strlfdelnew #3", strlfdelnew(work2, work1, 10), ans03);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlfset							*/
/*									*/
strcpy(work1, string1);
strlfset(work1, 4, '-');
printline("strlfset #1", work1, ans19);

strcpy(work1, string1);
strlfset(work1, 99, '-');
printline("strlfset #2", work1, ans18);

strcpy(work1, string1);
printline("strlfset #3", strlfset(work1, 4, '-'), ans19);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlfsetnew							*/
/*									*/
strlfsetnew(work1, string1, 4, '-');
printline("strlfsetnew #1", work1, ans19);

strlfsetnew(work1, string1, 99, '-');
printline("strlfsetnew #2", work1, ans18);

printline("strlfsetnew #3", strlfsetnew(work1, string1, 4, '-'), ans19);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlfjust							*/
/*									*/
strcpy(work1, string2);
strlfjust(work1);
printline("strlfjust #1", work1, ans07);

strcpy(work1, string2);
printline("strlfjust #2", strlfjust(work1), ans07);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlfjustnew							*/
/*									*/
strcpy(work2,"");
strlfjustnew(work2, string2);
printline("strlfjustnew #1", work2, ans07);

strcpy(work2,"");
printline("strlfjustnew #2", strlfjustnew(work2, string2), ans07);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlfpad							*/
/*									*/
strtrimnew(work1, string2);
strlfpad(work1, 3, '-');
printline("strlfpad #1", work1, ans12);

strtrimnew(work1, string2);
printline("strlfpad #2", strlfpad(work1, 3, '-'), ans12);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlfpadnew							*/
/*									*/
strtrimnew(work1, string2);
strlfpadnew(work2, work1, 3, '-');
printline("strlfpadnew #1", work2, ans12);

strtrimnew(work1, string2);
printline("strlfpadnew #2", strlfpadnew(work2, work1, 3, '-'), ans12);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlfrot							*/
/*									*/
strcpy(work1, string1);
strlfrot(work1, 10);
printline("strlfrot #1", work1, ans08);

strcpy(work1, string1);
printline("strlfrot #2", strlfrot(work1, 10), ans08);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlfrotnew							*/
/*									*/
strcpy(work1, string1);
strlfrotnew(work2, work1, 10);
printline("strlfrotnew #1", work2, ans08);

strcpy(work1, string1);
printline("strlfrotnew #2", strlfrotnew(work2, work1, 10), ans08);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlfsh								*/
/*									*/
strcpy(work1, string1);
strlfsh(work1, 10);
printline("strlfsh #1", work1, ans05);

strcpy(work1, string1);
printline("strlfsh #2", strlfsh(work1, 10), ans05);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlfshnew							*/
/*									*/
strcpy(work1, string1);
strlfshnew(work2, work1, 10);
printline("strlfshnew #1", work2, ans05);

strcpy(work1, string1);
printline("strlfshnew #2", strlfshnew(work2, work1, 10), ans05);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlfsize							*/
/*									*/
strcpy(work1, string1);
strlfsize(work1, 10);
printline("strlfsize #1", work1, ans03);

strlfsize(work1, 20);
printline("strlfsize #2", work1, ans40);

strcpy(work1, string1);
printline("strlfsize #3", strlfsize(work1, 10), ans03);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlfsizenew							*/
/*									*/
strlfsizenew(work1, string1, 10);
printline("strlfsizenew #1", work1, ans03);

strlfsizenew(work2, work1, 20);
printline("strlfsizenew #2", work2, ans40);

printline("strlfsizenew #3", strlfsizenew(work1, string1, 10), ans03);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlftrim							*/
/*									*/
strcpy(work1, string2);
strlftrim(work1);
printline("strlftrim #1", work1, ans09);

strcpy(work1, string2);
printline("strlftrim #2", strlftrim(work1), ans09);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strlftrimnew							*/
/*									*/
strcpy(work1, string2);
strlftrimnew(work2, work1);
printline("strlftrimnew #1", work2, ans09);

strcpy(work1, string2);
printline("strlftrimnew #2", strlftrimnew(work2, work1), ans09);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strmid								*/
/*									*/
strcpy(work1, string1);
strmid(work1, 5);
printline("strmid #1", work1, ans01);

strcpy(work1, string1);
strmid(work1, 55);
printline("strmid #2", work1, "");

strcpy(work1, string1);
printline("strmid #3", strmid(work1, 5), ans01);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strmiddel							*/
/*									*/
strcpy(work1, string1);
strmiddel(work1, 5, 5);
printline("strmiddel #1", work1, ans22);

strcpy(work1, string1);
strmiddel(work1, 9, 99);
printline("strmiddel #2", work1, ans02);

strcpy(work1, string1);
strmiddel(work1, 99, 5);
printline("strmiddel #3", work1, string1);

strcpy(work1, string1);
printline("strmiddel #4", strmiddel(work1, 5, 5), ans22);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strmiddelnew							*/
/*									*/
strmiddelnew(work1, string1, 5, 5);
printline("strmiddelnew #1", work1, ans22);

strmiddelnew(work1, string1, 9, 99);
printline("strmiddelnew #2", work1, ans02);

strmiddelnew(work1, string1, 99, 5);
printline("strmiddelnew #3", work1, string1);

printline("strmiddelnew #4", strmiddelnew(work1, string1, 5, 5), ans22);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strmidset							*/
/*									*/
strcpy(work1, string1);
strmidset(work1, 4, 6, '-');
printline("strmidset #1", work1, ans26);

strcpy(work1, string1);
printline("strmidset #2", strmidset(work1, 4, 6, '-'), ans26);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strmidsetnew							*/
/*									*/
strcpy(work1, string1);
strmidsetnew(work2, work1, 4, 6, '-');
printline("strmidsetnew #1", work2, ans26);

strcpy(work1, string1);
printline("strmidsetnew #2", strmidsetnew(work2, work1, 4, 6, '-'), ans26);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strmidn								*/
/*									*/
strcpy(work1, string1);
strmidn(work1, 5, 4);
printline("strmidn #1", work1, "date");

strcpy(work1, string1);
printline("strmidn #2", strmidn(work1, 5, 4), "date");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strmidnew							*/
/*									*/
strmidnew(work2, string1, 5);
printline("strmidnew #1", work2, ans01);

strmidnew(work2, string1, 55);
printline("strmidnew #2", work2, "");

printline("strmidnew #3", strmidnew(work2, string1, 5), ans01);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strmidnnew							*/
/*									*/
strcpy(work1, string1);
strmidnnew(work2,work1, 5, 4);
printline("strmidnnew #1", work2, "date");

strcpy(work1, string1);
printline("strmidnnew #2", strmidnnew(work2, work1, 5, 4), "date");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strmidpad							*/
/*									*/
strcpy(work1, string1);
strmiddel(work1, 4, 6);
strmidpad(work1, 4, 3, '-');
printline("strmidpad #1", work1, ans32);

strcpy(work1, string1);
strmiddel(work1, 4, 6);
printline("strmidpad #2", strmidpad(work1, 4, 3, '-'), ans32);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strmidpadnew							*/
/*									*/
strcpy(work1, string1);
strmiddel(work1, 4, 6);
strmidpadnew(work2, work1, 4, 3, '-');
printline("strmidpadnew #1", work2, ans32);

strcpy(work1, string1);
strmiddel(work1, 4, 6);
printline("strmidpadnew #2", strmidpadnew(work2, work1, 4, 3, '-'), ans32);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrepeat							*/
/*									*/
strrepeat(work1, "this ", 3);
printline("strrepeat", work1, "this this this ");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrepeatn							*/
/*									*/
strrepeatn(work1, "this is ", 6, 20);
printline("strrepeat", work1, "this is this is this");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strreverse							*/
/*									*/
strcpy(work1, string1);
strreverse(work1);
printline("strreverse #1", work1, ans25);

strcpy(work1, string1);
printline("strreverse #2", strreverse(work1), ans25);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strreversenew							*/
/*									*/
strreversenew(work1, string1);
printline("strreversenew #1", work1, ans25);

printline("strreversenew #1", strreversenew(work1, string1), ans25);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strright							*/
/*									*/
strcpy(work1, string1);
strright(work1, 10);
printline("strright #1", work1, ans03);

strcpy(work1, string1);
strright(work1, 99);
printline("strright #2", work1, string1);

strcpy(work1, string1);
printline("strright #3", strright(work1, 10), ans03);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrightnew							*/
/*									*/
strcpy(work2,"");
strrightnew(work2, string1, 10);
printline("strrightnew #1", work2, ans03);

strcpy(work2,"");
strrightnew(work2, string1, 99);
printline("strrightnew #2", work2, string1);

strcpy(work2,"");
printline("strrightnew #3", strrightnew(work2, string1, 10), ans03);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrtdel							*/
/*									*/
strcpy(work1, string1);
strrtdel(work1, 11);
printline("strrtdel #1", work1, ans02);

strcpy(work1, string1);
strrtdel(work1, 99);
printline("strrtdel #2", work1, "");

strcpy(work1, string1);
printline("strrtdel #3", strrtdel(work1, 11), ans02);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrtdelnew							*/
/*									*/
strcpy(work1, string1);
strrtdelnew(work2, work1, 11);
printline("strrtdelnew #1", work2, ans02);

strcpy(work1, string1);
strrtdelnew(work2, work1, 99);
printline("strrtdelnew #2", work2, "");

strcpy(work1, string1);
printline("strrtdelnew #3", strrtdelnew(work2, work1, 11), ans02);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrtset							*/
/*									*/
strcpy(work1, string1);
strrtset(work1, 5, '-');
printline("strrtset #1", work1, ans20);

strcpy(work1, string1);
strrtset(work1, 99, '-');
printline("strrtset #2", work1, ans18);

strcpy(work1, string1);
printline("strrtset #3", strrtset(work1, 5, '-'), ans20);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrtsetnew							*/
/*									*/
strrtsetnew(work1, string1, 5, '-');
printline("strrtsetnew #1", work1, ans20);

strrtsetnew(work1, string1, 99, '-');
printline("strrtsetnew #2", work1, ans18);

printline("strrtsetnew #3", strrtsetnew(work1, string1, 5, '-'), ans20);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrtjust							*/
/*									*/
strcpy(work1, string2);
strrtjust(work1);
printline("strrtjust #1", work1, ans06);

strcpy(work1, string2);
printline("strrtjust #2", strrtjust(work1), ans06);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrtjustnew							*/
/*									*/
strcpy(work2, "");
strrtjustnew(work2, string2);
printline("strrtjustnew #1", work2, ans06);

strcpy(work2, "");
printline("strrtjustnew #2", strrtjustnew(work2, string2), ans06);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrtpad							*/
/*									*/
strtrimnew(work1, string2);
strrtpad(work1, 3, '-');
printline("strrtpad #1", work1, ans13);

strtrimnew(work1, string2);
printline("strrtpad #2", strrtpad(work1, 3, '-'), ans13);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrtpadnew							*/
/*									*/
strtrimnew(work1, string2);
strrtpadnew(work2, work1, 3, '-');
printline("strrtpadnew #1", work2, ans13);

strtrimnew(work1, string2);
printline("strrtpadnew #2", strrtpadnew(work2, work1, 3, '-'), ans13);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrtrot							*/
/*									*/
strcpy(work1, string1);
strrtrot(work1, 10);
printline("strrtrot #1", work1, ans08);

strcpy(work1, string1);
printline("strrtrot #2", strrtrot(work1, 10), ans08);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrtrotnew							*/
/*									*/
strcpy(work1, string1);
strrtrotnew(work2, work1, 10);
printline("strrtrotnew #1", work2, ans08);

strcpy(work1, string1);
printline("strrtrotnew #2", strrtrotnew(work2, work1, 10), ans08);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrtsh								*/
/*									*/
strcpy(work1, string1);
strrtsh(work1, 11);
printline("strrtsh #1", work1, ans04);

strcpy(work1, string1);
printline("strrtsh #2", strrtsh(work1, 11), ans04);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrtshnew							*/
/*									*/
strcpy(work1, string1);
strrtshnew(work2, work1, 11);
printline("strrtshnew #1", work2, ans04);

strcpy(work1, string1);
printline("strrtshnew #2", strrtshnew(work2, work1, 11), ans04);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrtsize							*/
/*									*/
strcpy(work1, string1);
strrtsize(work1, 9);
printline("strrtsize #1", work1, ans02);

strrtsize(work1, 20);
printline("strrtsize #2", work1, ans41);

strcpy(work1, string1);
printline("strrtsize #3", strrtsize(work1, 9), ans02);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrtsizenew							*/
/*									*/
strrtsizenew(work1, string1, 9);
printline("strrtsizenew #1", work1, ans02);

strrtsizenew(work2, work1, 20);
printline("strrtsizenew #2", work2, ans41);

printline("strrtsizenew #1", strrtsizenew(work1, string1, 9), ans02);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrttrim							*/
/*									*/
strcpy(work1, string2);
strrttrim(work1);
printline("strrttrim #1", work1, ans10);

strcpy(work1, string2);
printline("strrttrim #2", strrttrim(work1), ans10);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strrttrimnew							*/
/*									*/
strcpy(work1, string2);
strrttrimnew(work2, work1);
printline("strrttrimnew #1", work2, ans10);

strcpy(work1, string2);
printline("strrttrimnew #2", strrttrimnew(work2, work1), ans10);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strstri								*/
/*									*/
/*	char *strstri(char *instring,  char *substring);		*/
/*									*/
/*	<== not done yet <==	*/

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubcount							*/
/*									*/
itoa(strsubcount("This that and the other", "th"), work1, 10);
printline("strsubcount #1", work1, "3");

itoa(strsubcount("This that and the other", "This that and the other thing"), work1, 10);
printline("strsubcount #2", work1, "0");


/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubcounti							*/
/*									*/
itoa(strsubcounti("This that and the other", "TH"), work1, 10);
printline("strsubcounti #1", work1, "4");

itoa(strsubcounti("This that", "THis that and"), work1, 10);
printline("strsubcounti #2", work1, "0");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubdel							*/
/*									*/
strcpy(work1, string1);
strsubdel(work1, "time date ");
printline("strsubdel #1", work1, ans03);

strcpy(work1, string1);
printline("strsubdel #2", strsubdel(work1, "time date "), ans03);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubdelall							*/
/*									*/
strcpy(work1, "This that and the other");
strsubdelall(work1, "th");
printline("strsubdelall #1", work1, "This at and e oer");

strcpy(work1, "This that and the other");
printline("strsubdelall #2", strsubdelall(work1, "th"), "This at and e oer");

printline("strsubdelall #3", strsubdelall("this", "this and that"), "this");
/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubdelallnew							*/
/*									*/
/* <== next mod goes here <==	*/
strcpy(work1, "This that and the other");
strsubdelallnew(work2, work1, "th");
printline("strsubdelallnew #1", work2, "This at and e oer");

strcpy(work1, "This that and the other");
printline("strsubdelallnew #2", strsubdelallnew(work2, work1, "th"),
					"This at and e oer");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubdeli							*/
/*									*/
strcpy(work1, "This that and the other");
strsubdeli(work1, "th");
printline("strsubdeli #1", work1, "is that and the other");

strcpy(work1, "This that and the other");
printline("strsubdeli #2", strsubdeli(work1, "th"), "is that and the other");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubdeliall							*/
/*									*/
strcpy(work1, "This that and the other");
strsubdeliall(work1, "TH");
printline("strsubdelall #1", work1, "is at and e oer");

strcpy(work1, "This that and the other");
printline("strsubdelall #2", strsubdeliall(work1, "TH"), "is at and e oer");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubdeliallnew						*/
/*									*/
strcpy(work1, "This that and the other");
strsubdeliallnew(work2, work1, "TH");
printline("strsubdeliallnew #1", work2, "is at and e oer");

strcpy(work1, "This that and the other");
printline("strsubdeliallnew #2", strsubdeliallnew(work2, work1, "TH"),
						"is at and e oer");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubdelinew							*/
/*									*/
strcpy(work1, "This that and the other");
strsubdelinew(work2, work1, "th");
printline("strsubdelinew #1", work2, "is that and the other");

strcpy(work1, "This that and the other");
printline("strsubdelinew #2", strsubdelinew(work2, work1, "th"),
						"is that and the other");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubdelnew							*/
/*									*/
strcpy(work1, string1);
strsubdelnew(work2, work1, "time date ");
printline("strsubdel #1", work2, ans03);

strcpy(work1, string1);
printline("strsubdel #2", strsubdelnew(work2, work1, "time date "), ans03);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubrpl							*/
/*									*/
strcpy(work1, string1);
strsubrpl(work1, "date", "new");
printline("strsubrpl #1", work1, ans31);

strcpy(work1, string1);
printline("strsubrpl #2", strsubrpl(work1, "time", "----"), ans19 + 4);
/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubrplall							*/
/*									*/
strcpy(work1, "This that and the other");
tempi = strsubrplall(work1, "th", "TH");
printline("strsubrplall #1a", work1, "This THat and THe oTHer");
itoa(tempi, work2, 10);
printline("strsubprlall #1b", work2, "3");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubrplallnew							*/
/*									*/
strcpy(work1, "This that and the other");
tempi = strsubrplallnew(work2, work1, "th", "TH");
printline("strsubrplallnew #1a", work2, "This THat and THe oTHer");
itoa(tempi, work2, 10);
printline("strsubprlallnew #1b", work2, "3");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubrpli							*/
/*									*/
strcpy(work1, "This that and the other");
strsubrpli(work1, "th", "TH");
printline("strsubrpli #1", work1, "THis that and the other");

strcpy(work1, "This that and the other");
printline("strsubrpli #1", strsubrpli(work1, "th", "TH") - 2,
				"THis that and the other");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubrpliall							*/
/*									*/
strcpy(work1, "This that and the other");
tempi = strsubrpliall(work1, "Th", "TH");
printline("strsubrpliall #1a", work1, "THis THat and THe oTHer");
itoa(tempi, work2, 10);
printline("strsubrpliall #1b", work2, "4");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubrpliallnew						*/
/*									*/
strcpy(work1, "This that and the other");
tempi = strsubrpliallnew(work2, work1, "Th", "TH");
printline("strsubrpliallnew #1a", work2, "THis THat and THe oTHer");
itoa(tempi, work2, 10);
printline("strsubrpliallnew #1b", work2, "4");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubrplinew							*/
/*									*/
strcpy(work1, "This that and the other");
strsubrplinew(work2, work1, "th", "TH");
printline("strsubrplinew  #1", work2, "THis that and the other");

strcpy(work1, "This that and the other");
printline("strsubrplinew  #2", strsubrplinew(work2, work1, "th", "TH") - 2,
					"THis that and the other");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strsubrplnew							*/
/*									*/
strcpy(work1, string1);
strsubrplnew(work2, work1, "time", "----");
printline("strsubrplnew #1", work2, ans19);

strcpy(work1, string1);
printline("strsubrplnew #2", strsubrplnew(work2, work1, "time", "----"), ans19);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strtabtoblank							*/
/*									*/
strcpy(work1, "This is \tthe \tsample line");
strtabtoblank(work1, 8);
printline("strtabtoblank #1", work1, "This is         the     sample line");

strcpy(work1, "This is \tthe \tsample line");
strtabtoblank(work1, 4);
printline("strtabtoblank #2", work1, "This is     the     sample line");

strcpy(work1, "This is \tthe \tsample line");
printline("strtabtoblank #3", strtabtoblank(work1, 8),
		"This is         the     sample line");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strtextfirst							*/
/*									*/
strtextfirst(work1, string7);
printline("strtextfirst #1", work1, "text1");

strtextfirst(work1, string4);
printline("strtextfirst #2", work1, "12345");

printline("strtextfirst #3", strtextfirst(work1, "this"), "this");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strtextget							*/
/*									*/
strtextget(work1, string7);
printline("strtextget #1", work1, "text1");

strtextget(work1, string2);
printline("strtextget #2", work1, "");

printline("strtextget #3", strtextget(work1, string7), "text1");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strtextlast							*/
/*									*/
strtextlast(work1, string7);
printline("strtextlast #1", work1, "so");

strtextlast(work1, string2);
printline("strtextlast #2", work1, ans11);

printline("strtextlast #3", strtextlast(work1, string7), "so");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strtextnext							*/
/*									*/
strtextnext(work1, string7);
printline("strtextnext #1", work1, "text2");

strtextnext(work1, string1+17);
printline("strtextnext #2", work1, "");

printline("strtextnext #3", strtextnext(work1, string7 + 5), "text2");

printline("strtextnext #4", strtextnext(work1, ans42), "123");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strtextprev							*/
/*									*/
strtextprev(work1, string7+10);
printline("strtextprev #1", work1, "text1");

strtextprev(work1, strend(string2));
printline("strtextprev #2", work1, ans11);

printline("strtextprev #3", strtextprev(work1, string7+16), "text2");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strtextthis							*/
/*									*/
strtextthis(work1, string7 + 8);
printline("strtextthis #1", work1, "text2");

strtextthis(work1, string2);
printline("strtextthis #2", work1, "");

printline("strtextthis #3", strtextthis(work1, string7 + 8), "text2");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strtoc								*/
/*									*/
strcpy(work1, "a\5\t\142");
strtoc(work2, work1);
printline("strtoc", work2, "a\\x05\\tb");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strtolower							*/
/*									*/
strcpy(work1, ans21);
strtolower(work1);
printline("strtolower #1", work1, string1);

strcpy(work1, ans21);
printline("strtolower #2", strtolower(work1), string1);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strtolowernew							*/
/*									*/
strtolowernew(work1, ans21);
printline("strtolowernew #1", work1, string1);

printline("strtolowernew #2", strtolowernew(work1, ans21), string1);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strtoupper							*/
/*									*/
strcpy(work1, string1);
strtoupper(work1);
printline("strtoupper #1", work1, ans21);

strcpy(work1, string1);
printline("strtoupper #2", strtoupper(work1), ans21);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strtouppernew							*/
/*									*/
strtouppernew(work1, string1);
printline("strtouppernew #1", work1, ans21);

printline("strtouppernew #2", strtouppernew(work1, string1), ans21);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strtrim								*/
/*									*/
strcpy(work1, string2);
strtrim(work1);
printline("strtrim #1", work1, ans11);

strcpy(work1, string2);
printline("strtrim #2", strtrim(work1), ans11);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strtrimnew							*/
/*									*/
strcpy(work1, string2);
strtrimnew(work2, work1);
printline("strtrimnew #1", work2, ans11);

strcpy(work1, string2);
printline("strtrimnew #2", strtrimnew(work2, work1), ans11);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strwordfirst							*/
/*									*/
strwordfirst(work1, string1);
printline("strwordfirst #1", work1, "time");

strwordfirst(work1, string2);
printline("strwordfirst #2", work1, ans11);

printline("strwordfirst #3", strwordfirst(work1, "this"), "this");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strwordget							*/
/*									*/
strwordget(work1, string1);
printline("strwordget #1", work1, "time");

strwordget(work1, string2);
printline("strwordget #2", work1, "");

printline("strwordget #3", strwordget(work1, string1), "time");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strwordlast							*/
/*									*/
strwordlast(work1, string1);
printline("strwordlast #1", work1, ans30);

strwordlast(work1, string2);
printline("strwordlast #2", work1, ans11);

printline("strwordlast #3", strwordlast(work1, string1), ans30);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strwordnext							*/
/*									*/
strwordnext(work1, string1+3);
printline("strwordnext #1", work1, "date");

strwordnext(work1, string1+17);
printline("strwordnext #2", work1, "");

printline("strwordnext #3", strwordnext(work1, string1+3), "date");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strwordprev							*/
/*									*/
strwordprev(work1, string1+10);
printline("strwordprev #1", work1, "date");

strwordprev(work1, strend(string2));
printline("strwordprev #2", work1, ans11);

printline("strwordprev #3", strwordprev(work1, string1+10), "date");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strwordthis							*/
/*									*/
strwordthis(work1, string1 + 5);
printline("strwordthis #1", work1, "date");

strwordthis(work1, string2);
printline("strwordthis #2", work1, "");

printline("strwordthis #3", strwordthis(work1, string1 + 8), "date");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strxcat								*/
/*									*/
work1[0] = EOS;
strxcat(work1, "time ", "date ", "size ", "other", NULL);
printline("strxcat #1", work1, string1);

work1[0] = EOS;
printline("strxcat #2", strxcat(work1, "time ",
	  "date ", "size ", "other", NULL), string1);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strxcatn							*/
/*									*/
work1[0] = EOS;
strxcatn(work1, 20, "time ", "date ", "size ",
		    "other", "and then some", NULL);
printline("strxcatn #1", work1, string1);

work1[0] = EOS;
strxcatn(work1, 9, "time ", "date ", "size ",
		   "other", "and then some", NULL);
printline("strxcatn #2", work1, ans02);

work1[0] = EOS;
printline("strxcatn #3", strxcatn(work1, 20, "time ", "date ",
	  "size ", "other", "and then some", NULL), string1);

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	strzero								*/
/*									*/
strcpy(work1, string1);
strzero(work1);
printline("strzero #1", work1, "00000000000000000000");

strcpy(work1, string1);
printline("strzero #2", strzero(work1), "00000000000000000000");

/*	-	-	-	-	-	-	-	-	*/
/*									*/
/*	clean up and say goodnight					*/
/*									*/
printf("\n\ntotal number of errors found: %d\n\n", ne);
if (printflag)
  printf("\n\ndone\n\n");		/* say goodnight		*/
}					/* end main			*/
/*									*/
/************************************************************************/
/*									*/
/*	printline --- print the test name, test answer, and OK/bad	*/
/*									*/
void printline(				/* no return			*/
	char *linehead,			/* test name			*/
	char *answer,			/* test answer			*/
	char *OKanswer)			/* correct answer		*/
{ strcpy(part1, linehead);		/* put the test name in part1	*/
  if (answer != NULL)			/* if the answer is not NULL,	*/
  { strlfpad(part2, 1, '\"');		/* put the test answer in	*/
    strcpy(part2+1, answer);		/*   part2, convert tabs to	*/
    strtabtoblank(part2, 8);		/*     blanks, and wrap		*/
    strrtpad(part2, 1, '\"');		/*	 quotes around part2	*/
  }					/* end if answer not NULL	*/
  else					/* otherwise, the answer is	*/
    strcpy(part2, "(null)");		/*   NULL, so insert "(null)"	*/
  strrtsize(part1, 25);			/* force part1 to 25 characters	*/
  strrtsize(part2, 25);			/* force part2 to 25 characters	*/
  if (strcmp(answer, OKanswer))		/* if the answer is bad,	*/
  { printf("\n%s%s", part1, part2);	/*   print test name & answer	*/
    printf("\7 WRONG <==");		/*     and tack on "WRONG"	*/
    ne++;				/*	 and number of errors++ */
  }					/* end if answer is bad		*/
  else					/* otherwise, answer was good,	*/
  { if (printflag)			/*   so if the print flag is	*/
    { printf("\n%s%s", part1, part2);	/*     on, print test name	*/
      printf(" OK");			/*	 and answer, and tack	*/
    }					/*	   on "OK"		*/
  }					/* end else answer was bad	*/
}					/* end function printline	*/



