/*
	In working with various bulletin boards and dealing with
	miscellaneous files over the years, we have found a number of
	date formats in use. To facilitate our own function naming, we
	have given the various types the following totally arbitrary
	numerical designations. This information is contained with both
	the "strdate<n>" and "strdateconv" functions, for ease of
	reference.

		type	 format
		----	 ------
		  1	mm/dd/yy   NOTE: mm and dd will be padded on the
		  2	mm-dd-yy	 left with a 0 where necessary
		  3	 m/ d/yy   NOTE: m and d will be padded on the
		  4	 m- d-yy	 left with a blank where necessary
		  5	m/d/yy	   NOTE: m and d can be one digit or two
		  6	m-d-yy		 digits but will not be padded
					 with either 0's or blanks
		  7     yy/mm/dd   NOTE: this format is a sortable version
					 which is similar to type 1

	As can be seen above, the difference between the even and odd
	types is the use of '-' versus '/' as the separator character.
	The difference between types 1/2, 3/4 and 5/6 is as follows:

		1/2	Format is totally fixed and there are no blanks.
			0's will be added to the left of mm and dd as
			necessary to fill out the format.

		3/4	Exactly the same as 1/2 except that no 0's will
			be added, so the format may contain blanks.

		5/6	The date appears in minimal form using a variable
			format with no leading blanks or zeros.

		  7	This is identical to 1, except that the order of
			the month/day/year has been changed so as to
			provide a "sortable" format.


*/

#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include <time.h>
#include <stdio.h>
#include "hhstring.h"

/************************************************************************/
/*									*/
/*	main								*/
/*									*/
void main(void)
{ char date_string[9];

  printf("\n");
  printf("%s  ", strdate1(date_string));
  printf("%s  ", strdate2(date_string));
  printf("%s  ", strdate3(date_string));
  printf("%s  ", strdate4(date_string));
  printf("%s  ", strdate5(date_string));
  printf("%s  ", strdate6(date_string));
  printf("%s  ", strdate7(date_string));
  printf("\n\n");

  printf("%s  ", strdateconv(strdate1(date_string), 1, 1));
  printf("%s  ", strdateconv(strdate1(date_string), 1, 2));
  printf("%s  ", strdateconv(strdate1(date_string), 1, 3));
  printf("%s  ", strdateconv(strdate1(date_string), 1, 4));
  printf("%s  ", strdateconv(strdate1(date_string), 1, 5));
  printf("%s  ", strdateconv(strdate1(date_string), 1, 6));
  printf("%s  ", strdateconv(strdate1(date_string), 1, 7));
  printf("\n");

  printf("%s  ", strdateconv(strdate2(date_string), 2, 1));
  printf("%s  ", strdateconv(strdate2(date_string), 2, 2));
  printf("%s  ", strdateconv(strdate2(date_string), 2, 3));
  printf("%s  ", strdateconv(strdate2(date_string), 2, 4));
  printf("%s  ", strdateconv(strdate2(date_string), 2, 5));
  printf("%s  ", strdateconv(strdate2(date_string), 2, 6));
  printf("%s  ", strdateconv(strdate2(date_string), 2, 7));
  printf("\n");

  printf("%s  ", strdateconv(strdate3(date_string), 3, 1));
  printf("%s  ", strdateconv(strdate3(date_string), 3, 2));
  printf("%s  ", strdateconv(strdate3(date_string), 3, 3));
  printf("%s  ", strdateconv(strdate3(date_string), 3, 4));
  printf("%s  ", strdateconv(strdate3(date_string), 3, 5));
  printf("%s  ", strdateconv(strdate3(date_string), 3, 6));
  printf("%s  ", strdateconv(strdate3(date_string), 3, 7));
  printf("\n");

  printf("%s  ", strdateconv(strdate4(date_string), 4, 1));
  printf("%s  ", strdateconv(strdate4(date_string), 4, 2));
  printf("%s  ", strdateconv(strdate4(date_string), 4, 3));
  printf("%s  ", strdateconv(strdate4(date_string), 4, 4));
  printf("%s  ", strdateconv(strdate4(date_string), 4, 5));
  printf("%s  ", strdateconv(strdate4(date_string), 4, 6));
  printf("%s  ", strdateconv(strdate4(date_string), 4, 7));
  printf("\n");

  printf("%s  ", strdateconv(strdate5(date_string), 5, 1));
  printf("%s  ", strdateconv(strdate5(date_string), 5, 2));
  printf("%s  ", strdateconv(strdate5(date_string), 5, 3));
  printf("%s  ", strdateconv(strdate5(date_string), 5, 4));
  printf("%s  ", strdateconv(strdate5(date_string), 5, 5));
  printf("%s  ", strdateconv(strdate5(date_string), 5, 6));
  printf("%s  ", strdateconv(strdate5(date_string), 5, 7));
  printf("\n");

  printf("%s  ", strdateconv(strdate6(date_string), 6, 1));
  printf("%s  ", strdateconv(strdate6(date_string), 6, 2));
  printf("%s  ", strdateconv(strdate6(date_string), 6, 3));
  printf("%s  ", strdateconv(strdate6(date_string), 6, 4));
  printf("%s  ", strdateconv(strdate6(date_string), 6, 5));
  printf("%s  ", strdateconv(strdate6(date_string), 6, 6));
  printf("%s  ", strdateconv(strdate6(date_string), 6, 7));
  printf("\n");

  printf("%s  ", strdateconv(strdate7(date_string), 7, 1));
  printf("%s  ", strdateconv(strdate7(date_string), 7, 2));
  printf("%s  ", strdateconv(strdate7(date_string), 7, 3));
  printf("%s  ", strdateconv(strdate7(date_string), 7, 4));
  printf("%s  ", strdateconv(strdate7(date_string), 7, 5));
  printf("%s  ", strdateconv(strdate7(date_string), 7, 6));
  printf("%s  ", strdateconv(strdate7(date_string), 7, 7));
  printf("\n");

}					/* end function datedemo	*/


