'+--------------------------[ SHOWEVNT Ver 1.00]-----------------------------+
'|  Written By Gary Meeker 05/01/93                        Updated   /  /    |
'|  SYSOP: SHARP Technical Support Line BBS               Lawrenceville, GA  |
'|         (404) 962-1788                          300-14400 Baud. 24 Hours  |
'+---------------------------------------------------------------------------+
'V1.00 05/01/93 - Initial Release

DEFINT A-Z

'   PDQ Declarations
DECLARE FUNCTION PDQValI% (Number$)
DECLARE FUNCTION PDQExist (FileName$)

'   QuickPack Declarations
DECLARE FUNCTION GetBit% (Array$, Element%)
DECLARE SUB ShiftIL (IntVar%, NumBits%)

'   Myown Declarations
DECLARE FUNCTION UnSignedL& (BYVAL X%)
DECLARE SUB DelChar (Target$, Position, Char$)

'   Local Declarations
DECLARE FUNCTION JulianInt2Str$(Julian)
DECLARE FUNCTION ZeroStr$(Num)
DECLARE SUB GetParameter(Parameter$, Flag)

TYPE EventRec
    EventType AS STRING * 1             ' E or S
    UnKnown AS STRING * 3               ' UnUsed?
    Days2Run AS STRING * 1              ' ASC()  Bit Mapped 01 = Sun ~ 40 = Sat
    BeginTime AS STRING * 5             ' hh:mm
    EndTime AS STRING * 5               ' hh:mm
    RunDate AS STRING * 8               ' mm-dd-yy Specific Date to run
    FileName AS STRING * 8              ' Filename no extension
    Reserved AS INTEGER                 ' Unused (was probably Node)
END TYPE

DIM SHARED Days(0 TO 1, 1 TO 12)
    Days(0, 1) =   0   :   Days(1, 1) =   0
    Days(0, 2) =  31   :   Days(1, 2) =  31
    Days(0, 3) =  59   :   Days(1, 3) =  60
    Days(0, 4) =  90   :   Days(1, 4) =  91
    Days(0, 5) = 120   :   Days(1, 5) = 121
    Days(0, 6) = 151   :   Days(1, 6) = 152
    Days(0, 7) = 181   :   Days(1, 7) = 182
    Days(0, 8) = 212   :   Days(1, 8) = 213
    Days(0, 9) = 243   :   Days(1, 9) = 244
    Days(0,10) = 273   :   Days(1,10) = 274
    Days(0,11) = 304   :   Days(1,11) = 305
    Days(0,12) = 334   :   Days(1,12) = 335

DIM Active$(-1 TO 0), Day$(-1 TO 0), EventFile$(-1 TO 0)
    Active$(-1)    = " Y    "
    Active$(0)     = " N    "
    Day$(-1)       = "Y"
    Day$(0)        = "N"
    EventFile$(-1) = " *"
    EventFile$(0)  = "  "

'   Get the Command Line
C$ = UCASE$(COMMAND$)

GetParameter "/N", NumberLines       ' Number Events?

StartNode = 1
GetParameter "/S:", StartNode        ' Start at Event number.

NumNodes = PDQValI(C$)

DatFile$ = "PCBOARD.DAT"
IF NOT PDQExist(DatFile$) THEN
    PRINT DatFile$; " not found in current directory!"
    END
END IF

OPEN DatFile$ FOR INPUT ACCESS READ SHARED AS #1
    FOR X = 1 TO 229
        LINE INPUT #1, A$
    NEXT X
    LINE INPUT #1, EventFile$
    LINE INPUT #1, EventPath$
CLOSE #1

IF NOT PDQExist(EventFile$) THEN
    PRINT EventFile$; " not found!"
    END
END IF

OPEN EventFile$ FOR BINARY ACCESS READ SHARED AS #1
    GET #1,, NumEvents           ' Get the Number of Events
    Bytes = NumEvents \ 8 - (NumEvents MOD 8 <> 0)
    EventActive$ = STRING$(Bytes, 0)
    GET #1,, EventActive$
    REDIM Event(1 TO NumEvents) AS EventRec
    Nodes = (LOF(1) - Bytes - 2 - LEN(Event(1)) * NumEvents) \ (NumEvents * 2)
    IF NumNodes = 0 THEN NumNodes = Nodes
    PRINT TAB(24); "ShowEvent - V1.00 by Gary Meeker"
    PRINT
    IF StartNode > Nodes THEN StartNode = 1
    EndNode = StartNode + NumNodes - 1
    IF EndNode > Nodes THEN EndNode = Nodes
    PRINT "Event Data for Node"; StartNode; "to Node"; Endnode
    REDIM LastRun(1 TO NumEvents, 1 TO Nodes), NodeExt$(1 TO Nodes)
    FOR E = 1 TO NumEvents
        GET #1,, Event(E)
    NEXT E
    FOR E = 1 TO NumEvents
        FOR N = 1 TO Nodes
            GET #1,, LastRun(E, N)
        NEXT N
    NEXT E
CLOSE #1
FOR N = 1 TO Nodes
    NodeExt$(N) = "." + RIGHT$("00" + LTRIM$(STR$(N)), 3)
NEXT N

IF NumberLines THEN
    Pad$ = SPACE$(7)
ELSE
    Pad$ = ""
END IF

PRINT
PRINT Pad$; "          Batch     Begin End                     ";
FOR N = StartNode TO EndNode
    PRINT "  Last Run";
NEXT N
PRINT

PRINT Pad$; "Act  Mod  File      Time  Time   SMTWTFS  Date    ";
FOR N = StartNode TO EndNode
    PRINT "  Node"; LEFT$(STR$(N) + "   ", 4);
NEXT N
PRINT

PRINT Pad$; "           ";
FOR N = StartNode TO EndNode
    PRINT "  ";
NEXT N
PRINT

FOR E = 1 TO NumEvents
    IF NumberLines THEN
        Pad$ = RIGHT$("  " + STR$(E), 3) + ")   "
    END IF
    PRINT Pad$; Active$(GetBit(EventActive$, E - 1)); Event(E).EventType$; _
           "   "; Event(E).FileName$; "  "; _
           Event(E).BeginTime; "-"; Event(E).EndTime; "  ";
    Test = 1
    Days2Run = ASC(Event(E).Days2Run$)
    FOR D = 1 TO 7
        PRINT Day$((Days2Run AND Test) <> 0);
        ShiftIL Test, 1
    NEXT D
    PRINT "  "; Event(E).RunDate$;
    FOR N = StartNode TO EndNode
        Flag = PDQExist(EventPath$ + Event(E).FileName$ + NodeExt$(N)) OR _
                PDQExist(EventPath$ + Event(E).FileName$)
        PRINT EventFile$(Flag); JulianInt2Str$(LastRun(E, N));
    NEXT N
    PRINT
NEXT E

END



FUNCTION ZeroStr$(Num) STATIC
    ZeroStr$ = RIGHT$("00" + LTRIM$(STR$(Num)), 2)
END FUNCTION

FUNCTION JulianInt2Str$(Julian) STATIC
    IF Julian <> 0 THEN
        Julian& = UnSignedL&(Julian)
        Year   = (100 * Julian&) \ 36525&
        Temp&  = Year * 36525&
        DayofYear = Julian& - (Temp& \ 100)

        IF (Temp& MOD 100) = 0 THEN
            DayOfyear = DayOfYear + 1
            Leap = 1
        ELSE
            Leap = 0
        END IF
        Month = 1
        FOR Counter = 2 TO 12
            IF Days(Leap, Counter) < DayOfYear THEN
                Month = Counter
            END IF
        NEXT Counter
        Day = DayOfYear - Days(Leap, Month)
    ELSE
        Year = 0
        Month = 0
        Day = 0
    END IF
    JulianInt2Str$ = ZeroStr$(Month) + "-" + ZeroStr$(Day) + "-" + ZeroStr$(Year)
END FUNCTION

SUB GetParameter(Parameter$, Par) STATIC
   SHARED C$, Value$
   StrLen = LEN(Parameter$)
   Flag = INSTR(C$, Parameter$)
   IF Flag THEN                                   ' Was Parameter present?
      IF RIGHT$(Parameter$, 1) = ":" THEN         ' Yes, Is it an Optional?
         EndName = INSTR(Flag, C$, " ")           '      Yes, Find End
         IF EndName = 0 THEN                      '
            EndName = LEN(C$) + 1                 '      Must be end of Line
         END IF                                   '
         Temp = EndName - Flag - StrLen           '      This is the length
         Value$ = MID$(C$, Flag + StrLen, Temp)   ' So we can return this
         Par = PDQValI(Value$)                    '
      ELSE
         Temp = 0                                 ' No, so zero length
         Par = -1
      END IF
      DelChar C$, Flag, SPACE$(StrLen + Temp)     ' delete it all
   END IF
END SUB
