Path: labri.greco-prog.fr!corsini
Newsgroups: news.answers,comp.answers,comp.os.linux,comp.os.linux.announce
Distribution: world
Followup-To: poster
From: corsini@labri.greco-prog.fr
Reply-To: linux@numero6.greco-prog.fr
Organization: Greco Prog. CNRS & LaBRI, Bordeaux France
Subject: Linux Frequently Asked Questions 4/4 [monthly posted]
Approved: news-answers-request@MIT.Edu
Summary: Linux, a small and free unix-like for 386-AT computers.

Archive-name: linux-faq/part4
Last-Modified: 93/02/11
Version: 1.16

*********************************************************
*							*
*   Answers to Frequently asked questions about Linux   *
*							*
*********************************************************

This post contains Part 4 of the Linux FAQ (4 parts).
It must be read *after* the 3 first parts. 

===================================8<====>8============================
CONTENTS (of this part)

	XI.	NETWORKING and LINUX		(part4)
	XII.	X11, THE MAXIMUM and MORE	(part4)
	XIII.	EMACS for LINUX			(part4)

===================================8<====>8============================


XI.	NETWORKING and LINUX
============================
*** This section should be maintained by Philip Copeland
*** (p_copela@csd.uwe.ac.uk). This first version was built by myself
*** (MM. Corsini) from the original material posted by Phil in c.o.l.
*** I hope the information provided below are readable and useful.
*** Last Update: 16 Jan 92 01:12:45 GMT

     **** In the ANSWER part the I/MY stands for P. Copeland ****

QUESTION: Where can I find useful information about networking for
Linux ?

ANSWER: Join the NET channel of the mailing list. Also, you need to
read the NET-FAQ by Phil Copeland, it's on sunsite and tsx-11 and 
posted to c.o.l and the NET channel every couple of weeks.

Basically, all of the information on networking and TCP/IP for Linux
is in the NET-FAQ, all that's given here is the Quick Start guide.

QUESTION: What do I need to get started ?

ANSWER: Here is the Linux TCP/IP Quick Start guide, version 1.2 by
Matt Welsh. 

This is an excerpt from the Linux NET-FAQ by Phil which describes in a
nutshell what you need to get and do to setup TCP/IP on a Linux
machine. It's really quite easy.

I suggest that you get the NET-FAQ instead of just this document. This
is an overview of the process. All of the details of inetd, named,
etc. setup are in the NET-FAQ. This mostly talks about getting and
installing the softs, just getting it to work. 

The NET-FAQ is posted occasionally to comp.os.linux.announce and can
be FTP'd from sunsite.unc.edu or tsx-11.mit.edu. Let me know if you
need help finding it (or I can mail you a copy).


** What you need to get started

   To configure TCP/IP under Linux you need:
 
   1)	A linux machine with linux kernel 0.98.5 although I'd
	recommend going all the way to 0.99 as many tcp/ip errors
	have been stomped out (although not all). Users of the
	virgin 0.98.6 release will have to apply patches 1-12
	available on sunsite.unc.edu:/pub/Linux/system/Network

   2)  	Version 4.2 of the jump table library image (/lib/libc.so.4.2).
	This is needed for the various network binaries and so on.
	The most recent version is on sunsite.unc.edu:/pub/Linux/GCC.

   3) 	If you're going to use TCP/IP over the network (i.e. not just
	loopback mode), then you need one of the following Ethernet
	cards:

	wd8013
	wd8003
	SMC Elite 16
	ne2000
	ne1000
	3com503 EtherlinkII
	Cabletron
	various HP 8390-based boards

	The wd8003, wd8013, and SMC Elite 16 are all included in the
	standard Linux kernel. The ne2000, ne1000, 3c503, Cabletron,
	and other 8390 card drivers are available for beta testing.
	This will be covered later.

   4)	If you are only going to use 'loopback' mode, you won't need
	a card! A special loopback device is used to comunicate
	with yourself. 

	*** NOTE when talking of ethernet devices, it should
	be noted that /dev/eth0 does NOT exist, the kernel
	knows about it and thats all you need to know, /dev/eth0
	and /dev/loopback are fictionous (FS speaking)
 
   5) 	The tcpip-0.8 networking package. This is the old, original
	release of the TCP/IP software. The only things you need
	from this package are the 'config' program and the network
	installation scripts (such as rc.net, install.net, and so on).

	ALL of the binaries, kernel code, diffs, and so on in the
	tcpip-0.8 package is obsolete. All you need from it is the
	install.net, rc.net, and other configuration programs (this
	is covered later).

	You also need the tcpip-0.8-fixes package.
	It's available from all of the major Linux FTP sites, in the
	file tcpip-0.8.tar.Z. The fixes are in tcpip-0.8-fixes.tar.Z.
	They should both be in the same place.

   6) 	The net-bin-0.2 package. It's on sunsite and tsx-11 in the
	file net-bin-0.2.tar.Z. 

	This file contains all of the TCP/IP clients and daemons that
	you'll need, including: telnet, telnetd, ftp, ftpd, inetd,
	named, rcp, rlogin, rsh, talk, ping, nslookup, and more.

		
   7) 	The net-lib-1.1 package, on sunsite and tsx-11 as 
	net-lib-1.1.tar.Z. It contains libnet.so.1.1, which is the
	library used by the net-bin binaries. Although the network
	libraries have been put back into libc.so.4.2, they were
	still compiled to use libnet.so.1.1. (You can get the
	net-src-0.2 package and recompile them yourself if you want).


   8) 	If you want NFS support, Linux 0.99 now contains NFS as a 
	standard filesystem. But you'll need the NFS client program
	from nic.funet.fi:/pub/OS/Linux/ALPHA/NFS and the new
	version of 'mount' which supports the '-t nfs' option (should
	be in the nfs client package).

   9)	Know the IRQ's of your internal cards. This is to avoid
	conflicts and allow the 'drivers' to communicate with your
	hardware

  10)	Also, If you do have ethernet cable, both coax (thin and thick)
	as well as twisted pair will work, the cable is only there to
	carry signals, your ethernet board works out how and the linux
	'drivers' simply stuff data onto the card.

  11)	A lot of coffee and one of those stress relieving 
	gadgets you can get in the local market. [Ed. note: I drank
	about 3 Dr. Peppers and I was okay. -mdw]
 

** Setting it all up.

This is a rundown of what you need to do to setup TCP/IP. Read it
through and then keep it all in mind as you're cleaning up all of
the details below. It's not difficult if you do everything correctly.

It's not as quick as I wanted it to be. Basically I get all of the
installation stuff straight and then let Peter explain the details
of setting up named, etc. in the NET-FAQ. 

You can get the Linux NET-FAQ from sunsite.unc.edu and tsx-11.mit.edu,
or I can mail you the most recent version if you don't have it. It
fills in all of the gaps left here.

- First things first: Get all of the files, etc. listed above in
  section 2.0. When unpacking the tcpip-0.8, tcpip-0.8-fixes, and 
  net-bin packages, it's helpful to unpack them in seperate directories,
  because we'll be moving the files around to the right places. For 
  example, unpack tcpip-0.8.tar.Z in /usr/src/tcpip-0.8 and 
  net-bin-0.2.tar.Z in /usr/src/net-bin (or something like that).

  BE WARNED: Some versions of SLS (including the current one, I think)
  have all of the TCP/IP files in the wrong place. You need to check
  and make sure that all of the files listed below are in the places
  that are listed here (i.e. daemons go in /usr/etc/inet, and binaries
  go in /usr/bin). If things aren't in the right place, you'll have
  problems (like fingerd won't work if it can't find 'finger', and so 
  on).

- Most of the files in tcpip-0.8 you don't need. After you've unpacked
  it somewhere, take inet.tar and unpack it in /usr/etc/inet (which you
  may need to create). You can delete the following files in 
  /usr/etc/inet:
  	config
  	inetd
  	named-xfer
  	telnetd
  	named
       (Don't worry; later we replace them with newer versions).
 
- The rest of the files from tcpip-0.8.tar.Z you can delete.

- Unpack tcpip-0.8-fixes.tar.Z in /usr/etc/inet. You can delete
  the file 'config' from it.

- Take the config.c (from tcpip-0.8-fixes) and compile it in 
  /usr/etc/inet with the command
	gcc -o config config.c

- Unpack net-lib-1.1.tar.Z in /lib. It should contain the files
	libnet.so.1 (symlink to libnet.so.1.1)
	libnet.so.1.1

- Having unpacked net-bin-0.2.tar.Z in /usr/src somwhere, you
  can install these binaries. The following files are copied to
  /usr/bin:
	ftp
	telnet
	ping (must be setuid root; i.e. do 'chmod 4755 /usr/bin/ping')
	nslookup
	nsquery
	netest
	rsh (must be setuid root)
	rcp (must be setuid root)
	rlogin (must be setuid root)
	finger
	talk 
	tftp
  The following files are copied to /usr/etc/inet:
	ftpd
	telnetd
	inetd
	named
	named-xfer
	rshd
	rlogind
	fingerd
	ntalkd
	tftpd
  The man pages are copied to /usr/man... for example, all *.1 are
  copied to /usr/man/man1 and *.8 are copied to /usr/man/man8.
	
- Now you've got all the software installed, you need to recompile
  your kernel with TCP/IP enabled. This is easy unless you have an
  old kernel (pre-0.99) or need to install the ne2000/3c503/ne1000
  drivers. Here's how.

  IF you're installing the 8390/n2000/3c503/ne1000 drivers (from
  super.org, directory /pub/linux/ethercards), follow the directions
  below for installing the driver. If you're NOT installing the 
  8390 driver, just skip down to compiling the kernel.

  Get the files that you need. See the README's there for full details.
  Basically yo need:
	8390.c
	8390.h 
	Space.c
  one or more of ne.c, wd.c, 3c503.c, and so on, depending on
  the card you have.

  Just follow the directions found in the file INSTALL on super.org.
  It's easy. Just:
      - Put the files above in /usr/src/linux/net/tcp
      - Add 8390.o (and ne.o, 3c503.o, etc. depending on which card
	you have) to OBJS in /usr/src/linux/net/tcp/Makefile,
      - Edit Space.c (if needed),
      - Add the proper defines for EI8390, EI8390_IRQ, etc. to
	/usr/include/linux/config.h (this is covered in the 8390 driver
	README files),
      - Edit /usr/include/linux/rc.net (which you'll set up later) to
	configure the device  'eth_if' instead of 'eth0'. Basically
	change all occurances of 'eth0' in the file (there's only 1
	or 2 of them) to 'eth_if'.

    	If you have problems with the 8390 driver, contact becker@super.org.

      - If you're NOT installing the 8390 driver (i.e. just using the wd8003
	driver with the standard kernel), then you need to edit 
	/usr/src/linux/net/tcp/Space.c to reflect your card's IRQ, base
	address, and so on. If you're only using loopback you can skip
	this step, too.

	Anyway for those who are frexible, the standard kernel parameters
        for this are :
	    
	     IRQ: 5		(card interrupt)
	     mem: D0000		(where in memory to buffer data)
	     i/o addr: 280	(low level address of card)
	     mem start: D0000	(nearly all boards have a jumper to
				 set this)
	     mem end: D2000	(for wd8013, make this D4000)
 
	NOTE: If you have problems with the memory start addr for the 
	WD80[0/1]3, please get in touch with bir7@leland.stanford.edu.

      - Now you're all set to compile the kernel. I really suggest that 
	you use version 0.99.pl4 or newer (probably 1.0 by the time this
	is out). If you don't have at least 0.99 you can't run 
	'make config' to autoconfigure the kernel and you'll have to
	do some stuff by hand.

	In any case, it's easy. If you have 0.99 or newer, just cd to
	/usr/src/linux and do a 'make config'. Make sure you answer 'yes'
	to the question on configuring TCP/IP. The rest of the options are
	up to you. Also make sure you edit /usr/src/linux/Makefile to fix
	your root device, keyboard, and so on.
	  
	Then do a 'make dep' to fix your dependencies--- THIS
	STEP IS VERY IMPORTANT. Then (if you've already compiled this 
	version of the kernel) do a 'make clean'. FINALLY you're ready to
	just do 'make' to compile the kernel.

 	When you're done you'll have the new kernel in /usr/src/linux/Image.
	Copy it to a floppy or install it in /etc for use with LILO, or 
	whatever. Reboot with your new kernel.

      - Once you're rebooted you can configure the stuff in /usr/etc/inet.
	Run the script 'install.net' there, and answer the questions to
	set your IP address, net address, router, domain name, and 
	nameserver. This is covered in the NET-FAQ.

      - I had to edit resolv.conf there to make sure that the hostname and
	domain names were right. No big deal.

      - Set up your named configuration files. Named is the service that
	allows your machine to act as a nameserver. If you have a real
	nameserver already, you probably don't want to run named (wastes
	memory). If you're on loopback, you don't need it either (just put
	all of your hostnames and ip addresses in /usr/etc/inet/hosts). 
	Named is nice if you have a LAN setup and want your Linux box to be 
	the name server. This is covered in detail in the NET-FAQ as 
	well.

      - Set up inetd.conf to include lines for all of the tcp/ip daemons
	(such as telnetd, fingerd, etc.) that you have in /usr/etc/inet.
	This is covered in the NET-FAQ.

      - Make sure that /usr/etc/rc.net is run from your /etc/rc.local.

      - Edit rc.net to make sure it's getting your IP address right. As
	it stands now it tries to grep for it in /usr/etc/inet/hosts,
	and this doesn't always work. I just hardcode my IP address in
	rc.net since my IP address isn't going to change much. :)

	If you are only using loopback, make sure you comment the lines
	in rc.net that config 'eth0' (since you don't have an Ethernet
	card). 

	If you're using the 8390 driver (see above) make sure you've
	changed 'eth0' to 'eth_if' in rc.net.

      - If you have a real nameserver, be aware that the hostnames/IP addrs
	in /usr/etc/inet/hosts will be ignored unless you create the file
	/usr/etc/inet/host.conf. It should contain only these 2 lines:
		order hosts,bind
		multi
	This file tells the BIND libraries how to lookup hostnames. This
	is covered more later. If it still doesn't work you don't have
	either net-lib-1.1 or the newest jumptables (v4.2) installed.

      - If you want to use NFS (network file system), you're on your 
	own. It should suffice to say that you need the nfs-client 
	stuff from tsx-11 and nfs enabled in your kernel. Should be
	easy, I haven't played with it yet.

      - If you didn't already, read all of the README files that come
	with net-bin-0.2 and all that. They contain more up-to-date
	info. NOTE that the info in tcpip-0.8's README file is mostly
	out-of-date, follow the directions above and you'll be okay.

      - At this point you should be able to reboot your system, rc.net
	will run, and you'll see something like
		loomer -> 128.253.153.53
		Starting /usr/etc/inet/inetd
	which is output from rc.net. If you don't see this (or if
	there are errors) then there's a problem; the best way to fix
	this is to edit rc.net and the other files in /usr/etc/inet
	and make sure you have your IP addresses and everything set right.

As I said, please get the NET-FAQ from sunsite or tsx-11 if you don't
have it already. This Quick Start guide is part of that document. 


XII. X11 THE MAXIMUM and MORE
=============================
*** This section is maintained by Krishna Balasubramanian
*** <balasub@cis.ohio-state.edu>. Mail him if you have corrections,
*** additions, etc.
*** Last update: Tue, 16 Jan 93 19:06:57 -0500

XII.A. X386 GENERAL INFORMATION
XII.B. HARDWARE REQUIREMENTS: Supported Video cards.
XII.C. LINUX DISTRIBUTION: Files required, Current version.
XII.D. LEARNING/USING X: Pointers to X documentation.
XII.E. DEBUGGING STARTUP PROBLEMS: Checklist, Screen restoration, Hanging.
XII.F. XCONFIG: Video mode settings and common errors in Xconfig.
XII.G. X-APPLICATIONS: Compiling X programs.
XII.H. BUGS
XII.J. MISC: the things that I don't know where to put :)

The X11 directories are (depending on your version of X)
XLIB = /usr/X386/lib/X11/ or /usr/lib/X11/ 
XBIN = /usr/X386/bin/ or /usr/bin/X11/



XII.A. X386 GENERAL INFORMATION
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

QUESTION: What is the X11 release supported by Linux?

ANSWER: It's the X11R5 (xfree86-1.1). 


QUESTION: What is X386/xfree86?

ANSWER: X386 is the port of the X11 server to System V/386 that was
done by Thomas Roell (roell@informatik.tu-muenchen.de).  It supports a
wide variety of VGA boards.  X386 1.2 is included in MIT's X11R5
distribution.

The Linux X386 port was based on the stock distribution from X11R5,
from MIT and was done by Orest Zborowski (obz@sisd.kodak.com).

It has since moved to becoming part of the standard xfree86 distribution.


QUESTION: Where can I get X386 1.2 (X11R5)?

ANSWER: The X386 1.2 and xfree86 sources are available at any site that
distributes the X11R5 source (too numerous to list here, but includes
export.lcs.mit.edu)


QUESTION: Any tips on compiling X11R5?

ANSWER:
-  Dont do it.
-  XFree86 is distributed with a link kit so you can optionally
	include what you like in the server.
-  You will need lots of disk space (around 150Meg for the MIT core). 
-  Look at mit/server/ddx/x386/README and follow any instructions for
	your particular platform. 
-  Contact the X11 channel at linux-activists



XII.B  HARDWARE REQUIREMENTS:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Approx: at least 4 megs of ram + swap ...slooooww. 10 Meg disk for X.
Another 6-10 meg of disk for GCC if you want to compile X11 programs.

QUESTION: What VGA boards are supported?

ANSWER: 
	et3000, et4000, gvga, pvga1a, wd890c00, tvga8900, ati ver. 5 or 6,
        8514/A, generic vga: 800x600 mono (Xmono), 640x480x16 (Xega).

	Diamond cards are not supported and will not be supported.
Contact Diamond if you have further questions or (better) buy another card. 

Standard x11v1.1 or xfree86 server:
	ET3000 		(for ex. GENOA 5300/5400)
        ET4000 		(Tricom, STB PWR Graph, Sigma Legend, etc.)
        GVGA 		(Genoa 6400)
        PVGA1A 		(Paradise VGA Professional) ... see BUGS.
        WD90C00 	(Paradise VGA 1024)

supported by xfree86:
	TVGA8900 	TRIDENT 8900 support is in xfree86	

	ATI		ATI VGA WONDER XL and most ATI VGA WONDER PLUS 
			cards (chip version 5 or 6). 
			Courtesy Rik Faith (faith@cs.unc.edu)
ATI Notes: An example Xconfig file is available from ftp.cs.unc.edu:
/pub/faith/linux/x386. Please note that:
1) clock.exe does *NOT* work with ATI cards.  
2) The ATI Wonder driver in xFree86 is known only to work with 
   chip version 5 and 6 cards.  This is most ATI VGA Wonder PLUS cards 
   and all ATI VGA Wonder XL cards (although sporadic problems have been
   reported even with these very recent cards). The driver will tell 
   you which ATI chip version you have, as will the ati.test program in
   XLIB/etc/ 


MONO    Any vga card should be able to use X386mono server. (At least
	640x480 with 800x600 virtual). Use vga2 section of Xconfig.

Also available as ALPHA test versions (join the X11 channel):
(The standard x386/xfree86 server will not handle the following cards)

8514	ATI graphics ULTRA, ATI graphics Vantage 
	(should work with any VESA standard 8514/A register compatible card?)  
	tsx-11 pub/linux/packages/X11/X8514/  (X8514new.T.Z x.8514.src.T.Z)
	courtesy Kevin Martin (martin@cs.unc.edu).

Xega	Generic 640x480x16 compatible server (originally for laptops).
	This requires a microsoft mouse at /dev/mouse for now
	and it does not use Xconfig so use environment variables
	to define the font path etc. in .xinitrc:
	export FONT_PATH=/usr/lib/X11/fonts/misc:/usr/lib/X11/fonts75dpi
	Works better with courier fonts so add to .Xresources:  
	*Font: -*-courier-medium-r-*--10* ..or whatever..
	A link kit is available at tsx-11 (you need gcc2.2.2).
	in pub/linux/ALPHA/Xega/X386.ega.T.Z
	courtesy Marc Hoffman (marc.hoffman@analog.com).

The Xega server is compiled with the gcc-2.2.2 libs and should be 
upgraded soon. It should however work with programs/fonts in new X11
releases as long as you ensure you have the shared images needed by
the server in /lib.


XS3	S3 chipset server (Jon Tombs jon@robots.ox.ac.uk)
I've started a FAQ on ftp.robots.ox.ac.uk (pub/linux/S3), but the Xserver 
is still very alpha. Unless you know something about X386 and are prepared 
to work at it, stick with the mono XFree86 server until you see different 
advice. I'd hope to get the server integrated with XFree86 in the next 
couple of weeks. This will make most the current problems go away.


WARNING: Do not try to bring up an Xserver that does not support your 
hardware. There have been cases where damage has resulted from pushing
the monitor beyond its specs.


QUESTION: What Mouses are supported?

ANSWER: Serial : Logitech, Microsoft, MouseSystems .... compatibles ...
	Busmouses : Logitech, microsoft, ATI_XL, PS/2 (aux).


QUESTION: Has anyone gotten the "Mini-DIN" mouse on an HP Vectra 486/33T 
to work? The slight info I've been able to find says it's PS/2 compatible.

ANSWER: First you need to create an entry in /dev for it:

mknod /dev/psaux c 10 1

There is no direct PS/2 mouse support in XFree86 yet, so to use the
mouse with X you'll have to use the mconv mouse protocol conversion
utility, which can be found on nic.funet.fi, in
/pub/OS/Linux/utils/tools/mconv.c. This program converts the packets
sent by the PS/2 mouse into the corresponding ones from a Microsoft
mouse, so you can fool X telling it you have a Microsoft serial
mouse instead. Instructions for use are included in the source file.
(Johan Myreen jem@cs.hut.fi)



XII.C. LINUX DISTRIBUTION
~~~~~~~~~~~~~~~~~~~~~~~~~

QUESTION: What is the current version?

ANSWER:	The newest public Linux release is x11v2.1. It is the linux 
release of xfree86-1.1. It was compiled with gcc-2.2.2d and is available 
for example at tsx-11 in pub/linux/packages/X11/xfree86-1.1/
The SLS distribution stays at 2.0.

QUESTION: What Files do I need to download?

ANSWER: For x11v2.1: There is a README file in the distribution directory.
Bring this down first and read it. Then get xbin, xman and xfonts.
You need xprog and xlibman only if you plan to compile X applications.
You dont need xkit if you want to relink the server.

**** You need The shared images libc.so.4 (4.1 or later) and libm.so.4 (4.0) 
in /lib/. All the X11 binaries use these. To compile programs you should
get gcc-2.2.2d7 or later and the 4.x libraries.

For Other servers see also the notes in the previous section.



QUESTION: Where do the X11 files go? What are they?

ANSWER: x11v2.1 uses the directories /usr/X386/bin/ (XBIN) for programs
and /usr/X386/lib/X11/ (XLIB) for support files.

The support files include default/example Xconfig, xinitrc, twmrc
which you should copy to your HOME directory (as Xconfig, .xinitrc
and .twmrc) and edit them to define your hardware and X11 setup.
The directory XLIB/etc/ contains some documentation which
should explain how to configure your video.




XII.D.  LEARNING/USING X
~~~~~~~~~~~~~~~~~~~~~~~~

QUESTION: Where can I find the basic help for learning/using X ?

ANSWER: Try man X386; man Xserver; man xterm; man twm; man xinit
on any unix machine.  The man pages on xterm and twm will reflect
behaviour on Linux systems quite accurately. The others will give you
some bearing though not every option will work.  These man pages are
part of the xfree86 distribution.
	

QUESTION: What docs are available besides man pages?

ANSWER: The FAQ in comp.windows.x11 is extensive and has a bibliography. 
There is also the Xt-FAQ. Both are available from export.lcs.mit.edu in
pub/contrib/.


QUESTION: [suggested by Thomas Koenig]
	How do I support national keyboards in X11 ?

ANSWER: Put a .Xmodmap file into the user's home directory specifying
which keys to use for what; or else replace the
/usr/lib/X11/xinit/.Xmodmap with the national keyboard keys
customized. Do man xmodmap for more details. 
enclosed an excerpt of mine (french keyboard):
keycode   8 =
keycode   9 = Escape
keycode  10 = ampersand 1
keycode  11 = eacute 2 asciitilde
keycode  12 = quotedbl 3 numbersign
keycode  13 = apostrophe 4 braceleft
keycode  14 = parenleft 5 bracketleft
keycode  15 = minus 6 bar
keycode  16 = egrave 7 grave
keycode  17 = underscore 8 backslash
keycode  18 = ccedilla 9 asciicircum
keycode  19 = agrave 0 at
keycode  20 = parenright degree bracketright
keycode  21 = equal plus braceright
keycode  22 = BackSpace
keycode  23 = Tab
keycode  24 = A
........


XII.E. DEBUGGING STARTUP PROBLEMS:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

QUESTION: How do I start up X?

ANSWER: Type 'startx' at the shell prompt.
Before doing this you should:
1) copy the file Xconfig.sample from the XLIB directory to your 
	HOME directory (/usr/root/Xconfig?) or to XLIB/Xconfig.
2) Edit Xconfig and set the video data for you card and monitor. 
   Use the clocks appropriate for your card and the modes appropriate 
   for your monitor for those clock values. To determine what values are
   appropriate read files in XLIB/etc and the Xconfig section below. 
3) Set the mouse device in Xconfig correctly....Use the busmouse entry
   for Logitech only. For other busmouses use microsoft.
4) Ensure that there is a termcap entry for xterm in /etc/termcap
   (One is available in the subdir /doc).
5) Ensure that the X11 binaries are in the path example:
   add the line PATH=${PATH}:/usr/X386/bin to ~/.profile or
   look at bash.ad in /doc.
WARNING: NONE of the modes (in the Modes line in Xconfig) should use a 
clock your monitor cannot handle.
Now type startx.


QUESTION: I cannot type in my xterm 

ANSWER: /dev/console must have major=4, minor=0
	rm -f /dev/console; ln /dev/console /dev/tty0


QUESTION: What are some of the common omissions and errors?

ANSWER: (Peter)
1) Add /usr/bin/X11 (or /usr/X386/bin) to your path.

2) Add the xterm termcap entry to /etc/termcap.

3) ln -s X386 X in the XBIN directory.
   ln -s X386mono X (if you want to use the mono server).

4) Run X as root first. This avoids some trivial problems.

5) If you change the font path entry .... X386 is finicky about
   the syntax. 

6) Make sure your mouse entry in Xconfig points to a legitimate serial 
   device  (or busmouse)... usually something like:  microsoft "/dev/ttys1"
   serial devices have major # 4 minor 64,65 ... busmouses are major 10.
   ls -l in /dev will show you the major and minor entries.

7) Need read/write/exec access to /tmp directory 

8) Use startx 2> x.err to log your error messages. If the server sticks 
   and you have to reboot you'll probably loose this stuff... see notes
   on `hanging' below.

9) See Xconfig problems and the device list below.

10) Have you read the X386 man page?


QUESTION: Why is the server unable to find some of the fonts?

ANSWER: First check that the directories listed in the font path exist
and have font files in them. Some of the servers are not set up to use 
compressed fonts. In such cases you have to uncompress the fonts in the
directory and run `mkfontdir .`. Read the man page on mkfontdir.


QUESTION: My server "hangs" Why?

ANSWER: (Peter) Quite often it isn't a hang. If the server grabs the
screen(and enters graphics mode) and then dies, it may return you to
bash *without* restoring the screen. In other words, just because you
see no output, don't assume it's running/hanging.  The way to test
this is to see if you can use a bash command to spin your disk. eg.:
sync; ls -l /bin.

Also - I *suspect* that (at least for me), you can kill the
server if you include the servernum option in the Xconfig

You can kill the server when you want to by typing ctrl-alt-backspace. 
Then a couple of ctrl-C 's in case your stuck in xinit.

The two line message
 		X386 version .....
 		(protocol Version ....
is returned from the X386 programme itself, so if you get
this (or if the screen blanks) X must be starting.


QUESTION: When I try to use X11 I got "Cannot connect to
server" or "process does not exist", any clue ?

ANSWER: The cause might be wrong fontpath variable setup in your
Xconfig; uncomment and set the correct fontpath variable.


QUESTION: Why cant I run more than 4 xterms?
	  How can I have more than 4 pty's ?

ANSWER: set the number in the header include/linux/tty.h and 
recompile the kernel. Also make nodes :
	mknod /dev/ptypxx 4  minor  (where minor = 128 + xx)
	mknod /dev/ttypxx 4  minor  (minor = 192 + xx)
	This is for before linux-0.97pl6.... for later versions
	you only need to make the nodes.
	

QUESTION: I have trouble with my logitech Pilot mouse and X under
Linux, any clue ? 

ANSWER: (Thomas Roell?) There are TWO line of Logitech mice out there.
One is the programmable and uses MouseSystems protocol at startup.
X386 reprogramms them to use another protocol. If you specify
'Logitech' in the Xconfig, X386 assumes a mouse like C7 or S9 (notC7-M).
The second line is the MicroSoft compatible. Currently all newer
Logitech mice follows this practice, like the MouseMan. In that case
you have to say 'MicroSoft' or 'MouseMan'. 

From: jliddle@rs6000.cmp.ilstu.edu (Jean Liddle)
I just purchased a new logitech mouseman, and yes, the new X-Windows
(XFree86 as opposed to X386) requires that you use the "microsoft" mousetype.
However, if you turn Third Button Emulation off, the middle button WILL work.


QUESTION: How does X11 start up?

ANSWER: The startup involves the server (XBIN/X), and some
programs like startx and xinit.

Typing startx runs the script  XBIN/startx. Look through startx. 
For explanation of the server arguments try man Xserver.
startx does little other than gather arguments and then call xinit.

xinit **calls** X (X is linked to X386). xinit therefore continues to
run, and quite often you will receive error messages from xinit rather
than X itself. If you get the message "giving up", it means X has died
(quite probably it died immediately) and xinit has been unable to start
x applications. xinit processes the startup script xinitrc.


QUESTION: How can I see what startx passes to xinit, and xinit to X?

ANSWER:  Add the line:  set -x      near the top of startx.

To see what xinit passes to X, try: (Peter)

	rm XBIN/X
 - yes, if you have set it up correctly, X should only be a link 
 so it's safe to remove it.

 then create a shell script XBIN/X containing:
	#/bin/sh
	echo $*
 and run startx. You should see something like:
	X :0
 which is all xinit passes to X. If you don't see the :0, you may not
 have your DISPLAY=":0" set correctly. THEN RESTORE X!! :
	cd XBIN; rm X; ln -s X386 X


QUESTION: What devices does X depend on:

ANSWER: check your device numbers with ls -l /dev. You should have:

5 0 tty
4 0 tty0
4 0 console
4 1 tty1 (etc)
1 1 mem

4 128 ptyp0 		pseudo ttys used by xterm/emacs etc 
4 129 ptyp1 (etc)	to talk to unix programs.
4 192 ttyp0
4 193 ttyp1 (etc)

4 64 ttys1 		one of these is the mouse 
4 65 ttys2		or you have a busmouse.
10 x mouse 		busmouse x = 0 => logitech 	1 => ps/2 (aux)
			2 => microsoft		3 => ATI_XL.
/tmp/.X11-unix/X0       socket used by X apps to talk to the server.
			this is created by X386.




XII.F. Xconfig: Xconfig and Video mode settings.
~~~~~~~~~~~~~~~
QUESTION: What do the mode names mean?

ANSWER: The mode names like "640x480" are used to match entries in 
the modes line with the modeDB entry which actually defines the mode. 
You can toggle between modes in the modes line  with ctrl-alt-numericplus. 
If you're experimenting with 640x480 you can define 
      modes "640x480a" "641x480b" "642x480c"
with corresponding entries under ModeDB so you can toggle between 
these three modes. Try man X386.

QUESTION: How do I compute the numbers for the video modes?

ANSWER: See if there is an entry that matches your chip/monitor in
XLIB/etc/modeDB.txt. Use the clock entries for your chip
and the mode entry for that clock appropriate for your monitor.
If you cant find a mode entry for a particular clock 'needed_clock'
but can find a mode entry (for your monitor) for a nearby clock value
'found_clock', scale all numbers in the modeDB entry by 
(needed_clock/found_clock). man X386 and Read CONFIG and Xconfig.notes.


QUESTION: How can I determine the clocks on the video chip?
	Where can I find clock.exe or clock.pas ?

ANSWER: The XFREE Team discourages the use  of clocks.exe and wants it
to be removed from all docs, since the new Server is better at
guessing the clocks than clocks.exe.

You can get X to tell you what it finds by commenting the
clocks entry in Xconfig. Use 'startx 2> x.err' to log the output.
If X starts up this file gets the clocks only after you exit.

I strongly advise using the 'modegen' spreadsheets to generate the 
appropriate settings. If I remember correctly you can find them in 
'pub/linux/packages/SLS/x4' called modegen.taz or something equally 
as obvious ... Good luck. (Andy asb@cs.nott.ac.uk)

The clocks entry in Xconfig serves as an index. example: 
clocks 1 2 
ModeDB
1 640x480 .....
2 800x600 .....
means the first clock on the chip will be used for the 640x480 mode
and so on. Usually one uses the MHz value for the clock for convenience
instead of 1 2  you probably have 25 28 ... etc.


QUESTION: What are the settings used with a trident-8900C?

ANSWER: To get X/SLS/Linux working with a trident-8900C, do the following:

1) From Frank Houston fh8n@uvacs.cs.Virginia.EDU 
vga256
  Virtual	1024 768
  ViewPort      0 0
  Modes	        "1024x768" "800x600" "640x480"
Use the VESA monitor timings from the modeDB in the example Xconfig.
You do not need to specify the chipset or clocks.

2) From: Henk Vandecasteele henkv@cs.kuleuven.ac.be 
TRIDENT TVGA 8900C card with BIOS C2.11, A cheap color monitor AOC (CM-335) 
with a maximum horizontal frequence of 39.5
vga256
  Virtual	1024 1024
  ViewPort      0 0
  Modes        "912x684" "800x600" "640x480" 
# This mode drives my monitor to the limit (VESA timings for the rest).
 "912x684"     45      912  944 1104 1136    684  684  690  712 


QUESTION: What are common problems with Xconfig?

ANSWER: If X isn't firing at all, or even if it clears the screen and
crashes (see below) you almost certainly have a fault in Xconfig.

1. Note that the server X interprets Xconfig. (not xinit)

2. If you have a fault in Xconfig it is possible to crash or hang the
server without getting an error message.

3. leave the two paths at the top of Xconfig commented out when testing.

4. test with only one graphics mode included - one you are most sure of.

5. If you make a mistake in the mouse section, you will (I understand)
get an error message, so if you don't get some mouse error, try
elsewhere first. (eg "No such file or directory" indicates you have a
fault in the "/dev/ttyxx" line, or /dev/ttyxx doesn't exist.

6. *NB* X looks in your home directory first to find an Xconfig. make
certain it's using the one you've been working on!

7. you need double quotes (") around your chipset and modes: eg
	chipset "et4000"
	Modes   "640x480" "640x480a" "800x600"
and around the /dev/ttyxx eg.:
	microsoft "/dev/ttys1"

8. Check your VGA section and modeDB first.

9. ensure ModeDB clock speeds match the VGA section. Comment out any
unused lines in MODEDB.

eg  clocks  25 36 00 00 00 00 00 00 

then you *must* have (and only have) lines under modeDB corresponding
to speeds 25 and 36. If you have one with (say) 62 uncommented out in
the modeDB section in place of the 36 line, you will cause the server to
die immediately with no error message.

10. a syntax error (such as an unrecognised word) in Xconfig will cause
a death with no warning.

11. videoram must equal the amount of display ram on your chip.


QUESTION: What do I use in my Xconfig file to use the bus mouse?
Logitech doesn't work with my Logitech busmouse.

ANSWER: (Nathan I. Laredo)
Here are the mouse lines from my Xconfig:

BusMouse   "/dev/mouse"

You may add a sample rate if you want, but chances are, unless the model
number on your mouse matches mine: PC-93-9MD it probably will cause your
machine to lock up, as I've gotten several reports saying that.

According to the X386 documentation, non-logitech mice do not support
a sample rate.





XII.G X-APPLICATIONS: Compiling X Programs.
~~~~~~~~~~~~~~~~~~~~~

QUESTION: Does anyone know where I can find the libobz.a library ?

ANSWER: This library contained the socket stuff, when X386 V0.1 was
released. Meanwhile it has found it's way into the kernel, so
remove -lobz from the link step in the Makefile.


QUESTION: I get _setjmp undefined when linking xv from .a files.

ANSWER: You are trying to link a program compiled with gcc-2.2.2
and setjmp has changed sice then. Recompile xv from the source
using the latest gcc.


QUESTION: How do I compile an X application that has an Imakefile?

ANSWER:
	Type xmkmf to generate the Makefile.
	Type make.


QUESTION: gcc complains the X libraries are not found or links static.

ANSWER: Check out the -nojump -static options of GCC ... read the GCC FAQ.
	You can tell gcc what directories to search with -L. 




XII.H BUGS:
~~~~~~~~~~~
Restoration of the text screen fails on some hardware.

Cant compile Xaw programs without -static in versions x11v1.1 or older.
There is a glitch with the Xaw shared libs ... I haven't seen
this in a while anyway its fixed in newer releases.

Color problems with Xega .... fixed in latest version on tsx-11.

from chuck@coplex.com (Chuck Sites)
It is possible to run X386 on a Paradise VGA Plus. The X386.0 doc file
has a small misprint.  The Chipset is not pvga. It's pvga1.   Anyway,
under the line in /usr/X386/lib/X11/Xconfig VGA256, add, `chipset "pvga1"`.
You will need a 512k board.  There seems to be a problem with 800x600 mode
that causes pixels to be misplaced in the center 1/3 of the screen. 640x480
works fine.  Anybody out there might have a fix for that? You may want to use
X386mono with 800x600 instead.


Fix for missing numlock control in xfree86-1.1.
use xmodmap to change the mapping:
  clear mod1
  add mod1 = Alt_L
  keysym Alt_R = Mode_switch
  add mod5 = Mode_switch
David (Dawes)

XII.J. MISC
~~~~~~~~~~~
QUESTION: When using Makefiles generated by xmkmf why do I get many error 
	messages?

ANSWER: Currently xmkmf under Linux doesn't like # comments in Imakefiles. 
Therefore you must change the #'s to XCOMM. But be careful. Don't change
any pre-compiler directives. (mal11@po.CWRU.Edu  Matthew A. Lewis)


QUESTION: Why do I get the  error message 'could not open default font'
	when I start X?

ANSWER: Some servers only work with compressed (uncompressed) fonts.
So compress (uncompress) the font files in misc and 75dpi directories and 
run `mkfontdir .`. Leave the files fonts.alias and fonts.dir uncompressed.


QUESTION: Why is it I cannot get Xfree86 to work with my trident card?

ANSWER: You should get xfree86-1.1 which has improved trident support.
SLS contains 1.0Ya (I believe). If you have SLS already and a slow 
connection get xbin2.1.TZa from the xfree86-1.1 distribution on tsx-11.


Sources for X11_FAQ: 
Steve Kotsopoulos, Peter Hawkins, John Morris, MM. Corsini, 
K. Balasubramanian. 
Direct comments, questions, complaints to krishna at:
balasub@cis.ohio-state.edu


XIII. EMACS for LINUX
=====================
*** This section is maintained by Rick Sladkey (jrs@world.std.com)
*** Last Update November 1992.

XIII.A. GENERAL INFORMATION 
XIII.B. GNU EMACS for LINUX

XIII.A. GENERAL INFORMATION
~~~~~~~~~~~~~~~~~~~~~~~~~~~

This is a short list of Frequently Asked Questions about GNU Emacs
under Linux.  It does not address general questions about Emacs which
are not Linux specific.  For general help about Emacs, 1) learn to use
and read the online documentation, 2) read the real Emacs FAQ found in
emacs/etc/FAQ, and 3) read the newsgroup gnu.emacs.help.

                                        Rick Sladkey <jrs@world.std.com>

XIII.B. GNU EMACS for LINUX
~~~~~~~~~~~~~~~~~~~~~~~~~~~
QUESTION: Does Linux Emacs use the shared libraries?

ANSWER: Yes.  It wasn't easy.  If you have any problems with them let
me know. Also contact me if you would like static binaries.

QUESTION: What version of the compiler was used?  Which shared libaries?

ANSWER: This describes version of GNU Emacs 18.59 for Linux 0.97 and above
compiled with GCC 2.2.2d7 using the libc.so.4.1 and libX11.so.2.1 shared
libraries.

QUESTION: Which files do I need?

ANSWER:
emacs-18.59a.tar.Z		this file, sample default.el and diffs
				for this version, the eight-bit patch,
				iso-latin-1.el and eight-bit.el
emacs-etc-18.59a.tar.Z		emacs support programs and misc info
emacs-bin-18.59a.tar.Z		shared emacs binary and its doc file
x11emacs-bin-18.59a.tar.Z	shared x11emacs binary and its doc file

QUESTION: How do I install them?

ANSWER: According to Linux convention, cd to /usr and untar the
packages. 

QUESTION: Does Linux Emacs support eight-bit input/output?

ANSWER: Yes.  It is new with this version.  It uses the so-called
"ctl-arrow" patch.  See the file README.8bit for more information.

QUESTION: How much disk space is required?

ANSWER: Anywhere from 1 to 15 Meg.  Emacs works reasonably well with no
support files at all.  With a judicious selection from lisp/*.elc and
etc/*, quite a lot can be done using only 2 Meg.  If you want all of
lisp/*.elc, info/*, and etc/* this will require 4 to 6 Meg.  If you
unpack the whole source you need 8 Meg.  If you collect info files
like rare coins and install a lot of big lisp packages then Emacs may
need its own partition. :-)

QUESTION: Why does Emacs crash under Linux 0.98 patchlevel 4 or higher?

ANSWER: It crashes becuase of the a new 256-bit wide fd_set structure. 
Sometimes progress requires sacrifice.

QUESTION: Why can't Emacs find its support files anymore?

ANSWER: This is because older versions of Emacs were compiled with
"/usr/local/emacs" based paths.  The current version is compiled with
"/usr/emacs" paths.  If you have a previous installation, just "mv
/usr/local/emacs /usr" and you're done.  If you can't bear to part
with the "/usr/local" pathnames because of inertia then do "ln -s
/usr/local/emacs /usr" and you can have them both.

QUESTION: How do I get Emacs to recognize my cursor keys?

ANSWER: Simple.  Don't use them. :-)  Seriously, there are as many
ways to do this are there are elisp hackers but the preferred way is
to follow the pattern set by the other terminal definition files in
emacs/lisp/term/*.el.  For just arrow keys you can just copy vt220.el
to console.el and that's it.  For function keys and the others see
the sample default.el included with this file.

QUESTION: What packages are particularly useful under Linux?

ANSWER: Because info format is the documentation standard of the GNU
project and just about everything except the kernel comes from FSF,
you will find that Dave Gillespie's enhanced info package is very
useful.  It allows multiple info directories, space bar paging, and
supports compressed info files. Please learn to use info.  Imagine
Unix life without man.

Others that I highly recommend are Sebastian Kremer's enhanced
dired directory editor, Dave Gillespie's calc calculator, Masanobu
UMEDA's gnus for usenet news, and Kyle Jone's vm for mail.

All can be found in the OSU Emacs archive.  See the real FAQ for more
details.

QUESTION: Does Linux Emacs use the shared libraries?

ANSWER: Yes.  It is very delicate.  Emacs uses its own malloc and the
library uses the standard one.  Everything works as long as the two
never meet. 

QUESTION: Does Linux Emacs support the X Window System?

ANSWER: Yes.  However, there are two binaries.  One without X support
(about 485k) and one with X support (about 515k).

QUESTION: Do I need both Emacs if I don't always use X?

ANSWER: No. The X11 version works equally well inside or outside of X.
If you get the message "Check your DISPLAY variable" it means that
you have defined DISPLAY in your ~/.profile (or whatever).  You can
fix this by starting Emacs with 'emacs -nw' or by removing the DISPLAY
variable from your ~/.profile and putting it in you ~/.xinitrc.

QUESTION: Why doesn't Emacs use the settings in my
.Xdefaults/.Xresources file? 

ANSWER: You are probably using the word "emacs" and your X version of
emacs is called x11emacs.  Either use the word "Emacs" in your resource
file or rename x11emacs to emacs.  See above question on why this
is reasonable.

QUESTION: I read about some menu that is supposed to pop up when I
press some mouse button.  Does this work with Linux Emacs?

ANSWER: Yes.  This requires XMenu support to be compiled in.  Former
versions did not support it because it did not work correctly.

QUESTION: Sometimes Emacs crashes with a SIGALRM message.  What's
wrong? 

ANSWER: You need to upgrade to a newer version of bash.  Some older
versions of bash were compiled with buggy libraries that caused bash
to send a SIGALRM to its parent in some circumstances.  Recent
versions do not exhibit this problem.

QUESTION: Why does Emacs always put me in the root directory?

ANSWER: You have an old version of Emacs compiled before GCC 2.11c and
you are using the Linux extended filesystem.  Get the new version.

QUESTION: Why doesn't Control-Z doesn't work right with Emacs?

QUESTION: Why doesn't job control work in shell mode?

ANSWER: You have a really old version of Linux Emacs.  Get the new one.

	   ===================8<==========>8================


