/************************************************************************

	Software:	LCKOWL.DLL

	Version:	1.02
			Copyright by Larry Klein, LCK Consulting, December 15, 1992

	Developed By:	Larry Klein
			LCK Consulting
			732 Symphony Woods Drive
			Silver Spring, MD  20901
			Phone - 301-593-2745
			Fax   - 301-593-4262
			Compuserve - 76330,2525

	Purpose:	BC++ OWL-derived MDI Frame class that automatically manages
				a status bar, tool bar and toolbox.
			BC++ OWL-derived Window classes that add administrative
				features lacking in OWL.

	Requirements:	Borland C++ Compiler 3.0 or higher
			LCKUtil.DLL for error message handling

	Requirements	Drover's Toolbox by Farpoint
	For Extending		FarPoint Technologies
	LCKOWL.DLL:		P.O. Box 309
				75 Walnut Street
				Richmond, Ohio  43944-0309
				Phone: 614-765-4333
				Fax:   614-765-4939

************************************************************************/

#include "windows.h"
extern "C" {
#include "toolbox.h"
}
#include "lckowl.h"
#include "lckutil.h"

char		szAppName[] 	= "LCK OWL Extension";
char		szNull[]	= "";

PTModule 	TheModule;

TLCKWindow::TLCKWindow( PTWindowsObject AParent, LPSTR ATitle, WORD AWindowType )
	: TWindow(AParent, ATitle)
{
	strncpy(szClassName, ATitle, LCK_MAXLEN_CLASSNAME);
        szClassName[LCK_MAXLEN_CLASSNAME] = NULL;
	SetFlags(WB_KBHANDLER, FALSE);
	wWindowType = AWindowType;
	bResize = TRUE;
}

LPSTR 	TLCKWindow::GetClassName()
{
	return szClassName;
}

void 	TLCKWindow::GetWindowClass(WNDCLASS _FAR & AWndClass)
{
	TWindow::GetWindowClass(AWndClass);
	AWndClass.hIcon = LoadIcon(GetApplication()->hInstance, szClassName);
	AWndClass.cbWndExtra = 2;
}

void 	TLCKWindow::SetupWindow()
{
	TWindow::SetupWindow();
	GetApplication()->SetKBHandler(this);
	EnableKBHandler();
	SetWindowWord(HWindow, 0, wWindowType);
}

void 	TLCKWindow::WMNCCreate(RTMessage Msg)
{
	LONG   	Styles;

        if(!bResize) {
		Styles = GetWindowLong( HWindow, GWL_STYLE );
		Styles &= ~( WS_MAXIMIZEBOX );
		SetWindowLong( HWindow, GWL_STYLE, Styles);
        }

	DefWndProc( Msg );
}

void 	TLCKWindow::WMNCLButtonDown(RTMessage Msg)
{
	if( bResize ) {
		DefWndProc( Msg );
		return;
	}

	switch( Msg.WParam ) {
	    case HTLEFT:
	    case HTRIGHT:
	    case HTTOP:
	    case HTTOPLEFT:
	    case HTTOPRIGHT:
	    case HTBOTTOM:
	    case HTBOTTOMLEFT:
	    case HTBOTTOMRIGHT:
		break;
	    default:
		DefWndProc( Msg );
	}
}

TMDIChildWindow::TMDIChildWindow(PTWindowsObject AParent, LPSTR ATitle, LPSTR ADialogName, WORD AWindowType)
	: TWindowTools(AParent, ATitle, AWindowType)
{
	ChildDialog = NULL;
	bResize = FALSE;
	strncpy(szDialogName, ADialogName, LCK_MAXLEN_DIALOGNAME);
        szDialogName[LCK_MAXLEN_DIALOGNAME] = NULL;
}

PTDialog TMDIChildWindow::CreateChildDialog()
{
	ChildDialog = (PTDialog) GetApplication()->MakeWindow(new TMDIChildDialog(this, szDialogName));
	Resize();
	return ChildDialog;
}

void 	TMDIChildWindow::Resize()
{
/*
	RECT	Rect;
	int	nClientTopOffset, nClientBottomOffset;

	if( IsIconic(HWindow) ) return;	// can't resize icon!

	nClientTopOffset = nClientBottomOffset = 0;

	if( ToolBar && ToolBar->Exists() ) {
		nClientTopOffset += ToolBar->nHeight + 2;
		nClientBottomOffset += ToolBar->nHeight + 2;
	}
	if( StatusBar && StatusBar->Exists() ) nClientBottomOffset += StatusBar->nHeight;

	GetClientRect(HWindow, &Rect);
	MoveWindow(ClientWnd->HWindow, 0, nClientTopOffset, Rect.right,
		 Rect.bottom - nClientBottomOffset, TRUE);
	if( StatusBar && StatusBar->Exists() ) MoveWindow(StatusBar->HWindow, 0, Rect.bottom - StatusBar->nHeight,
				Rect.right, StatusBar->nHeight, TRUE);
*/
	RECT		Rect;
	int		nClientTopOffset, nClientBottomOffset;
	RECT		rcWindow, rcDialog;
	PTMDIFrame	Frame;
        POINT		pWindow;

	if(IsIconic(HWindow)) return;	// can't resize icon!
	if(!ChildDialog) return;

	Frame = (PTMDIFrame) Parent;

	GetWindowRect(HWindow, &rcWindow);
	GetWindowRect(ChildDialog->HWindow, &rcDialog);

	pWindow.x = rcWindow.left;
	pWindow.y = rcWindow.top;

	ScreenToClient(Frame->ClientWnd->HWindow, &pWindow);

	nClientTopOffset = nClientBottomOffset = 0;
	if( ToolBar && ToolBar->Exists() ) {
		nClientTopOffset += ToolBar->nHeight + 2;
		nClientBottomOffset += ToolBar->nHeight + 2;
	}
	if( StatusBar && StatusBar->Exists() ) nClientBottomOffset += StatusBar->nHeight;

	MoveWindow(HWindow, pWindow.x, pWindow.y,
		rcDialog.right - rcDialog.left + GetSystemMetrics(SM_CXFRAME) + GetSystemMetrics(SM_CXDLGFRAME) ,
		rcDialog.bottom - rcDialog.top + GetSystemMetrics(SM_CYCAPTION)
		+ GetSystemMetrics(SM_CYDLGFRAME) + GetSystemMetrics(SM_CYFRAME) + nClientBottomOffset,
		TRUE);
	MoveWindow(ChildDialog->HWindow, 0, nClientTopOffset, rcDialog.right - rcDialog.left,
		rcDialog.bottom - rcDialog.top, TRUE);

	TWindowTools::Resize();
}

void 	TMDIChildWindow::SetupWindow()
{
	TWindowTools::SetupWindow();
	CreateChildDialog();
}

void 	TMDIChildWindow::WMMDIActivate(RTMessage Msg)
{
	TWindowTools::WMMDIActivate(Msg);
	if ( Msg.WParam == TRUE ) {
		GetApplication()->SetKBHandler( this );
		if( ChildDialog != NULL ) SetFocus(ChildDialog->HWindow);
	}
}

void 	TMDIChildWindow::WMSize(RTMessage Msg)
{
	TWindowTools::WMSize(Msg);
	if(!bResize) Resize();	// In case user cascades or tiles child window
}

TMDIFrameTools::TMDIFrameTools(LPSTR ATitle, LPSTR MenuName)
	: TMDIFrame(ATitle, MenuName)
{
	StatusBar = NULL;
	ToolBar = NULL;
        ToolBox = NULL;
};

TMDIFrameTools::~TMDIFrameTools()
{
	if(StatusBar) delete StatusBar;
	if(ToolBar) delete ToolBar;
	if(ToolBox) delete ToolBox;
}

void	TMDIFrameTools::CloseChildWindows(WORD AWindowType)
{
	ForEach((TActionMemFunc) &TMDIFrameTools::CloseChildWindow, (void *) AWindowType);
}

void	TMDIFrameTools::CloseChildWindow(PTWindowsObject Child, Pvoid Param)
{
	WORD		wType;

	wType = GetWindowWord(Child->HWindow, 0);
	if(wType == (WORD) Param)
		Child->CloseWindow();
}

void	TMDIFrameTools::CMCreateStatusBar(RTMessage)
{
	if( StatusBar && !StatusBar->Exists() ) {
		StatusBar->Create(HWindow);
		Resize();
	}
}

void	TMDIFrameTools::CMCreateToolBar(RTMessage)
{
	if( ToolBar && !ToolBar->Exists() ) {
		ToolBar->Create(GetApplication()->hInstance, HWindow);
		Resize();
	}
}

void	TMDIFrameTools::CMCreateToolBox(RTMessage)
{
	if( ToolBox && !ToolBox->Exists() ) {
		ToolBox->Create(GetApplication()->hInstance, HWindow);
		Resize();
	}
}

void 	TMDIFrameTools::CMDestroyStatusBar(RTMessage)
{
	if( StatusBar && StatusBar->Exists() ) {
		StatusBar->Destroy();
		Resize();
	}
}

void 	TMDIFrameTools::CMDestroyToolBar(RTMessage)
{
	if( ToolBar && ToolBar->Exists() ) {
		ToolBar->Destroy();
		Resize();
	}
}

void 	TMDIFrameTools::CMDestroyToolBox(RTMessage)
{
	if( ToolBox && ToolBox->Exists() ) {
		ToolBox->Destroy();
		Resize();
	}
}

void 	TMDIFrameTools::CMToggleStatusBar(RTMessage)
{
	HMENU	hMenu;

	if ( !StatusBar ) return; 	// Must first initialize status bar

	hMenu = GetMenu(HWindow);

	if ( StatusBar->Exists() ) {
		CheckMenuItem(hMenu, IDM_TOGGLESTATUSBAR, MF_BYCOMMAND | MF_UNCHECKED);
		StatusBar->Destroy();
	}
	else {
		CheckMenuItem(hMenu, IDM_TOGGLESTATUSBAR, MF_BYCOMMAND | MF_CHECKED);
		StatusBar->Create(HWindow);
	}
	Resize();
	DrawMenuBar(HWindow);
}

void 	TMDIFrameTools::CMToggleToolBar(RTMessage)
{
	HMENU	hMenu;

	if ( !ToolBar ) return; 	// Must first initialize tool bar

	hMenu = GetMenu(HWindow);

	if ( ToolBar->Exists() ) {
		CheckMenuItem(hMenu, IDM_TOGGLETOOLBAR, MF_BYCOMMAND | MF_UNCHECKED);
		ToolBar->Destroy();
	}
	else {
		CheckMenuItem(hMenu, IDM_TOGGLETOOLBAR, MF_BYCOMMAND | MF_CHECKED);
		ToolBar->Create(GetApplication()->hInstance, HWindow);
	}
	Resize();
	DrawMenuBar(HWindow);
}

void 	TMDIFrameTools::CMToggleToolBox(RTMessage)
{
	HMENU	hMenu;

	if ( !ToolBox ) return; 	// Must first initialize tool bar

	hMenu = GetMenu(HWindow);

	if ( ToolBox->Exists() ) {
		CheckMenuItem(hMenu, IDM_TOGGLETOOLBOX, MF_BYCOMMAND | MF_UNCHECKED);
		ToolBox->Destroy();
	}
	else {
		CheckMenuItem(hMenu, IDM_TOGGLETOOLBOX, MF_BYCOMMAND | MF_CHECKED);
		ToolBox->Create(GetApplication()->hInstance, HWindow);
	}
	Resize();
	DrawMenuBar(HWindow);
}

PTWindowsObject	TMDIFrameTools::GetFirstChildWindow(WORD AWindowType)
{
	return FirstThat((TCondMemFunc) &TMDIFrameTools::IsWindowType, (void *) AWindowType);
}

int	TMDIFrameTools::GetWindowTypeCount(WORD AWindowType)
{
	nWindowTypeCount = 0;
	ForEach((TActionMemFunc) &TMDIFrameTools::IncWindowTypeCount, (void *) AWindowType);
	return nWindowTypeCount;
}

void 	TMDIFrameTools::IncWindowTypeCount(PTWindowsObject Child, Pvoid Param)
{
	WORD		wType;

	wType = GetWindowWord(Child->HWindow, 0);
	if(wType == (WORD) Param) nWindowTypeCount++;
}

void CALLBACK TMDIFrameTools::InitStatusBar(LPSTATUSBARITEM AStatusBar, int AItems, int AHeight, DWORD AStyle)
{
 	StatusBar = new TLCKStatusBar(AStatusBar, AItems, AHeight, AStyle);
}

void CALLBACK TMDIFrameTools::InitToolBar(LPTOOLBOXITEM AToolBar, int AItems, int AHeight, int AWidth, DWORD AStyle)
{
	ToolBar = new TLCKToolBar(AToolBar, AItems, AHeight, AWidth, AStyle);
}

void CALLBACK TMDIFrameTools::InitToolBox(LPTOOLBOXITEM AToolBox, int AItems, LPSTR ATitle, int AColumns, int ARows, int AHeight, int AWidth, DWORD AStyle)
{
	ToolBox = new TLCKToolBox(AToolBox, AItems, ATitle, AColumns, ARows, AHeight, AWidth, AStyle);
}

BOOL 	TMDIFrameTools::IsWindowType(PTWindowsObject Child, Pvoid Param)
{
	WORD		wType;

	wType = GetWindowWord(Child->HWindow, 0);
	if(wType == (WORD) Param) return TRUE;
        return FALSE;
}

void 	TMDIFrameTools::Resize()
{
	RECT	Rect;
	int	nClientTopOffset, nClientBottomOffset;

	if( IsIconic(HWindow) ) return;	// can't resize icon!

	nClientTopOffset = nClientBottomOffset = 0;
	 
	if( ToolBar && ToolBar->Exists() ) {
		nClientTopOffset += ToolBar->nHeight + 2;
		nClientBottomOffset += ToolBar->nHeight + 2;
	}
	if( StatusBar && StatusBar->Exists() ) nClientBottomOffset += StatusBar->nHeight;

	GetClientRect(HWindow, &Rect);
	MoveWindow(ClientWnd->HWindow, 0, nClientTopOffset, Rect.right,
		 Rect.bottom - nClientBottomOffset, TRUE);
	if( StatusBar && StatusBar->Exists() ) MoveWindow(StatusBar->HWindow, 0, Rect.bottom - StatusBar->nHeight,
				Rect.right, StatusBar->nHeight, TRUE);

}

void 	TMDIFrameTools::WMCommand(RTMessage Msg)
{
        TMDIFrame::WMCommand(Msg);

	// This will convert toolbar/box button clicks to menu commands
	// if the button IDs match menu IDs

	if(Msg.LP.Hi == TBXN_CLICKED)	
		PostMessage(HWindow, WM_COMMAND, Msg.WParam, 0L);
}

void 	TMDIFrameTools::WMSize(RTMessage)
{
	// Don't send TMDIFrame::WMSize or you will get a double flash
	Resize();
}

TLCKStatusBar::TLCKStatusBar(LPSTATUSBARITEM AStatusBar, int AItems, int AHeight, DWORD AStyle)
{
	HWindow = NULL;
	Style = AStyle;
	nHeight = AHeight;
	nItems = AItems;
	StatusBar = new STATUSBARITEM[nItems];
	if(!StatusBar) LCKMessage(LCKERR_CANTALLOCATE);
        else MemCpy(StatusBar, AStatusBar, nItems * sizeof(STATUSBARITEM));
}

TLCKStatusBar::~TLCKStatusBar()
{
	delete StatusBar;
}

HWND CALLBACK TLCKStatusBar::Create(HWND AWindow)
{
	RECT		RectClient;

	if(!nHeight) {
		HDC hdc = GetDC(AWindow);
		TEXTMETRIC tm;
		GetTextMetrics(hdc, &tm);
		nHeight = tm.tmHeight + tm.tmExternalLeading + 2;
		ReleaseDC(AWindow, hdc);
        }

	GetClientRect(AWindow, &RectClient);
	HWindow = tbCreateStatusBar(AWindow, WS_CHILD | WS_VISIBLE | SBRS_DRAWTOPLINE |
			    SBRS_PIXELS, 0,
                            RectClient.bottom - nHeight,
			    RectClient.right, nHeight,
			    StatusBar, nItems);

        return HWindow;
}

void CALLBACK TLCKStatusBar::Destroy()
{
	if(!HWindow) {
		LCKMessage(LCKERR_CANTDESTROYSTATUSBAR);
                return;
        }

	DestroyWindow(HWindow);
	HWindow = NULL;
}

void CALLBACK TLCKStatusBar::SetItemText(WORD AItem, LPSTR AText)
{
	SendMessage(HWindow, SBRM_SETITEMTEXT, AItem, (LONG) AText);
}

void CALLBACK TLCKStatusBar::SetProgressPos(WORD AItem, WORD APos)
{
	SendMessage(HWindow, SBRM_SETPROGRESSPOS, AItem, (LONG) APos);
}

void CALLBACK TLCKStatusBar::SetProgressRange(WORD AItem, WORD AMinimum, WORD AMaximum)
{
	SendMessage(HWindow, SBRM_SETPROGRESSRANGE, AItem, MAKELONG(AMinimum, AMaximum));
}

TLCKToolBar::TLCKToolBar(LPTOOLBOXITEM AToolBar, int AItems, int AHeight, int AWidth, DWORD AStyle)
{
	HWindow = NULL;
	Style = AStyle;
	nHeight = AHeight;
        nWidth = AWidth;
	nItems = AItems;
	x = y = 0;
	dColCount = TBX_MAXSIZE;
	dRowCount = 1;
	dBorderSize = 0;
	ToolBar = new TOOLBOXITEM[nItems];
	if(!ToolBar) LCKMessage(LCKERR_CANTALLOCATE);
	else MemCpy(ToolBar, AToolBar, nItems * sizeof(TOOLBOXITEM));
}

TLCKToolBar::~TLCKToolBar()
{
	delete ToolBar;
}

HWND CALLBACK TLCKToolBar::Create(HINSTANCE AInst, HWND AWindow)
{
	int	i;

	HWindow = tbCreateToolBox(AInst, AWindow, Style, x, y, nWidth, nHeight,
			 dColCount, dRowCount, dBorderSize, NULL);

	for (i = 0; i < nItems; i++)
		SendMessage(HWindow, TBXM_ADDITEM, 0, (long)(LPSTR)&ToolBar[i]);

        return HWindow;
}

void CALLBACK TLCKToolBar::Destroy()
{
	if(!HWindow) {
		LCKMessage(LCKERR_CANTDESTROYTOOLBAR);
                return;
        }

	DestroyWindow(HWindow);
	HWindow = NULL;
}

TLCKToolBox::TLCKToolBox(LPTOOLBOXITEM AToolBox, int AItems, LPSTR ATitle, int AColumns, int ARows, int AHeight, int AWidth, DWORD AStyle)
{
	HWindow = NULL;
        if(ATitle) {
		strncpy(Title, ATitle, LCK_MAXLEN_TITLE);
		Title[LCK_MAXLEN_TITLE - 1] = NULL;
	}
	else *Title = NULL;
	Style = AStyle;
	nHeight = AHeight;
        nWidth = AWidth;
	nItems = AItems;
	x = y = 0;
	dColCount = AColumns;
	dRowCount = ARows;
	dBorderSize = 0;
	ToolBox = new TOOLBOXITEM[nItems];
	if(!ToolBox) LCKMessage(LCKERR_CANTALLOCATE);
	else MemCpy(ToolBox, AToolBox, nItems * sizeof(TOOLBOXITEM));
}

TLCKToolBox::~TLCKToolBox()
{
	delete ToolBox;
}

HWND CALLBACK TLCKToolBox::Create(HINSTANCE AInst, HWND AWindow)
{
	int	i;

	HWindow = tbCreateToolBox(AInst, AWindow, Style, x, y, nWidth, nHeight,
			 dColCount, dRowCount, dBorderSize, *Title ? Title : NULL);

	for (i = 0; i < nItems; i++)
		SendMessage(HWindow, TBXM_ADDITEM, 0, (long)(LPSTR)&ToolBox[i]);

        return HWindow;
}

void CALLBACK TLCKToolBox::Destroy()
{
	if(!HWindow) {
		LCKMessage(LCKERR_CANTDESTROYTOOLBOX);
                return;
        }

	DestroyWindow(HWindow);
	HWindow = NULL;
}

TWindowTools::TWindowTools(PTWindowsObject AParent, LPSTR ATitle, WORD AWindowType)
	: TLCKWindow(AParent, ATitle, AWindowType)
{
	StatusBar = NULL;
	ToolBar = NULL;
	ToolBox = NULL;
};

TWindowTools::~TWindowTools()
{
	if(StatusBar) delete StatusBar;
	if(ToolBar) delete ToolBar;
	if(ToolBox) delete ToolBox;
}

void	TWindowTools::CMCreateStatusBar(RTMessage)
{
	if( StatusBar && !StatusBar->Exists() ) {
		StatusBar->Create(HWindow);
		Resize();
	}
}

void	TWindowTools::CMCreateToolBar(RTMessage)
{
	if( ToolBar && !ToolBar->Exists() ) {
		ToolBar->Create(GetApplication()->hInstance, HWindow);
		Resize();
	}
}

void	TWindowTools::CMCreateToolBox(RTMessage)
{
	if( ToolBox && !ToolBox->Exists() ) {
		ToolBox->Create(GetApplication()->hInstance, HWindow);
		Resize();
	}
}

void 	TWindowTools::CMDestroyStatusBar(RTMessage)
{
	if( StatusBar && StatusBar->Exists() ) {
		StatusBar->Destroy();
		Resize();
	}
}

void 	TWindowTools::CMDestroyToolBar(RTMessage)
{
	if( ToolBar && ToolBar->Exists() ) {
		ToolBar->Destroy();
		Resize();
	}
}

void 	TWindowTools::CMDestroyToolBox(RTMessage)
{
	if( ToolBox && ToolBox->Exists() ) {
		ToolBox->Destroy();
		Resize();
	}
}

void 	TWindowTools::CMToggleStatusBar(RTMessage)
{
	HMENU	hMenu;

	if ( !StatusBar ) return; 	// Must first initialize status bar

	hMenu = GetMenu(HWindow);

	if ( StatusBar->Exists() ) {
		CheckMenuItem(hMenu, IDM_TOGGLESTATUSBAR, MF_BYCOMMAND | MF_UNCHECKED);
		StatusBar->Destroy();
	}
	else {
		CheckMenuItem(hMenu, IDM_TOGGLESTATUSBAR, MF_BYCOMMAND | MF_CHECKED);
		StatusBar->Create(HWindow);
	}
	Resize();
	DrawMenuBar(HWindow);
}

void 	TWindowTools::CMToggleToolBar(RTMessage)
{
	HMENU	hMenu;

	if ( !ToolBar ) return; 	// Must first initialize tool bar

	hMenu = GetMenu(HWindow);

	if ( ToolBar->Exists() ) {
		CheckMenuItem(hMenu, IDM_TOGGLETOOLBAR, MF_BYCOMMAND | MF_UNCHECKED);
		ToolBar->Destroy();
	}
	else {
		CheckMenuItem(hMenu, IDM_TOGGLETOOLBAR, MF_BYCOMMAND | MF_CHECKED);
		ToolBar->Create(GetApplication()->hInstance, HWindow);
	}
	Resize();
	DrawMenuBar(HWindow);
}

void 	TWindowTools::CMToggleToolBox(RTMessage)
{
	HMENU	hMenu;

	if ( !ToolBox ) return; 	// Must first initialize tool box

	hMenu = GetMenu(HWindow);

	if ( ToolBox->Exists() ) {
		CheckMenuItem(hMenu, IDM_TOGGLETOOLBOX, MF_BYCOMMAND | MF_UNCHECKED);
		ToolBox->Destroy();
	}
	else {
		CheckMenuItem(hMenu, IDM_TOGGLETOOLBOX, MF_BYCOMMAND | MF_CHECKED);
		ToolBox->Create(GetApplication()->hInstance, HWindow);
	}
	Resize();
	DrawMenuBar(HWindow);
}

void CALLBACK TWindowTools::InitStatusBar(LPSTATUSBARITEM AStatusBar, int AItems, int AHeight, DWORD AStyle)
{
 	StatusBar = new TLCKStatusBar(AStatusBar, AItems, AHeight, AStyle);
}

void CALLBACK TWindowTools::InitToolBar(LPTOOLBOXITEM AToolBar, int AItems, int AHeight, int AWidth, DWORD AStyle)
{
	ToolBar = new TLCKToolBar(AToolBar, AItems, AHeight, AWidth, AStyle);
}

void CALLBACK TWindowTools::InitToolBox(LPTOOLBOXITEM AToolBox, int AItems, LPSTR ATitle, int AColumns, int ARows, int AHeight, int AWidth, DWORD AStyle)
{
	ToolBox = new TLCKToolBox(AToolBox, AItems, ATitle, AColumns, ARows, AHeight, AWidth, AStyle);
}

void 	TWindowTools::Resize()
{
	RECT	Rect;
	int	nClientBottomOffset;

	if( IsIconic(HWindow) ) return;	// can't resize icon!

	nClientBottomOffset = 0;
 
	if( StatusBar && StatusBar->Exists() ) nClientBottomOffset += StatusBar->nHeight;

	GetClientRect(HWindow, &Rect);
	if( StatusBar && StatusBar->Exists() ) MoveWindow(StatusBar->HWindow, 0, Rect.bottom - StatusBar->nHeight,
				Rect.right, StatusBar->nHeight, TRUE);
}

void 	TWindowTools::WMCommand(RTMessage Msg)
{
        TWindow::WMCommand(Msg);

	// This will convert toolbar/box button clicks to menu commands
	// if the button IDs match menu IDs

	if(Msg.LP.Hi == TBXN_CLICKED)	
		PostMessage(HWindow, WM_COMMAND, Msg.WParam, 0L);
}

void 	TWindowTools::WMSize(RTMessage)
{
	// Don't send TMDIFrame::WMSize or you will get a double flash
	Resize();
}

int FAR PASCAL LibMain(HANDLE hInstance, WORD /*wDataSeg*/,
  WORD /* cbHeapSize */, LPSTR lpCmdLine)
{
	int TheStatus;

	TheModule = new TModule("LCKOWL", hInstance, lpCmdLine);
	TheStatus = TheModule->Status;
	if ( TheStatus != 0 ) {
		delete TheModule;
		TheModule = NULL;
	}

	return (TheStatus == 0);
}

int FAR PASCAL WEP(int /*bSystemExit*/)
{
//	if ( TheModule ) delete TheModule;
	return 1;
}

