extern int sw_doom; /* is this shareware doom? */
extern int breakpoint; /* used for debugging */
extern int backup; /* make backup files */
extern int version; /* version number times 10 */
extern int graph_on; /* graphics mode is on */
extern int testmode; /* if in test mode */
extern int grid; /* grid color/off */
extern int roundoff; /* round off mouse (x,y) coords to 8 or 16 */
extern int color_num; /* current hilight color */
extern int points; /* display points mode size/off */
extern int point_size;
extern int things_on; /* size to draw things/off */
extern int line_size; /* thickness of drawn lines */
extern int midx, midy; /* center of screen coord */
extern int mouse;
extern int mousex, mousey; /* mouse screen coord */
extern int crossx, crossy;
extern int cross_on;
extern int mouse_maxx, mouse_maxy; /* max mouse screen coord */
extern int maxx, maxy; /* max screen coord */
extern int cur_drag; /* # of whatever we are currently draging */
extern int episode, mission; /* duh.. */
extern int edit_mode; /* what are we editing now? */
extern int color_scheme; /* what colors we use for walls */
extern int mark_mask; /* marked items hilighting method */
extern int flags_mask; /* display things bits */
extern int flags_mask2; /* display things match exactly bits */
extern int text_color; /* color to draw text */
extern int editing_pwad; /* are we editing a pwad? */
extern int marked; /* are there any marked objects? */
extern uint v_size; /* # of vertexes */
extern uint v_max;
extern uint max_vertex; /* # of line vertexes (below ones used by segs */
extern uint l_size; /* # of linedefs */
extern uint l_max;
extern uint s_size; /* # of sidedefs */
extern uint s_max;
extern uint t_size; /* # of things */
extern uint t_max;
extern uint b_size; /* size of blockmap */
extern uint n_size; /* size of nodes block */
extern uint n_max;
extern uint r_size; /* size of reject block */
extern uint ss_size; /* # of special sectors */
extern uint ss_max;
extern uint sec_size; /* # of sectors */
extern uint sec_max;
extern uint seg_size; /* # of segments */
extern uint seg_max;
extern long dir_ptr; /* fseek position of directory in wad file */
extern long dir_size; /* # of entries in the wad directory */
extern long entry_ptr; /* fseek position of wad subfile */
extern long entry_len; /* length of wad subfile */
extern long entry_count; /* # entries left in directory structure */
extern int button_status; /* current mouse buttons state */
extern int true_button;
extern int ignore_button;
extern int button_lock;
extern int keypress; /* current key pressed on keyboard (ext +1000) */
extern int scale; /* zoom factor, 0 is actually max zoomed in */
extern int xoffset, yoffset; /* map to screen offsets */
extern int doom1; /* WAD is named doom1.wad, instead of doom.wad */
extern int thing_max; /* size of things list */
extern int thing_name_size; /* length of longest name in list */
extern int linetype_max;
extern int linetype_name_size;
extern int test_node; /*node being displayed (test mode only) */
extern int tx1, tx2, tx3, tx4, ty1, ty2, ty3, ty4; /* test drawing points */
extern FILE *fp, *fp2; /* general file pointers */

extern char pwad[8]; /* working wad filename */
extern char iwad[60]; /* path to doom.wad */
extern int thing_types[96]; /* types of all known things */
extern char far *thing_names[96]; /* descriptions of thing types */
extern int thing_shapes[96]; /* shape to draw for this thing */
extern int linetypes[133];
extern char far *linetype_names[133];
extern int adjvx[2000], adjvy[2000]; /* adjusted vertexes (screen coord) */
extern int ll_size, llines[2000]; /* local lines (ones on the screen) */
extern int far *mthings; /* marked thing list */
extern int far *mvertexes; /* marked vertex list */
extern int far *mlinedefs; /* marked linedef list */
extern int far *msidedefs; /* marked sidedef list */
extern int far *msectors; /* marked sector list */
extern char *point_ptr[5]; /* pointer to point size images */
extern uint no_shapes, *shp_offsets; /* offset into shapes[] of shapes */
extern char far *shapes; /* shape image data memory block */
extern int lthing_count, *lthing_num; /* local things indexes */
extern int *lthingx, *lthingy; /* local things screen coords */
extern uint *lthing_offsets; /* local things shape table offsets */
extern int far llist[LL_MAX];
extern char *subfiles[10];
extern int scalers[];

extern struct { /* small radio button struct */
	int num;
	struct {
		int x;
		int y;
		int on;
		int status;
	} pos[30];
} far b;

extern struct { /* window struct */
	int top;
	int bottom;
	int left;
	int right;
	int bars;
	int okbar;
	int canbar;
} win;

extern struct { /* big button struct */
	int num;
	struct {
		int x1;
		int x2;
		int y;
	} pos[2];
} bigb;

extern struct t_struct {
	int x;
	int y;
	int angle;
	int type;
	int flags;
} huge *things;

extern struct l_struct {
	int v1;
	int v2;
	uint attrib;
	int type;
	int trig;
	int sd1;
	int sd2;
} huge *linedefs;

extern struct s_struct {
	int xoffset;
	int yoffset;
	char top[8];
	char bottom[8];
	char middle[8];
	int sector;
} huge *sidedefs;

extern struct v_struct {
	int x;
	int y;
} huge *vertexes;

extern struct seg_struct {
	int v1;
	int v2;
	uint angle;
	int linedef;
	int dir;
	int dist;
} huge *segs;

extern struct ss_struct {
	int size;
	int segptr;
} huge *ssectors;

extern struct n_struct {
	int x;
	int y;
	int dx;
	int dy;
	struct {
		int y1;
		int y2;
		int x1;
		int x2;
	} node1;
	struct {
		int y1;
		int y2;
		int x1;
		int x2;
	} node2;
	uint link1;
	uint link2;
} huge *nodes;

extern struct sec_struct {
	int floor;
	int ceiling;
	char floor_name[8];
	char ceiling_name[8];
	int light;
	int type;
	int trig;
} huge *sectors;

extern char huge *reject;

extern struct {
	int xorigin;
	int yorigin;
	int xsize;
	int ysize;
	int offsets[9];
} huge *blockmap;
