/*
	This is a DMapEdit source code module.  Though it is copyrighted, you
	may modify it and use it for your own personal use, meaning that new
	modified code and anything derived from it (such as exe files) doesn't
	get distributed to anyone, unless you get my permission first.  Code
	from this file, or code based on ideas from this file may be used with
	other programs, provided that you give credit for it in the source code,
	documentation, and 'about' windows or screens, if one exists, for the
	programs using it.  Giving credit means something like this:

	Code from DMapEdit was used in this program

							  or

	Some code for this program was based on ideas presented in DMapEdit

	Whatever.  Just be sure to mention "DMapEdit" in such a way that it's
	self-evident how it was useful to the new program, and be sure to have
	"DMapEdit is a trademark of Jason Hoffoss" in the docs.  That's all..
*/

#include <stdio.h>
#include <graphics.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "dme.h"
#include "dme2.h"

int test_ssec=0;

void block_test(void)
{
	int offset, line1, num, x, y;
	int x1, y1, v2, v3, v4;

	x = (re_x() - blockmap->xorigin) / 128;
	y = (re_y() - blockmap->yorigin) / 128;
	if (x < 0 || x >= blockmap->xsize || y < 0 || y >= blockmap->ysize)
		return;
	num = y * blockmap->xsize + x;
	offset = blockmap->offsets[num] - 4;
	if (blockmap->offsets[offset++])
	{
		error("non-zero error");
		return;
	}
	while ((line1 = blockmap->offsets[offset++]) != -1)
	{
		setcolor(255);
		draw_line(line1, SOLID_LINE);
		setcolor(0);
		draw_line(line1, DOTTED_LINE);
	}
	return;
}

int seg_test(void)
{
	char msg[1024], msg2[256];
	int i, start, end, key, n_count, v1, v2, x1, x2, y1, y2;

	if (test_ssec >= ss_size)
		test_ssec = 0;
	while (1)
	{
		draw_ssec(test_ssec);
		sprintf(msg, "SSec #%d: (%d segs)", test_ssec,
			ssectors[test_ssec].size);
		start = ssectors[test_ssec].segptr;
		end = start + ssectors[test_ssec].size;
		for (i=start; i<end; i++)
		{
			sprintf(msg2, " {%u, %d}", segs[i].angle, segs[i].dist);
			strcat(msg, msg2);
		}

		toptext(msg);
		key = getkey();
		if (key == ',') {
			if (test_ssec-- == 0)
				test_ssec = ss_size-1;
		} else if (key == '.') {
			if (++test_ssec == ss_size)
				test_ssec = 0;
		} else if (key == 't') {
			i = start;
			while (!kbhit())
			{
				v1 = segs[i].v1;
				v2 = segs[i].v2;
				x1 = adjustx(vertexes[v1].x);
				x2 = adjustx(vertexes[v2].x);
				y1 = adjusty(vertexes[v1].y);
				y2 = adjusty(vertexes[v2].y);

				setcolor(96);
				if (line_in_rect(x1, y1, x2, y2, 0, 0, maxx, maxy))
					line(win.left, win.top, win.right, win.bottom);

				delay(500);
				draw_ssec(test_ssec);
				if (i++ == end - 1)
					i = start;
			}
			getch();
		} else return key;
		draw_map();
	}
}

int node_test(void)
{
	char msg[1024];
	int i, key, x1, y1, x2, y2, left_nodes, right_nodes, left_ss, right_ss;

	if (test_node >= n_size)
		test_node = 0;
	while (1)
	{
		left_ss = right_ss = left_nodes = right_nodes = 0;
		draw_node(test_node, &left_nodes, &right_nodes, &left_ss, &right_ss, 1);
		setlinestyle(SOLID_LINE, 0, 3);
		setcolor(60);
		x1 = nodes[test_node].x;
		y1 = nodes[test_node].y;
		x2 = x1 + nodes[test_node].dx;
		y2 = y1 + nodes[test_node].dy;
		draw_side(x1, y1, x2, y2);
		setlinestyle(SOLID_LINE, 0, 1);

		sprintf(msg, "Node #%d Contains: %d Sub Sectors, %d Recursed Nodes",
			test_node, left_ss + right_ss, left_nodes + right_nodes);
		toptext(msg);
		key = getkey();
		if (key == ',')
		{
			if (test_node-- == 0)
				test_node = n_size-1;
		} else if (key == '.')
		{
			if (++test_node == n_size)
				test_node = 0;
		} else return key;
		draw_map();
	}
}

int node_test2(void)
{
	char msg[1024], msg2[80];
	int i, key, x1, y1, x2, y2, left_nodes, right_nodes, left_ss, right_ss;
	uint link;
	struct n_struct node;

	while (1)
	{
		left_ss = right_ss = 0;
		left_nodes = right_nodes = -1;
		draw_node(test_node, &left_nodes, &right_nodes, &left_ss, &right_ss, 0);
		setlinestyle(SOLID_LINE, 0, 3);
		setcolor(60);
		x1 = nodes[test_node].x;
		y1 = nodes[test_node].y;
		x2 = x1 + nodes[test_node].dx;
		y2 = y1 + nodes[test_node].dy;
		draw_side(x1, y1, x2, y2);
		setlinestyle(SOLID_LINE, 0, 1);

		if ((link = nodes[test_node].link1) < 32768)
			sprintf(msg, "Node #%d Contains: Right: Node #%u (%d more), "
				"%d Sub Sectors", test_node, link, right_nodes, right_ss);
		else
			sprintf(msg, "Node #%d Contains: Right: Sub Sector #%u",
				test_node, link - 32768);
		if ((link = nodes[test_node].link2) < 32768)
			sprintf(msg2, "Left: Node #%u (%d more), %d Sub Sectors",
				link, left_nodes, left_ss);
		else
			sprintf(msg2, "Left: Sub Sector #%u", link - 32768);
		toptext2(msg, msg2);
		key = getkey();
		if (key == ',')
			link = nodes[test_node].link2;
		else if (key == '.')
			link = nodes[test_node].link1;
		else if (key == '[')
		{
			if (test_node-- == 0)
				test_node = n_size-1;
		} else if (key == ']')
		{
			if (++test_node == n_size)
				test_node = 0;
		} else if (key == '=')
		{
			node = nodes[test_node];
			nodes[test_node].node1.x1 = node.node2.x1;
			nodes[test_node].node1.y1 = node.node2.y1;
			nodes[test_node].node1.x2 = node.node2.x2;
			nodes[test_node].node1.y2 = node.node2.y2;
			nodes[test_node].node2.x1 = node.node1.x1;
			nodes[test_node].node2.y1 = node.node1.y1;
			nodes[test_node].node2.x2 = node.node1.x2;
			nodes[test_node].node2.y2 = node.node1.y2;
			nodes[test_node].link1 = node.link2;
			nodes[test_node].link2 = node.link1;
			nodes[test_node].x = node.x + node.dx;
			nodes[test_node].y = node.y + node.dy;
			nodes[test_node].dx = -node.dx;
			nodes[test_node].dy = -node.dy;
			continue;
		}
		else return key;

		draw_map();

		if (link < 32768)
			test_node = link;
		else {
			test_ssec = link - 32768;
			edit_mode = 100; /* display ssector now */
			return 0;
		}
	}
}

void draw_node(int node, int *ln, int *rn, int *lss, int *rss, int recurse)
{
	int x1, y1, x2, y2, rr, ln1, rn1, lss1, rss1;
	uint link;

	if (recurse >= 0)
	{
		setlinestyle(DOTTED_LINE, 0, 3);
		setcolor(96);
		x1 = nodes[node].node1.x1;
		y1 = nodes[node].node1.y1;
		x2 = nodes[node].node1.x2;
		y2 = nodes[node].node1.y2;
		rectangle(adjustx(x1), adjusty(y1), adjustx(x2), adjusty(y2));
		setcolor(32);
		x1 = nodes[node].node2.x1;
		y1 = nodes[node].node2.y1;
		x2 = nodes[node].node2.x2;
		y2 = nodes[node].node2.y2;
		rectangle(adjustx(x1), adjusty(y1), adjustx(x2), adjusty(y2));
	}
	rr = 1;
	if (recurse < 1)
		rr = -1;

	if ((link = nodes[node].link1) > 32767)
	{
		if (recurse > 0)
			draw_ssec(link - 32768);
		(*rss)++;
	} else {
		ln1 = rn1 = lss1 = rss1 = 0;
		draw_node(link, &ln1, &rn1, &lss1, &rss1, rr);
		(*rn) += ln1 + rn1 + 1;
		(*rss) += lss1 + rss1;
	}
	if ((link = nodes[node].link2) > 32767)
	{
		if (recurse > 0)
			draw_ssec(link - 32768);
		(*lss)++;
	} else {
		ln1 = rn1 = lss1 = rss1 = 0;
		draw_node(link, &ln1, &rn1, &lss1, &rss1, rr);
		(*ln) += ln1 + rn1 + 1;
		(*lss) += lss1 + rss1;
	}
	return;
}

void draw_ssec(int ssec)
{
	int i, start, end, x1, y1, x2, y2, point1, point2;

	setlinestyle(DOTTED_LINE, 0, 3);
	setcolor(253);
	for (i=0; i<n_size; i++)
	{
		if (nodes[i].link1 == ssec + 32768)
		{
			x1 = nodes[i].node1.x1;
			y1 = nodes[i].node1.y1;
			x2 = nodes[i].node1.x2;
			y2 = nodes[i].node1.y2;
			break;
		}
		if (nodes[i].link2 == ssec + 32768)
		{
			x1 = nodes[i].node2.x1;
			y1 = nodes[i].node2.y1;
			x2 = nodes[i].node2.x2;
			y2 = nodes[i].node2.y2;
			break;
		}
	}
	rectangle(adjustx(x1), adjusty(y1), adjustx(x2), adjusty(y2));

	setlinestyle(SOLID_LINE, 0, 3);
	start = ssectors[ssec].segptr;
	end = start + ssectors[ssec].size;
	for (i=start; i<end; i++)
	{
		point1 = segs[i].v1;
		point2 = segs[i].v2;
		x1 = adjustx(vertexes[point1].x);
		x2 = adjustx(vertexes[point2].x);
		y1 = adjusty(vertexes[point1].y);
		y2 = adjusty(vertexes[point2].y);

		if (segs[i].dir)
			setcolor(254);
		else
			setcolor(255);

		if (line_in_rect(x1, y1, x2, y2, 0, 0, maxx, maxy))
		{
			line(win.left, win.top, win.right, win.bottom);
			if (points)
			{
				draw_seg_vertex(point1, 96);
				draw_seg_vertex(point2, 32);
			}
		}
	}
	setlinestyle(SOLID_LINE, 0, 1);
	return;
}

void draw_seg_vertex(int num, int color)
{
	char image[125];
	int i, x, y;

	x = adjustx(vertexes[num].x);
	y = adjusty(vertexes[num].y);

	if (x < points ||
		 y < points ||
		 x > maxx - (points * 2) ||
		 y > maxy - (points * 2)) return;

	getimage(x-points, y-points, x+points, y+points, image);
	for (i=4; i<125; i++)
		if (point_ptr[points-1][i])
			image[i] = color;
	putimage(x-points, y-points, image, 0);
	return;
}

void color2wall(int line, int col1, int col2)
{
	setcolor(col1);
	draw_line(line, SOLID_LINE);
	setcolor(col2);
	draw_line(line, DOTTED_LINE);
	return;
}

void test_draw_sector(int line, int sector)
{
	int sec1, sec2;

	if ((sec1 = linedefs[line].sd1) != -1)
		sec1 = sidedefs[sec1].sector;
	if ((sec2 = linedefs[line].sd2) != -1)
		sec2 = sidedefs[sec2].sector;
	if (sec1 == sector || sec2 == sector)
		draw_line(line, SOLID_LINE);
	return;
}
