#include <sys/types.h>
#include <termios.h>
#include <errno.h>
#include <strings.h>
#include <sys/stat.h>

char prog[256] = "/usr/local/libexec/";

int main(ac, av)
char *av[];
{
  unsigned char ci[128], co[128], cc[256];
  pid_t pid;
  int status, c;
  char *p;
  struct stat st;

  for (c=0; c<256; c++) cc[c] = c;

  p = strrchr(av[0], '/');
  if (p) p++;
  else p = av[0];
  strcat(prog, p);

  if (fstat(0, &st)) {
	perror("Terminal permission fetching failed");
	exit(errno);
  }
  fchmod(0, 0600);

  if (ioctl(0, TIOCGIMAP, ci) < 0 || ioctl(0, TIOCGOMAP, co) < 0) {
	perror("Fetch of translation tables failed");
	exit(errno);
  }
  if (ioctl(0, TIOCSIMAP, &cc[128]) < 0 || ioctl(0, TIOCSOMAP, &cc[128]) < 0) {
	perror("Reset of translation tables failed");
	exit(errno);
  }
  pid = vfork();
  switch(pid) {
  case -1:
	perror("Child creating failed");
	goto done;
  case 0:
	execv(prog, av);
	perror(prog);
	exit(errno);
  }
  wait(&status);
 done:
  if (ioctl(0, TIOCSIMAP, ci) < 0 || ioctl(0, TIOCSOMAP, co) < 0) {
	perror("Store of translation tables failed");
	exit(errno);
  }
  fchmod(0, st.st_mode & 0777);
  return 0;
}
