#ifndef LINT
static char genericid[]="@(#) generic.c 2.2 88/01/24 12:44:03";
#endif /* LINT */

/* 
Generic template for machine-dependent functions.

The contents of this file are hereby released to the public domain

											-- Rahul Dhesi 1988/01/24

Functions in this file have not yet been revised to work with zoo 
version 2.0.  To port zoo to a new system, look in files sysv.c and bsd.c 
to see which system-dependent functions may be needed.
*/

/****************
function trunc() truncates a file.
*/

int trunc (handle)
int handle;
{
   /* code to truncate file goes here -- may be left empty */
}

/*****************
Function gettime() or getutime() gets the date and time of the file handle 
or filename supplied.  Date and time is in MSDOS format.
*/
#ifdef GETUTIME
getutime (fname, date, time)
char *fname;
#else
gettime (handle,date,time)
int handle;
#endif
unsigned *date, *time;
{
   *date = *time = 0; /* not yet implemented */
}

/*****************
Function settime() or setutime() sets the date and time of the file handle
or filename supplied.  Date and time is in MSDOS format.
*/
#ifdef NIXTIME
int setutime(path,date,time)
char *path;
#else
int settime(handle, date, time)
int handle;
#endif
unsigned int date, time;
{
   /* not yet implemented */
}

/*****************
Function mktemp() accepts a template of the form `baseXXXXXX' where
base is an arbitrary string, and returns a unique temporary filename.
If template is not correct, it is returned unchanged.
*/
char *mktemp(template)
char *template;
{
#ifndef NDEBUG
   if (instr(template, "XXXXXX") == -1)
      prterror ('w', "Incorrect template [%s] supplied to mktemp().\n",
         template);
#endif

   strcpy(&template[instr(template, "XXXXXX")],"z.@@@");
   return (template);
}

/*****************
Function isadir() or isuadir() returns 1 if supplied handle or 
filename is a directory or other special file that should not be 
archived, else it returns 0.
*/

#ifdef CHEKDIR
int isadir(han)
int han;
{
   return (0); /* by default assume never a directory */
}
#endif

#ifdef CHEKUDIR
int isuadir(path)
char *path;
{
   return (0); /* by default assume never a directory */
}
#endif

/****************
Function fixfname() converts the supplied filename to a syntax
legal for the host system.  It is used during extraction to make sure
that a file can be extracted even if a badly-implemented archiver
stored it with an illegal filename.
*/

char *fixfname(fname)
char *fname;
{
   return (fname); /* default is no-op */
}

/*****************
Function nextfile() is effectively a no-op.  Any wildcard expansion 
must have been done before Zoo receives the arguments.
*/

#define FMAX 1
char *nextfile (what, filespec, fileset)
int what;                        /* whether to initialize or match      */
register char *filespec;         /* filespec to match if initializing   */
register int fileset;            /* which set of files                  */
{
   static int first_time [FMAX+1];
   static char saved_fspec [FMAX+1][PATHSIZE];  /* our own copy of filespec */

   if (what == 0) {
      strcpy (saved_fspec[fileset], filespec);  /* save the filespec */
      first_time[fileset] = 1;
      return (NULL);
   }

   if (first_time[fileset]) {
      first_time[fileset] = 0;
      return (saved_fspec[fileset]);
   } else {
      return (NULL);
   }
}
