/* @(#) assert.h 2.1 87/12/25 12:21:32 */

/*
The contents of this file are hereby released to the public domain.

                           -- Rahul Dhesi 1986/11/14

Defines a macro assert() that causes an assertion error if the assertion
fails.  For some useful information about this see "Reliable Data
Structures in C" by Thomas Plum page 1-21.

Conditional compilation:

   If NDEBUG is defined then
      assert() is defined as null so all assertions vanish
   else
      if DUMB_ASS is defined then   
-- use dumb assertions
         assertions print a message but not the filename and line number
      else
         assertions print message including filename and line number
      endif
   endif

Note:
   DUMB_ASS should be defined if the preprocessor does not support the 
   varying constants __FILE__ and __LINE__, which are supposed to hold the 
   name of the current file and the number of the current line.

*/

#ifndef NDEBUG
/* assert() macro defined only if NDEBUG is undefined */
#ifdef DUMB_ASS
#define assert(E) \
   { if (!(E)) \
      prterror ('w', "Assertion error.\n"); \
   }
#else
/* else not DUMB_ASS */
#define assert(E) \
   { if (!(E)) \
      prterror ('w',"Assertion error in %s:%d.\n", __FILE__, __LINE__); \
   }
#endif /* not DUMB_ASS */
#else
/* else NDEBUG */
#define assert(E)
#endif /* NDEBUG */
