// UUDECODE - a Win32 utility to uudecode single files.

// Copyright (C) 1998 Clem Dye

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Modified 13 July 2001 by Clem Dye to allow any character in the range 0 to 
// 7 in the 'begin' statement within the header of the uuencoded file being 
// decoded.


#include <stdio.h>
#include <string.h>
#define DEC(c)  (((c) - ' ') & 077)
static char outname[200];
int ReadDataLine(FILE *f,char *buf)
{
        int c,i;

        i=0;
        while ((c=fgetc(f)) != EOF) {
                if (c == '\n') break;
                if (c != '\r') {
                        buf[i++] = c;
                }
        }
        buf[i] = 0;
        return(c == EOF ? 0 : 1);
}

static char *uudecode (FILE *f)
{
  register int n;
  register char ch, *p;
  char buf[2 * BUFSIZ];
  FILE *out;

  do {
          if (!ReadDataLine(f,buf)) return(NULL);
  }
  while (strncmp(buf,"begin",5));
  p = buf + 6;


  while(*p && (strchr(" 01234567",*p))) p++;
  //while (*p && (*p == ' '|| *p == '0' || *p == '6')) p++; // Clem Dye, 13 July 2001.
  strcpy(outname,p);
  /* Create output file and set mode.  */ 
  out = fopen(outname,"wb");
  /* For each input line:  */
  while (1)
    {
        if (!ReadDataLine(f,buf)) break;
        if (!strncmp(buf,"end\r\n",5)) break;
          p = buf;

      /* N is used to avoid writing out all the characters at the end of the file.  */

      n = DEC (*p);
      if (n <= 0)
        break;
      for (++p; n > 0; p += 4, n -= 3)
        {
          if (n >= 3)
            {
              ch = DEC (p[0]) << 2 | DEC (p[1]) >> 4; 
              fputc(ch,out);
              ch = DEC (p[1]) << 4 | DEC (p[2]) >> 2; 
              fputc (ch,out);
              ch = DEC (p[2]) << 6 | DEC (p[3]);
              fputc (ch,out);
            }
          else
            {
              if (n >= 1)
                {
                  ch = DEC (p[0]) << 2 | DEC (p[1]) >> 4; 
                  fputc (ch,out);
                }
              if (n >= 2)
                {
                  ch = DEC (p[1]) << 4 | DEC (p[2]) >> 2; 
                  fputc (ch,out);
                }
            }
        }
    }

  fclose(out);
  return outname;
}

int main(int argc,char *argv[])
{
        FILE *f;

        if (argc <= 1) {
                printf("Usage: %s <input file>\n",argv[0]); 
                return(1);
        }
        f = fopen(argv[1],"rb");
        if (f == NULL) {
                printf("I can't find %s\n",argv[1]); 
                return(1);
        }
        uudecode(f);
        fclose(f);
        printf("Result decoded in %s\n",outname); 
        return(0);
}
