/*
 * Uud -- decode a uuencoded file back to binary form.
 *
 * From the Berkeley original, modified by MSD, RDR, JPHD & WLS.
 * The Atari ST version compiled with MWC.
 * this version is made: 06 Aug 1987.
 */

#include <stdio.h>

#ifdef ST
#include <osbind.h>
#define Error(n)  { Bconin(2); exit(n); }
#define WRITE     "wb"
#else
#define Error(n)  exit(n)
#define WRITE     "w"
int mode;
#endif

#define loop    while (1)

extern FILE *fopen();
extern char *strcpy();

char *getnword();

#define MAXCHAR 256
#define LINELEN 256
#define FILELEN 64
#define CODEDLN 61
#define NORMLEN 45

#define SEQMAX 'z'
#define SEQMIN 'a'
char seqc;
int first, check, numl;

FILE *in, *out;
char ifname[FILELEN];
int chtbl[MAXCHAR], cdlen[NORMLEN + 3];
char *pos;
char *filename;
char blank, part = '\0';
int partn = 'a', chap = 'a';
int lens;
int debug = 0, onedone = 0;

main(argc, argv) int argc; char *argv[];
{
        register int i, j;
        char dest[FILELEN], buf[LINELEN];

        if (argc < 2) {
                format("Almost foolproof uudecode v3.1 06-Aug-1987\n");
                format("Usage: uud [-d] inputfile\n");
                Error(1);
        }
        filename = argv[1];
        if ((filename[0] == '-') &&
            ((filename[1] == 'd') || (filename[1] == 'D'))) {
                debug = 1;
                if (argc != 3) {
                        format("Usage: uud [-d] inputfile\n");
                        Error(15);
                }
                filename = argv[2];
        }
        if((in = fopen(filename, "r")) == NULL) {
                format("Can't open %s\n", filename);
                Error(2);
        }
        numl = 0;
        strcpy(ifname, filename);

/*
 * Set up the default translation table.
 */
        for (i = 0; i < ' '; i++) chtbl[i] = -1;
        for (i = ' ', j = 0; i < ' ' + 64; i++, j++) chtbl[i] = j;
        for (i = ' ' + 64; i < MAXCHAR; i++) chtbl[i] = -1;
        chtbl['`'] = chtbl[' '];        /* common mutation */
        chtbl['~'] = chtbl['^'];        /* an other common mutation */
        blank = ' ';
/*
 * set up the line length table, to avoid lotsa * and / ...
 */
        cdlen[0] = 1;
        for (i = 1, j = 5; i <= NORMLEN; i += 3, j += 4)
                cdlen[i] = (cdlen[i + 1] = (cdlen[i + 2] = j));
/*
 * search for header or translation table line.
 */
        loop {  /* master loop for multiple decodes in one file */
                loop {
                        if (fgets(buf, sizeof buf, in) == NULL) {
                                if(onedone) {
                                        if (debug) format("End of file.\n");
                                        exit(0);
                                } else {
                                        format("No begin line.\n");
                                        Error(3);
                                }
                        }
                        numl++;
                        if (strncmp(buf, "table", 5) == 0) {
                                gettable();
                                continue;
                        }
                        if (strncmp(buf, "begin", 5) == 0) {
                                break;
                        }
                }
                lens = strlen(buf);
                if (lens) buf[--lens] = '\0';
#ifdef ST
                if ((pos = getnword(buf, 3))) {
                        strcpy(dest, pos);
                } else {
#else
                if(sscanf(buf,"begin%o%s", &mode, dest) != 2) {
#endif
                        format("Missing filename in begin line.\n");
                        Error(10);
                }
                if((out = fopen(dest, WRITE)) == NULL) {
                        format("Cannot open output file: %s\n", dest);
                        Error(4);
                }
                if (debug) format("Begin uudecoding: %s\n", dest);
                seqc = SEQMAX;
                check = 1;
                first = 1;
                decode();
                fclose(out);
#ifndef ST
                chmod(dest, mode);
#endif
                onedone = 1;
                if (debug) format("End uudecoding: %s\n", dest);
        }       /* master loop for multiple decodes in one file */
}
/*
 * Bring back a pointer to the start of the nth word.
 */
char *getnword(str, n) register char *str; register int n;
{
        while((*str == '\t') || (*str == ' ')) str++;
        if (! *str) return NULL;
        while(--n) {
                while ((*str != '\t') && (*str != ' ') && (*str)) str++;
                if (! *str) return NULL;
                while((*str == '\t') || (*str == ' ')) str++;
                if (! *str) return NULL;
        }
        return str;
}

/*
 * Install the table in memory for later use.
 */
gettable()
{
        char buf[LINELEN];
        register int c, n = 0;
        register char *cpt;

        for (c = 0; c <= MAXCHAR; c++) chtbl[c] = -1;

again:  if (fgets(buf, sizeof buf, in) == NULL) {
                format("EOF while in translation table.\n");
                Error(5);
        }
        numl++;
        if (strncmp(buf, "begin", 5) == 0) {
                format("Incomplete translation table.\n");
                Error(6);
        }
        cpt = buf + strlen(buf) - 1;
        *cpt = ' ';
        while (*(cpt) == ' ') {
                *cpt = 0;
                cpt--;
        }
        cpt = buf;
        while (c = *cpt) {
                if (chtbl[c] != -1) {
                        format("Duplicate char in translation table.\n");
                        Error(7);
                }
                if (n == 0) blank = c;
                chtbl[c] = n++;
                if (n >= 64) return;
                cpt++;
        }
        goto again;
}

/*
 * copy from in to out, decoding as you go along.
 */

decode()
{
        char buf[LINELEN], outl[LINELEN];
        register char *bp, *ut;
        register int *trtbl = chtbl;
        register int n, c, rlen;
        register unsigned int len;

        loop {
                if (fgets(buf, sizeof buf, in) == NULL) {
                        format("EOF before end.\n");
                        fclose(out);
                        Error(8);
                }
                numl++;
                len = strlen(buf);
                if (len) buf[--len] = '\0';
/*
 * Is it an unprotected empty line before the end line ?
 */
                if (len == 0) continue;
/*
 * Get the binary line length.
 */
                n = trtbl[*buf];
                if (n >= 0) goto decod;
/*
 * end of uuencoded file ?
 */
                if (strncmp(buf, "end", 3) == 0) return;
/*
 * end of current file ? : get next one.
 */
                if (strncmp(buf, "include", 7) == 0) {
                        getfile(buf);
                        continue;
                }
                format("Bad prefix line %d in file: %s\n",numl, ifname);
                if (debug) format("Bad line =%s\n",buf);
                Error(11);
/*
 * Sequence checking ?
 */
decod:          rlen = cdlen[n];
/*
 * Is it the empty line before the end line ?
 */
                if (n == 0) continue;
/*
 * Pad with blanks.
 */
                for (bp = &buf[c = len];
                        c < rlen; c++, bp++) *bp = blank;
/*
 * Verify if asked for.
 */
                if (debug) {
                        for (len = 0, bp = buf; len < rlen; len++) {
                                if (trtbl[*bp] < 0) {
                                        format(
        "Non uuencoded char <%c>, line %d in file: %s\n", *bp, numl, ifname);
                                        format("Bad line =%s\n",buf);
                                        Error(16);
                                }
                                bp++;
                        }
                }
                if (first) {
                        first = 0;
                        if (buf[rlen] != SEQMAX) {
                                check = 0;
                                if (debug) format("No sequence check.\n");
                        } else
                                if (debug) format("Sequence check on.\n");
                }
                if (check) {
                        if (buf[rlen] != seqc) {
                                format("Wrong sequence line %d in %s\n",
                                        numl, ifname);
                                if (debug)
                                        format(
        "Sequence char is <%c> instead of <%c>.\n", buf[rlen], seqc);
                                Error(18);
                        }
                        seqc--;
                        if (seqc < SEQMIN) seqc = SEQMAX;
                }
/*
 * output a group of 3 bytes (4 input characters).
 * the input chars are pointed to by p, they are to
 * be output to file f.n is used to tell us not to
 * output all of them at the end of the file.
 */
                ut = outl;
                len = n;
                bp = &buf[1];
                while (n > 0) {
                        *(ut++) = trtbl[*bp] << 2 | trtbl[bp[1]] >> 4;
                        n--;
                        if (n) {
                                *(ut++) = (trtbl[bp[1]] << 4) |
                                          (trtbl[bp[2]] >> 2);
                                n--;
                        }
                        if (n) {
                                *(ut++) = trtbl[bp[2]] << 6 | trtbl[bp[3]];
                                n--;
                        }
                        bp += 4;
                }
                n = fwrite(outl, 1, len, out);
        }
}

/*
 * you may need to rename the filenames at the ends of each part
 * if the encoder encoded them on directories and specified drives.
 */
getfile(buf) register char *buf;
{
        if ((pos = getnword(buf, 2)) == NULL) {
                format("Missing include file name.\n");
                Error(17);
        } else
                strcpy(ifname, pos);
#ifdef ST
        if (Fattrib(ifname, 0, 0) < 0) {
#else   /* } */
        if (access(ifname, 04)) {
#endif
                if (debug) {
                        format("Cant find: %s\n", ifname);
                        format("Continuing to read same file.\n");
                }
        }
        else {
                if (freopen(ifname, "r", in) == in) {
                        numl = 0;
                        if (debug) 
                                format("Reading next section from: %s\n", ifname);
                } else {
                        format("Freopen abort: %s\n", ifname);
                        Error(9);
                }
        }
        loop {
                if (fgets(buf, LINELEN, in) == NULL) {
                        format("No begin line after include: %s\n", ifname);
                        Error(12);
                }
                numl++;
                if (strncmp(buf, "table", 5) == 0) {
                        gettable();
                        continue;
                }
                if (strncmp(buf, "begin", 5) == 0) break;
        }
        lens = strlen(buf);
        if (lens) buf[--lens] = '\0';
/*
 * Check the part suffix.
 */
        if ((pos = getnword(buf, 3)) == NULL ) {
                format("Missing part name, in included file: %s\n", ifname);
                Error(13);
        } else {
                part = *pos;
                partn++;
                if (partn > 'z') partn = 'a';
                if (part != partn) {
                        format("Part suffix mismatch: <%c> instead of <%c>.\n",
                                part, partn);
                        Error(14);
                }
                if (debug) format("Reading part %c\n", *pos);
        }
}

/*
 * Printf style formatting.
 */
/* VARARGS1 */
format(fp, args) char *fp;
{
        doprnt(fp, (char *)&args);
}

doprnt(fp, ap)
register char   *fp;
register char   *ap;
{
        register int    c, k;
        register char   *s;

        while ((c = *fp++) != '\0') {
                if (c != '%')
                        outc(c);
                else {
                        c = *fp++;
                        switch (c) {
                        case 'd':
                                puti(*(int *)ap, 10);
                                ap += sizeof(int);
                                break;

                        case 's':
                                s = *(char **)ap;
                                while ((k = *s++) != '\0')
                                        outc(k);
                                ap += sizeof(char *);
                                break;

                        case 'c':
                                outc(*(int *)ap);
                                ap += sizeof(int);
                                break;

                        default:
                                outc(c);
                        }
                }
        }
}

/*
 * Put integer, in radix "r".
 */
puti(i, r)
register unsigned int   i;
register unsigned int   r;
{
        register unsigned int   q, s;

        if ((q = i / r) != 0)
                puti(q, r);
        s = i % r;
        if (s <= 9)
                outc(s + '0');
        else
                outc(s - 10 + 'A');
}
outc(c) register char c;
{
#ifdef ST
        if (c == '\n') Bconout(2, '\r');
        Bconout(2, c);
#else
        putchar(c);
#endif
}
