/*
 * %W% %E% %U% ncoast!bsa %Z%
 * %Z% Copyright (C) 1986 by Brandon S. Allbery, All Rights Reserved %Z%
 */

#ifndef lint
static char _SccsId[] = "%W% %E% %U% ncoast!bsa %Z%";
static char _CopyRt[] = "%Z% Copyright (C) 1985 by Brandon S. Allbery %Z%";
#endif  lint

#include <stdio.h>
#include <pwd.h>

struct passwd *getpwuid();

#ifdef SYS3
#define TTYLIST "/etc/inittab"
#else
#define TTYLIST	"/etc/ttys"
#endif

main(argc, argv)
char **argv;
{
	FILE *tfp;
	int cnt, flg;
	char line[1024];
#ifdef SYS3
	int state;
	char tty[18];
	char mode[20];
#endif

	if ((tfp = fopen(TTYLIST, "r")) == NULL)
	{
		fprintf(stderr, "%s: can't open %s\n", argv[0], TTYLIST);
		exit(1);
	}
	flg = 0;
	while (fgets(line, 1024, tfp) != NULL)
	{
		line[strlen(line) - 1] = '\0';	/* kill trailing newline */
#ifdef SYS3
		sscanf(line, "%d:%[^:]:%[^:]:", &state, tty, mode);
		if (strcmp(tty, "co") == 0)
			strcpy(tty, "console");
		else
			sprintf(tty, "tty%d", atoi(tty));	/* I hope!!! */
			/* The above will be a parameter. */
		if ((state != 2 && state != 7) || strchr(mode, 'o') != 0)
			continue;	/* disabled tty */
#else  SYS3
		if (line[0] == '0')		/* disabled tty */
			continue;
#endif SYS3
		if (argc > 1)			/* list specific ttys */
		{
			for (cnt = 1; cnt < argc; cnt++)
#ifdef SYS3
				if (strcpy(argv[cnt], tty) == 0)
#else  SYS3
					if (strcmp(argv[cnt], &line[2]) == 0)
#endif SYS3
					{
#ifdef SYS3
						showme(tty);
#else  SYS3
						showme(&line[2]);
#endif SYS3
						flg++;
					}
		}
		else				/* list all enabled ttys */
#ifdef SYS3
			showme(tty);
#else  SYS3
			showme(&line[2]);
#endif SYS3
	}
	fclose(tfp);
	if (argc > 1 && flg != argc - 1)
	{
		fprintf(stderr, "%s: bad tty name(s)\n", argv[0]);
		exit(1);
	}
	exit(0);
}

showme(ttyf)
char *ttyf;
{
	FILE *fp;
	char line[1024];

	sprintf(line, "%s/%s", getpwuid(geteuid())->pw_dir, ttyf);
	if ((fp = fopen(line, "r")) == NULL)	/* not in use on this tty */
		return;
	fgets(line, 1024, fp);
	printf("%s: %s", ttyf, line);		/* line already has newline */
	fclose(fp);
}
