
#define TRUE -1
#define FALSE 0

/*#include <stdlib.h>*/
#include <stdio.h>
#include <sys/types.h>
FILE *input_file;     /*-* File to read from                              *-*/

char *program_name;   /*-* the name of the program. (Usually 'sect')      *-*/
int start_line=0;     /*-* Line to start cutting at                       *-*/
int end_line=0;       /*-* Line to end cutting at                         *-*/
int from_stdin=FALSE; /*-* Is data from stdin rather then a file?         *-*/
int invert=FALSE;     /*-* Invert selection?                              *-*/
int quiet=FALSE;      /*-* Supress error messages                         *-*/
int current_line=1;   /*-* Counter: Keeps track of the current line       *-*/
int current_char=0;   /*-* Holds the value for the character being read   *-*/

main (argc,argv)
int argc;
 char *argv[]; {
  program_name = argv[0]; /*-* store program name for later use *-*/


/****** Process Command-Line options ******/
while ( (argc > 1) && (argv[1][0] == '-') && (argv[1][1] != NULL) ) {
  switch (argv[1][1]) {  

    case 'q':
      quiet=TRUE;
      break;

    case 'v':   /*-* Invert Option                 *-*/
      invert = TRUE;
      break;

    case 's':   /*-* Start line                    *-*/
      start_line = atoi (&argv[1][2]);
      if ( start_line < 1 ) {
	if (quiet == FALSE) {
	  printf ("ERROR: starting line must be greater than 0.\n");
	}
	usage();
      }
      break;

    case 'e':  /*-* End Line                       *-*/
      end_line = atoi (&argv[1][2]);
      if ( end_line < start_line ) {
	if (quiet == FALSE) {
	  printf ("ERROR: end line must come after start line.\n");
	}
	usage();
      }       
      break;

    case 'l':
      if ( end_line == 0 ) {
	end_line = (start_line + atoi (&argv[1][2]) ) - 1;
	if ( end_line < 1 ) {
	  if (quiet == FALSE) {
	    printf ("ERROR: number of lines must be greater than 0.\n");
	  }
	  usage();
	} 
      }
      break;

    default:    /*-* Invalid Option                *-*/
      if (quiet == FALSE) printf ("Illegal option -- %c\n",argv[1][1]);
      usage (); /*-* Explain correct usage of sect *-*/
  }
argc--;
argv++;
}

/****** Check to make sure all required parameters were specified     ******/
if ( (start_line < 1) || (end_line < 1 ) ) usage ();

/****** Determine if input should be read from a file or from stdin.  ******/
/****** If needed, open a file handle (input_file).                   ******/
if ( (argc > 1) && (strcmp ("-",argv[1]) ) ) {
  input_file = fopen (argv[1], "r");
  from_stdin = FALSE;
  if ( input_file == NULL ) {
    if (quiet == FALSE) printf ("ERROR: Cannot open input file (%s)\n",argv[1]);
    usage ();
  }
} else {
  from_stdin = TRUE;
}

/****** Main Loop                                                     ******/
while (1) {
  current_char = input_next_char ();     /*-* Input char *-*/
  if ( current_char == EOF ) break;
  if ( invert == TRUE) {          /*-* Determine if char should be printed *-*/
    if ( (current_line > end_line) || (current_line < start_line) ) print_char();
  } else {
    if ( (current_line <= end_line) && (current_line >= start_line) ) print_char();
  }
  if ( current_char == '\n' ) current_line++;  /*-* Increment line counter *-*/
}

return (0);
}

int print_char ()
 {
      printf ("%c",current_char);
}

int input_next_char()
 {
  if ( from_stdin == TRUE ) {
    return (getchar());
  } else {
    return (fgetc(input_file));
  }
}

int usage ()
 {
  if (quiet == FALSE) {
    printf ("Usage: %s [-q] [-v] -s# [-e# | -l#] [file]\n", program_name);
  }
  exit(1);
}
  
