
#       Onyx - System III - Oct. 1982

#       "@(#)pac.mk     1.1"

#       pac.mk: Makefile for making all of games/pac.
#       This makefile installs the games in a subsidiary games and games/lib
#       directory.

#       Don't change SHELL, Y, N, or S under pain of death!
SHELL   = /bin/sh
Y       =
N       = exit 0;
S       = N="$N";

#       Product, i.e. c8002, sbz8002, m68000, or sbm68000
P       = c8002

#       CPU, i.e. z8000 or m68000
C       = z8000

#       Frozen directory (where ONICE node is)
F       = /onice/unix/$P

#       Thawed directory (where to put it when pulled from ONICE)
T       = /srccpy/$C

#       Install file system, i.e. "" for root, "/srccpy", etc.
I       =

#       Set to null for low level making of one file
O       = NOOP

#       Test directory
TESTDIR = .

#       Default CC flags (don't alter except on command line) -O for optomize
CFLAGS  = -O

#       Default LD flags (don't alter except on command line) -s for strip
LDFLAGS = -s

#       Operations to perform on NODES.  Defaults may be overriden
#       on command line.
PULL    = N
COMPILE = N
TEST    = N
INSTALL = N
CLEAN   = N
CLOBBER = N
PRINT   = N

#       LIBRARIES TO BE USED
LIBES   = -lm -lcurses -ltermcap

#       owner and group for files.
OWN     = games
GRP     = games

#       BUILD DIRECTORIES
GBLD    = ../games
GLIB    = $(GBLD)/lib

#DFLAGS =       -DBELL3.0 -DNODELAY
DFLAGS =        -DBELL3.0
CFILES =        pacman.c monster.c util.c
OFILES =        pacman.o monster.o util.o

#       Sub-trees/programs to operate on
NODES   = $(NODESG)

#       Nodes that are default made
#       NODESG are all default nodes
NODESG  = $(NODESGB) $(NODESGL)

#       NODESGB are all default nodes that are put into GBLD
NODESGB=\
        pac\
        $(NOOP)

#       NODESGL are all default nodes that are put into GLIB
NODESGL=\
        paclog\
        $(NOOP)

#       The parameters to pass down the tree
PASS    = P=$P C=$C F=$F T=$T I=$I TESTDIR=$(TESTDIR) \
          CFLAGS=$(CFLAGS) ASFLAGS=$(ASFLAGS) \
          LDFLAGS=$(LDFLAGS) YFLAGS=$(YFLAGS) LFLAGS=$(LFLAGS) \
          GFLAGS=$(GFLAGS) FRC=$(FRC) CC=$(CC) AS=$(AS) LD=$(LD)

all:    $(FRC)
        $(MAKE) -f pac.mk PULL=$(PULL) COMPILE=Y TEST=$(TEST) \
          INSTALL=$(INSTALL) CLEAN=$(CLEAN) CLOBBER=$(CLOBBER) \
          PRINT=$(PRINT) $(PASS) NODES='$(NODES)' NODES

global: $(FRC)
        $(MAKE) -f pac.mk PULL=Y COMPILE=Y TEST=$(TEST) INSTALL=Y \
          CLEAN=Y CLOBBER=Y PRINT=$(PRINT) $(PASS) NODES='$(NODES)' NODES

install: $(FRC)
        $(MAKE) -f pac.mk PULL=$(PULL) COMPILE=$(COMPILE) TEST=$(TEST) \
          INSTALL=Y CLEAN=$(CLEAN) CLOBBER=$(CLOBBER) \
          PRINT=$(PRINT) $(PASS) NODES='$(NODES)' NODES

NODES:  $(FRC) $(NODES)

#       Nodes that are default made (single .c, .sh, or .y) in $(GBLD)
$(NODESGB) NONEB:ALWAYS
        $S $$$(COMPILE) $(MAKE) -f pac.mk $@ $(PASS) NODESGB=NONE \
                          COMPILE=$(COMPILE) O=
        $S $$$(PRINT)   ;pr *.c *.h *.sh *.y | lpr
        $S $$$(TEST)    make -f pac.mk $@ $(PASS) NODESGB=NONE \
                          COMPILE=$(TEST) O= ; rtest $@
        $S $$$(INSTALL) make -f pac.mk $@ $(PASS) NODESGB=NONE \
                          COMPILE=$(INSTALL) O= ; /etc/install -f $(GBLD) \
                          -u $(OWN) -g $(GRP) -m 4755 $@
        $S $$$(CLEAN)   /bin/rm -f      *.o y.tab.c
        $S $$$(CLOBBER) /bin/rm -f      *.o y.tab.c $@

#       Nodes that are default made (single .c, .sh, or .y) in $(GLIB)
$(NODESGL) NONEL:ALWAYS
        $S $$$(COMPILE) $(MAKE) -f pac.mk $@ $(PASS) NODESGL=NONE \
                          COMPILE=$(COMPILE) O=
        $S $$$(PRINT)   ;pr *.c *.h *.sh *.y | lpr
        $S $$$(TEST)    make -f pac.mk $@ $(PASS) NODESGL=NONE \
                          COMPILE=$(TEST) O= ; rtest $@
        $S $$$(INSTALL) make -f pac.mk $@ $(PASS) NODESGL=NONE \
                          COMPILE=$(INSTALL) O= ; /etc/install -f $(GLIB) \
                          -u $(OWN) -g $(GRP) -m 644 $@
        $S $$$(CLEAN)   /bin/rm -f      *.o y.tab.c
        $S $$$(CLOBBER) /bin/rm -f      *.o y.tab.c $@

#       Our rule for making programs from single-file C program.
#       Note that THESE rules are quite different from MAKE's defaults.
.c:
        $S $$$(COMPILE) $(CC) $(CFLAGS) $(LDFLAGS) $< -o $@ $(LIBES)

#       Our rule for making programs from single-file shell script.
#       Note that our rules are quite different from MAKE's defaults.
.sh:
        $S $$$(COMPILE) cp $< $(TESTDIR)/$@ ; chmod 644 $(TESTDIR)/$@

#       Our rule for making programs from single-file yacc grammar.
#       Note that our rules are quite different from MAKE's defaults.
.y:
        $S $$$(COMPILE) $(YACC) $(YFLAGS) $< ; \
          $(CC) $(CFLAGS) $(LDFLAGS) y.tab.c -o $(TESTDIR)/$@ ; \
          /bin/rm -f y.tab.c y.tab.o

#       Nodes that are specially made
# $(NODESS):$(FRC)

FRC:

ALWAYS:

pac$O:  $(OFILES)
        $(CC) $(CFLAGS) $(LDFLAGS) -i -o pac $(OFILES) -ltermlib -lcurses

pacman.o:       pacman.c pacdefs.h
        $(CC) -c $(CFLAGS) $(DFLAGS) pacman.c

monster.o:      monster.c pacdefs.h
        $(CC) -c $(CFLAGS)  $(DFLAGS) monster.c

util.o: util.c pacdefs.h
        $(CC) -c $(CFLAGS)  $(DFLAGS) util.c

paclog$O:
        cat /dev/null >$@
