/*    SCCS Id: @(#)termcap.c    2.1    87/10/19
/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1985. */

#include <stdio.h>
#include <ctype.h>    /* for isdigit() */
#include "hack.h"     /* for ROWNO, COLNO, *HI, *HE */

#define xputc(c)    WindowPutchar(c)
#define xputs(s)    WindowFPuts(s)

extern char *getenv();
extern long *alloc();

static char HO[] = "\x9BH";         /* Home */
static char CL[] = "\x1Bc";         /* Clear */
static char CE[] = "\x9BK";         /* Erase end of line */
static char UP[] = "\x0B";          /* Cursor up */
static char CM[] = "\x9B%d;%dH";    /* used with function tgoto() */
static char ND[] = "\x9BC";         /* Cursor right */
static char XD[] = "\x9BB";         /* Cursor down */
static char BC[] = "\x08";          /* Cursor left */

#ifdef MSDOSCOLOR    /* creps@silver.bacs.indiana.edu */
static char SO[] = "\x9B33m";       /* Standout: Color #3 (red) */
static char SE[] = "\x9B0m";

#else

static char SO[] = "\x9B7m";        /* Inverse video */
static char SE[] = "\x9B0m";
#endif

char *CD = "\x9BJ"; /* char *CD; tested in pri.c: docorner() */

/* #if defined(DGK) || defined(SORTING) */
#ifdef DGK
# define XXX
#endif
#ifdef SORTING
# define XXX
#endif

#ifdef XXX
# ifdef MSDOSCOLOR
char *HI_OBJ = "\x9B31;42m";        /* White on Black */
char *HI_MON = "\x9B33;42m";        /* Orange on black */
char *HI = "\x9B1m";                /* Bold (hilight) */
char *HE = "\x9B0m";                /* Plain */
# else
char *HI_OBJ = "";
char *HI_MON = "";
char *HI = "\x9B4m";                /* Underline */
char *HE = "\x9B0m";                /* Plain */
# endif
#endif
#undef XXX

int CO = COLNO;
int LI = ROWNO; 	/* used in pri.c and whatis.c */

static char tgotobuf[20];
#define tgoto(fmt, x, y)    (sprintf(tgotobuf, fmt, y+1, x+1), tgotobuf)

startup()
{
    (void) Initialize();    /* This opens screen, window, console, &c */
}

start_screen()
{
}

end_screen()
{
    clear_screen();
}

/* Cursor movements */
extern xchar curx, cury;

#ifdef TERMCAP

curs(x, y)
register int x, y;    /* not xchar: perhaps xchar is unsigned and
	       curx-x would be unsigned as well */
{

    if (y == cury && x == curx)
	return;
    if(!ND && (curx != x || x <= 3)) {    /* Extremely primitive */
	cmov(x, y);            /* bunker!wtm */
	return;
    }
    if(abs(cury-y) <= 3 && abs(curx-x) <= 3)
	nocmov(x, y);
    else if((x <= 3 && abs(cury-y)<= 3) || (!CM && x<abs(curx-x))) {
	(void) putchar('\r');
	curx = 1;
	nocmov(x, y);
    } else if(!CM) {
	nocmov(x, y);
    } else
	cmov(x, y);
}

nocmov(x, y)
{
    if (cury > y) {
	if(UP) {
	    while (cury > y) {    /* Go up. */
		xputs(UP);
		cury--;
	    }
	} else if(CM) {
	    cmov(x, y);
	} else if(HO) {
	    home();
	    curs(x, y);
	} /* else impossible("..."); */
    } else if (cury < y) {
	if(XD) {
	    while(cury < y) {
		xputs(XD);
		cury++;
	    }
	} else if(CM) {
	    cmov(x, y);
	} else {
	    while(cury < y) {
		xputc('\n');
		curx = 1;
		cury++;
	    }
	}
    }
    if (curx < x) {        /* Go to the right. */
	if(!ND) cmov(x, y); else    /* bah */
	    /* should instead print what is there already */
	while (curx < x) {
	    xputs(ND);
	    curx++;
	}
    } else if (curx > x) {
	while (curx > x) {    /* Go to the left. */
	    xputs(BC);
	    curx--;
	}
    }
}

cmov(x, y)
register x, y;
{
    xputs(tgoto(CM, x-1, y-1));
    cury = y;
    curx = x;
}

#else /* !TERMCAP */

curs(x, y)
register x, y;
{
    if (x != curx || y != cury) {
	xputs(tgoto(CM, x-1, y-1));
	cury = y;
	curx = x;
    }
}
#endif /* TERMCAP */

#ifndef xputc
xputc(c) char c; {
    (void) putchar(c, stdout);
}
#endif

#ifndef xputs
xputs(s) char *s; {
    WindowFPuts(s);
}
#endif

cl_end() {
#ifdef TERMCAP
    if(CE)
	xputs(CE);
    else {    /* no-CE fix - free after Harold Rynes */
	/* this looks terrible, especially on a slow terminal
	   but is better than nothing */
	register cx = curx, cy = cury;

	while(curx < COLNO) {
	    xputc(' ');
	    curx++;
	}
	curs(cx, cy);
    }
#else
    xputs(CE);
#endif
}

clear_screen() {
    xputs(CL);
    home();
}

home()
{
#ifdef TERMCAP
    if(HO)
	xputs(HO);
    else if(CM)
	xputs(tgoto(CM, 0, 0));
    else
	curs(1, 1);    /* using UP ... */
#else
    xputs(HO);
#endif
    curx = cury = 1;
}

standoutbeg()
{
#ifdef TERMCAP
    if(SO)
#endif
	xputs(SO);
}

standoutend()
{
#ifdef TERMCAP
    if(SE)
#endif
	xputs(SE);
}

backsp()
{
    xputs(BC);
    curx--;
}

bell()
{
#ifdef DGKMOD
    if (flags.silent) return;
#endif /* DGKMOD /**/
    (void) putchar('\007');        /* curx does not change */
    (void) fflush(stdout);
}

delay_output() {
    /* delay 50 ms - could also use a 'nap'-system call */
    Delay(2L);
}

cl_eos()            /* free after Robert Viduya */
{		 /* must only be called with curx = 1 */
#ifdef TERMCAP
    if(CD)
	xputs(CD);
    else {
	register int cx = curx, cy = cury;
	while(cury <= LI-2) {
	    cl_end();
	    xputc('\n');
	    curx = 1;
	    cury++;
	}
	cl_end();
	curs(cx, cy);
    }
#else
    xputs(CD);
#endif
}

