/*
 *  amigaMenu.c     (C) Copyright 1988 by Olaf Seibert (KosmoSoft)
 *
 *  Originally by John Toebes.
 */

#define TEXT(nam,str) \
static struct IntuiText nam = {0,1,JAM2,0,0,NULL,(UBYTE *)str,NULL}

	/* Commands */
	TEXT(T_HELP,  "?   display help");
	TEXT(T_o,     "O   set options");
	TEXT(T_SHELL, "!   AMIGADOS commands");
	TEXT(T_v,     "v   version number");
	TEXT(T_CR,    "^R  redraw screen");
	TEXT(T_CP,    "^P  repeat last message");
	TEXT(T_Q,     "Q   quit game");
	TEXT(T_S,     "S   save the game");

	/* Inventory */
	TEXT(T_i,     "i   inventory");
	TEXT(T_p,     "p   pay your bill");
	TEXT(T_d,     "d   drop an object");
	TEXT(T_D,     "D   Drop several things");
	TEXT(T_COMMA, ",   Pickup an object");
	TEXT(T_SLASH, "/   identify something");
	TEXT(T_c,     "c   call class of objects");
	TEXT(T_C,     "C   Christen a monster");

	/* Actions */
	TEXT(T_a,     "a   apply/use something");
	TEXT(T_e,     "e   eat something");
	TEXT(T_q,     "q   quaff a potion");
	TEXT(T_r,     "r   read a scroll");
	TEXT(T_t,     "t   throw/shoot weapon");
	TEXT(T_z,     "z   zap a wand");

	/* Preparations */
	TEXT(T_w,     "w   wield a weapon");
	TEXT(T_P,     "P   Put on ring");
	TEXT(T_R,     "R   Remove ring");
	TEXT(T_T,     "T   Take off armor");
	TEXT(T_W,     "W   Wear armor");
	TEXT(T_WPN,   ")   current weapon");
	TEXT(T_ARMOR, "[   current armor");
	TEXT(T_RING,  "=   current rings");

	/* Movement */
	TEXT(T_E,     "E   Engrave msg on floor");
	TEXT(T_s,     "s   search");
	TEXT(T_UP,    "<   Go up stairs");
	TEXT(T_DOWN,  ">   Go down stairs");
	TEXT(T_WAIT,  ".   wait a moment");
	TEXT(T_CT,    "^T  Teleport");

#define IFLAGS ITEMENABLED|ITEMTEXT|HIGHCOMP
#define IDATA(cmd,str,off) 0,off,WDT,9,IFLAGS,0,(APTR)&str,NULL,cmd,NULL,NULL

/* Commands */

#undef	WDT
#define WDT 184

static struct MenuItem cmdsub[] = {
    { &cmdsub[1], IDATA('?', T_HELP,   0) }, /*   display help */
    { &cmdsub[2], IDATA('O', T_o,     10) }, /*   set options */
    { &cmdsub[3], IDATA('!', T_SHELL, 20) }, /*   AMIGADOS commands */
    { &cmdsub[4], IDATA('v', T_v,     30) }, /*   version number */
    { &cmdsub[5], IDATA(022, T_CR,    40) }, /*R  redraw screen */
    { &cmdsub[6], IDATA(024 ,T_CP,    50) }, /*P  repeat last message */
    { &cmdsub[7], IDATA('Q', T_Q,     60) }, /*   quit game */
    { NULL,	  IDATA('S', T_S,     70) }  /*   save the game */
};

/* Inventory */

#undef	WDT
#define WDT 200

static struct MenuItem invsub[] = {
    { &invsub[1], IDATA('i', T_i,      0) }, /*   inventory */
    { &invsub[2], IDATA('p', T_p,     10) }, /*   pay your bill */
    { &invsub[3], IDATA('d', T_d,     20) }, /*   drop an object */
    { &invsub[4], IDATA('D', T_D,     30) }, /*   Drop several things */
    { &invsub[5], IDATA(',', T_COMMA, 40) }, /*   Pickup an object */
    { &invsub[6], IDATA('/', T_SLASH, 50) }, /*   identify something */
    { &invsub[7], IDATA('c', T_c,     60) }, /*   call a class of objects */
    { NULL,	  IDATA('C', T_C,     70) }  /*   Christen a monster */
};

/* Actions */

#undef	WDT
#define WDT 184

static struct MenuItem actsub[] = {
    { &actsub[1], IDATA('a', T_a,     0) }, /*   apply/use something */
    { &actsub[2], IDATA('e', T_e,    10) }, /*   eat something */
    { &actsub[3], IDATA('q', T_q,    20) }, /*   quaff a potion */
    { &actsub[4], IDATA('r', T_r,    30) }, /*   read a scroll */
    { &actsub[5], IDATA('t', T_t,    40) }, /*   throw/shoot weapon */
    { NULL,	  IDATA('z', T_z,    50) }  /*   zap a wand */
};

/* Preparations */

#undef	WDT
#define WDT 144

static struct MenuItem armsub[] = {
    { &armsub[1], IDATA('w', T_w,      0) }, /*   wield a weapon */
    { &armsub[2], IDATA('P', T_P,     10) }, /*   Put on ring */
    { &armsub[3], IDATA('R', T_R,     20) }, /*   Remove ring */
    { &armsub[4], IDATA('T', T_T,     30) }, /*   Take off armor */
    { &armsub[5], IDATA('W', T_W,     40) }, /*   Wear armor */
    { &armsub[6], IDATA(')', T_WPN,   50) }, /*   current weapon */
    { &armsub[7], IDATA('[', T_ARMOR, 60) }, /*   current armor */
    { NULL,	  IDATA('=', T_RING,  70) }  /*   current rings */
};

/* Movement */

#undef	WDT
#define WDT 192

static struct MenuItem movsub[] = {
    { &movsub[1], IDATA('E', T_E,     0) }, /*   Engrave msg on floor */
    { &movsub[2], IDATA('s', T_s,    10) }, /*   search */
    { &movsub[3], IDATA('<', T_UP,   20) }, /*   Go up stairs */
    { &movsub[4], IDATA('>', T_DOWN, 30) }, /*   Go down stairs */
    { &movsub[5], IDATA('.', T_WAIT, 40) }, /*   wait a moment */
    { NULL,	  IDATA(024, T_CT,   50) }  /*T  Teleport */
};

/* Menustrip */

/* Width = #letters * 8 + 8 */

struct Menu HackMenu[] = {
   { &HackMenu[1], 10,0, 72,0,MENUENABLED,"Commands",     &cmdsub[0] }, /*8*/
   { &HackMenu[2], 82,0, 80,0,MENUENABLED,"Inventory",    &invsub[0] }, /*9*/
   { &HackMenu[3],162,0, 64,0,MENUENABLED,"Actions",      &actsub[0] }, /*7*/
   { &HackMenu[4],226,0,104,0,MENUENABLED,"Preparations", &armsub[0] }, /*12*/
   { NULL,	  330,0, 72,0,MENUENABLED,"Movement",     &movsub[0] }  /*8*/
};

