/*
    This program has only been run under Sun OS 4.1.  I make no guarantee
    that this program works on your system -- I haven't seen any problems,
    but you might want to look it over in any case.

                                 - Bill Heelan (wheelan@cs.mcgill.ca)


    Try to create a lock file, possibly trying some number of times.
    If successful return 0 (SUCCESS), otherwise return non-zero, the
    exact value depending on the particular error.

    Usage:

	lockit [-s <secs-to-sleep>] [-t <#-tries>] <lock-file-name>

    where <lock-file-name> is the name of the lock file to try to create.
    If it is not a fully specified path, then it will try to create it in
    the current directory.

    If '-t' is given with an integer value greater than 1, then 'lockit'
    will try to create the file that many times.  If '-t' is not specified
    the number of tries defaults to 1.

    '-s' specifies the number of seconds to sleep between tries (if the
    number of tries is greater than one).  Its default value is 1.
*/

#include <stdio.h>
/*#include <errno.h>*/
#include "stand.h"
#include <sys/file.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include <sys/conf.h>


/*
   Return codes.
*/


#define SUCCESS	    0
#define	F_ERROR	    1	/* open returned an error other than EEXISTS */
#define F_EXISTS    2	/* the final open returned EEXISTS */
#define	F_MISC	    3	/* any other reason it didn't work (e.g. bad arg) */

#define MASK	0660    /* octal file creation mask */

main( ac, av )
    int ac ;
    char *av[] ;
{
    extern char *tail() ;
    extern void usage() ;
    char *lock_file_name ;
    char prog[ 128 ] ;
    int fd ;
    int sleep_time ;
    int tries ;
    

    sleep_time = 1 ;
    tries = 1 ;
    lock_file_name = (char *)NULL ;
    
    strcpy( prog, tail( av[0] )) ;
    
    while( ++av, --ac )
    {
	if( av[0][0] != '-' )
	{
	    if( lock_file_name == (char *)NULL )
		lock_file_name = av[0] ;
	    else
	    {
		fprintf( stderr, "%s: a lock file name has already been specified.\n",
			 prog ) ;
		usage( prog ) ;
	    }
	}
	else
	{
	    switch( av[0][1] )
	    {
	    case 's':	/* number of seconds to sleep between tries */

		++av ;
		if( --ac > 0 )
		{
		    if( sscanf( av[0], "%d", &sleep_time ) != 1 )
		    {
			fprintf( stderr, "%s: -s requires numeric argument.\n",
				 prog ) ;
			usage( prog ) ;
		    }
		    else
		    {
			if( sleep_time < 0 )
			{
			    fprintf( stderr, "%s: argument to '-s' must be non-negative.\n",
				     prog ) ;
			    exit( F_MISC ) ;
			}
		    }
		}
		else
		{
		    fprintf( stderr, "%s: -s requires an argument.\n",
			     prog ) ;
		    usage( prog ) ;
		}

		break ;
		

	    case 't':	/* number of times to retry */

		++av ;
		if( --ac > 0 )
		{
		    if( sscanf( av[0], "%d", &tries ) != 1 )
		    {
			fprintf( stderr, "%s: -t requires numeric argument.\n",
				 prog ) ;
			usage( prog ) ;
		    }
		    else
		    {
			if( tries < 1 )
			{
			    fprintf( stderr, "%s: argument to '-t' must be greater than zero.\n",
				     prog ) ;
			    exit( F_MISC ) ;
			}
		    }
		}
		else
		{
		    fprintf( stderr, "%s: -t requires an argument.\n",
			     prog ) ;
		    usage( prog ) ;
		}

		break ;
		

	    default:

		fprintf( stderr, "%s: unknown option '%s'.\n", prog, av[0] ) ;
		usage( prog ) ;
	    }
	}
    }
    
    if( lock_file_name == (char *)NULL )
    {
	fprintf( stderr, "%s: a lock-file name must be specified.\n",
		 prog ) ;
	usage( prog ) ;
    }
    
    /*
        Try to exclusively create the lock file.  If requested, try a few
        times.
    */
    
    umask( 0 ) ;
    if(( fd = open( lock_file_name, O_CREAT | O_EXCL | O_WRONLY, MASK )) != -1 )
    {
	close( fd ) ;
	exit( SUCCESS ) ;
    }
    else
    {
	if( errno != EEXIST )
	{
	   perror( prog ) ;
	   fprintf( stderr, "%s: error trying to open lock file [%s].\n",
		    prog, lock_file_name ) ;
	   exit( F_ERROR ) ;
	}

	while( --tries )
	{
	    sleep((unsigned)sleep_time) ;

	    if(( fd = open( lock_file_name, O_CREAT | O_EXCL | O_WRONLY, MASK )) != -1 )
	    {
		close( fd ) ;
		exit( SUCCESS ) ;
	    }
	    else
	    {
		if( errno != EEXIST )
		{
		   perror( prog ) ;
		   fprintf( stderr, "%s: error trying to open lock file [%s].\n",
			    prog, lock_file_name ) ;
		   exit( F_ERROR ) ;
		}
	    }
	}
    }

    close( fd ) ;
    exit( F_EXISTS ) ;
}



char *tail( path )
    char *path ;
{
    char *p ;

    
    return (p = strrchr( path, '/' )) == (char *)NULL ? path : ++p ;
}



void usage( prog )
    char *prog ;
{
    fprintf( stderr, "Usage: %s [-t <#-tries>] [-s <secs-to-sleep>] <lock-file-name>\n",
	     prog ) ;
    exit( F_MISC ) ;
}
