/*
   I hold no responsibility nor do I accept credit for authenticity
   of source code.  I do ask that nothing be modified and then credit
   taken.
*/

/*
 * eek.c
 *
 * This UNIX C program takes any number of uuencoded files
 * from <stdin>, extracts the good stuff, and feeds
 * each file one at a time to uudecode.
 *
 * To compile, "cc -o eek eek.c" should suffice.
 *
 * For example, if you want to extract images from news:
 *
 * From within "rn" (readnews), once in the pictures group,
 * you can hit "=" (equals sign) to get a listing of the
 * headers.  Here's an example of a few lines of the output:
 *
   3219 Marilyn Monroe 2 of 3
   3220 Marilyn Monroe 1 of 3
   3221 Marilyn Monroe 3 of 3
   3223 .zip and .gl files
   3224 Vibrators.gif (1/3)
   3225 Vibrators.gif (2/3)
   3226 Vibrators.gif (3/3)
   3227 Cindy.gif (1/1)
   3228 Blair.gif (1/1)
 *
 * From the prompt, you can use the 's' command like this:
 *
     [rn prompt from within the group] 3220,3219,3221,3224-3228 s ims
 *
 * If this is the first set of images this run, it will ask if you
 * want mailbox format, to which "n" (no) is the best response, though
 * it shouldn't make much difference.
 *
 * This will send four pictures to the file "ims".  Notice that when
 * the parts aren't in order, you have to specify the numbers in the
 * proper order -- but it can still be done on one line (in one command).
 *
 * Once out of "rn", the command
 *
     eek < ims
 *
 * will extract the four images into the current directory, at which point
 * you probably want to remove "ims" so you can start fresh next time.
 *
 * It will break if someone has junk lines starting with "end" or "begin #".
 * Probably in other ways too.  But heh, it's free.  Whaddya want?  If you
 * improve upon it, please send me a copy so I can use it too.
 *
 * If you find it useful, drop me a note so I can feel all warm inside.
 *
 *  - Brandyn (brandyn@apple.com), 1/25/90
 */

#include <ctype.h>
#include <stdio.h>

main()
{
    FILE *uu;
    int num;

    for (num=0; ; num++) {
        printf("Extracting file %d...",num); fflush(stdout);
        uu  = popen("uudecode","w");
        if (CopyOne(stdin,uu))
            break;
        pclose(uu);
        printf("Done - file %s\n",uu);
    }

    printf("oops, no more.\n");
    pclose(uu);
}

/*
 * Throws the input stream <from> away until
 * it finds "begin ...", then copies
 * all uuencode type lines to <to> until
 * it finds "end ..." at which point it may
 * reintroduce the last one or two "rejected"
 * lines to account for uuencode's funny endings.
 *
 * Returns TRUE on EOF.
 */
CopyOne(from,to)
FILE *from,*to;
{
    int len;
    char buf[250];
    char a[250],b[250];
    char *res;

    while (res = fgets(buf,250,from))
        if (strncmp(buf,"begin ",6)==0 && isdigit(buf[6]))
            break;

    if (!res)
        return(1);

    printf("(%s)...",buf+6); fflush(stdout);
    fputs(buf,to);

    while (res = fgets(buf,250,from)) {

        if (!strncmp(buf,"end",3))
            break;

        len = strlen(buf);

        if (buf[0] != 'M' ||
            len < 60      ||
            len > 70      ||
            (strncmp(buf,"Message-ID",10)==0)) {
                /* fprintf(stderr,"Rejecting \"%s\"\n",buf); */
                strcpy(b,a);
                strcpy(a,buf);
                continue;
        }
        a[0] = '\0';
        b[0] = '\0';
        fputs(buf,to);
    }

    if (!res) {
        fprintf(stderr,
            "Warning: hit end of file without ever finding \"end\"\n");
        exit(0);
    }

    if (b[0]) {
        /* fprintf(stderr,"Restoring \"%s\"\n",b); */
        fputs(b,to);
    }

    if (a[0]) {
        /* fprintf(stderr,"Restoring \"%s\"\n",a); */
        fputs(a,to);
    }
    fputs(buf,to);

    return(0);
}

