/**********************************************************************
 
       Copyright (c) 1995 by the Trustees of Dartmouth College.

   Permission to use, copy, modify and distribute these programs and
   their  documentation  for  any  purpose and without fee is hereby
   granted, provided that this copyright notice and  permission  ap-
   pear on all copies and supporting documentation.  The name of the
   Trustees of Dartmouth College may not be used in  advertising  or
   publicity  relating  to  distribution  of  these programs without
   specific prior permission.  Neither  the  Trustees  of  Dartmouth
   College nor the author make representations about the suitability
   of this software for any purpose.  It is provided "as is" without
   expressed or implied warranty.

************************************************************************/
#include "menu.h"
/*****************************************************************************/
menu(file)
char file[];
{
	FILE *menufd;
	MENU *item;
	int recnum = 0, i;
	char line[MAXLINE];
	void parse(), display(), runprog();
	static int stat = 0; 	/* used to determine which is top menu */
	int select();

	stat++;
	/* open the menu file if it exists */
	if ((menufd = fopen(file,"r")) == NULL)
	{
		sprintf(command,"Unable to open menu %s",file);
		prtmsg(command,0);
		sleep(2);
		return;
	}

	/* count number of records in the menu file */
	while(fgetline(menufd,line,MAXLINE) != 0)
		recnum++;
	rewind(menufd);

	/* get enough memory to hold file dynamically */
	item = (MENU *)malloc(recnum*sizeof(MENU));

	for(i = 0; i < recnum; i++)  /* read file into malloc'd memory */
	{
		fgetline(menufd,line,MAXLINE);
		stripcrlf(line);
		parse(line,item+i);  /* parse the fields into structure */
	}

	do
	{
		display(item,recnum,stat);
	}
	while(select(item,recnum));
	free(item);
	stat--;
	return;
}
/*****************************************************************************/
void 
parse(line, item)
char line[];
MENU *item;
{
	char *loc;

	if((loc = strchr(line,':')) == NULL)
	  {
	    strcpy(item->desc,"---------------");
	    item->todo = 'E';
	    strcpy(item->object,"");
	    return;
	  }
	
	*loc = '\0';
	strcpy(item->desc,line);  /* get first string field */
	++loc;
	item->todo = *loc;        /* get second char field */
	loc += 2;
	strcpy(item->object,loc); /* get third string field */
}
/*****************************************************************************/
void 
display(item,num,stat)
MENU *item;
int num;
int stat;
{
	int i;

	clrworkarea();
	move(3,4);standout();
	printw("    %s    ",item->desc); /* menu title */
	standend();

	for(i = 1; i < num; i++)
	{
		move(i+4,4);
		if((item+i)->todo == '*')
			printw("[%c]  %s (unavailable)",i+0140,(item+i)->desc);
		else if((item+i)->todo == 'M' || (item+i)->todo == 'm')
			printw("[%c]  %s (menu)",i+0140,(item+i)->desc);
		else if((item+i)->todo == 'E')
			printw("  %s   ","--------------");
		else
			printw("[%c]  %s",i+0140,(item+i)->desc);
	}
	if (stat == 1)
	{
		mvaddstr(i+4,4, "[q]  Quit");
		prtmsg("Enter a letter or [q] to quit",0);
	}
	else
	{
		mvaddstr(i+4,4, "[q]  Return to previous menu");
		prtmsg("Enter a letter or [q] to return",0);
	}
	mvaddstr(i+6,2, "Select Value: ");                     
	move(i+6,16);                       
	refresh();
}
/*****************************************************************************/
int
select(item,num)
MENU *item;
int num;
{
	int c,i;
	c = getch();

	i = c - 0140;  /* turn ascii into number */
	if(i >= 1 && i < num)
	{
		switch((item+i)->todo)
		{
			case 'M':
			case 'm':
				menu((item+i)->object);
				break;
			case 'N':
			case 'n':
				runprog((item+i)->object,0);
				break;
			case 'P':
			case 'p':
				runprog((item+i)->object,1);
				break;
		}
	}
	else if (c == 'q' || c == 'Q')
		return 0;
	else
	{
		prtmsg("Invalid Entry, try again!",0);
		sleep(2);
		clrmsg(0);
	}
	return 1;
}
/*****************************************************************************/
void
runprog(program, pause)
char program[];
int pause;
{
	int c;

	clear();
	refresh();
	move(1,1);
	endwin();  /* kill curses */

	system(program); /* run the program */

	if(pause)
	{
		printf("\n\nPress [RETURN] to continue: ");
		c = getchar();
	}

	initscr(); /* restart curses */
	intro(VERSION);
	initinput();
}
/*****************************************************************************/
