/**********************************************************************
 
       Copyright (c) 1995 by the Trustees of Dartmouth College.

   Permission to use, copy, modify and distribute these programs and
   their  documentation  for  any  purpose and without fee is hereby
   granted, provided that this copyright notice and  permission  ap-
   pear on all copies and supporting documentation.  The name of the
   Trustees of Dartmouth College may not be used in  advertising  or
   publicity  relating  to  distribution  of  these programs without
   specific prior permission.  Neither  the  Trustees  of  Dartmouth
   College nor the author make representations about the suitability
   of this software for any purpose.  It is provided "as is" without
   expressed or implied warranty.

************************************************************************/

#include "menu.h"

main(argc,argv)
int argc;
char *argv[];
{
	int die();
	char menufile[MAXLINE];
/*
	chdir(WORKDIR);
	openlog("admin",LOG_PID,LOG_LOCAL0);
	syslog(LOG_INFO,"MENU version %s Login Starting",VERSION);
*/
	signal(SIGINT, (void *)die);

	if (argc < 2)
		strcpy(menufile,"main.mnu");
	else
		strcpy(menufile,argv[1]);

	initscr();
	initinput();
	wrap(menufile);
	die();
}
/******************************************************************************
 * INITINPUT - Set up curses
 *****************************************************************************/
initinput()
{
	raw();
	echo();
	nonl();
}
/******************************************************************************
 * DIE - This function is where to end entire program
 *****************************************************************************/
die()
{
	FILE *fp;
	signal(SIGINT, SIG_IGN);
	mvcur(0, COLS-1, LINES-1, 0);
	endwin();
	exit(0);
}
/******************************************************************************
 * WRAP - This wraps up the whole program.
 *****************************************************************************/
wrap(menufile)
char menufile[];
{
	intro(VERSION);
	menu(menufile);
	return;
}
/******************************************************************************
 * INTRO - This prints the program name, version and current time at the top
 *         of the display.
 *****************************************************************************/
intro(version)
char version[];
{
	int x1, x2, y;
	char *tp, *get_time();

	/* box(stdscr, ' ', '='); */
	move(1,2);
	standout();
	addstr(" Dartmouth Menu Shell, version: ");
	getyx(stdscr, y, x1);
	printw("%s", version);
	getyx(stdscr, y, x2);
	while (x2++ - x1 < 6)
		addch(' ');
	tp = (char *)get_time();
	stripcrlf(tp);
	addstr(tp);
	addstr(" ");
	standend();
	move(MESSAGE,1);
	addstr("MESSAGES:");
	clrtobot();
	move(0,0);
	refresh();
}
