/*
 *	SystemV simulation of bsd's gettimeofday(2).
 *
 *	Thad Floryan, 24-June-1990.
 */

/*
** This is a truly imaginative hack by Thad Floryan.  Because times(2) 
** returns the 1/60s of a second that have passed since boot time, it is 
** perfectly useable for the measurement of time between calls.  That's all
** anybody ever uses it for anyway...
**
** Added:  (-1) return value upon failure of time().  If times() fails, bite
** the bullet and set tv_usec to 0.
**
** -Andy
*/

#include <sys/types.h>
#include <sys/times.h>

struct timeval {
	long	tv_sec;		/* seconds */
	long	tv_usec;	/* and microseconds */
};

struct timezone {
	int	tz_minuteswest;	/* minutes west of Greenwich */
	int	tz_dsttime;	/* type of dst correction */
};

#define	DST_NONE	0	/* not on dst */
#define	DST_USA		1	/* USA style dst */
#define	DST_AUST	2	/* Australian style dst */
#define	DST_WET		3	/* Western European dst */
#define	DST_MET		4	/* Middle European dst */
#define	DST_EET		5	/* Eastern European dst */


gettimeofday( tp, tz )
    struct timeval *tp;	/* long tv_sec  secs since 1-jan-1970	*/
			/* long tv_usec microseconds fraction	*/
    struct timezone *tz;/* int tz_minuteswest of GMT		*/
			/* int tz_dsttime = DST_* if apply DST	*/
{
    extern long time(), times();
    extern long timezone;
    struct tms dummy;

    /* tp->tv_sec = time((long *) 0); */
    if ((tp->tv_sec = time((long *) 0)) < 0)
	return(-1);
    /* tp->tv_usec = (times(&dummy) % 60L) * 16666L; /* 1/60 = .016666 S */
    if ((tp->tv_usec = (times(&dummy) % 60L) * 16666L) < 0) /* 1/60 = .016666 S */
	tp->tv_usec = 0;
    if (tz != (struct timezone *)0) {
	tz->tz_minuteswest = (int) (timezone / 60L);  /* convert sec to min */
	tz->tz_dsttime = DST_USA;		/* assume USA DST handling */
    }
}
