/****************************************************************************\
|*                                                                          *|
|*  Dissect.c: a rough-and-ready heap of junk to split a file in mbox       *|
|*             format into a number of mbox-format files, each containing   *|
|*             all the messages from a sender whose mail was in the         *|
|*             original mbox, and named after that sender.                  *|
|*                                                                          *|
|*  Also:      it will count the number of articles in each mbox in its     *|
|*             argument list, when called with argv[0] not equal to         *|
|*             dissect.                                                     *|
|*                                                                          *|
|*  This program written in the early hours of 21st January 1989.           *|
|*  Copyright (C) 1989 by Mike Taylor.  No rights reserved - copy me!       *|
|*                                                                          *|
\****************************************************************************/

#include <stdio.h>
#include <strings.h>

#define LINELEN 1024

extern char *fgets ();
static int onlycount = 0;

/*--------------------------------------------------------------------------*/

int handle (argv, index)
  char **argv;
  int index;
{
  FILE *fp;
  FILE *to = NULL;
  static char name[LINELEN];
  static char line[LINELEN];
  static char last[LINELEN] = "\n";
  char *cp;
  int flag = 0;

  if ((fp = fopen (argv[index], "r")) == NULL) {
    (void) fprintf (stderr, "%s: couldn't open input file %s.\n",
		    argv[0], argv[index]);
    return (1);
  }

  while (fgets (line, LINELEN, fp) != NULL) {
    if ((!strncmp (line, "From ", 5)) && (*last == '\n')) {
      flag++;
      if (!onlycount) {
	(void) fclose (to);
	(void) strcpy (name, line+5);
	for (cp = name; (*cp != ' ') && (*cp != '@') && (*cp != '%'); cp++);
	*cp = '\0';
	if (!strcmp (name, argv[index])) {
	  (void) fprintf (stderr, "%s: won't overwrite input file %s.\n",
			  argv[0], argv[index]);
	  continue;
	}
	if ((to = fopen (name, "a")) == NULL) {
	  (void) fprintf (stderr, "%s: couldn't open output file %s.\n",
			  argv[0], name);
	  return (1);
	}
      }
    }
    if ((to != NULL) && (!onlycount))
      (void) fputs (line, to);
    (void) strcpy (last, line);
  }
  if (flag == 0)
    (void) fprintf (stderr, "%s: found no mail in input file %s.\n",
		    argv[0], argv[index]);
  else
    if (onlycount)
      (void) printf ("%s: %3d items of mail in input file %s.\n",
		     argv[0], flag, argv[index]);
  return (flag == 0);
}

/*--------------------------------------------------------------------------*/

main (argc, argv)
  int argc;
  char **argv;
{
  int status = 0;
  int i;

  if (argc == 1) {
    (void) fprintf (stderr, "Usage: %s file [ file ... ]\n", argv[0]);
    exit (255);
  }

  if (strcmp (argv[0], "dissect"))
    onlycount = 1;

  for (i = 1; i < argc; i++)
    status += handle (argv, i);

  exit (status);
}

/*--------------------------------------------------------------------------*/
