/*	Count.c  Released into the public domain on 05/09/89
 *	Written by:  Jeff Beadles  jeff@quark.WV.TEK.COM
 *	  or ...!tektronix!quark.WV!jeff
 *
 *	NOTE:  This program is not supported by Tektronix, Inc.
 *
 *	This program will count from the starting number to the stop
 *	number, using the character 'fs' as the field seperator.
 *	Note, that fs may be in several forms:
 *	-A	will use the letter 'A'
 *	--	will use a '-' as fs, and
 *	-\011	will use a tab (Octal 011) as the fs.  (sh does the expansion.)
 *
 *	Bugs may be sent to me if desired.
 *	Please keep your flames to yourself.  What do you expect for free?
 *
 */


#include <stdio.h>
#include <ctype.h>

/*
 *	Default field seperator
 */

#ifndef FS
#define FS '\n'
#endif

int
main(argc,argv)
int argc;
char **argv;

{
	void usage();
	int oatc();
	int	start = 0;	/* Start count				*/
	int	stop  = 0;	/* Stop  count				*/
	int	pos   = 1;	/* Position in command line for parsing	*/
	char	fs    = FS;	/* Field Separator			*/

	if ( argc < 2)
		usage(argv[0]);		/* Does not return */

	if ( argv[1][0] == '-' ) {
		if ( (isdigit(argv[1][1])) && (strlen(argv[1]) == 4) )
			fs=oatc(argv[1] + 1);
			else
			fs = argv[1][1];
		pos++;		/* On to the next arg... */
	}
	start = atoi(argv[pos++]);	/* Start here, and... */

	if ( argc <= pos)
		usage(argv[0]);		/* Does not return */

	stop  = atoi(argv[pos]); 	/* Stop here. */
	if ( start >= stop)		/* Are they brain damaged? */
	{
		fprintf(stderr,"Error:  START must be less than STOP\n");
		exit(-2);
	}

/*
   Yes, this is it.  It even prints a '\n' when done, if the fs != '\n' (Wow)
 */
	while ( start <= stop )
		printf("%d%c",start++,( (start != stop) ? fs : '\n' ) );
}

/*
   Can you figure out this function with no comments?  Sure, you can.
*/
void usage(program)
char *program;

{
	fprintf(stderr,"Usage: %s [ -c] start stop\n",program);
	exit(-1);
}

/*
 *	octal ascii to char
 */

int oatc(str)
char *str;
	{
	int retval=0;
	int pos=0;
	int tmp=0;
	int loop;
	static int table[] = { 1, 8, 64 };   /* Powers of 8, to avoid POW */


	for(loop=strlen(str) - 1; loop >= 0; loop--)
		retval += ( (str[loop] - '0') * table[pos++] );

	return((char)retval);
}

