/*
 * logfile (CONFLOG) struct 
 *
 */

struct clogfil
{
    int type;
    int f_line;
    unsigned int f_usrlen;
    unsigned int f_ttylen;
    unsigned int t_utlen;
    unsigned int messlen;
};

/*
 * message type
 *
 */

#define	NORMAL		0
#define	SEND		1
#define	SHOUT		2
#define	INFORM		3

/*
 * userfile (CONFUSERS) struct
 *
 */

struct cusrfil
{
    int cu_flags;
    char cu_cname[MAXNAMELEN];
    char cu_tty[MAXTTYLEN];
    int cu_line;
    short cu_procid;
};

/*
 * cu_flags
 *
 */

#define	USER_OFF	0
#define	USER_ON		1
#define	USER_RECORD	2

/*
 * Structure of valid options
 *
 */

struct varopts
    {
	char *name;
	int type;
	int *var;
	int extra;
	int (*var_func)();
    };

/*
 * Some flags to go with varopt struct
 *
 */

#define	BOOLEAN		0
#define	NUMBER		1
#define	STRING		2
#define	VARMASK		3

#define	DISPLAY		0
#define	NODISPLAY	4
#define	DISPLAYMASK	4

#define	POINTER		1
#define	ROUTINE		2

/*
 * Return values from setops
 *
 */

#define	NOOPT		0
#define	FOUNDOPT	1
#define	AMBIGUOUS	2

/*
 * for the who routine
 *
 */

struct whostr
    {
	char name[MAXNAMELEN+1];
	char tty[MAXTTYLEN+1];
	int line;
	int flags;
    };
