#include "conf.h"

unsigned int wordlen;

char *
parsestr(string, length, flags)
char *string;
int length, flags;
{
    static char *retbuf;
    static int buflen = 0;
    static char *prevs;
    static int prevl;
    char *p;

    if (buflen == 0)
	retbuf = mymalloc((unsigned)(buflen = PAGESIZ));

    p = retbuf;

    if (!length)
    {
	string = prevs;
	length = prevl;
    }

    while (length && isspace(*string))
    {
        ++string;
	--length;
    }

    prevs = string;
    prevl = length;

    if (!length)
    {
	wordlen = linelen = 0;
	return NULL;
    }

    while (length &&
	   ((flags&THEREST) || (!isspace(*string) &&
				(*string != ',') && (*string != '='))))
    {
	if (*string == '"')
	{
	    ++string;  --length;

	    while (length && (*string != '"'))
	    {
		if (*string == '\\')
		{
		    ++string; --length;

		    if (length && isdigit(*string))
		    {
			int x, c;

			x = (*string++ - '0');  --length;

			if (length && isdigit(*string))
			{
			    x = (x * 10) + (*string++ - '0');  --length;

			    if (length && isdigit(*string))
			    {
				c = (x * 10) + (*string - '0');
				if (c < 256)
				{
				    x = c;
				    ++string;  --length;
				}
			    }
			}

			*p++ = x;
		    }
		    else
			if (length)
			{
			    *p++ = *string++;  --length;
			}
		}
		else
		{
		    *p++ = *string++; --length;
		}
	    }
	}
	else
	{
	    if (*string == '\\')
	    {
		++string; --length;

		if (length && isdigit(*string))
		{
		    int x, c;

		    x = (*string++ - '0');  --length;

		    if (length && isdigit(*string))
		    {
			x = (x * 10) + (*string++ - '0');  --length;

			if (length && isdigit(*string))
			{
			    c = (x * 10) + (*string - '0');
			    if (c < 256)
			    {
				x = c;
				++string;  --length;
			    }
			}
		    }

		    *p++ = x;
		}
		else
		    if (length)
		    {
			*p++ = *string++;  --length;
		    }
	    }
	    else
	    {
		*p++ = *string++; --length;
	    }
	}
    }

    *p = '\0';

    while (length && isspace(*string))
    {
        ++string;  --length;
    }

    if (length && ((*string == ',') || (*string == '=')))
    {
	++string;  --length;
    } 

    prevs = string;
    prevl = length;

    linelen = length;
    wordlen = p - retbuf;

    return wordlen ? retbuf : NULL;
}

cpystr(to, from, length)
register char *to, *from;
register unsigned int length;
{
   while(length--) *to++ = *from++;
}

char *
puterr(error)
int error;
{
    static char qwerty[42];

    (void) sprintf(qwerty, "Unknown error %d", error);

    return ((unsigned)error >= sys_nerr) ? qwerty : sys_errlist[error];
}
