#include "conf.h"

int nsig = 16;

char *sig_list[] =
{
	"Unkown Signal: 0",
	"Hangup",
	"Interrupt",
	"Quit",
	"Illegal Instruction",
	"Trace Trap", 
	"IOT Instruction",
	"EMT Instruction",
	"Floating Point Exception",
	"Kill",
	"Bus Error",
	"Segmentation Violation",
	"Bad Argument To System Call",
	"Write On A Pipe With No One To Read It",
	"Alarm Clock",
	"Software Termination Signal From Kill",
};

fatal(sig)
int sig;
{
    int p;

    (void) printf("\nFatal Signal %d (%s).\n", sig, putsig(sig));
    make_nice(FALSE);

    p = kill(cuser.cu_procid, sig);
    if (p < 0)
	(void) fprintf(stderr, "%s: Couldn't kill proccess %d (%s)\n",
		       progname, cuser.cu_procid, puterr(errno));

    (void) exit(-1);
}

char *
putsig(sig)
int sig;
{
    static char qwerty[42];

    (void) sprintf(qwerty, "Unknown Signal: %d", sig);

    return ((unsigned)sig >= nsig) ? qwerty : sig_list[sig];
}
