#include "conf.h"

read_log()
{
    char *ptr, *p;
    char rduser[MAXNAMELEN], rdtty[MAXTTYLEN];
    int tous, toline;

    while (read(log_rfd, (char *)&tlog, (unsigned)sizeof(struct clogfil)) ==
	sizeof(struct clogfil))
    {
	switch(tlog.type)
	{
	    case NORMAL:
		if (tlog.f_line == cuser.cu_line)
		{
		    if (tlog.messlen > wdlen)
			wrdata = myrealloc(wrdata, wdlen = tlog.messlen);

		    read(log_rfd, rduser, tlog.f_usrlen);
		    read(log_rfd, rdtty, tlog.f_ttylen);
		    read(log_rfd, wrdata, tlog.messlen);

		    if (!seeme && !strcmp(rdtty, cuser.cu_tty))
			break;

		    if (beep)
			(void)putchar(BELL);

		    printmess(stdout, normform, rduser, rdtty,
			    wrdata, tlog.messlen);

		    if (cuser.cu_flags&USER_RECORD)
			printmess(rec_fp, normform, rduser, rdtty,
				wrdata, tlog.messlen);
		}
		else
		    (void)lseek(log_rfd, (long)(tlog.f_usrlen + tlog.f_ttylen +
			tlog.messlen), 1);
		break;

	    case SEND:
		read(log_rfd, rduser, tlog.f_usrlen);
		read(log_rfd, rdtty, tlog.f_ttylen);

		ptr = mymalloc(tlog.t_utlen);
		read(log_rfd, ptr, tlog.t_utlen);
		read(log_rfd, wrdata, tlog.messlen);

		p = ptr;
		toline = tous = FALSE;
		do
		{
		    switch(*p)
		    {
			case '/':
			    if (atoi(p+1) == cuser.cu_line)
			    toline = TRUE;
			    break;

			case ':':
			    if (!strcmp(p+1, cuser.cu_tty))
				tous = TRUE;
			    break;

			default:
			    if (!strcmp(p, cuser.cu_cname))
				tous = TRUE;
			    break;
		    }
		    
		    while (*p++) ;  /* to next name */
		} while (*p);       /* while another name exists */

		free(ptr);

		if (tous)
		{
		    if (beep)
			(void)putchar(BELL);

		    printmess(stdout, sendform, rduser, rdtty,
			wrdata, tlog.messlen);

		    if (cuser.cu_flags&USER_RECORD)
			printmess(rec_fp, sendform, rduser, rdtty,
				wrdata, tlog.messlen);

		    (void)strcpy(replytty, rdtty);
		    replytty[strlen(replytty)] = '\0'; /* extra nul 4 send*/
		    (void)strcpy(replyname, rduser);
		}

		if (toline)
		{
		    if (beep)
			(void)putchar(BELL);

		    printmess(stdout, lineform, rduser, rdtty,
			    wrdata, tlog.messlen);

		    if (cuser.cu_flags&USER_RECORD)
			printmess(rec_fp, lineform, rduser, rdtty,
				wrdata, tlog.messlen);
		}
		break;

	    case SHOUT:
		read(log_rfd, rduser, tlog.f_usrlen);
		read(log_rfd, rdtty, tlog.f_ttylen);
		read(log_rfd, wrdata, tlog.messlen);

		if (beep)
		    (void)putchar(BELL);

		printmess(stdout, shoutform, rduser, rdtty, wrdata,
			tlog.messlen);

		if (cuser.cu_flags&USER_RECORD)
		    printmess(rec_fp, shoutform, rduser, rdtty,
			    wrdata, tlog.messlen);
		break;

	    case INFORM:
		if (tlog.f_line == cuser.cu_line)
		{
		    if (tlog.messlen > wdlen)
			wrdata = myrealloc(wrdata, wdlen = tlog.messlen);

		    read(log_rfd, rduser, tlog.f_usrlen);
		    read(log_rfd, rdtty, tlog.f_ttylen);
		    read(log_rfd, wrdata, tlog.messlen);

		    if (!informe && !strcmp(rdtty, cuser.cu_tty))
			break;

		    if (beep)
			(void)putchar(BELL);

		    printmess(stdout, informform, rduser, rdtty,
			    wrdata, tlog.messlen);

		    if (cuser.cu_flags&USER_RECORD)
			printmess(rec_fp, informform, rduser,
				rdtty,wrdata, tlog.messlen);
		}
		else
		{
		    (void)lseek(log_rfd, (long)(tlog.f_usrlen + tlog.f_ttylen +
			tlog.messlen), 1);

#ifdef DEBUG1
		    (void)puts("flushin' this inform...");
		    (void)printf("f_line = %d, cu_line = %d.\n", 
			tlog.f_line, cuser.cu_line);
#endif DEBUG1
		}
		break;

	    default:
		/* ignore invalid type lseek to end */
#ifdef	DEBUG0
		(void)printf("invalid type (0x%x)\n",tlog.type);
#endif	DEBUG0
		(void)lseek(log_rfd, 0L, 2);
		break;
	}
    }
}

write_log(type, message, user, userlen, siz)
int type;
unsigned int userlen, siz;
char *message, *user;
{
    static char *wrbuf;
    static unsigned wblen=0;
    unsigned wrlen;

    clog.type = type;
    clog.messlen = siz;
    clog.t_utlen = userlen;

    switch(type)
    {
	case NORMAL:
	    wrlen = sizeof(struct clogfil) + clog.f_usrlen + clog.f_ttylen +
		    clog.messlen;

	    if (wrlen > wblen)
		wrbuf = myrealloc(wrbuf, wblen = wrlen);

	    /* move data into wrbuf */
	    cpystr(wrbuf, (char *)&clog, (unsigned)sizeof(struct clogfil));

	    strcpy(wrbuf+sizeof(struct clogfil), cuser.cu_cname);
	    strcpy(wrbuf+sizeof(struct clogfil)+clog.f_usrlen, cuser.cu_tty);
	    cpystr(wrbuf+sizeof(struct clogfil)+clog.f_usrlen+
		   clog.f_ttylen, message, clog.messlen);

	    write(log_wfd, wrbuf, wrlen);
	    break;

	case SEND:
	    wrlen = sizeof(struct clogfil) + clog.f_usrlen + clog.f_ttylen +
		clog.t_utlen + clog.messlen;

	    if (wrlen > wblen)
		wrbuf = myrealloc(wrbuf, wblen = wrlen);

	    /* move data into wrbuf */

	    cpystr(wrbuf, (char *)&clog, sizeof(struct clogfil));
	    (void)strcpy(wrbuf+sizeof(struct clogfil), cuser.cu_cname);
	    (void)strcpy(wrbuf+sizeof(struct clogfil)+clog.f_usrlen,
			 cuser.cu_tty);
	    cpystr(wrbuf+sizeof(struct clogfil)+clog.f_usrlen+clog.f_ttylen,
		   user, clog.t_utlen);

	    cpystr(wrbuf+sizeof(struct clogfil)+clog.f_usrlen+
		   clog.f_ttylen+clog.t_utlen, message, clog.messlen);

	    write(log_wfd, wrbuf, wrlen);
	    break;

	case SHOUT:
	    wrlen = sizeof(struct clogfil) + clog.f_usrlen + clog.f_ttylen +
		    clog.messlen;

	    if (wrlen > wblen)
		wrbuf = myrealloc(wrbuf, wblen = wrlen);

	    /* move data into wrbuf */


	    cpystr(wrbuf, (char *)&clog, sizeof(struct clogfil));
	    (void)strcpy(wrbuf+sizeof(struct clogfil), cuser.cu_cname);
	    (void)strcpy(wrbuf+sizeof(struct clogfil)+clog.f_usrlen,
			 cuser.cu_tty);
	    cpystr(wrbuf+sizeof(struct clogfil)+clog.f_usrlen+clog.f_ttylen,
		   message, clog.messlen);

	    write(log_wfd, wrbuf, wrlen);
	    break;

	case INFORM:
	    wrlen = sizeof(struct clogfil) + clog.f_usrlen + clog.f_ttylen +
		    clog.messlen;

	    if (wrlen > wblen)
		wrbuf = myrealloc(wrbuf, wblen = wrlen);

	    /* move data into wrbuf */

	    cpystr(wrbuf, (char *)&clog, (unsigned)sizeof(struct clogfil));
	    (void)strcpy(wrbuf+sizeof(struct clogfil), cuser.cu_cname);
	    (void)strcpy(wrbuf+sizeof(struct clogfil)+clog.f_usrlen,
			 cuser.cu_tty);
	    cpystr(wrbuf+sizeof(struct clogfil)+clog.f_usrlen+clog.f_ttylen,
		   message, clog.messlen);

	    write(log_wfd, wrbuf, wrlen);
	    break;

#ifdef	DEBUG0
	default:
	    (void)printf("warning .. Bogus type, no write (type = %d)\n", type);
	    break;
#endif	DEBUG0
    }
}

write_usr()
{
    (void)lseek(usr_fd, ourplace, 0);

#ifdef	SYSV
    locking(usr_fd, LK_LOCK, (long)sizeof(struct cusrfil));
#endif	SYSV

#ifdef	BSD
    flock(usr_fd, LOCK_EX);
#endif	BSD

    write(usr_fd, (char *)&cuser, sizeof(struct cusrfil));

#ifdef	SYSV
    (void)lseek(usr_fd, ourplace, 0);
    locking(usr_fd, LK_UNLCK, (long)sizeof(struct cusrfil));
#endif	SYSV

#ifdef	BSD
    flock(usr_fd, LOCK_UN);
#endif	BSD
}
