#include "conf.h"

jmp_buf glenv, cvenv;

#define	BACKCHAR() {if (expand8bit && !isascii(*(lp-1)))         \
			(void)fputs("\b \b", stdout);              \
		    if (expandctrl && iscntrl(toascii(*(lp-1)))) \
			(void)fputs("\b \b", stdout);              \
		    (void)fputs("\b \b", stdout); --lp;}

unsigned linelen, col = 0;

my_intr(sig)
int sig;
{
    longjmp(glenv, sig);
}

save_intr(sig)
int sig;
{
    longjmp(cvenv, sig);
}

fputchar(c)
int c;
{
    (void)putchar(c);
}

printmess(stream, constr, usr, tty, mess, length)
char *constr, *usr, *tty, *mess;
unsigned length;
FILE *stream;
{
    register char *ptr = constr;
    register int c;

    while (c = *ptr++)
    {
	switch(c)
	{
	    case '%':
		switch(c = *ptr++)
		{
		    case 'T':
			visprnt(cuser.cu_tty, stream);
			break;

		    case 't':
			visprnt(tty, stream);
			break;

		    case 'N':
			visprnt(cuser.cu_cname, stream);
			break;

		    case 'n':
			visprnt(usr, stream);
			break;

		    case 'm':
			messptr(mess, stream, length);
			break;

		    case '\0':
			(void)putc('%', stream);
			--ptr;
			break;

		    default:
			(void)putc('%', stream);
		    case '%':
			(void)putc(c, stream);
			break;
		}
		break;

	    default:
		(void)putc(c, stream);
		break;
	}
    }

    (void)fflush(stream);
}

messptr(mess, stream, length)
char *mess;
unsigned length;
FILE *stream;
{
    register char *ptr = mess;

    while (length--)
	dispchar(*ptr++, stream, NOVIS);

    (void)fflush(stream);
}

visprnt(mess, stream)
char *mess;
FILE *stream;
{
    register char *ptr = mess;

    while (*ptr)
	dispchar(*ptr++, stream, VIS);

    (void)fflush(stream);
}

vislen(mess)
register char *mess;
{
    register int length = 0;

    while (*mess)
    {
	if (!isascii(*mess) && expand8bit)
	    length += 2;
	if (iscntrl(*mess) && expandctrl)
	    ++length;
	++length;
	++mess;
    }

    return length;
}

dispchar(c, stream, flag)
int c;
FILE *stream;
int flag;
{
    int wasmeta = FALSE;

    if (!isascii(c) && !expand8bit)
    {
	(void)putc(c, stream);
	return;
    }

    if (!isascii(c))
    {
	(void)putc('~', stream);
	c = toascii(c);
	wasmeta = TRUE;
    }

    if (iscntrl(c) && expandctrl)
    {
	switch (c)
	{
	    case DEL:
		(void)fputs("^?", stream);
		break;

	    case '\n':
	    case TAB:
		if (!wasmeta && !(flag&VIS))
		{
		    (void)putc(c, stream);
		    break;
		}

	    default:
		(void)putc('^', stream);
		(void)putc(c|'@', stream);
		break;
	}
    }
    else
	(void)putc(c, stream);
}

char *
getline()
{
    int c;
    char *line = mymalloc(PAGESIZ);
    int tmplen, len = PAGESIZ;
    char *lp = line;

    if (c = setjmp(glenv))
    {
	(void)alarm(0);
	(void)signal(SIGALRM, my_intr);
	(void)signal(SIGINT, SIG_IGN);

	switch(c)
	{
	    case SIGINT:
		dispchar(ichar, stdout, NOVIS);
		(void)putchar('\n');
		break;
	}

	free(line);
	return NULL;
    }

    (void)signal(SIGALRM, my_intr);
    (void)signal(SIGINT, my_intr);

    (void)alarm(1);
    read(0, lp, 1);
    (void)alarm(0);

    do
    {
	if (lineinput) switch(*lp)
	{
	    case CR:
	    case LF:
		if (lp == line)
		{
		    free(line);
		    return NULL;
		}
		*lp = '\0';
		linelen = lp - line;
		return line;

	    default:
		lp++;
	    	break;
	}
	else switch(*lp)
	{
	    case BS:
	    case DEL:
		if (lp > line)
		    {BACKCHAR();}
		else
		    (void)putchar(BELL);

		(void)fflush(stdout);

		if (lp == line)
		{
		    free(line);
		    return NULL;
	        }
		break;

	    case CR:
	    case LF:
		(void)putchar('\n');

		if (lp == line)
		{
		    free(line);
		    return NULL;
		}
		*lp = '\0';
		linelen = lp - line;
		return line;

	    case CTRL('L'):
		if (cls == NULL)
		    puts("^L\n");
		else
		    tputs(cls, lines, fputchar);

		messptr(line, stdout, (unsigned)(lp-line));

		if (lp == line)
		{
		    free(line);
		    return NULL;
		}
		break;

	    case CTRL('R'):
		*lp = '\0';
		(void)puts("^R");

		messptr(line, stdout, (unsigned)(lp-line));

		if (lp == line)
		{
		    free(line);
		    return NULL;
		}
		break;

	    case CTRL('U'):
		while (lp > line)
		    BACKCHAR();

		(void)fflush(stdout);
		free(line);
		return NULL;

	    case CTRL('V'):
		if (c = setjmp(cvenv))
		{
		    switch(c)
		    {
			case SIGINT:
			    *lp = ichar;
			    break;

			case SIGQUIT:
			    *lp = qchar;
			    break;
		    }
		}
		else
		{
		    (void)signal(SIGINT, save_intr);
		    (void)signal(SIGQUIT, save_intr);

		    if (read(0, lp, 1) != 1)
		    {
			free(line);		/* some sort of read error */
			return NULL;
		    }
		}

		(void)signal(SIGINT, my_intr);
		(void)signal(SIGQUIT, fatal);
		dispchar(*lp++, stdout, NOVIS);
		(void)fflush(stdout);
		break;

	    case CTRL('W'):
		while ((lp > line) && isspace(*(lp-1)))
		    BACKCHAR();   /* ditch the post word white space */

		while ((lp > line) && !isspace(*(lp-1)))
		    BACKCHAR(); /* someday a cool worderizer */

		(void)fflush(stdout);

		if (lp == line)
		{
		    free(line);
		    return NULL;
		}
		break;

	    case CTRL('D'):	/* default must follow this case */
		if (lp == line)
		{
		    (void)puts(":quit");
		    nice_exit(0);
		}
				/* if not first character, do default: */
	    default:
		dispchar(*lp++, stdout, NOVIS);
		(void) fflush(stdout);
	    	break;
	}

	if ((tmplen = lp - line) >= len )
	{
	    line = myrealloc(line, (unsigned)(len += PAGESIZ));
	    lp = line + tmplen;
	}

    } while(read(0, lp, 1));

    free(line);
    return NULL;	/* error while reading -- punt */
}

colprnt(word, pad)
char *word;
int pad;
{
    if (col+pad > columns-1)
    {
	if (!columns)
	{
	    visprnt(word, stdout);
	    (void)putchar('\n');
	}
	else
	{
	    col = pad;
	    (void)putchar('\n');
	    visprnt(word, stdout);
	    (void)printf("%-*s", pad-vislen(word), " ");
	}
    }
    else
    {
	col += pad;
	visprnt(word, stdout);
	(void)printf("%-*s", pad-vislen(word), " ");
    }
}

terpri()
{
    if (col)
	(void)putchar('\n');
    col = 0;
}
