#include "conf.h"

int set_name(), set_ptrstr();

gettcap()
{
    char *ptr;
    char buf[1024];

    if (tgetent(buf, getenv("TERM")) == 1)
    {
	columns=tgetnum("co");
	lines=tgetnum("li");
	tcapstr("cl", &cls);
    }
    else
	puts("Unknown terminal type.  I'll wing it.\n");

    if ((ptr = getenv("COLUMNS")) != NULL)
	columns = atoi(ptr);

    if ((ptr = getenv("LINES")) != NULL)
	lines = atoi(ptr);

    if ((ptr = getenv("SHELL")) != NULL)
    {
	shell = myrealloc(shell, strlen(ptr)+1);
	(void) strcpy(shell, ptr);
    }

    if ((ptr = getenv("PG")) != NULL)
    {
	pager = myrealloc(pager, strlen(ptr)+1);
	(void) strcpy(pager, ptr);
    }

    if ((ptr = getenv("PAGER")) != NULL)
    {
	pager = myrealloc(pager, strlen(ptr)+1);
	(void) strcpy(pager, ptr);
    }
}

getrc()
{
    char *fname;
    char tmp[100];
    char *bp, *p;
    int c;
    FILE *fp;

    if (homedir == NULL)
    {
	(void) fprintf(stderr, "%s: Can't figure you out!  Not using %s.\n",
		       progname, CONFRC);
	return;
    }

    fname = mymalloc((unsigned)(strlen(homedir) + 1 + strlen(CONFRC) + 1));

    (void) strcpy(fname, homedir);
    (void) strcat(fname, "/");
    (void) strcat(fname, CONFRC);

    if ((fp = fopen(fname, "r")) == (FILE *)NULL)
    {
	if (errno == ENOENT)
	    return;				/* no confrc file...  sigh */
	else
	{
	    (void) fprintf(stderr,
			   "%s: Couldn't open confrc file %s (%s).\n",
			   progname, fname, puterr(errno));
	free(fname);
	exit(-1);
	}
    }

    forever
    {
	p = bp = tmp;

	while (((c = getc(fp)) != EOF) && (c != '\n'))
	    *p++ = c;

	if (c == EOF)
	    break;

	*p = '\0';

	while (isspace(*bp))
	    bp++;

	if ((*bp == '#') || (*bp == ';') || (*bp == '\0'))
	    continue;

	if (*bp == ':')			/* a colon command? */
	{
	    linelen = strlen(bp+1);
	    if (!intpret(bp+1))
	    {
		(void) printf("Invalid confrc line in %s @\"%s\".\n",
			      fname,bp);
		return;
	    }
	}
	else
	{
	    if ((bp = parsestr(bp, p-bp, NEXTWORD)) == NULL)
		continue;

	    do
	    {
		if ((c = setopts(bp)) != FOUNDOPT)
		{
		    if (c == AMBIGUOUS)
			(void)fputs("Ambiguous", stdout);
		    else
			(void)fputs("Invalid", stdout);

		    (void) printf(" confrc file %s @\"%s\"\n", fname, bp);
		    free(fname);
		    return;
		}
	    } while ((bp = parsestr((char *)NULL, 0, NEXTWORD)) != NULL);
	}
    }

    free(fname);
    (void) fclose(fp);
}

getopts()
{
    char *ptr;
    int x;

    if ((ptr = getenv("COLUMNS")) != NULL)
	columns = atoi(ptr);

    if ((ptr = getenv("LINES")) != NULL)
	lines = atoi(ptr);

    if ((ptr = getenv("SHELL")) != NULL)
    {
	shell = myrealloc(shell, strlen(ptr)+1);
	(void) strcpy(shell, ptr);
    }

    if ((ptr = getenv("PG")) != NULL)
    {
	pager = myrealloc(pager, strlen(ptr)+1);
	(void) strcpy(pager, ptr);
    }

    if ((ptr = getenv("PAGER")) != NULL)
    {
	pager = myrealloc(pager, strlen(ptr)+1);
	(void) strcpy(pager, ptr);
    }

    if ((ptr = getenv(CONFOPTS)) != NULL)
    {
	ptr = parsestr(ptr, strlen(ptr), NEXTWORD);

	do
	{
	    if ((x = setopts(ptr)) != FOUNDOPT)
	    {
		if (x == AMBIGUOUS)
		    (void)fputs("Ambiuous", stdout);
		else
		    (void)fputs("Invalid", stdout);

		(void)printf(" %s environment variable @%s\n", CONFOPTS, ptr);
		break;
	    }
	} while ((ptr = parsestr((char *)NULL, 0, NEXTWORD)) != NULL);
    }
}

setopts(opt)
char *opt;
{
    int found;

    static struct varopts vartab[] =
    {
	{ "banner", BOOLEAN|DISPLAY, &banner, TRUE, },
	{ "nobanner", BOOLEAN|DISPLAY, &banner, FALSE, },
	{ "!banner", BOOLEAN|NODISPLAY, &banner, FALSE, },
	{ "beep", BOOLEAN|DISPLAY, &beep, TRUE, },
	{ "nobeep", BOOLEAN|DISPLAY, &beep, FALSE, },
	{ "!beep", BOOLEAN|NODISPLAY, &beep, FALSE, },
	{ "expand8bit", BOOLEAN|DISPLAY, &expand8bit, TRUE, },
	{ "noexpand8bit", BOOLEAN|DISPLAY, &expand8bit, FALSE, },
	{ "!expand8bit", BOOLEAN|NODISPLAY, &expand8bit, FALSE, },
	{ "expandctrl", BOOLEAN|DISPLAY, &expandctrl, TRUE, },
	{ "noexpandctrl", BOOLEAN|DISPLAY, &expandctrl, FALSE, },
	{ "!expandctrl", BOOLEAN|NODISPLAY, &expandctrl, FALSE, },
	{ "inform-format", STRING|DISPLAY, (int *)&informform, POINTER, set_ptrstr, },
	{ "line", NUMBER|DISPLAY, &cuser.cu_line, 0, do_to, },
	{ "line-format", STRING|DISPLAY, (int *)&lineform, POINTER, set_ptrstr, },
	{ "name", STRING|DISPLAY, (int *)cuser.cu_cname, ROUTINE, set_name, },
	{ "normal-format", STRING|DISPLAY, (int *)&normform, POINTER, set_ptrstr, },
	{ "pager", STRING|DISPLAY, (int *)&pager, POINTER, set_ptrstr, },
	{ "recfile", STRING|DISPLAY, (int *)&recfile, POINTER, set_ptrstr, },
	{ "seeme", BOOLEAN|DISPLAY, &seeme, TRUE, },
	{ "noseeme", BOOLEAN|DISPLAY, &seeme, FALSE, },
	{ "!seeme", BOOLEAN|NODISPLAY, &seeme, FALSE, },
	{ "seemyinform", BOOLEAN|DISPLAY, &informe, TRUE, },
	{ "noseemyinform", BOOLEAN|DISPLAY, &informe, FALSE, },
	{ "!seemyinform", BOOLEAN|NODISPLAY, &informe, FALSE, },
	{ "send-format", STRING|DISPLAY, (int *)&sendform, POINTER, set_ptrstr, },
	{ "shell", STRING|DISPLAY, (int *)&shell, POINTER, set_ptrstr, },
	{ "shout-format", STRING|DISPLAY, (int *)&shoutform, POINTER, set_ptrstr, },
	{ NULL, }
    }, *varptr, *keepptr;

    if (opt == NULL)
    {
	char *string;
	int tmp;
	int len=0;

	for (varptr = vartab; varptr->name != NULL; varptr++)
	    if ((varptr->type == BOOLEAN) && (*varptr->var == varptr->extra))
		if ((tmp = strlen(varptr->name)) > len)
		    len = tmp;

	len += TABAGE;

	(void)fputs("Boolean flags:\n\n", stdout);

	for (varptr = vartab; varptr->name != NULL; varptr++)
	    if ((varptr->type == BOOLEAN) && (*varptr->var == varptr->extra))
		colprnt(varptr->name, len);

	terpri();

	len = 0;

	for (varptr = vartab; varptr->name != NULL; varptr++)
	    if (varptr->type == NUMBER)
		if ((tmp = strlen(varptr->name)+1+declen(varptr->var)) > len)
		    len = tmp;

	len += TABAGE;

	(void)fputs("\nNumeric options:\n\n", stdout);

	string = mymalloc((unsigned)(len+1));
	for (varptr = vartab; varptr->name != NULL; varptr++)
	    if (varptr->type == NUMBER)
	    {
		(void) sprintf(string, "%s=%d", varptr->name, *varptr->var);
		colprnt(string, len);
	    }

	terpri();

	len = 0;

	for (varptr = vartab; varptr->name != NULL; varptr++)
	    if (varptr->type == STRING)
		if (varptr->extra&POINTER)
		{
		    if ((tmp=strlen(varptr->name) + vislen(*varptr->var)+3) > len)
			len = tmp;
		}
		else
		{
		    if ((tmp= strlen(varptr->name) + vislen(varptr->var)+3) > len)
			len = tmp;
		}

	len += TABAGE;

	(void)fputs("\nString options:\n\n", stdout);

	string = myrealloc(string, (unsigned)(len+1));
	for (varptr = vartab; varptr->name != NULL; varptr++)
	    if (varptr->type == STRING)
	    {
		if (varptr->extra&POINTER)
		    (void) sprintf(string, "%s=\"%s\"", varptr->name,
			    *varptr->var);
		else
		    (void) sprintf(string, "%s=\"%s\"", varptr->name,
			    varptr->var);
		colprnt(string, len);
	    }

	terpri();
	free(string);

	return FOUNDOPT;
    }

    keepptr = (struct varopts *)NULL;
    found = 0;
    for (varptr = vartab; varptr->name != NULL; varptr++)
	if (!strncmp(varptr->name, opt, strlen(opt)))
	{
	    if (!found)
		keepptr = varptr;

	    if (found >= 0)
		++found;

	    if (strlen(varptr->name) == strlen(opt))
	    {
		found = -1;
		keepptr = varptr;
	    }
	}

    if (!found)
	return NOOPT;

    if (found > 1)
	return AMBIGUOUS;

    switch(keepptr->type&VARMASK)
    {
	case BOOLEAN:
	    *keepptr->var = keepptr->extra;
	    break;

	case NUMBER:
	    return (*keepptr->var_func)(keepptr->name, keepptr->var);

	case STRING:
	    return (*keepptr->var_func)(keepptr->name, keepptr->var);

	default:
	    return NOOPT;
    }

    return FOUNDOPT;
}

set_name()
{
    char *ptr, *ptr2;
    char nbuf[20+MAXNAMELEN];

    if ((ptr = ptr2 = parsestr((char *)NULL, 0, NEXTWORD)) == NULL)
    {
	if (confing)
	{
	    (void) printf("name = \"%s\"\n", cuser.cu_cname);
	    return TRUE;
	}

	return FALSE;
    }

    while(*ptr2 != '\0')
    {
	if ((*ptr2 > ' ') && !strchr(",:/", *ptr2))
	    ptr2++;
	else
	    *ptr2 = '\0';
    }

    if (*ptr == '\0')
    {
	if (confing)
	{
	    (void)puts("Invalid name given.");
	    return TRUE;
	}

	return FALSE;
    }

    (void) sprintf(nbuf, "Changed name from %s", cuser.cu_cname);

    (void) strncpy(cuser.cu_cname, ptr, MAXNAMELEN);
    cuser.cu_cname[MAXNAMELEN-1] = '\0';
    clog.f_usrlen = strlen(cuser.cu_cname) + 1;

    if (confing)
    {
	write_log(INFORM, nbuf, (char *)NULL, 0, (unsigned)strlen(nbuf));
	write_usr();
	(void)printf("Name changed to \"%s\"\n", cuser.cu_cname);
    }

    return TRUE;
}

/*set_integer(name, var)
 *char *name;
 *int *var;
 *{
 *    char *ptr;
 *
 *    if ((ptr = parsestr((char *)NULL, 0, NEXTWORD)) != NULL)
 *	*var = atoi(ptr);
 *
 *    (void) printf("%s = %d\n", name, *var);
 *    return FOUNDOPT;
 *}
 */

set_ptrstr(name, var)
char *name, **var;
{
    char *ptr;

    if ((ptr = parsestr((char *)NULL, 0, NEXTWORD)) != NULL)
    {
	*var = myrealloc(*var, strlen(ptr)+1);
	(void) strcpy(*var, ptr);
    }

    (void) printf("%s = \"", name);
    visprnt(*var, stdout);
    (void) puts("\"");

    return FOUNDOPT;
}

declen(num)
register int num;
{
    register int places = 1;

    while ((num /= 10) >= 1)
	++places;

    return places;
}

tcapstr(string, var)
char *string, **var;
{
    char tcapbuf[1024];
    char *tmp = tcapbuf;

    if (tgetstr(string, &tmp) == NULL)
	*var = NULL;
    else
    {
	*var = myrealloc(*var, tmp-tcapbuf);
	(void) strcpy(*var, tcapbuf);
    }
}
