/*
 * System type.  Define only the *ONE* system that applies to you
 * the most.
 */

#define SYSV		        /* System V and Xenix.  SCO Xenix */
/*#define BSD		        /* Any of the Berkeley clan */

/*
 * Define SENDER as the local command to use to SEND a message.
 * :rings will popen() this command giving it one user on the
 * command line and its message through standard input.
 *
 * If you do not have a local SEND program then define this as
 * "write".
 */

#define SENDER	"hello"		/* the local send program */

/*
 * The default pager
 *	maybe "more", "less", or "cat"
 */

#define	DEF_PAGER	"more"		/* local pager */
#define	DEF_SHELL	"sh"		/* default shell*/

/*
 * User settable files.
 *	Someday these files will be definable at any time during conf
 */

#define CONFLOG		"/usr/lib/conf/conflog"	  /* conversation log */
#define CONFUSERS	"/usr/lib/conf/confusers"    /* user log */
#define CONFHELP	"/usr/lib/conf/confhelp"     /* help file */
#define CONFLOCK	"/usr/lib/conf/conf.lock"	  /* lock file */

#define	DEF_RECFILE	"conf.rec"	 /* default record file */
#define	CONFRC		".confrc"	 /* default rc file */

#define	CONFOPTS	"CONFOPTS"		  /* environment variable */

#define	FILEMASK	0600		 /* filemask for CONF{USERS,LOG} */

/* Some buffer length stuff */
#define	MAXNAMELEN	21
#define	MAXTTYLEN	21
#define	MAXCONFLINES	100     /* number of conference lines */

#define	PAGESIZ		512     /* alloc this amount at a time */

#define TABAGE		2		/* space between columns */

/*
 * Some important influences.
 *
 * Thanks should also go out to Neil Pert for awesome percussion. -MQH
 */

#define SIGNIFICANT_OTHER	"Marla Gabryelski"

#define	MUSICIAN		"Brian_Eno"
#define	SONG			"Third_Uncle"

#define VERNUM			2
#define PATCHLEVEL		0

#define AUTHOR			"Keith M. Gabryelski"
#define ADDRESS			"ag@elgar.UUCP"
#define ALTPATH			"ag@portnoy.UUCP"
#define THANKS1			"ford@kenobi.UUCP (Mike Ditto)"

/*
 * form strings
 *
 *	Meta characters for form string:
 *
 *	%N - Your conference name.
 *	%n - Name of user sending message.
 *	%m - Message users sent.
 *	%T - Your tty.
 *	%t - Tty of user that sent message.
 *	%% - The character '%'
 *
 */

#define	DEF_NORM	"%n - %m\n"
#define	DEF_SEND	">>> %n (%t) - %m\n"
#define	DEF_INFORM	"::: %n (%t) [%m]\n"
#define	DEF_LINE	"::: %n (%t) - %m\n"
#define	DEF_SHOUT	"*** %n (%t) - %m\n"

/*
 * You probably don't need to modify anything after this line
 * unless you are debugging.
 */

/*
 * DEBUGx are debugging defines.
 *
 */

/*#define DEBUG0		/* insignificant checks around conf */
/*#define DEBUG1		/* temporary debug messages */

