;; Run conf(1) as asynchronous inferior of Emacs.
;; provided by Michael Ditto (ford@kenobi.cts.com)
;; This file is not part of GNU Emacs.

(defvar conf-process nil "The process of conf.")

(defun conference (switches)
  "Conference with other users."
  (interactive "sArgs to conference (switches): ")

  (require 'shell)

  (let ((buffer (get-buffer-create "*conference*")))
    (switch-to-buffer buffer)

    (if (get-buffer-process buffer)
	(error "A conference process is already running"))

    (setq conf-process
	  (start-process "conf" buffer
			 "/bin/sh" "-c" (format "conf %s" switches))))

  (shell-mode)
  (turn-on-auto-fill)
  (setq mode-name "Conference")
  (set-marker (process-mark conf-process) (point-max))
  (set-process-filter conf-process 'conf-filter))

(defun conf-filter (process string)
  (save-excursion
    (set-buffer (process-buffer process))
    (goto-char (process-mark process))
    (let ((start-line (point)))
      (insert-before-markers string)
      ;;    (fill-region start-line (point))
      )

    (if (get-buffer-window (process-buffer process))
	nil
      (beep t))))
