/*   Copyright (c) 1988 by George M. Sipe.  All rights reserved.

This software may only be redistributed without fee and without any
other form of monetary gain (including sold, rented, leased, or
traded), unless the express written permission of the copyright holder
is obtained in advance.

This copyright notice must be reproduced in its entirety on all copies
of this software.  Further, acknowledgment of the authorship of this
software must not be removed from its current or derived
documentation.

No expressed or implied warranty is made for this software.  No party
connected with this software assumes any liability or responsibility
for its use, the correctness of its operation, or its fitness for any
purpose.

Any distributor of copies of this software shall grant the recipient
permission for further redistribution as permitted by this notice.

Permission is hereby granted to copy, reproduce, redistribute and
otherwise use this software as long as the conditions above are
strictly adhered to.

	NOTE:  This software was originally written by Jim Earenluindil
	Trethewey and modified by George M. Sipe (rebel!george) to the
	point where Jim would no longer recognize it.  No copyright
	notices were embodied in the original net distribution.
*/

#include <curses.h>

#ifndef	MSDOS
extern  void pr_colon();
extern  void pr_space();
extern  void pr_big();
#else
extern  void pr_colon(int col);
extern  void pr_space(void);
extern  void pr_big(int num,int col);
#endif

extern WINDOW *scr;		/* screen where large numbers displayed */
extern int curr_col;		/* current center of colon column */
extern int NBASE;		/* numeric base line for output */

void pr_colon(col)
int col;
{
	curr_col = col + 1;
	wmove(scr, NBASE     , col); wprintw(scr, "   ");
	wmove(scr, NBASE +  1, col); wprintw(scr, "   ");
	wmove(scr, NBASE +  2, col); wprintw(scr, "   ");
	wmove(scr, NBASE +  3, col); wprintw(scr, " # ");
	wmove(scr, NBASE +  4, col); wprintw(scr, "###");
	wmove(scr, NBASE +  5, col); wprintw(scr, " # ");
	wmove(scr, NBASE +  6, col); wprintw(scr, "   ");
	wmove(scr, NBASE +  7, col); wprintw(scr, "   ");
	wmove(scr, NBASE +  8, col); wprintw(scr, " # ");
	wmove(scr, NBASE +  9, col); wprintw(scr, "###");
	wmove(scr, NBASE + 10, col); wprintw(scr, " # ");
	wmove(scr, NBASE + 11, col); wprintw(scr, "   ");
	wmove(scr, NBASE + 12, col); wprintw(scr, "   ");
	wmove(scr, NBASE + 13, col); wprintw(scr, "   ");
}

void pr_space()
{
	int i;
	for(i = NBASE; i < NBASE + 14; i++) {
		wmove(scr, i,  9);
		wprintw(scr, "                                   ");
		wmove(scr, i, 42);
		wprintw(scr, "                                   ");
	}
}

void pr_big(num, col)
int num;
int col;
{
	if(num == 0) {
		wmove(scr, NBASE     , col); wprintw(scr, "   ######   ");
		wmove(scr, NBASE +  1, col); wprintw(scr, " ########## ");
		wmove(scr, NBASE +  2, col); wprintw(scr, "####    ####");
		wmove(scr, NBASE +  3, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  4, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  5, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  6, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  7, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  8, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  9, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE + 10, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE + 11, col); wprintw(scr, "####    ####");
		wmove(scr, NBASE + 12, col); wprintw(scr, " ########## ");
		wmove(scr, NBASE + 13, col); wprintw(scr, "   ######   ");
	} else if(num == 1) {
		wmove(scr, NBASE     , col); wprintw(scr, "      ##    ");
		wmove(scr, NBASE +  1, col); wprintw(scr, "     ###    ");
		wmove(scr, NBASE +  2, col); wprintw(scr, "    ####    ");
		wmove(scr, NBASE +  3, col); wprintw(scr, "   #####    ");
		wmove(scr, NBASE +  4, col); wprintw(scr, "     ###    ");
		wmove(scr, NBASE +  5, col); wprintw(scr, "     ###    ");
		wmove(scr, NBASE +  6, col); wprintw(scr, "     ###    ");
		wmove(scr, NBASE +  7, col); wprintw(scr, "     ###    ");
		wmove(scr, NBASE +  8, col); wprintw(scr, "     ###    ");
		wmove(scr, NBASE +  9, col); wprintw(scr, "     ###    ");
		wmove(scr, NBASE + 10, col); wprintw(scr, "     ###    ");
		wmove(scr, NBASE + 11, col); wprintw(scr, "     ###    ");
		wmove(scr, NBASE + 12, col); wprintw(scr, "   #######  ");
		wmove(scr, NBASE + 13, col); wprintw(scr, "   #######  ");
	} else if(num == 2) {
		wmove(scr, NBASE     , col); wprintw(scr, "  ########  ");
		wmove(scr, NBASE +  1, col); wprintw(scr, " ########## ");
		wmove(scr, NBASE +  2, col); wprintw(scr, "###     ####");
		wmove(scr, NBASE +  3, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  4, col); wprintw(scr, "         ###");
		wmove(scr, NBASE +  5, col); wprintw(scr, "         ###");
		wmove(scr, NBASE +  6, col); wprintw(scr, "         ###");
		wmove(scr, NBASE +  7, col); wprintw(scr, "        ### ");
		wmove(scr, NBASE +  8, col); wprintw(scr, "       ###  ");
		wmove(scr, NBASE +  9, col); wprintw(scr, "     ####   ");
		wmove(scr, NBASE + 10, col); wprintw(scr, "   ####     ");
		wmove(scr, NBASE + 11, col); wprintw(scr, " ####       ");
		wmove(scr, NBASE + 12, col); wprintw(scr, "############");
		wmove(scr, NBASE + 13, col); wprintw(scr, "############");
	} else if(num == 3) {
		wmove(scr, NBASE     , col); wprintw(scr, "  ########  ");
		wmove(scr, NBASE +  1, col); wprintw(scr, " ########## ");
		wmove(scr, NBASE +  2, col); wprintw(scr, "###     ####");
		wmove(scr, NBASE +  3, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  4, col); wprintw(scr, "         ###");
		wmove(scr, NBASE +  5, col); wprintw(scr, "         ###");
		wmove(scr, NBASE +  6, col); wprintw(scr, "    ####### ");
		wmove(scr, NBASE +  7, col); wprintw(scr, "    ####### ");
		wmove(scr, NBASE +  8, col); wprintw(scr, "         ###");
		wmove(scr, NBASE +  9, col); wprintw(scr, "         ###");
		wmove(scr, NBASE + 10, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE + 11, col); wprintw(scr, "###     ####");
		wmove(scr, NBASE + 12, col); wprintw(scr, " ########## ");
		wmove(scr, NBASE + 13, col); wprintw(scr, "  ########  ");
	} else if(num == 4) {
		wmove(scr, NBASE     , col); wprintw(scr, "       ###  ");
		wmove(scr, NBASE +  1, col); wprintw(scr, "      ####  ");
		wmove(scr, NBASE +  2, col); wprintw(scr, "     #####  ");
		wmove(scr, NBASE +  3, col); wprintw(scr, "    ######  ");
		wmove(scr, NBASE +  4, col); wprintw(scr, "   ### ###  ");
		wmove(scr, NBASE +  5, col); wprintw(scr, "  ###  ###  ");
		wmove(scr, NBASE +  6, col); wprintw(scr, " ###   ###  ");
		wmove(scr, NBASE +  7, col); wprintw(scr, "############");
		wmove(scr, NBASE +  8, col); wprintw(scr, "############");
		wmove(scr, NBASE +  9, col); wprintw(scr, "       ###  ");
		wmove(scr, NBASE + 10, col); wprintw(scr, "       ###  ");
		wmove(scr, NBASE + 11, col); wprintw(scr, "       ###  ");
		wmove(scr, NBASE + 12, col); wprintw(scr, "       ###  ");
		wmove(scr, NBASE + 13, col); wprintw(scr, "       ###  ");
	} else if(num == 5) {
		wmove(scr, NBASE     , col); wprintw(scr, "############");
		wmove(scr, NBASE +  1, col); wprintw(scr, "############");
		wmove(scr, NBASE +  2, col); wprintw(scr, "###         ");
		wmove(scr, NBASE +  3, col); wprintw(scr, "###         ");
		wmove(scr, NBASE +  4, col); wprintw(scr, "### ######  ");
		wmove(scr, NBASE +  5, col); wprintw(scr, "########### ");
		wmove(scr, NBASE +  6, col); wprintw(scr, "###     ####");
		wmove(scr, NBASE +  7, col); wprintw(scr, "         ###");
		wmove(scr, NBASE +  8, col); wprintw(scr, "         ###");
		wmove(scr, NBASE +  9, col); wprintw(scr, "         ###");
		wmove(scr, NBASE + 10, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE + 11, col); wprintw(scr, "###     ####");
		wmove(scr, NBASE + 12, col); wprintw(scr, " ########## ");
		wmove(scr, NBASE + 13, col); wprintw(scr, "  ########  ");
	} else if(num == 6) {
		wmove(scr, NBASE     , col); wprintw(scr, "       ###  ");
		wmove(scr, NBASE +  1, col); wprintw(scr, "      ###   ");
		wmove(scr, NBASE +  2, col); wprintw(scr, "     ###    ");
		wmove(scr, NBASE +  3, col); wprintw(scr, "    ###     ");
		wmove(scr, NBASE +  4, col); wprintw(scr, "   ###      ");
		wmove(scr, NBASE +  5, col); wprintw(scr, "  ###       ");
		wmove(scr, NBASE +  6, col); wprintw(scr, " #########  ");
		wmove(scr, NBASE +  7, col); wprintw(scr, "########### ");
		wmove(scr, NBASE +  8, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  9, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE + 10, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE + 11, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE + 12, col); wprintw(scr, " ########## ");
		wmove(scr, NBASE + 13, col); wprintw(scr, "   ######   ");
	} else if(num == 7) {
		wmove(scr, NBASE     , col); wprintw(scr, "############");
		wmove(scr, NBASE +  1, col); wprintw(scr, "############");
		wmove(scr, NBASE +  2, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  3, col); wprintw(scr, "         ###");
		wmove(scr, NBASE +  4, col); wprintw(scr, "         ###");
		wmove(scr, NBASE +  5, col); wprintw(scr, "        ### ");
		wmove(scr, NBASE +  6, col); wprintw(scr, "       ###  ");
		wmove(scr, NBASE +  7, col); wprintw(scr, "      ###   ");
		wmove(scr, NBASE +  8, col); wprintw(scr, "     ###    ");
		wmove(scr, NBASE +  9, col); wprintw(scr, "    ###     ");
		wmove(scr, NBASE + 10, col); wprintw(scr, "   ###      ");
		wmove(scr, NBASE + 11, col); wprintw(scr, "  ###       ");
		wmove(scr, NBASE + 12, col); wprintw(scr, " ###        ");
		wmove(scr, NBASE + 13, col); wprintw(scr, "###         ");
	} else if(num == 8) {
		wmove(scr, NBASE     , col); wprintw(scr, "   ######   ");
		wmove(scr, NBASE +  1, col); wprintw(scr, " ########## ");
		wmove(scr, NBASE +  2, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  3, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  4, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  5, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  6, col); wprintw(scr, " ########## ");
		wmove(scr, NBASE +  7, col); wprintw(scr, " ########## ");
		wmove(scr, NBASE +  8, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  9, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE + 10, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE + 11, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE + 12, col); wprintw(scr, " ########## ");
		wmove(scr, NBASE + 13, col); wprintw(scr, "   ######   ");
	} else if(num == 9) {
		wmove(scr, NBASE     , col); wprintw(scr, "   ######   ");
		wmove(scr, NBASE +  1, col); wprintw(scr, " ########## ");
		wmove(scr, NBASE +  2, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  3, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  4, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  5, col); wprintw(scr, "###      ###");
		wmove(scr, NBASE +  6, col); wprintw(scr, " ###########");
		wmove(scr, NBASE +  7, col); wprintw(scr, "  ######### ");
		wmove(scr, NBASE +  8, col); wprintw(scr, "       ###  ");
		wmove(scr, NBASE +  9, col); wprintw(scr, "      ###   ");
		wmove(scr, NBASE + 10, col); wprintw(scr, "     ###    ");
		wmove(scr, NBASE + 11, col); wprintw(scr, "    ###     ");
		wmove(scr, NBASE + 12, col); wprintw(scr, "   ###      ");
		wmove(scr, NBASE + 13, col); wprintw(scr, "  ###       ");
	}
}
