/*   Copyright (c) 1988 by George M. Sipe.  All rights reserved.

This software may only be redistributed without fee and without any
other form of monetary gain (including sold, rented, leased, or
traded), unless the express written permission of the copyright holder
is obtained in advance.

This copyright notice must be reproduced in its entirety on all copies
of this software.  Further, acknowledgment of the authorship of this
software must not be removed from its current or derived
documentation.

No expressed or implied warranty is made for this software.  No party
connected with this software assumes any liability or responsibility
for its use, the correctness of its operation, or its fitness for any
purpose.

Any distributor of copies of this software shall grant the recipient
permission for further redistribution as permitted by this notice.

Permission is hereby granted to copy, reproduce, redistribute and
otherwise use this software as long as the conditions above are
strictly adhered to.

	NOTE:  This software was originally written by Jim Earenluindil
	Trethewey and modified by George M. Sipe (rebel!george) to the
	point where Jim would no longer recognize it.  No copyright
	notices were embodied in the original net distribution.
*/

#include <stdio.h>
#include <curses.h>
#include <signal.h>
#include <sys/types.h>

#ifndef	MSDOS

#ifdef	BSD

#include <strings.h>
#include <sys/ioctl.h>
#include <sys/time.h>
extern	time_t time();

#else	/* !BSD */

#include <string.h>
#include <time.h>
extern	long time();
extern	unsigned int sleep();
extern	void exit();

#endif	/* !BSD */

extern	struct tm *localtime();
extern	unsigned int alarm();
extern  void pr_big();
extern  void pr_colon();
extern  void pr_space();
static  int on_intr();
static  void big_nums();
static  void time_update();

#else	/* MSDOS */

#include <stdlib.h>
#undef	getch
#include <conio.h>
#include <string.h>
#include <time.h>
#include <local.h>
extern  int main(int argc,char **argv);
extern  void pr_big(int num,int col);
extern  void pr_colon(int col);
extern  void pr_space(void);
static  int on_intr(void);
static  void big_nums(int hrs,int mins);
static  void time_update(void);

#endif	/* MSDOS */

#define	SYSLINE	0		/* line to put system name on */
#define	DIGITS	3		/* line to put digits on */
#define	DATETM	19		/* line to put full date and time on */

static int BASE;		/* base line for output */
static struct tm *loc_time;	/* local time structure */
static unsigned int refresh_rate;/* seconds between updates */

static char myname[40];		/* string to store system name in */

WINDOW *scr;			/* screen where large numbers displayed */
int curr_col;			/* current center of colon column */
int NBASE;			/* numeric base line for output */

static int on_intr()
{
	refresh_rate = 0;
	alarm(0);
#ifdef	BSD
	kill(0, SIGALRM);
#endif
	return(0);
}

static void big_nums(hrs, mins)
int hrs, mins;
{
	static int x_hr_h = -1, x_hr_l = -1;
	static int x_min_h = -1, x_min_l = -1, x_indent = -1;
	int hr_h, hr_l, min_h, min_l, indent;

	hr_h = hrs / 10;
	hr_l = hrs % 10;
	min_h = mins / 10;
	min_l = mins % 10;
	indent = (hr_h == 0) ? 16 : 24;
	if (indent != x_indent) {
		pr_space();
		x_hr_h = x_hr_l = x_min_h = x_min_l = -1;
		pr_colon(indent + 15);
		x_indent = indent;
	}
	if ((hr_h != 0) && (hr_h != x_hr_h)) {
		pr_big(hr_h, 9);
		x_hr_h = hr_h;
	}
	if (hr_l != x_hr_l) {
		pr_big(hr_l, indent);
		x_hr_l = hr_l;
	}
	if (min_h != x_min_h) {
		pr_big(min_h, indent + 21);
		x_min_h = min_h;
	}
	if (min_l != x_min_l) {
		pr_big(min_l, indent + 36);
		x_min_l = min_l;
	}
}

static void time_update()
{
	time_t clock;
	char time_str[43];
	int t_hour, t_min, t_sec;
	int delta;
	static int colon = 15;

	wmove(scr, BASE, 0);
	wclrtoeol(scr);
	wmove(scr, BASE, (COLS / 2 - strlen(myname) / 2));
	wprintw(scr, myname);
	wmove(scr, BASE + DATETM, 0);
	wclrtoeol(scr);
	(void) time(&clock);
	(void) strcpy(time_str, ctime(&clock));
	wmove(scr, BASE + DATETM, (COLS / 2 - strlen(time_str) / 2));
	wprintw(scr, time_str);

	loc_time = localtime(&clock);
	t_hour = loc_time->tm_hour;
	if (t_hour > 12) t_hour = t_hour - 12;
	if (t_hour == 0) t_hour = 12;
	t_min = loc_time->tm_min;
	big_nums(t_hour, t_min);
	t_sec = loc_time->tm_sec;
	colon = (colon == 9) ? 4 : 9;
	wmove(scr, NBASE + colon, curr_col);
	wrefresh(scr);
	if (refresh_rate % 60 == 0)
		delta = refresh_rate
			- ((t_min % (refresh_rate / 60)) * 60)
			- (t_sec % 60);
	else
		delta = refresh_rate - (t_sec % refresh_rate);
	if (delta > 0) (void) sleep((unsigned) delta);
	else (void) sleep(refresh_rate);
#ifdef	MSDOS
	while (kbhit()) (void) getch();
#endif
}

int main(argc, argv)
int argc;
char *argv[];
{
#ifdef BSD
	struct sgttyb tty_old, tty_new;
#endif
#ifdef	MSDOS
	int brk_old;

	brk_old = setbreak(TRUE);
	if (argc == 1) refresh_rate = 1;
#else
	if (argc == 1) refresh_rate = 60;
#endif
	else if (argc == 2) refresh_rate = atoi(argv[1]);
	else {
		(void) printf("Usage: %s [refresh_rate]\n", argv[0]);
		exit(1);
	}
	if (refresh_rate < 1) refresh_rate = 1;
#ifdef BSD
	if (ioctl(1, TIOCGETP, &tty_old) < 0) perror("ioctl TIOCGETP");
	tty_new = tty_old;
	tty_new.sg_flags |= XTABS;
	if (ioctl(1, TIOCSETP, &tty_new) < 0) perror("ioctl TIOCSETP");
#endif
	initscr();
	BASE = LINES - 21 + SYSLINE;
	NBASE = BASE + DIGITS;
	(void) gethostname(myname,sizeof(myname));
	noecho();
	nonl();
	scr = newwin(LINES, COLS, 0, 0);
	scrollok(scr, FALSE);
	leaveok(scr, FALSE);
	wclear(scr);
	(void) signal(SIGINT, on_intr);
	for ( ; refresh_rate; ) time_update();
	wclear(scr);
	wmove(scr, LINES - 1, 0);
	wclrtoeol(scr);
	wrefresh(scr);
	endwin();
#ifdef BSD
	if (ioctl(1, TIOCSETP, &tty_old) < 0) perror("ioctl TIOCSETP");
#endif
#ifdef	MSDOS
	(void) setbreak(brk_old);
#endif
	return(0);
}
