.TH ACCESS l "19 June 1988"
.SH NAME
access - limit system usage to specified ttys and times
.SH SYNTAX
.B "/usr/local/access"
.SH DESCRIPTION
.I Access
provides a simple yet powerful method of limiting user access to a
system.  Simply specify
.B /usr/local/access
in place of a login shell in the password file for each user who is to
have restricted accessibility to a system.
.I Access
will lookup that user's entry in the control file
.B /usr/local/lib/access
and execute the specified real login shell (with optional arguments) if
the current tty and time falls within one or more of the access
constraints given.
.PP
Each entry in the control file has the form:
.PP
userspec [constraint1] [...[-]o[r] constraintN]
.br
	full_pathname [args]
.PP
Blank lines are ignored, while `#' marks the start of a comment which
continues to the end of the line.  Entries may be continued by indenting
continuation lines with whitespace (blanks or tabs).  Entries are
limited to a maximum of 1k characters.
.PP
Accessibility constraints limit the tty port and/or up to 6
accessibility classes of time.  Accessibility constraints are composed
of multiple specifications separated by spaces and/or tabs.  Additional
constraints may be specified by connecting them with the
.B OR
operator (see below).
.PP
Each specification within an accessibility constraint is composed of a
letter (optionally preceded by `-') followed by the specification.  They
are as follows:
.PP
.nf
.ta 0.8i 1.6i 2.4i
	class	range	description
	-----	-----	-----------
	`t'		tty name restrictor
	`m'	0-59	minute restrictor
	`h'	0-23	hour restrictor
	`w'	0-6	day of week restrictor (0 = Sunday)
	`D'	1-31	day of month restrictor
	`M'	1-12	month restrictor
	`Y'	87-99	year restrictor
	`o[r]'		logical OR separator
.fi
.PP
Where an accessibility class is not specified within an accessibility
constraint, no restriction will be applied to that class.  For instance,
if `m' does not appear within an accessibility constraint then
accessibility will not be constrained by the current minute.
.PP
Numeric accessibility classes are specified with single values or a
range of values separated by `-'.  Multiple specifications may be given
at one time separated by `,'.  Any given class may appear more than
once.  The sense of any specific specification may be negated by `!'
(or `^').  Further, `*' (or `@') may be used to indicate infinity.  For
example, each of the following are equivalent:  "h0-23", "h*-23",
"h0-*", "h*-*", "h*", "h0,1,2-10 h11-*".
.PP
The tty accessibility class is composed of one or more string segments,
one of which must match the tail of the current tty's name.  As with the
numeric accessibility classes, "-,!^*@" are all supported.
.PP
The first entry in the control file, in which the current user's name is
matched within the "userspec", will be the entry processed for that
user.  The "userspec" is composed of one or more full usernames, one of
which must exactly match the current user's name.  As with the numeric
and tty accessibility classes, ",!^*@" are all supported.  Note that
ranges specified by `-' are NOT supported in the "userspec".
.SH EXAMPLES
joe h9-17 /bin/csh
.IP "" 5
Allow `joe' access only between 9AM and 5PM.
.PP
uucp,net ttya7 w1-5 h*,!9-17 or ttya0-ab w0,6
.br
	/usr/lib/uucp/uucico
.IP "" 5
Allow `uucp' and `net' access on (/dev/t)tya7 weekdays except between
9AM and 5PM
.B or
on (/dev/t)tya0 thru (/dev/tty)ab (anytime) on weekends.  Note the "*"
is required in the hour specification.  Otherwise, since "h" appeared -
hours would be constrained, no unrestricted hours specified, then
further constrained to not be between 9 and 17.  In other words no hour
would be acceptable and only the second accessibility constraint could
possibly pass.
.PP
*,!root Y*-87 t*,!console or M*-9 Y88 t*,!console /bin/sh
.IP "" 5
Allow everyone access except `root' thru September 1988 on any tty
except consoles.  Note that if
.I access
is specified as `root's login shell as this example implies, then `root'
must have an entry somewhere following this example entry.  Alternately,
`root' may have an entry before this one in which event the ",!root"
would be extraneous since
.I access
would never get this far for user `root'.
.PP
uucp /usr/lib/uucp/uucico
.br
*    /bin/csh
.IP "" 5
Give `uucp' unrestricted access to `uucico' and everyone else
unrestricted access to the `csh'.  Effectively,
.I access
would not be doing anything.  This would be one method of removing
access constraints for everyone without changing the password file.
.SH TESTING
If
.I access
is invoked from a shell then the access constraints will be derived from
its arguments (do not specify the `userspec').  In place of actually
executing the real login shell specified, that program's name and its
argument vector will be displayed.
.SH INSTALLATION
Be sure to disable users ability to change their login shell and thereby
defeat this control.  For example, "chmod o-x /usr/ucb/chsh".
.SH "SEE ALSO"
Files:  /etc/passwd and /usr/local/lib/access
.SH DIAGNOSTICS
If at least one accessibility constraint passes, the presence of
.I access
is invisible.  If no accessibility constraint passes, then a message is
issued and the user immediately logged off.
.SH AUTHOR
George M. Sipe currently (7/88) at rebel!george
