	page	60,132
;-----------------------------------------------------------------------------
;	Compensa.asm -  Snd_Compensate()  Records a group of samples and
;			determines where where the silence centerline is.
;			Then it builds a translation table to be used for
;			recording.  Snd_Compensate is part of the PSSJ Digital
;			Sound Toolkit.
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;-----------------------------------------------------------------------------
	include	sound.inc
	include external.inc
	extrn	_snd_record:FAR

SAMPSIZE equ	2000
PCNT85	equ	1700

snddata	segment	public	'DATA'
snddata	ends
	page
sndseg	segment	public	'CODE'
	assume	cs:sndseg,ds:snddata

	public	_snd_compensate
_snd_compensate	proc far		;(*sp)
	push	bp
	mov	bp,sp
	push	ds
	mov	ax,snddata
	mov	ds,ax		;=============================================
	assume	DS:snddata

;	Make sure we aren't doing anything.  Abort if we are.

$recheck:
	mov	al,byte ptr snd_mode	;<22>
	test	al,INPLAY OR INRECORD	;Are we doing anything?
	jz	$valid			;No, 

	mov	ax,INVALID
$abort:	pop	ds
	pop	bp
	ret				;FAR

;	No activity at the moment, so get ready.

$valid:	push	si
	push	di
	push	es

	les	di,queue_free		;Point at the free queue
	mov	ax,es
	or	ax,di			;There had better be a buffer free
	jnz	$bufavail
	page
;	Bail out since there is no area to store our test sample.

$nobufs:mov	ax,INVALID
$internal:
	pop	es
	pop	di
	pop	si
	jmp	short $abort

;	ES:DI now points to a buffer that can be used for recording.
;	Now, within that buffer, create a sound header that also points
;	into the buffer for storing the recorded sample.  We will record
;	a round number like 2000 bytes for this test.
;	NOTE:  This function uses the first buffer on the free-list but
;	never actually removes it from the free list.

$bufavail:
	les	di,es:[di]		;We need two buffers
	mov	ax,es
	or	ax,di
	jz	$nobufs

	les	di,queue_free		;Point at the free queue

	add	di,HEADER_SIZE		;Skip free-list chain info
	mov	ax,di
	add	ax,offset 20		;***KLUDGE**** HARDCODED
	push	ax			;Save that DATA POINTER
	mov	word ptr es:[di].sndbuf,ax	;Make a pointer to data area
	mov	word ptr es:[di].sndbuf[2],es	;Store segment
	mov	ax,SAMPSIZE
	mov	word ptr es:[di].sndblen,ax	;Store length of sample
	xor	ax,ax				;Get a zero
	mov	word ptr es:[di].sndblen[2],ax
	page
;	ES:DI points at the start of our section of the buffer.
;	queue_free points to the entire buffer should we need to reference
;	it again.

	push	ax			;<30>No Threshold 
	push	ax			;<30>or thresh length
	push	ax			;<33>Default depth 
	push	ax			;No Block (default)
	push	ax
	push	ax			;No adjust table (yet)
	mov	bx,R22000		;Fastest sampling rate
	push	bx			;rate
	push	ax			;No time limit (length only)
	push	es
	push	di			;Push address of header
	call	_snd_record
	add	sp,20			;<30>Fix stack
	or	ax,ax
	jnz	$internal		;Something fatal occurred

;	The record call took, and we are recording now.  So wait until
;	the recorder stops.

$wait:	mov	al,byte ptr snd_mode	;<22>
	test	al,INRECORD
	jnz	$wait			;Wait (.09 sec)

;	The recorder stopped, so we must have a sample to work with.
;	Generate an occurrence table.

	pop	di			;DATA POINTER
	push	ds			;Save DS (snddata)
	push	es
	push	di

	les	di,queue_free		;Get pointer to table (FAR depth)
	les	di,es:[di]		;Get pointer to second buffer
	add	di,HEADER_SIZE		;Leave that area alone
	push	di
	xor	cx,cx
	xor	ax,ax
	cld
$initl:	stosw				;Clear table out first
	mov	es:[di],cl
	inc	di
	inc	cl
	cmp	cl,0
	jnz	$initl

	pop	di			;Get table pointer back
	pop	si
	pop	ds
	mov	cx,SAMPSIZE
	xor	ah,ah
	page
;	Now, keep track of bytes 

$nextbyte:
	lodsb
	mov	bx,ax
	shl	bx,1			;Multiply by 2
	add	bx,ax			;x 3
	inc	word ptr es:[di+bx]	;Increment occurrence
	loop	$nextbyte
	pop	ds

;	Now we have a table of the values.  Now sort them to find
;	the largest entries.
;	The table appears as   count +0 MSB +1 LSB value +2 LSB
;	Yes, this is the horrible bubble sort

	push	di
$passn:	pop	di
	push	di
	mov	cl,255			;This many entries -1
	mov	ch,0

$loopn:	mov	ax,es:[di]
	cmp	ax,es:[di+3]
	jae	$nosort

;	Exchange

	mov	dx,es:[di+3]
	mov	es:[di],dx
	mov	es:[di+3],ax
	mov	bh,es:[di+2]
	mov	bl,es:[di+5]
	mov	es:[di+2],bl
	mov	es:[di+5],bh
	mov	ch,1

$nosort:inc	di
	inc	di
	inc	di
	dec	cl
	jnz	$loopn
	cmp	ch,1
	jz	$passn
	page
;	Okay, the table is now sorted.
;	Hopefully a single point will equal 85% or more of the hits

	pop	di			;Point at start of table
	mov	bx,es:[di]
	mov	al,es:[di+2]
	sub	ah,ah

	cmp	bx,PCNT85		;for 2000 = 1700
	jb	$nothave
	jmp	$havecl			;We have a centerline
					;al = amplitude of c/l

$nothave:
;	Here, the number we calculates was not a clear winner.
;	So scan down the sorted table until we have enough numbers
;	to equal 85%.
;	We also determine which value is the lowest.  This makes some
;	math simpler later.

	mov	ax,PCNT85		;for 2000 = 1700

	sub	bx,bx
	sub	cx,cx
	push	di			;Save starting pointer

$sumlp:	add	bx,es:[di]
	inc	di
	inc	di
	inc	di
	inc	cx

	cmp	bx,ax
	jb	$sumlp

;	We now have found 85% + of the hits
;	cx is the number of points needed

	pop	di
	push	bx			;Save counts
	xor	bx,bx
	xor	si,si
	push	cx
	page
$sum:	mov	ax,es:[di]
	mov	dl,es:[di+2]
	xor	dh,dh
	mul	dx
	add	bx,ax
	adc	si,dx
	inc	di
	inc	di
	inc	di
	loop	$sum

	pop	cx

	mov	dx,si
	mov	ax,bx
	pop	bx			;Get counts back
	div	bx			;Divide by counts in 85% +

;	AX is the quotient & DX is the remainder

	shr	bx,1
	cmp	bx,dx
	jb	$havecl
	inc	ax			;Ceiling (round up)
	page
;	AH is now the centerline (better fit in AH)
;	We can now compute the translation table.

$havecl:les	di,[bp+6]		;Get pointer to table (FAR depth)
	
	mov	cl,0
	mov	ah,80h			;So if 82, we will move down 2 (-2)
	sub	ah,al			;If 7e, we will move up 2 (+2)

$nextsam:
	mov	al,ah
	add	al,cl

;	Check numbers near zero for wrap

	cmp	cl,20h
	ja	$nocheck
	or	al,al			;Make sure we did not wrap
	jns	$ok			;No rail
	xor	al,al			;Force rail on lower limit
	jmp	short $ok

;	Check numbers near 255 for wrap

$nocheck:
	cmp	cl,0e0h
	jb	$ok
	or	al,al
	js	$ok
	mov	al,0ffh

$ok:	stosb				;Store byte in table

	inc	cl
	cmp	cl,0
	jnz	$nextsam

;	All our work is done, so get outta here.

	pop	es
	xor	ax,ax
	pop	di
	pop	si
	pop	ds
	pop	bp
	ret				;FAR

_snd_compensate endp
sndseg	ends
	end

